---
generated_at: 2026-02-10 10:30:00
metrics:
  claims_total: 105
  claims_with_evidence: 98
  claims_without_evidence: 7
confidence_derived: 0.93
---

# 根拠レポート：Workspaces-SharedUtilitiesAndExtensions 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードの実装が存在するか
2. **根拠との整合性**：テストケースの内容が実装と矛盾していないか
3. **網羅性**：主要なメソッド・クラスがカバーされているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：98 / 105、根拠なし：7
- 優先レビュー（高）
  1. **UT-SUE-092〜093**: AbstractSimplificationService.ReduceAsyncの抽象メソッド実装
  2. **UT-SUE-094〜095**: AbstractIndentationService.GetIndentationの言語固有実装
  3. **UT-SUE-101**: ReuseExistingSpeculativeModelAsyncのキャッシュ動作

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/Extensions/StringExtensions.cs`
- E-02: `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/Extensions/SyntaxNodeExtensions.cs`
- E-03: `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/Utilities/StringBreaker.cs`
- E-04: `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/SymbolKey/SymbolKey.cs`
- E-05: `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/NamingStyles/NamingStyle.cs`
- E-06: `src/Workspaces/SharedUtilitiesAndExtensions/Compiler/Core/NamingStyles/Naming/IdentifierNameParts.cs`
- E-07: `src/Workspaces/SharedUtilitiesAndExtensions/Workspace/Core/CodeGeneration/CodeGenerationSymbolFactory.cs`
- E-08: `src/Workspaces/SharedUtilitiesAndExtensions/Workspace/Core/Simplification/AbstractSimplificationService.cs`
- E-09: `src/Workspaces/SharedUtilitiesAndExtensions/Workspace/Core/Indentation/AbstractIndentationService.cs`
- E-10: `src/Workspaces/SharedUtilitiesAndExtensions/Workspace/Core/Extensions/DocumentExtensions.cs`

## 3) Claims と根拠の対応（レビューの主戦場）

### StringExtensions (UT-SUE-001〜021)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GetFirstNonWhitespaceOffset正常系 | E-01 L14-27 | ○ |
| C-02 | GetFirstNonWhitespaceOffset空白なし | E-01 L14-27 | ○ |
| C-03 | GetFirstNonWhitespaceOffset全空白 | E-01 L14-27 | ○ |
| C-04 | GetFirstNonWhitespaceOffset null入力 | E-01 L16 Contract.ThrowIfNull | ○ |
| C-05 | GetLastNonWhitespaceOffset正常系 | E-01 L29-42 | ○ |
| C-06 | GetLastNonWhitespaceOffset全空白 | E-01 L29-42 | ○ |
| C-07 | GetLeadingWhitespace正常系 | E-01 L44-53 | ○ |
| C-08 | GetLeadingWhitespace空白なし | E-01 L44-53 | ○ |
| C-09 | GetTrailingWhitespace正常系 | E-01 L55-64 | ○ |
| C-10 | ConvertTabToSpace正常系 | E-01 L77-98 | ○ |
| C-11 | ConvertTabToSpaceタブサイズ1 | E-01 L77-98 | ○ |
| C-12 | GetFirstLineText正常系 | E-01 L118-127 | ○ |
| C-13 | GetFirstLineText改行なし | E-01 L118-127 | ○ |
| C-14 | GetLastLineText正常系 | E-01 L129-138 | ○ |
| C-15 | ContainsLineBreak改行あり | E-01 L140-151 | ○ |
| C-16 | ContainsLineBreak改行なし | E-01 L140-151 | ○ |
| C-17 | GetNumberOfLineBreaks正常系 | E-01 L153-172 | ○ |
| C-18 | GetNumberOfLineBreaks CRLF | E-01 L153-172 | ○ |
| C-19 | ContainsTab正常系 | E-01 L174-186 | ○ |
| C-20 | GetColumnFromLineOffset正常系 | E-01 L206-213 | ○ |
| C-21 | GetLineOffsetFromColumn正常系 | E-01 L215-242 | ○ |

### SyntaxNodeExtensions (UT-SUE-022〜039)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | GetRequiredParent正常系 | E-02 L23-24 | ○ |
| C-23 | GetRequiredParent例外 | E-02 L23-24 throw new InvalidOperationException | ○ |
| C-24 | GetAncestors正常系 | E-02 L32-42 | ○ |
| C-25 | GetAncestors<TNode>正常系 | E-02 L44-57 | ○ |
| C-26 | GetAncestor<TNode>正常系 | E-02 L59-74 | ○ |
| C-27 | GetAncestor<TNode>該当なし | E-02 L59-74 return null | ○ |
| C-28 | HasAncestor正常系 | E-02 L97-101 | ○ |
| C-29 | GetCommonRoot正常系 | E-02 L177-193 | ○ |
| C-30 | Width正常系 | E-02 L195-196 | ○ |
| C-31 | FullWidth正常系 | E-02 L198-199 | ○ |
| C-32 | FindInnermostCommonNode正常系 | E-02 L204-291 | ○ |
| C-33 | FindInnermostCommonNode空リスト | E-02 L278 | ○ |
| C-34 | GetContainedSpan正常系 | E-02 L296-310 | ○ |
| C-35 | FindTokenOnRightOfPosition正常系 | E-02 L613-647 | ○ |
| C-36 | FindTokenOnLeftOfPosition正常系 | E-02 L652-686 | ○ |
| C-37 | WithPrependedLeadingTrivia正常系 | E-02 L688-720 | ○ |
| C-38 | WithPrependedLeadingTrivia空配列 | E-02 L692-695 | ○ |
| C-39 | WithAppendedTrailingTrivia正常系 | E-02 L722-754 | ○ |

### StringBreaker (UT-SUE-040〜047)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | AddWordParts正常系 | E-03 L16-17 | ○ |
| C-41 | AddWordPartsキャメルケース | E-03 L101-148 | ○ |
| C-42 | AddWordPartsパスカルケース | E-03 L101-148 | ○ |
| C-43 | AddWordParts単一文字 | E-03 L49-52 | ○ |
| C-44 | AddCharacterParts正常系 | E-03 L19-20 | ○ |
| C-45 | GenerateSpan正常系 | E-03 L40-78 | ○ |
| C-46 | GenerateSpan句読点スキップ | E-03 L172-187 | ○ |
| C-47 | GenerateSpan数字認識 | E-03 L161-170 | ○ |

### SymbolKey (UT-SUE-048〜059)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-48 | Create正常系 | E-04 L129-130 | ○ |
| C-49 | Create nullシンボル | E-04 L129-130 | ○ |
| C-50 | Resolve正常系 | E-04 L224-228 | ○ |
| C-51 | ResolveString正常系 | E-04 L166-200 | ○ |
| C-52 | ResolveStringバージョン不一致 | E-04 L187-190 | ○ |
| C-53 | CanCreate正常系 | E-04 L148-164 | ○ |
| C-54 | CanCreateローカルシンボル | E-04 L148-164 | ○ |
| C-55 | GetComparer正常系 | E-04 L145-146 | ○ |
| C-56 | Equals正常系 | E-04 L356-368 | ○ |
| C-57 | GetHashCode正常系 | E-04 L338-351 | ○ |
| C-58 | IsBodyLevelSymbolラベル | E-04 L317-325 | ○ |
| C-59 | IsBodyLevelSymbol通常メソッド | E-04 L317-325 | ○ |

### NamingStyle (UT-SUE-060〜071)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | CreateName正常系 | E-05 L61-66 | ○ |
| C-61 | CreateName接辞適用 | E-05 L65 Prefix + combinedWordsWithCasing + Suffix | ○ |
| C-62 | CreateNameセパレータ | E-05 L64 string.Join(WordSeparator, wordsWithCasing) | ○ |
| C-63 | IsNameCompliant正常系 | E-05 L123-172 | ○ |
| C-64 | IsNameCompliantプレフィックス不足 | E-05 L125-129 | ○ |
| C-65 | IsNameCompliantサフィックス不足 | E-05 L131-135 | ○ |
| C-66 | IsNameCompliant大文字小文字不正 | E-05 L163-170 | ○ |
| C-67 | MakeCompliant正常系 | E-05 L322-332 | ○ |
| C-68 | StripCommonPrefixes正常系 | E-05 L343-380 | ○ |
| C-69 | StripCommonPrefixesアンダースコア | E-05 L361-368 | ○ |
| C-70 | CreateXElement正常系 | E-05 L464-471 | ○ |
| C-71 | FromXElement正常系 | E-05 L473-480 | ○ |

### IdentifierNameParts (UT-SUE-072〜073)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-72 | CreateIdentifierNameParts(ISymbol)正常系 | E-06 L20-25 | ○ |
| C-73 | CreateIdentifierNameParts(string)正常系 | E-06 L27-33 | ○ |

### CodeGenerationSymbolFactory (UT-SUE-074〜091)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-74 | CreateEventSymbol正常系 | E-07 L28-40 | ○ |
| C-75 | CreatePropertySymbol正常系 | E-07 L42-72 | ○ |
| C-76 | CreateFieldSymbol正常系 | E-07 L102-114 | ○ |
| C-77 | CreateConstructorSymbol正常系 | E-07 L119-133 | ○ |
| C-78 | CreateDestructorSymbol正常系 | E-07 L138-145 | ○ |
| C-79 | CreateMethodSymbol正常系 | E-07 L147-186 | ○ |
| C-80 | CreateOperatorSymbol正常系 | E-07 L191-214 | ○ |
| C-81 | CreateOperatorSymbol例外 | E-07 L203-209 ArgumentException | ○ |
| C-82 | CreateConversionSymbol正常系 | E-07 L219-259 | ○ |
| C-83 | CreateParameterSymbol正常系 | E-07 L264-280 | ○ |
| C-84 | CreateTypeParameterSymbol正常系 | E-07 L315-323 | ○ |
| C-85 | CreatePointerTypeSymbol正常系 | E-07 L347-348 | ○ |
| C-86 | CreateArrayTypeSymbol正常系 | E-07 L353-354 | ○ |
| C-87 | CreateNamedTypeSymbol正常系 | E-07 L414-454 | ○ |
| C-88 | CreateDelegateTypeSymbol正常系 | E-07 L459-498 | ○ |
| C-89 | CreateNamespaceSymbol正常系 | E-07 L503-508 | ○ |
| C-90 | CreateAttributeData正常系 | E-07 L403-409 | ○ |
| C-91 | IsCodeGenerationSymbol正常系 | E-07 L22-23 | ○ |

### AbstractSimplificationService (UT-SUE-092〜093)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-92 | ReduceAsync正常系 | E-08 L54-84 | △ |
| C-93 | ReduceAsync空スパン | E-08 L66-67 | △ |

### AbstractIndentationService (UT-SUE-094〜095)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-94 | GetIndentation正常系 | E-09 L16-37 | △ |
| C-95 | GetIndentationインデントなし | E-09 L22-25 | ○ |

### DocumentExtensions (UT-SUE-096〜105)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-96 | GetRequiredSemanticModelAsync正常系 | E-10 L33-40 | ○ |
| C-97 | GetRequiredSemanticModelAsync例外 | E-10 L39 throw new InvalidOperationException | ○ |
| C-98 | GetRequiredSyntaxTreeAsync正常系 | E-10 L57-64 | ○ |
| C-99 | GetRequiredSyntaxRootAsync正常系 | E-10 L74-81 | ○ |
| C-100 | IsOpen正常系 | E-10 L91-95 | ○ |
| C-101 | ReuseExistingSpeculativeModelAsync正常系 | E-10 L111-161 | △ |
| C-102 | IsGeneratedCodeAsync正常系 | E-10 L205-210 | ○ |
| C-103 | GetLinkedDocuments正常系 | E-10 L212-220 | ○ |
| C-104 | GetLanguageService正常系 | E-10 L27-28 | ○ |
| C-105 | GetLanguageService null | E-10 L27-28 | △ |

## 4) 不足情報（Unknown / Missing）
- **C-92, C-93 (AbstractSimplificationService)**: 抽象クラスのため、具体的な実装は言語固有サブクラス（CSharpSimplificationService等）に依存
  - 候補：`src/Workspaces/CSharp/Portable/Simplification/CSharpSimplificationService.cs`
- **C-94 (AbstractIndentationService)**: 抽象クラスのため、具体的なインデント規則は言語固有実装に依存
  - 候補：`src/Workspaces/CSharp/Portable/Indentation/CSharpIndentationService.cs`
- **C-101 (ReuseExistingSpeculativeModelAsync)**: ISemanticModelReuseWorkspaceServiceの実装に依存
  - 候補：`src/Workspaces/Core/Portable/Workspace/Solution/SemanticModelReuse/`
- **C-105 (GetLanguageService null)**: 条件分岐の挙動は実装から読み取れるが、実際のnull返却テストが必要

## 5) リスクフラグ（レビュー観点）
- **1 (中リスク)**: 抽象クラスのテストケースは言語固有実装との組み合わせテストが必要
- **0 (低リスク)**: 静的拡張メソッドのテストケースは単体で完結
- **1 (中リスク)**: SymbolKeyのバージョン互換性テストは将来のフォーマット変更に注意

## 6) レビュアーチェックリスト（最小）
- [ ] StringExtensions: null入力時のContract例外がテストフレームワークで検証可能か確認
- [ ] SyntaxNodeExtensions: テストで使用するSyntaxTreeの生成方法を確認
- [ ] SymbolKey: Compilationの生成コストを考慮したテスト設計
- [ ] NamingStyle: 各Capitalizationスキームのテストデータ準備
- [ ] CodeGenerationSymbolFactory: 生成されたシンボルの属性が正しく設定されているか詳細確認
- [ ] AbstractSimplificationService: 言語固有サブクラスでの結合テスト検討
- [ ] DocumentExtensions: Workspaceのモック/スタブ設計確認
