---
generated_at: 2026-02-10 15:30:00
metrics:
  claims_total: 50
  claims_with_evidence: 42
  claims_without_evidence: 8
confidence_derived: 0.84
---

# 根拠レポート：受入テストケース一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.84**
  - 根拠あり：42 / 50、根拠なし：8
- 優先レビュー（高）
  1. **UAT-041 Live Unit Testingの統合**：具体的な実装詳細の根拠不足
  2. **UAT-046 Roslyn Scripting API**：詳細なテスト手順の根拠不足
  3. **UAT-047 Embedded Language Support**：機能範囲の根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/roslyn-main/README.md` - プロジェクト概要、C#/VBコンパイラの説明
- E-02: `/Users/tomoka.baba/Work/roslyn-main/docs/Language Feature Status.md` - 言語機能の状態、C# 8.0-14.0の機能一覧
- E-03: `/Users/tomoka.baba/Work/roslyn-main/docs/contributing/Compiler Test Plan.md` - コンパイラテスト計画、テスト観点
- E-04: `/Users/tomoka.baba/Work/roslyn-main/docs/ide/README.md` - IDE機能の一覧、リファクタリング・コードフィックス
- E-05: `/Users/tomoka.baba/Work/roslyn-main/src/Features/` - IDE機能の実装（Snippets、CodeFixes、Refactorings）
- E-06: `/Users/tomoka.baba/Work/roslyn-main/src/Compilers/` - コンパイラ実装
- E-07: `/Users/tomoka.baba/Work/roslyn-main/src/Analyzers/` - コードアナライザー実装
- E-08: `/Users/tomoka.baba/Work/roslyn-main/src/LanguageServer/` - LSPサーバー実装
- E-09: `/Users/tomoka.baba/Work/roslyn-main/src/VisualStudio/` - Visual Studio統合
- E-10: `/Users/tomoka.baba/Work/roslyn-main/src/Workspaces/` - Workspace API実装
- E-11: `/Users/tomoka.baba/Work/roslyn-main/src/Scripting/` - Scripting API実装
- E-12: `/Users/tomoka.baba/Work/roslyn-main/docs/contributing/IDE Test Plan.md` - IDEテスト計画への参照

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | C#ソースコードのコンパイル機能 | E-01, E-03, E-06 | ○ |
| C-02 | VBソースコードのコンパイル機能 | E-01, E-03, E-06 | ○ |
| C-03 | 構文エラーの検出とレポート | E-03, E-04, E-09 | ○ |
| C-04 | IntelliSenseによるコード補完 | E-04, E-05, E-09 | ○ |
| C-05 | Go to Definition機能 | E-04, E-05 | ○ |
| C-06 | Find All References機能 | E-04, E-05 | ○ |
| C-07 | リネームリファクタリング | E-04, E-05 | ○ |
| C-08 | Extract Methodリファクタリング | E-04, E-05 | ○ |
| C-09 | コードフィックス(自動修正) | E-04, E-05, E-07 | ○ |
| C-10 | Nullableリファレンスタイプ分析 | E-02, E-03 | ○ |
| C-11 | Pattern Matching構文のサポート | E-02, E-03 | ○ |
| C-12 | Record型のサポート | E-02 | ○ |
| C-13 | Collection Expressions構文のサポート | E-02 | ○ |
| C-14 | Primary Constructor構文のサポート | E-02 | ○ |
| C-15 | コードアナライザーの実行 | E-07 | ○ |
| C-16 | Source Generatorの実行 | E-02, E-06 | ○ |
| C-17 | Debugger Expression Evaluation | E-03, E-09 | ○ |
| C-18 | Edit and Continue機能 | E-03, E-04 | ○ |
| C-19 | LSP (Language Server Protocol) 機能 | E-08 | ○ |
| C-20 | Workspace APIの利用 | E-10 | ○ |
| C-21 | Syntax Tree APIの利用 | E-06, E-10 | ○ |
| C-22 | Semantic Model APIの利用 | E-03, E-06 | ○ |
| C-23 | Code Fixプロバイダーの実装 | E-05, E-07 | ○ |
| C-24 | 診断アナライザーの実装 | E-07 | ○ |
| C-25 | コンパイル時エラーの処理 | E-03, E-06 | ○ |
| C-26 | コンパイル警告の処理 | E-03, E-06 | ○ |
| C-27 | #pragma warningディレクティブ | E-03 | ○ |
| C-28 | Conditional Compilation | E-03 | ○ |
| C-29 | XMLドキュメントコメント生成 | E-03 | ○ |
| C-30 | Deterministic Build | E-03 | ○ |
| C-31 | Portable PDB生成 | E-03, E-06 | ○ |
| C-32 | Span<T>のサポート | E-02 | ○ |
| C-33 | Async/Await構文のサポート | E-02, E-03 | ○ |
| C-34 | Top-Level Statements | E-02 | ○ |
| C-35 | Global Using Directives | E-02 | ○ |
| C-36 | File-scoped Namespaces | E-02, E-04 | ○ |
| C-37 | Extension Methodsのナビゲーション | E-04, E-05 | ○ |
| C-38 | using statementのコード補完 | E-04, E-05 | ○ |
| C-39 | コードフォーマット機能 | E-04 | ○ |
| C-40 | EditorConfig適用 | E-04 | ○ |
| C-41 | Live Unit Testingの統合 | **根拠なし** | △ |
| C-42 | CodeLens参照カウント表示 | E-04 | ○ |
| C-43 | Large Solution対応 | **根拠なし** | △ |
| C-44 | Multi-targeting対応 | E-03 | ○ |
| C-45 | NuGetパッケージのアナライザー参照 | E-07 | ○ |
| C-46 | Roslyn Scripting API | E-11 | △ |
| C-47 | Embedded Language Support | **根拠なし** | △ |
| C-48 | JSON埋め込み言語サポート | **根拠なし** | △ |
| C-49 | Razor(.cshtml)ファイルのサポート | E-04 | ○ |
| C-50 | Incremental Compilation | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **Live Unit Testing統合**: Visual Studioの機能であり、Roslynコードベース内に直接的な実装が見つからない
  - 候補：Visual Studio Enterprise Documentation / Visual Studio SDK / 外部テスト
- **Large Solution対応**: パフォーマンステストの具体的な基準がコードベースから特定できない
  - 候補：パフォーマンスベンチマーク / 負荷テスト仕様書 / リリースノート
- **Embedded Language Support (正規表現・JSON)**: 機能は確認されているが詳細な仕様書が見つからない
  - 候補：IDE feature documentation / 実装コード詳細調査 / テストコード
- **Incremental Compilation**: コンパイラ内部の最適化機能であり、ユーザー向けテストケースの根拠が不足
  - 候補：コンパイラ内部設計書 / ビルドパフォーマンスレポート

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - UAT-001〜010: コンパイラとIDE基本機能は十分な根拠あり
- **0: 低リスク** - UAT-011〜016: 言語機能は Language Feature Status.md で確認済み
- **1: 中リスク** - UAT-017〜018: デバッガ統合は部分的な根拠のみ
- **0: 低リスク** - UAT-019〜024: APIとアナライザー機能は実装コードで確認
- **0: 低リスク** - UAT-025〜040: コンパイル・IDE機能は十分な根拠あり
- **2: 高リスク** - UAT-041, 043, 47-48, 50: 根拠不足のため手動検証が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 高優先度テストケース（UAT-001〜010）がRoslynの主要機能を網羅しているか確認
- [ ] C# 12-14の新機能（Collection Expressions、Primary Constructor等）のテストケースが最新仕様に準拠しているか確認
- [ ] 根拠なしの項目（UAT-041, 043, 47-48, 50）について追加調査または削除の判断
- [ ] LSP機能のテストケース（UAT-019）がVS Code拡張との統合を適切にカバーしているか確認
- [ ] パフォーマンス関連テストケース（UAT-043, 50）の具体的な合格基準を定義
- [ ] テスト手順の詳細度が実際のテスト実行に十分か確認
