---
generated_at: 2026-02-10 14:55:00
metrics:
  claims_total: 50
  claims_with_evidence: 47
  claims_without_evidence: 3
confidence_derived: 0.94
---

# 根拠レポート：業務要件一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：47 / 50、根拠なし：3
- 優先レビュー（高）
  1. **BR-038 C#スクリプト実行**：Scripting APIの詳細仕様要確認
  2. **BR-039 スクリプトグローバル変数**：ホストオブジェクトの仕様要確認
  3. **BR-044 テスト実行連携**：テストランナー連携の詳細要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/roslyn-main/README.md` - プロジェクト概要
- E-02: `/Users/tomoka.baba/Work/roslyn-main/src/Compilers/CSharp/Portable/Compilation/CSharpCompilation.cs` - C#コンパイラ実装
- E-03: `/Users/tomoka.baba/Work/roslyn-main/src/Features/Core/Portable/Microsoft.CodeAnalysis.Features.csproj` - IDE機能プロジェクト定義
- E-04: `/Users/tomoka.baba/Work/roslyn-main/src/Features/Core/Portable/Completion/CompletionService.cs` - 補完サービス実装
- E-05: `/Users/tomoka.baba/Work/roslyn-main/src/Features/Core/Portable/CodeRefactorings/CodeRefactoringService.cs` - リファクタリングサービス実装
- E-06: `/Users/tomoka.baba/Work/roslyn-main/src/Analyzers/Core/Analyzers/` - コードアナライザー群
- E-07: `/Users/tomoka.baba/Work/roslyn-main/src/Workspaces/Core/Portable/` - ワークスペースコア機能
- E-08: `/Users/tomoka.baba/Work/roslyn-main/src/LanguageServer/Protocol/` - LSPプロトコル実装
- E-09: `/Users/tomoka.baba/Work/roslyn-main/src/Compilers/Core/Portable/` - コンパイラコア機能
- E-10: `/Users/tomoka.baba/Work/roslyn-main/src/Features/Core/Portable/GoToDefinition/` - 定義へ移動機能
- E-11: `/Users/tomoka.baba/Work/roslyn-main/src/Features/Core/Portable/FindUsages/` - 参照検索機能
- E-12: `/Users/tomoka.baba/Work/roslyn-main/src/Features/Core/Portable/Rename/` - リネーム機能
- E-13: `/Users/tomoka.baba/Work/roslyn-main/src/Features/Core/Portable/Formatting/` - フォーマット機能
- E-14: `/Users/tomoka.baba/Work/roslyn-main/src/Features/Core/Portable/SignatureHelp/` - シグネチャヘルプ機能
- E-15: `/Users/tomoka.baba/Work/roslyn-main/src/Features/Core/Portable/QuickInfo/` - クイック情報機能
- E-16: `/Users/tomoka.baba/Work/roslyn-main/src/Features/Core/Portable/NavigationBar/` - ナビゲーションバー機能
- E-17: `/Users/tomoka.baba/Work/roslyn-main/src/Features/Core/Portable/InlineHints/` - インレイヒント機能
- E-18: `/Users/tomoka.baba/Work/roslyn-main/src/Features/Core/Portable/InheritanceMargin/` - 継承マージン機能
- E-19: `/Users/tomoka.baba/Work/roslyn-main/src/Features/Core/Portable/Structure/` - アウトライン機能
- E-20: `/Users/tomoka.baba/Work/roslyn-main/src/Features/Core/Portable/Diagnostics/` - 診断機能
- E-21: `/Users/tomoka.baba/Work/roslyn-main/src/Features/Core/Portable/CodeCleanup/` - コードクリーンアップ機能
- E-22: `/Users/tomoka.baba/Work/roslyn-main/src/Features/Core/Portable/EditAndContinue/` - Edit and Continue機能
- E-23: `/Users/tomoka.baba/Work/roslyn-main/src/Scripting/Core/` - スクリプティング機能
- E-24: `/Users/tomoka.baba/Work/roslyn-main/src/Workspaces/MSBuild/` - MSBuild統合
- E-25: `/Users/tomoka.baba/Work/roslyn-main/src/Workspaces/Remote/` - リモートホスティング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| BR-001 | C#ソースコードのコンパイル | E-02, E-09 | ○ |
| BR-002 | Visual Basicソースコードのコンパイル | E-09 | ○ |
| BR-003 | 構文解析（パーサー） | E-02, E-09 | ○ |
| BR-004 | 意味解析（バインディング） | E-02, E-09 | ○ |
| BR-005 | IL/PEコード生成 | E-09 | ○ |
| BR-006 | 診断メッセージ生成 | E-09, E-20 | ○ |
| BR-007 | メタデータ参照管理 | E-09 | ○ |
| BR-008 | ソースジェネレーター実行 | E-09 | ○ |
| BR-009 | コード補完（IntelliSense） | E-03, E-04 | ○ |
| BR-010 | シグネチャヘルプ | E-03, E-14 | ○ |
| BR-011 | 定義へ移動（Go to Definition） | E-03, E-10 | ○ |
| BR-012 | 参照検索（Find All References） | E-03, E-11 | ○ |
| BR-013 | コードリファクタリング | E-03, E-05 | ○ |
| BR-014 | コード修正（Quick Fix） | E-03 | ○ |
| BR-015 | リネーム | E-03, E-12 | ○ |
| BR-016 | コードフォーマット | E-03, E-13 | ○ |
| BR-017 | コードクリーンアップ | E-03, E-21 | ○ |
| BR-018 | 構文ハイライト | E-03 | ○ |
| BR-019 | アウトライン表示（折りたたみ） | E-03, E-19 | ○ |
| BR-020 | クイック情報（ホバー） | E-03, E-15 | ○ |
| BR-021 | ナビゲーションバー | E-03, E-16 | ○ |
| BR-022 | ドキュメントシンボル | E-03 | ○ |
| BR-023 | 継承マージン | E-03, E-18 | ○ |
| BR-024 | インレイヒント | E-03, E-17 | ○ |
| BR-025 | 静的コード分析 | E-06 | ○ |
| BR-026 | 命名規則チェック | E-06 | ○ |
| BR-027 | 未使用コード検出 | E-06 | ○ |
| BR-028 | コードスタイル推奨 | E-06 | ○ |
| BR-029 | Null安全性分析 | E-02 | ○ |
| BR-030 | ソリューション管理 | E-07 | ○ |
| BR-031 | ドキュメント同期 | E-07 | ○ |
| BR-032 | バックグラウンド分析 | E-07 | ○ |
| BR-033 | シンボル検索 | E-07 | ○ |
| BR-034 | リモートホスティング | E-07, E-25 | ○ |
| BR-035 | Language Server Protocol対応 | E-08 | ○ |
| BR-036 | テキストドキュメント同期 | E-08 | ○ |
| BR-037 | 診断のプッシュ通知 | E-08 | ○ |
| BR-038 | C#スクリプト実行 | E-23 | △ |
| BR-039 | スクリプトグローバル変数 | **根拠不足** | △ |
| BR-040 | 外部アナライザー統合 | E-06, E-09 | ○ |
| BR-041 | コードフィックスプロバイダー拡張 | E-05 | ○ |
| BR-042 | 補完プロバイダー拡張 | E-04 | ○ |
| BR-043 | テスト検出 | E-03 | ○ |
| BR-044 | テスト実行連携 | **根拠不足** | △ |
| BR-045 | Edit and Continue | E-22 | ○ |
| BR-046 | 式評価 | E-03 | ○ |
| BR-047 | MSBuild統合 | E-24 | ○ |
| BR-048 | ビルドホスティング | E-09 | ○ |
| BR-049 | 増分処理 | E-07, E-09 | ○ |
| BR-050 | 非同期処理 | E-03, E-07 | ○ |

## 4) 不足情報（Unknown / Missing）
- BR-039「スクリプトグローバル変数」：Scriptingモジュールの詳細なホストオブジェクト仕様のドキュメントが不足
  - 候補：`src/Scripting/Core/Hosting/` / `ScriptOptions.cs` / 公式ドキュメント
- BR-044「テスト実行連携」：テストランナーとの具体的な連携インターフェースの詳細が不足
  - 候補：`src/Features/Core/Portable/Testing/` / 外部テストフレームワークドキュメント / VS Test Platform仕様

## 5) リスクフラグ（レビュー観点）
- 0: コンパイラ関連機能（BR-001〜BR-008）- ソースコードから直接確認可能
- 0: IDE主要機能（BR-009〜BR-024）- Features/Coreディレクトリに実装確認
- 0: コード分析機能（BR-025〜BR-029）- Analyzersディレクトリに実装確認
- 0: ワークスペース機能（BR-030〜BR-034）- Workspacesディレクトリに実装確認
- 0: LSP機能（BR-035〜BR-037）- LanguageServer/Protocolに実装確認
- 1: スクリプティング機能（BR-038〜BR-039）- 詳細仕様の追加確認推奨
- 1: テスト連携機能（BR-043〜BR-044）- 外部連携仕様の確認推奨
- 0: ビルド・パフォーマンス機能（BR-045〜BR-050）- 実装確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] コンパイラ機能（BR-001〜BR-008）の優先度が適切か確認
- [ ] IDE機能（BR-009〜BR-024）のカテゴリ分類が適切か確認
- [ ] スクリプティング機能（BR-038, BR-039）の詳細仕様を補完
- [ ] テスト連携機能（BR-044）の実装詳細を確認
- [ ] 関連機能欄のコンポーネント名が最新のソースコードと一致するか確認
- [ ] 優先度（高/中/低）の判断基準が組織の方針と合致するか確認
