---
generated_at: 2026-02-10 12:50:00
metrics:
  claims_total: 146
  claims_with_evidence: 146
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：機能一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：146 / 146、根拠なし：0
- 優先レビュー（高）
  1. **なし**：すべての主張に根拠が存在

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `README.md` - プロジェクト概要説明
- E-02: `src/Compilers/` - コンパイラソースコードディレクトリ
- E-03: `src/Compilers/CSharp/csc/` - C#コンパイラ実行可能ファイル
- E-04: `src/Compilers/VisualBasic/` - VBコンパイラディレクトリ
- E-05: `src/Compilers/Core/Portable/` - コンパイラ共通基盤
- E-06: `src/Compilers/Core/MSBuildTask/` - MSBuildタスク
- E-07: `src/Compilers/Core/AnalyzerDriver/` - アナライザードライバー
- E-08: `src/Compilers/Extension/` - コンパイラ拡張機能
- E-09: `src/Workspaces/Core/` - ワークスペースコア
- E-10: `src/Workspaces/MSBuild/` - MSBuildワークスペース
- E-11: `src/Workspaces/Remote/` - リモートワークスペース
- E-12: `src/Features/Core/Portable/Completion/` - コード補完機能
- E-13: `src/Features/Core/Portable/SignatureHelp/` - シグネチャヘルプ
- E-14: `src/Features/Core/Portable/GoToDefinition/` - 定義へ移動
- E-15: `src/Features/Core/Portable/GoToBase/` - 基底へ移動
- E-16: `src/Features/Core/Portable/FindUsages/` - 参照の検索
- E-17: `src/Features/Core/Portable/DocumentHighlighting/` - ドキュメントハイライト
- E-18: `src/Features/Core/Portable/Navigation/` - ナビゲーション
- E-19: `src/Features/Core/Portable/NavigateTo/` - NavigateTo
- E-20: `src/Features/Core/Portable/NavigationBar/` - ナビゲーションバー
- E-21: `src/Features/Core/Portable/QuickInfo/` - クイック情報
- E-22: `src/Features/Core/Portable/Snippets/` - スニペット
- E-23: `src/Features/Core/Portable/CodeFixes/` - コード修正
- E-24: `src/Features/Core/Portable/CodeRefactorings/` - リファクタリング
- E-25: `src/Features/Core/Portable/CodeCleanup/` - コードクリーンアップ
- E-26: `src/Features/Core/Portable/Rename/` - 名前変更
- E-27: `src/Features/Core/Portable/ExtractMethod/` - メソッド抽出
- E-28: `src/Features/Core/Portable/ExtractInterface/` - インターフェース抽出
- E-29: `src/Features/Core/Portable/ExtractClass/` - クラス抽出
- E-30: `src/Features/Core/Portable/ChangeSignature/` - シグネチャ変更
- E-31: `src/Features/Core/Portable/EncapsulateField/` - フィールドカプセル化
- E-32: `src/Features/Core/Portable/MoveToNamespace/` - 名前空間移動
- E-33: `src/Features/Core/Portable/MoveStaticMembers/` - 静的メンバー移動
- E-34: `src/Features/Core/Portable/PullMemberUp/` - メンバー引き上げ
- E-35: `src/Features/Core/Portable/InlineMethod/` - メソッドインライン化
- E-36: `src/Features/Core/Portable/InlineTemporary/` - 一時変数インライン化
- E-37: `src/Features/Core/Portable/IntroduceParameter/` - パラメータ導入
- E-38: `src/Features/Core/Portable/IntroduceVariable/` - 変数導入
- E-39: `src/Features/Core/Portable/IntroduceUsingStatement/` - using文導入
- E-40: `src/Features/Core/Portable/GenerateConstructors/` - コンストラクタ生成
- E-41: `src/Features/Core/Portable/GenerateType/` - 型生成
- E-42: `src/Features/Core/Portable/ImplementInterface/` - インターフェース実装
- E-43: `src/Features/Core/Portable/GenerateOverrides/` - オーバーライド生成
- E-44: `src/Features/Core/Portable/GenerateEqualsAndGetHashCodeFromMembers/` - Equals/GetHashCode生成
- E-45: `src/Features/Core/Portable/GenerateComparisonOperators/` - 比較演算子生成
- E-46: `src/Features/Core/Portable/AddConstructorParametersFromMembers/` - コンストラクタパラメータ追加
- E-47: `src/Features/Core/Portable/ConvertAnonymousType/` - 匿名型変換
- E-48: `src/Features/Core/Portable/ConvertTupleToStruct/` - タプル変換
- E-49: `src/Features/Core/Portable/ConvertAutoPropertyToFullProperty/` - 自動プロパティ変換
- E-50: `src/Features/Core/Portable/ConvertForEachToFor/` - foreach変換
- E-51: `src/Features/Core/Portable/ConvertForToForEach/` - for変換
- E-52: `src/Features/Core/Portable/ConvertIfToSwitch/` - if-switch変換
- E-53: `src/Features/Core/Portable/ConvertLinq/` - LINQ変換
- E-54: `src/Features/Core/Portable/ConvertNumericLiteral/` - 数値リテラル変換
- E-55: `src/Features/Core/Portable/ConvertToInterpolatedString/` - 文字列補間変換
- E-56: `src/Features/Core/Portable/ConvertCast/` - キャスト変換
- E-57: `src/Features/Core/Portable/ReplaceConditionalWithStatements/` - 条件式変換
- E-58: `src/Features/Core/Portable/ReplaceMethodWithProperty/` - メソッド→プロパティ
- E-59: `src/Features/Core/Portable/ReplacePropertyWithMethods/` - プロパティ→メソッド
- E-60: `src/Features/Core/Portable/SplitOrMergeIfStatements/` - if文分割・結合
- E-61: `src/Features/Core/Portable/InvertIf/` - 条件反転
- E-62: `src/Features/Core/Portable/InvertLogical/` - 論理反転
- E-63: `src/Features/Core/Portable/AddImport/` - using追加
- E-64: `src/Features/Core/Portable/AddPackage/` - パッケージ追加
- E-65: `src/Features/Core/Portable/AddMissingReference/` - 参照追加
- E-66: `src/Features/Core/Portable/FullyQualify/` - 完全修飾
- E-67: `src/Features/Core/Portable/OrganizeImports/` - インポート整理
- E-68: `src/Features/Core/Portable/Diagnostics/` - 診断
- E-69: `src/Features/Core/Portable/SpellCheck/` - スペルチェック
- E-70: `src/Features/Core/Portable/UnusedReferences/` - 未使用参照
- E-71: `src/Features/Core/Portable/RemoveUnusedVariable/` - 未使用変数削除
- E-72: `src/Features/Core/Portable/TaskList/` - タスクリスト
- E-73: `src/Features/Core/Portable/BraceCompletion/` - 括弧補完
- E-74: `src/Features/Core/Portable/BraceMatching/` - 括弧マッチング
- E-75: `src/Features/Core/Portable/BracePairs/` - 括弧ペア
- E-76: `src/Features/Core/Portable/CommentSelection/` - コメント選択
- E-77: `src/Features/Core/Portable/DocumentationComments/` - ドキュメントコメント
- E-78: `src/Features/Core/Portable/Formatting/` - フォーマット
- E-79: `src/Features/Core/Portable/LineSeparators/` - 行セパレータ
- E-80: `src/Features/Core/Portable/Structure/` - コード構造
- E-81: `src/Features/Core/Portable/StringIndentation/` - 文字列インデント
- E-82: `src/Features/Core/Portable/InlineHints/` - インラインヒント
- E-83: `src/Features/Core/Portable/Wrapping/` - コードラッピング
- E-84: `src/Features/Core/Portable/EditAndContinue/` - Edit and Continue
- E-85: `src/Features/Core/Portable/Debugging/` - デバッグ機能
- E-86: `src/Features/Core/Portable/AddDebuggerDisplay/` - DebuggerDisplay追加
- E-87: `src/Features/Core/Portable/StackTraceExplorer/` - スタックトレース探索
- E-88: `src/Features/Core/Portable/ValueTracking/` - 値追跡
- E-89: `src/Features/Core/Portable/MetadataAsSource/` - メタデータソース
- E-90: `src/Features/Core/Portable/DecompiledSource/` - 逆コンパイル
- E-91: `src/Features/Core/Portable/PdbSourceDocument/` - PDBソース
- E-92: `src/LanguageServer/Protocol/` - LSPプロトコル
- E-93: `src/LanguageServer/Microsoft.CommonLanguageServerProtocol.Framework/` - 共通LSP
- E-94: `src/LanguageServer/Microsoft.CodeAnalysis.LanguageServer/` - Roslyn LSP
- E-95: `src/Features/Core/Portable/CodeLens/` - CodeLens
- E-96: `src/Features/Core/Portable/InheritanceMargin/` - 継承マージン
- E-97: `src/Scripting/CSharp/` - C#スクリプト
- E-98: `src/Scripting/VisualBasic/` - VBスクリプト
- E-99: `src/Scripting/Core/` - スクリプトコア
- E-100: `src/Interactive/csi/` - C# REPL
- E-101: `src/Interactive/vbi/` - VB REPL
- E-102: `src/Interactive/Host/` - インタラクティブホスト
- E-103: `src/VisualStudio/CSharp/` - VS C#拡張
- E-104: `src/VisualStudio/VisualBasic/` - VS VB拡張
- E-105: `src/VisualStudio/Core/` - VSコア
- E-106: `src/VisualStudio/CodeLens/` - CodeLens拡張
- E-107: `src/VisualStudio/LiveShare/` - LiveShare
- E-108: `src/VisualStudio/Razor/` - Razor
- E-109: `src/VisualStudio/Xaml/` - XAML
- E-110: `src/EditorFeatures/Core/` - エディタコア
- E-111: `src/EditorFeatures/CSharp/` - C#エディタ
- E-112: `src/EditorFeatures/VisualBasic/` - VBエディタ
- E-113: `src/EditorFeatures/Text/` - テキストエディタ
- E-114: `src/RoslynAnalyzers/` - Roslynアナライザー
- E-115: `src/Analyzers/CSharp/` - C#アナライザー
- E-116: `src/Analyzers/VisualBasic/` - VBアナライザー
- E-117: `src/Analyzers/Core/` - コアアナライザー
- E-118: `src/CodeStyle/` - コードスタイル
- E-119: `src/Tools/AnalyzerRunner/` - AnalyzerRunner
- E-120: `src/Tools/BuildBoss/` - BuildBoss
- E-121: `src/Tools/BuildValidator/` - BuildValidator
- E-122: `src/Tools/dotnet-format/` - dotnet-format
- E-123: `src/Tools/IdeBenchmarks/` - IDEベンチマーク
- E-124: `src/Tools/PrepareTests/` - テスト準備
- E-125: `src/Tools/SemanticSearch/` - セマンティック検索
- E-126: `src/Features/Core/Portable/Copilot/` - Copilot連携
- E-127: `src/Features/Core/Portable/SymbolSearch/` - シンボル検索
- E-128: `src/Features/Core/Portable/SyncNamespaces/` - 名前空間同期
- E-129: `src/Features/Core/Portable/MapCode/` - マップコード
- E-130: `src/Features/Core/Portable/UseNamedArguments/` - 名前付き引数
- E-131: `src/Features/Core/Portable/NameTupleElement/` - タプル要素命名
- E-132: `src/Features/Core/Portable/SimplifyThisOrMe/` - this簡略化
- E-133: `src/Features/Core/Portable/SimplifyTypeNames/` - 型名簡略化
- E-134: `src/Features/Core/Portable/PreferFrameworkType/` - フレームワーク型優先
- E-135: `src/Features/Core/Portable/RawStringLiteral/` - 生文字列リテラル
- E-136: `src/Features/Core/Portable/MoveDeclarationNearReference/` - 宣言移動
- E-137: `src/Features/Core/Portable/AddFileBanner/` - ファイルバナー
- E-138: `src/Features/Core/Portable/InitializeParameter/` - パラメータ初期化
- E-139: `src/Features/Core/Portable/PickMembers/` - メンバー選択
- E-140: `src/Features/Core/Portable/SolutionCrawler/` - ソリューションクローラー
- E-141: `src/Features/Core/Portable/SolutionExplorer/` - ソリューションエクスプローラー
- E-142: `src/Features/Core/Portable/ProjectManagement/` - プロジェクト管理
- E-143: `src/Features/Core/Portable/EmbeddedLanguages/` - 埋め込み言語
- E-144: `src/Features/Core/Portable/Intents/` - インテント
- E-145: `src/Features/Core/Portable/SemanticSearch/` - セマンティック検索機能
- E-146: `src/Features/Core/Portable/Testing/` - テストサポート
- E-147: `src/Features/Core/Portable/Emit/` - IL出力
- E-148: `src/Features/Lsif/` - LSIF

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | C#コンパイラ (csc) - C#ソースコードをILにコンパイル | E-02, E-03 | ○ |
| C-02 | Visual Basicコンパイラ (vbc) - VBソースコードをILにコンパイル | E-02, E-04 | ○ |
| C-03 | コンパイラ共通基盤 - 構文解析・セマンティック解析・コード生成 | E-05 | ○ |
| C-04 | MSBuildタスク - MSBuildからコンパイラ呼び出し | E-06 | ○ |
| C-05 | アナライザードライバー - アナライザー実行基盤 | E-07 | ○ |
| C-06 | 拡張機能 - コンパイラ拡張ポイント | E-08 | ○ |
| C-07 | ワークスペース管理 - ソリューション・プロジェクト管理 | E-09 | ○ |
| C-08 | MSBuildワークスペース - MSBuildプロジェクトからワークスペース構築 | E-10 | ○ |
| C-09 | リモートワークスペース - プロセス間通信 | E-11 | ○ |
| C-10 | コード補完 (IntelliSense) - 入力補完 | E-12 | ○ |
| C-11 | シグネチャヘルプ - パラメータ情報表示 | E-13 | ○ |
| C-12 | 定義へ移動 - シンボル定義への移動 | E-14 | ○ |
| C-13 | 基底へ移動 - 基底クラスへの移動 | E-15 | ○ |
| C-14 | 参照の検索 - シンボル使用箇所の検索 | E-16 | ○ |
| C-15 | ドキュメントハイライト - シンボル出現箇所のハイライト | E-17 | ○ |
| C-16 | ナビゲーション - ファイル・プロジェクト内移動 | E-18 | ○ |
| C-17 | NavigateTo - シンボル検索ナビゲーション | E-19 | ○ |
| C-18 | ナビゲーションバー - ドロップダウン選択 | E-20 | ○ |
| C-19 | クイック情報 - ホバー情報表示 | E-21 | ○ |
| C-20 | スニペット - コードスニペット | E-22 | ○ |
| C-21 | コード修正 (CodeFix) - 自動修正 | E-23 | ○ |
| C-22 | コードリファクタリング - コード品質向上 | E-24 | ○ |
| C-23 | コードクリーンアップ - 一括修正 | E-25 | ○ |
| C-24 | 名前変更 (Rename) - シンボル名一括変更 | E-26 | ○ |
| C-25 | メソッド抽出 - 新メソッドへの抽出 | E-27 | ○ |
| C-26 | インターフェース抽出 - インターフェース抽出 | E-28 | ○ |
| C-27 | クラス抽出 - 新クラスへの移動 | E-29 | ○ |
| C-28 | シグネチャ変更 - パラメータ変更 | E-30 | ○ |
| C-29 | フィールドのカプセル化 - プロパティ化 | E-31 | ○ |
| C-30 | 名前空間の移動 - 別名前空間への移動 | E-32 | ○ |
| C-31 | 静的メンバーの移動 - 別型への移動 | E-33 | ○ |
| C-32 | メンバーの引き上げ - 基底クラスへの移動 | E-34 | ○ |
| C-33 | メソッドのインライン化 - 呼び出し箇所展開 | E-35 | ○ |
| C-34 | 一時変数のインライン化 - 式への置換 | E-36 | ○ |
| C-35 | パラメータの導入 - パラメータ抽出 | E-37 | ○ |
| C-36 | 変数の導入 - 変数抽出 | E-38 | ○ |
| C-37 | using文の導入 - usingでラップ | E-39 | ○ |
| C-38 | コンストラクタ生成 - フィールドからコンストラクタ | E-40 | ○ |
| C-39 | 型生成 - 存在しない型の生成 | E-41 | ○ |
| C-40 | インターフェース実装 - メンバー自動実装 | E-42 | ○ |
| C-41 | オーバーライド生成 - 仮想メンバーオーバーライド | E-43 | ○ |
| C-42 | Equals/GetHashCode生成 - メンバーから生成 | E-44 | ○ |
| C-43 | 比較演算子生成 - IComparableから生成 | E-45 | ○ |
| C-44 | コンストラクタパラメータ追加 - メンバーから追加 | E-46 | ○ |
| C-45 | 匿名型を構造体に変換 - 型変換 | E-47 | ○ |
| C-46 | タプルを構造体に変換 - 型変換 | E-48 | ○ |
| C-47 | 自動プロパティをフルプロパティに変換 | E-49 | ○ |
| C-48 | foreachをforに変換 | E-50 | ○ |
| C-49 | forをforeachに変換 | E-51 | ○ |
| C-50 | ifをswitchに変換 | E-52 | ○ |
| C-51 | LINQクエリ変換 | E-53 | ○ |
| C-52 | 数値リテラル変換 | E-54 | ○ |
| C-53 | 文字列補間に変換 | E-55 | ○ |
| C-54 | キャスト変換 | E-56 | ○ |
| C-55 | 条件式をステートメントに変換 | E-57 | ○ |
| C-56 | メソッドをプロパティに変換 | E-58 | ○ |
| C-57 | プロパティをメソッドに変換 | E-59 | ○ |
| C-58 | if文の分割・結合 | E-60 | ○ |
| C-59 | 条件反転 | E-61 | ○ |
| C-60 | 論理反転 | E-62 | ○ |
| C-61 | usingディレクティブ追加 | E-63 | ○ |
| C-62 | パッケージ追加 | E-64 | ○ |
| C-63 | 不足参照の追加 | E-65 | ○ |
| C-64 | 型の完全修飾 | E-66 | ○ |
| C-65 | インポート整理 | E-67 | ○ |
| C-66 | 診断エンジン | E-68 | ○ |
| C-67 | スペルチェック | E-69 | ○ |
| C-68 | 未使用参照検出 | E-70 | ○ |
| C-69 | 未使用変数削除 | E-71 | ○ |
| C-70 | タスクリスト | E-72 | ○ |
| C-71 | 括弧補完 | E-73 | ○ |
| C-72 | 括弧マッチング | E-74 | ○ |
| C-73 | 括弧ペア | E-75 | ○ |
| C-74 | コメント選択 | E-76 | ○ |
| C-75 | ドキュメントコメント | E-77 | ○ |
| C-76 | フォーマット | E-78 | ○ |
| C-77 | 行セパレータ | E-79 | ○ |
| C-78 | コード構造 | E-80 | ○ |
| C-79 | 文字列インデント | E-81 | ○ |
| C-80 | インラインヒント | E-82 | ○ |
| C-81 | コードラッピング | E-83 | ○ |
| C-82 | Edit and Continue | E-84 | ○ |
| C-83 | デバッグ機能 | E-85 | ○ |
| C-84 | DebuggerDisplay追加 | E-86 | ○ |
| C-85 | スタックトレース探索 | E-87 | ○ |
| C-86 | 値追跡 | E-88 | ○ |
| C-87 | メタデータソース表示 | E-89 | ○ |
| C-88 | 逆コンパイルソース | E-90 | ○ |
| C-89 | PDBソースドキュメント | E-91 | ○ |
| C-90 | Language Server Protocol | E-92 | ○ |
| C-91 | 共通LSPフレームワーク | E-93 | ○ |
| C-92 | Roslyn言語サーバー | E-94 | ○ |
| C-93 | CodeLens | E-95 | ○ |
| C-94 | 継承マージン | E-96 | ○ |
| C-95 | C#スクリプト | E-97 | ○ |
| C-96 | VBスクリプト | E-98 | ○ |
| C-97 | スクリプトコア | E-99 | ○ |
| C-98 | C# REPL (csi) | E-100 | ○ |
| C-99 | VB REPL (vbi) | E-101 | ○ |
| C-100 | インタラクティブホスト | E-102 | ○ |
| C-101 | VS C#拡張 | E-103 | ○ |
| C-102 | VS VB拡張 | E-104 | ○ |
| C-103 | VS コア | E-105 | ○ |
| C-104 | CodeLens拡張 | E-106 | ○ |
| C-105 | LiveShare連携 | E-107 | ○ |
| C-106 | Razor連携 | E-108 | ○ |
| C-107 | XAML連携 | E-109 | ○ |
| C-108 | エディタ機能基盤 | E-110 | ○ |
| C-109 | C#エディタ機能 | E-111 | ○ |
| C-110 | VBエディタ機能 | E-112 | ○ |
| C-111 | テキストエディタ | E-113 | ○ |
| C-112 | Roslynアナライザー | E-114 | ○ |
| C-113 | C#アナライザー | E-115 | ○ |
| C-114 | VBアナライザー | E-116 | ○ |
| C-115 | コアアナライザー | E-117 | ○ |
| C-116 | コードスタイル分析 | E-118 | ○ |
| C-117 | AnalyzerRunner | E-119 | ○ |
| C-118 | BuildBoss | E-120 | ○ |
| C-119 | BuildValidator | E-121 | ○ |
| C-120 | dotnet-format | E-122 | ○ |
| C-121 | IDEベンチマーク | E-123 | ○ |
| C-122 | テスト準備 | E-124 | ○ |
| C-123 | セマンティック検索ツール | E-125 | ○ |
| C-124 | Copilot連携 | E-126 | ○ |
| C-125 | シンボル検索 | E-127 | ○ |
| C-126 | 名前空間同期 | E-128 | ○ |
| C-127 | マップコード | E-129 | ○ |
| C-128 | 名前付き引数使用 | E-130 | ○ |
| C-129 | タプル要素命名 | E-131 | ○ |
| C-130 | thisの簡略化 | E-132 | ○ |
| C-131 | 型名の簡略化 | E-133 | ○ |
| C-132 | フレームワーク型優先 | E-134 | ○ |
| C-133 | 生文字列リテラル | E-135 | ○ |
| C-134 | 宣言の移動 | E-136 | ○ |
| C-135 | ファイルバナー追加 | E-137 | ○ |
| C-136 | パラメータ初期化 | E-138 | ○ |
| C-137 | メンバー選択 | E-139 | ○ |
| C-138 | ソリューションクローラー | E-140 | ○ |
| C-139 | ソリューションエクスプローラー | E-141 | ○ |
| C-140 | プロジェクト管理 | E-142 | ○ |
| C-141 | 埋め込み言語サポート | E-143 | ○ |
| C-142 | インテントサポート | E-144 | ○ |
| C-143 | セマンティック検索機能 | E-145 | ○ |
| C-144 | テストサポート | E-146 | ○ |
| C-145 | IL出力 | E-147 | ○ |
| C-146 | LSIF出力 | E-148 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：すべての機能項目に対して、対応するソースコードディレクトリが存在することを確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に対してソースコードディレクトリという明確な根拠が存在

## 6) レビュアーチェックリスト（最小）
- [ ] 機能名と説明がソースコードの実際の内容と一致しているか確認
- [ ] カテゴリ分類が適切か確認
- [ ] 重要な機能が漏れていないか確認
- [ ] 備考欄のディレクトリパスが正確か確認
