# 機能設計書 100-インタラクティブホスト

## 概要

本ドキュメントは、Roslyn のインタラクティブホスト（InteractiveHost）機能の設計を定義する。インタラクティブホストは、Visual Studio のインタラクティブウィンドウで使用される、別プロセスでスクリプトを実行するためのホスト環境を提供する。

### 本機能の処理概要

InteractiveHost は、Visual Studio のインタラクティブウィンドウ（C# Interactive、VB Interactive）のバックエンドとして動作する。スクリプトの実行は専用のホストプロセスで行われ、メイン IDE プロセスとは分離される。これにより、スクリプトのクラッシュや長時間実行が IDE に影響を与えないようになっている。

**業務上の目的・背景**：Visual Studio 内でインタラクティブにコードを実行する際、実行環境を IDE プロセスから分離することで、スクリプトの問題が IDE 全体に影響を与えないようにする。また、プラットフォーム（.NET Framework / .NET Core）の切り替えや、プロセスのリセットを可能にする。

**機能の利用シーン**：
- Visual Studio の C# Interactive ウィンドウ
- Visual Studio の VB Interactive ウィンドウ
- IDE 内でのコード実験とプロトタイピング

**主要な処理内容**：
1. ホストプロセスの起動と管理
2. JSON-RPC を介した IDE とホストプロセス間の通信
3. スクリプトの実行とリセット
4. 標準出力・標準エラーのキャプチャと転送
5. プラットフォーム設定の管理

**関連システム・外部連携**：Visual Studio、StreamJsonRpc、.NET ランタイム。

**権限による制御**：ホストプロセスはユーザー権限で実行される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | C# Interactive ウィンドウ | 主画面 | コード実行と結果表示 |
| - | VB Interactive ウィンドウ | 主画面 | コード実行と結果表示 |

## 機能種別

プロセス管理 / RPC 通信 / スクリプトホスティング

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| replServiceProviderType | Type | Yes | REPL サービスプロバイダーの型 | null チェック |
| workingDirectory | string | Yes | 作業ディレクトリ | 有効なパス |
| millisecondsTimeout | int | No | タイムアウト（ミリ秒） | デフォルト 5000 |

#### InteractiveHostOptions

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Platform | InteractiveHostPlatform | Yes | 実行プラットフォーム | Desktop64Bit, Core 等 |
| InitializationFilePath | string | No | 初期化ファイルパス | 有効なパス |

### 入力データソース

- IDE からの JSON-RPC リクエスト
- スクリプトコード文字列
- ファイルパス

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| RemoteExecutionResult | RemoteExecutionResult | 実行結果 |
| 標準出力 | char[] | 出力テキスト |
| 標準エラー | char[] | エラーテキスト |

### 出力先

- JSON-RPC を介した IDE へのレスポンス
- 標準出力・標準エラーのキャプチャ

## 処理フロー

### 処理シーケンス

```
1. ホスト初期化
   └─ InteractiveHost コンストラクタ
2. リモートサービス作成
   └─ CreateRemoteService でホストプロセス起動
3. 初期化
   └─ ResetAsync でホストプロセスを初期化/リセット
4. コード実行
   └─ ExecuteAsync でコードを送信・実行
5. 結果受信
   └─ RemoteExecutionResult で結果を受け取り
6. 出力転送
   └─ OnOutputReceived で標準出力をキャプチャ
```

### フローチャート

```mermaid
flowchart TD
    A[InteractiveHost 作成] --> B[ResetAsync 呼び出し]
    B --> C[LazyRemoteService 作成]
    C --> D[ホストプロセス起動]
    D --> E[JSON-RPC 接続確立]
    E --> F{初期化成功?}
    F -->|Yes| G[待機状態]
    F -->|No| H[リトライ or エラー]
    G --> I[ExecuteAsync 呼び出し]
    I --> J[InvokeRemoteAsync]
    J --> K[ホストプロセスで実行]
    K --> L[結果返却]
    L --> M{継続?}
    M -->|Yes| I
    M -->|No| N[Dispose]
    N --> O[プロセス終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-100-01 | プロセス分離 | スクリプト実行は別プロセスで行う | 常に |
| BR-100-02 | 自動リカバリ | ホストプロセスクラッシュ時は自動再起動 | MaxAttemptsToCreateProcess = 2 |
| BR-100-03 | Unicode 出力 | 標準出力/エラーは Unicode エンコーディング | OutputEncoding = Encoding.Unicode |
| BR-100-04 | デフォルトプラットフォーム | デフォルトは .NET Core | DefaultPlatform = InteractiveHostPlatform.Core |

### 計算ロジック

タイムアウト管理:
- millisecondsTimeout（デフォルト 5000ms）でプロセス初期化の待機時間を制御

## データベース操作仕様

本機能はデータベースを直接操作しない。

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | プロセス起動失敗 | ホストプロセスが起動できない | プロセス再起動試行 |
| - | 通信エラー | JSON-RPC 接続失敗 | プロセスリセット |
| - | プロセスクラッシュ | ホストプロセスが異常終了 | 自動再起動 |
| - | OperationCanceledException | リセット中にキャンセル | 新プロセスで再開 |

### リトライ仕様

- プロセス起動: 最大 2 回試行
- 通信エラー: プロセスリセットで対応

## トランザクション仕様

トランザクション不要。各実行は独立した操作。

## パフォーマンス要件

- プロセス起動: 2 秒以内
- コード実行応答: 実行時間 + RPC オーバーヘッド（100ms 以下）

## セキュリティ考慮事項

- ホストプロセスは IDE と同じユーザー権限で実行
- プロセス間通信は名前付きパイプ経由で暗号化なし（ローカルのみ）

## 備考

Visual Studio の Interactive Window 機能で使用される。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: メインクラスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | InteractiveHost.cs | `src/Interactive/Host/Interactive/Core/InteractiveHost.cs` | ホストのメインクラス |

**主要処理フロー**:
- **26行目**: DefaultPlatform = InteractiveHostPlatform.Core
- **35行目**: OutputEncoding = Encoding.Unicode
- **71-85行目**: コンストラクタ
- **113-120行目**: Dispose
- **127-150行目**: SetOutputs - 出力設定
- **187-190行目**: CreateRemoteService - リモートサービス作成
- **269-271行目**: ExecuteRemoteAsync - リモート実行
- **330-352行目**: ResetAsync - リセット
- **362-366行目**: ExecuteAsync - コード実行
- **377-381行目**: ExecuteFileAsync - ファイル実行
- **391-395行目**: AddReferenceAsync - 参照追加
- **400-407行目**: SetPathsAsync - パス設定

#### Step 2: リモートサービスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | InteractiveHost.RemoteService.cs | `src/Interactive/Host/Interactive/Core/InteractiveHost.RemoteService.cs` | リモートサービス実装 |
| 2-2 | InteractiveHost.LazyRemoteService.cs | `src/Interactive/Host/Interactive/Core/InteractiveHost.LazyRemoteService.cs` | 遅延初期化サービス |
| 2-3 | InteractiveHost.Service.cs | `src/Interactive/Host/Interactive/Core/InteractiveHost.Service.cs` | ホストプロセス側サービス |

#### Step 3: 実行結果を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | RemoteExecutionResult.cs | `src/Interactive/Host/Interactive/Core/RemoteExecutionResult.cs` | 実行結果データ構造 |

#### Step 4: オプションを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | InteractiveHostOptions.cs | `src/Interactive/Host/Interactive/Core/InteractiveHostOptions.cs` | ホストオプション |
| 4-2 | InteractiveHostPlatform.cs | `src/Interactive/Host/Interactive/Core/InteractiveHostPlatform.cs` | プラットフォーム列挙 |

### プログラム呼び出し階層図

```
InteractiveHost
    │
    ├─ コンストラクタ
    │      └─ 初期化
    │
    ├─ ResetAsync(options)
    │      └─ CreateRemoteService(options)
    │             └─ LazyRemoteService
    │                    └─ GetInitializedServiceAsync()
    │                           └─ RemoteService
    │                                  └─ Process 起動
    │                                  └─ JsonRpc 接続
    │
    ├─ ExecuteAsync(code)
    │      └─ ExecuteRemoteAsync("ExecuteAsync", code)
    │             └─ InvokeRemoteAsync<RemoteExecutionResult.Data>()
    │                    └─ remoteService.JsonRpc.InvokeAsync()
    │
    ├─ ExecuteFileAsync(path)
    │      └─ ExecuteRemoteAsync("ExecuteFileAsync", path)
    │
    └─ Dispose()
           └─ DisposeRemoteService()
                  └─ LazyRemoteService.Dispose()
```

### データフロー図

```
[入力]                          [処理]                              [出力]

InteractiveHostOptions ──▶ CreateRemoteService() ─────────▶ LazyRemoteService
                                 │
                                 ▼
                         Process.Start() ─────────────────▶ ホストプロセス
                                 │
                                 ▼
string code ────────────▶ ExecuteAsync() ─────────────────▶ JSON-RPC リクエスト
                                 │
                                 ▼
                         ホストプロセスで実行 ─────────────▶ RemoteExecutionResult
                                 │
                                 ▼
                         stdout/stderr キャプチャ ─────────▶ OnOutputReceived
                                 │
                                 ▼
                         TextWriter に出力 ───────────────▶ IDE へ表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| InteractiveHost.cs | `src/Interactive/Host/Interactive/Core/` | ソース | メインホストクラス |
| InteractiveHost.RemoteService.cs | `src/Interactive/Host/Interactive/Core/` | ソース | リモートサービス |
| InteractiveHost.LazyRemoteService.cs | `src/Interactive/Host/Interactive/Core/` | ソース | 遅延初期化 |
| InteractiveHost.Service.cs | `src/Interactive/Host/Interactive/Core/` | ソース | プロセス側サービス |
| RemoteExecutionResult.cs | `src/Interactive/Host/Interactive/Core/` | ソース | 実行結果 |
| InteractiveHostOptions.cs | `src/Interactive/Host/Interactive/Core/` | ソース | オプション |
| InteractiveHostPlatform.cs | `src/Interactive/Host/Interactive/Core/` | ソース | プラットフォーム |
| InteractiveHostPlatformInfo.cs | `src/Interactive/Host/Interactive/Core/` | ソース | プラットフォーム情報 |
| ReplServiceProvider.cs | `src/Interactive/Host/Interactive/Core/` | ソース | REPL サービスプロバイダー |
| InteractiveHostResources.resx | `src/Interactive/Host/` | リソース | 文字列リソース |
