# 機能設計書 101-VS C#拡張

## 概要

本ドキュメントは、Roslyn における Visual Studio 用 C# 言語サービス拡張機能の設計を記述する。この機能は Visual Studio IDE 内で C# 言語に対する包括的な言語サービスを提供する。

### 本機能の処理概要

Visual Studio 用 C# 拡張機能は、Visual Studio IDE 内で C# コードを編集する際に必要なすべての言語サービス機能を提供するパッケージである。

**業務上の目的・背景**：開発者が Visual Studio で C# コードを効率的に編集・デバッグ・ナビゲートするために、IDE と Roslyn コンパイラ/アナライザー基盤を統合する必要がある。この拡張機能により、IntelliSense、コード補完、シンタックスハイライト、リファクタリング、診断表示などの高度な編集機能が C# 開発者に提供される。

**機能の利用シーン**：Visual Studio で C# プロジェクトを開いた際に自動的にロードされ、コード編集、ナビゲーション、リファクタリング、デバッグなどすべての C# 開発作業において使用される。具体的には、コード補完の表示、定義への移動、参照の検索、名前変更、コードフォーマット、診断メッセージの表示などの場面で動作する。

**主要な処理内容**：
1. CSharpPackage の初期化とサービス登録（言語サービス、TempPE コンパイラ、プロジェクトホスト）
2. オプションページの提供（詳細設定、コードスタイル、フォーマット、命名規則）
3. エディタファクトリの生成と登録
4. オブジェクトブラウザライブラリマネージャの管理
5. プロジェクトシステムシムを通じた旧プロジェクトシステムとの互換性維持
6. コードモデル（EnvDTE）の提供によるマクロ・アドイン連携

**関連システム・外部連携**：Visual Studio Shell、MSBuild、NuGet パッケージマネージャ、Visual Studio テーマシステム、オブジェクトブラウザ、EnvDTE オートメーションモデルと連携する。

**権限による制御**：特定の権限制御はないが、ユーザー設定（オプションページ）によって機能の有効/無効を切り替え可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 34 | C#詳細オプションページコントロール | 主画面 | C#の分析・アウトライン・インラインヒント等の詳細設定 |
| 35 | C#書式設定オプションページコントロール | 主画面 | C#コードのインデント・改行・スペース設定 |

## 機能種別

IDE統合 / サービス提供 / 設定管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| なし | - | - | パッケージは Visual Studio によって自動的にロードされる | - |

### 入力データソース

- Visual Studio プロジェクトシステムからのプロジェクト情報
- ユーザー設定（Visual Studio オプション）
- 開いているドキュメントのテキストバッファ

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| LanguageService | CSharpLanguageService | C# 言語サービスインスタンス |
| EditorFactories | IEnumerable\<IVsEditorFactory\> | エディタファクトリ群 |
| AutomationObject | AutomationObject | オートメーション用オブジェクト |

### 出力先

- Visual Studio サービスコンテナ
- Visual Studio オブジェクトブラウザ
- Visual Studio エディタシステム

## 処理フロー

### 処理シーケンス

```
1. Visual Studio がパッケージをロード
   └─ CSharpPackage.InitializeAsync() が呼び出される
2. バックグラウンド初期化タスクの登録
   └─ PackageInitializationBackgroundThreadAsync() でサービス登録
3. TempPE コンパイラサービスの登録
   └─ ICSharpTempPECompilerService をサービスコンテナに追加
4. プロジェクトホストサービスの登録
   └─ ICSharpProjectHost をサービスコンテナに追加
5. オブジェクトブラウザライブラリマネージャの登録
   └─ RegisterObjectBrowserLibraryManager() でライブラリを登録
6. エディタファクトリの生成
   └─ CreateEditorFactories() で CSharpEditorFactory を生成
7. 言語サービスの生成
   └─ CreateLanguageService() で CSharpLanguageService を生成
```

### フローチャート

```mermaid
flowchart TD
    A[VS パッケージロード] --> B[InitializeAsync]
    B --> C[バックグラウンド初期化]
    C --> D[TempPE コンパイラ登録]
    C --> E[プロジェクトホスト登録]
    B --> F[ObjectBrowser 登録]
    B --> G[エディタファクトリ生成]
    B --> H[言語サービス生成]
    F --> I[パッケージ初期化完了]
    G --> I
    H --> I
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-101-01 | パッケージ遅延ロード | パッケージは必要になるまでロードされない | VS 起動時 |
| BR-101-02 | サービス非同期初期化 | 重い初期化処理はバックグラウンドで実行 | パッケージロード時 |
| BR-101-03 | オートメーション互換性 | EnvDTE オートメーションモデルとの互換性を維持 | マクロ/アドイン使用時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし（インメモリ処理のみ）

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | FatalError | 初期化中の例外 | FatalError.ReportAndPropagateUnlessCanceled でレポート |
| - | InvalidOperationException | ワークスペース取得失敗 | ログ出力して継続 |

### リトライ仕様

リトライなし（初期化失敗時は機能が利用不可となる）

## トランザクション仕様

トランザクションなし

## パフォーマンス要件

- パッケージの初期化は非同期で行い、UI スレッドをブロックしない
- バックグラウンドタスクで重い処理を実行
- オブジェクトブラウザライブラリマネージャは必要時のみ初期化

## セキュリティ考慮事項

- サービスは Visual Studio プロセス内で実行され、プロセス境界を超えない
- ユーザー設定はローカルに保存される

## 備考

- Visual Studio 2022 以降では新しいプロジェクトシステム（CPS）が使用されるが、旧プロジェクトシステムとの互換性のためにプロジェクトシムが維持されている
- オプションページは PackageRegistration.pkgdef にも重複定義されている

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、パッケージの基本構造と継承関係を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | CSharpPackage.cs | `src/VisualStudio/CSharp/Impl/CSharpPackage.cs` | AbstractPackage を継承した C# パッケージの実装、属性によるオプションページ登録 |

**読解のコツ**: クラス宣言の上部にある `[ProvideLanguageEditorOptionPage]` 属性群がオプションページの階層構造を定義している。これらの属性は Visual Studio のツール > オプションメニューに表示されるページを登録する。

#### Step 2: エントリーポイントを理解する

パッケージの初期化処理の流れを追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CSharpPackage.cs | `src/VisualStudio/CSharp/Impl/CSharpPackage.cs` | RegisterInitializeAsyncWork, PackageInitializationBackgroundThreadAsync |

**主要処理フロー**:
1. **63-68行目**: RegisterInitializeAsyncWork でバックグラウンドタスクを登録
2. **70-95行目**: PackageInitializationBackgroundThreadAsync で TempPE コンパイラとプロジェクトホストを登録
3. **97-112行目**: RegisterObjectBrowserLibraryManager でオブジェクトブラウザを登録
4. **149-155行目**: CreateEditorFactories でエディタファクトリを生成

#### Step 3: オプションページを理解する

オプションページの実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AdvancedOptionPage.cs | `src/VisualStudio/CSharp/Impl/Options/AdvancedOptionPage.cs` | AbstractOptionPage を継承した詳細オプションページ |
| 3-2 | AdvancedOptionPageControl.xaml.cs | `src/VisualStudio/CSharp/Impl/Options/AdvancedOptionPageControl.xaml.cs` | オプションページのUI実装 |

**主要処理フロー**:
- **14-17行目（AdvancedOptionPage.cs）**: CreateOptionPage でオプションページコントロールを生成

#### Step 4: プロジェクトシステムシムを理解する

旧プロジェクトシステムとの互換性レイヤーを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | CSharpProjectShim.cs | `src/VisualStudio/CSharp/Impl/ProjectSystemShim/CSharpProjectShim.cs` | ICSCompilerConfig, ICSharpProjectSite などの COM インターフェース実装 |

### プログラム呼び出し階層図

```
CSharpPackage (エントリーポイント)
    │
    ├─ PackageInitializationBackgroundThreadAsync
    │      ├─ TempPECompilerService 登録
    │      └─ ICSharpProjectHost 登録
    │
    ├─ RegisterObjectBrowserLibraryManager
    │      └─ ObjectBrowserLibraryManager
    │
    ├─ CreateEditorFactories
    │      ├─ CSharpEditorFactory
    │      └─ CSharpCodePageEditorFactory
    │
    └─ CreateLanguageService
           └─ CSharpLanguageService
```

### データフロー図

```
[入力]                    [処理]                         [出力]

VS Shell ───────────▶ CSharpPackage 初期化 ───────▶ サービス登録
                            │
プロジェクト情報 ──────▶ ProjectSystemShim ───────▶ Roslyn Workspace
                            │
ユーザー設定 ───────────▶ OptionPage ─────────────▶ IGlobalOptionService
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CSharpPackage.cs | `src/VisualStudio/CSharp/Impl/CSharpPackage.cs` | ソース | パッケージのメインクラス |
| AdvancedOptionPage.cs | `src/VisualStudio/CSharp/Impl/Options/AdvancedOptionPage.cs` | ソース | 詳細オプションページ |
| AdvancedOptionPageControl.xaml.cs | `src/VisualStudio/CSharp/Impl/Options/AdvancedOptionPageControl.xaml.cs` | ソース | 詳細オプションページUI |
| FormattingOptionPage.cs | `src/VisualStudio/CSharp/Impl/Options/Formatting/FormattingOptionPage.cs` | ソース | フォーマットオプションページ |
| NamingStylesOptionPage.cs | `src/VisualStudio/CSharp/Impl/Options/NamingStylesOptionPage.cs` | ソース | 命名規則オプションページ |
| CSharpProjectShim.cs | `src/VisualStudio/CSharp/Impl/ProjectSystemShim/CSharpProjectShim.cs` | ソース | プロジェクトシステムシム |
| CSharpCodeModelService.cs | `src/VisualStudio/CSharp/Impl/CodeModel/CSharpCodeModelService.cs` | ソース | コードモデルサービス |
| AutomationObject.cs | `src/VisualStudio/CSharp/Impl/Options/AutomationObject/AutomationObject.cs` | ソース | オートメーションオブジェクト |
