# 機能設計書 102-VS VB拡張

## 概要

本ドキュメントは、Roslyn における Visual Studio 用 Visual Basic 言語サービス拡張機能の設計を記述する。この機能は Visual Studio IDE 内で Visual Basic 言語に対する包括的な言語サービスを提供する。

### 本機能の処理概要

Visual Studio 用 VB 拡張機能は、Visual Studio IDE 内で Visual Basic コードを編集する際に必要なすべての言語サービス機能を提供するパッケージである。C# 拡張と同様のアーキテクチャを持ち、VB 固有の言語機能に対応している。

**業務上の目的・背景**：開発者が Visual Studio で Visual Basic コードを効率的に編集・デバッグ・ナビゲートするために、IDE と Roslyn コンパイラ/アナライザー基盤を統合する必要がある。VB は長年にわたり企業システムで広く使用されてきた言語であり、既存の VB コードベースのメンテナンスや新規開発に対応するため、高品質な言語サービスが必要とされる。

**機能の利用シーン**：Visual Studio で Visual Basic プロジェクトを開いた際に自動的にロードされ、コード編集、ナビゲーション、リファクタリング、デバッグなどすべての VB 開発作業において使用される。具体的には、IntelliSense によるコード補完、定義への移動、参照の検索、名前変更、コードフォーマット、診断メッセージの表示などの場面で動作する。

**主要な処理内容**：
1. VisualBasicPackage の初期化とサービス登録
2. オプションページの提供（詳細設定、コードスタイル、フォーマット）
3. エディタファクトリの生成と登録
4. オブジェクトブラウザライブラリマネージャの管理
5. VB 固有のコードモデル（EnvDTE）の提供
6. VB 固有の構文解析・セマンティック解析の統合

**関連システム・外部連携**：Visual Studio Shell、MSBuild、NuGet パッケージマネージャ、Visual Studio テーマシステム、オブジェクトブラウザ、EnvDTE オートメーションモデルと連携する。

**権限による制御**：特定の権限制御はないが、ユーザー設定（オプションページ）によって機能の有効/無効を切り替え可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 36 | VB詳細オプションページコントロール | 主画面 | Visual Basicの詳細設定（C#詳細設定と類似構成） |

## 機能種別

IDE統合 / サービス提供 / 設定管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| なし | - | - | パッケージは Visual Studio によって自動的にロードされる | - |

### 入力データソース

- Visual Studio プロジェクトシステムからのプロジェクト情報
- ユーザー設定（Visual Studio オプション）
- 開いているドキュメントのテキストバッファ

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| LanguageService | VisualBasicLanguageService | VB 言語サービスインスタンス |
| EditorFactories | IEnumerable\<IVsEditorFactory\> | エディタファクトリ群 |
| AutomationObject | AutomationObject | オートメーション用オブジェクト |

### 出力先

- Visual Studio サービスコンテナ
- Visual Studio オブジェクトブラウザ
- Visual Studio エディタシステム

## 処理フロー

### 処理シーケンス

```
1. Visual Studio がパッケージをロード
   └─ VisualBasicPackage.InitializeAsync() が呼び出される
2. バックグラウンド初期化タスクの登録
   └─ サービス登録処理を実行
3. オブジェクトブラウザライブラリマネージャの登録
   └─ RegisterObjectBrowserLibraryManager() でライブラリを登録
4. エディタファクトリの生成
   └─ CreateEditorFactories() で VisualBasicEditorFactory を生成
5. 言語サービスの生成
   └─ CreateLanguageService() で VisualBasicLanguageService を生成
```

### フローチャート

```mermaid
flowchart TD
    A[VS パッケージロード] --> B[InitializeAsync]
    B --> C[バックグラウンド初期化]
    B --> D[ObjectBrowser 登録]
    B --> E[エディタファクトリ生成]
    B --> F[言語サービス生成]
    D --> G[パッケージ初期化完了]
    E --> G
    F --> G
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-102-01 | パッケージ遅延ロード | パッケージは必要になるまでロードされない | VS 起動時 |
| BR-102-02 | C# との構造共通化 | 基本アーキテクチャは C# 拡張と共通 | 全機能 |
| BR-102-03 | VB 固有機能対応 | VB 固有の構文（With ブロック、イベント構文等）に対応 | VB コード編集時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし（インメモリ処理のみ）

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | FatalError | 初期化中の例外 | FatalError.ReportAndPropagateUnlessCanceled でレポート |
| - | InvalidOperationException | ワークスペース取得失敗 | ログ出力して継続 |

### リトライ仕様

リトライなし

## トランザクション仕様

トランザクションなし

## パフォーマンス要件

- パッケージの初期化は非同期で行い、UI スレッドをブロックしない
- C# 拡張と同等のパフォーマンス特性を維持

## セキュリティ考慮事項

- サービスは Visual Studio プロセス内で実行され、プロセス境界を超えない
- ユーザー設定はローカルに保存される

## 備考

- VB 拡張は C# 拡張と同様のアーキテクチャを採用しているが、VB 固有の言語機能（Late Binding、イベント構文、XML リテラル等）に対応している
- 機能一覧.csv によると、ソースコードは `src/VisualStudio/VisualBasic` に配置されているが、現在のリポジトリには存在しない可能性がある

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 共通基盤を理解する

VB 拡張は C# 拡張と共通の基盤を使用しているため、まず共通部分を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AbstractPackage.cs | `src/VisualStudio/Core/Def/Implementation/LanguageService/AbstractPackage.cs` | パッケージの共通基盤クラス |

**読解のコツ**: C# 拡張の実装パターンを理解した上で、VB 固有の差分に注目する。

#### Step 2: VB 固有の実装を理解する

VB 言語に固有の機能と実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | VisualBasicPackage.cs | `src/VisualStudio/VisualBasic/Impl/VisualBasicPackage.cs` | VB パッケージのメインクラス（存在する場合） |

**主要処理フロー**:
- C# 拡張と同様の初期化フローを持つ
- VB 固有のオプションページを登録
- VB 言語サービスを生成

#### Step 3: オプションページを理解する

VB のオプションページ実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AdvancedOptionPage.cs | `src/VisualStudio/VisualBasic/Impl/Options/AdvancedOptionPage.cs` | VB 詳細オプションページ（存在する場合） |

### プログラム呼び出し階層図

```
VisualBasicPackage (エントリーポイント)
    │
    ├─ RegisterObjectBrowserLibraryManager
    │      └─ ObjectBrowserLibraryManager
    │
    ├─ CreateEditorFactories
    │      ├─ VisualBasicEditorFactory
    │      └─ VisualBasicCodePageEditorFactory
    │
    └─ CreateLanguageService
           └─ VisualBasicLanguageService
```

### データフロー図

```
[入力]                    [処理]                              [出力]

VS Shell ───────────▶ VisualBasicPackage 初期化 ───────▶ サービス登録
                            │
プロジェクト情報 ──────▶ VB ProjectSystemShim ────────▶ Roslyn Workspace
                            │
ユーザー設定 ───────────▶ OptionPage ──────────────────▶ IGlobalOptionService
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| VisualBasicPackage.cs | `src/VisualStudio/VisualBasic/Impl/VisualBasicPackage.cs` | ソース | パッケージのメインクラス |
| AdvancedOptionPage.cs | `src/VisualStudio/VisualBasic/Impl/Options/AdvancedOptionPage.cs` | ソース | 詳細オプションページ |
| VisualBasicCodeModelService.cs | `src/VisualStudio/VisualBasic/Impl/CodeModel/VisualBasicCodeModelService.cs` | ソース | コードモデルサービス |
| AbstractPackage.cs | `src/VisualStudio/Core/Def/Implementation/LanguageService/AbstractPackage.cs` | ソース | 共通パッケージ基盤 |
