# 機能設計書 103-VS コア

## 概要

本ドキュメントは、Roslyn における Visual Studio 統合の共通基盤機能の設計を記述する。この機能は C# および Visual Basic の両言語サービスで共有される Visual Studio 統合の核となるコンポーネント群を提供する。

### 本機能の処理概要

VS コア機能は、Visual Studio と Roslyn エンジンを橋渡しする共通インフラストラクチャを提供する。ワークスペース管理、コードモデル、オプション管理、プロジェクトシステム統合など、言語に依存しない機能がここに実装されている。

**業務上の目的・背景**：C# と Visual Basic の両言語サービスにおいて重複する機能を共通化することで、コードの再利用性を高め、一貫した動作を保証する。また、Visual Studio のさまざまなサブシステム（プロジェクトシステム、エディタ、診断など）との統合ポイントを提供する。

**機能の利用シーン**：Visual Studio で Roslyn ベースのプロジェクトを操作するすべての場面で使用される。具体的には、ソリューション・プロジェクトの読み込み、ドキュメントの編集、定義への移動、参照の検索、コードモデル（EnvDTE）へのアクセスなどで動作する。

**主要な処理内容**：
1. RoslynVisualStudioWorkspace による Visual Studio ワークスペースの管理
2. ProjectCodeModelFactory によるコードモデル（EnvDTE）の生成と管理
3. AbstractOptionPage による共通オプションページ基盤の提供
4. OptionStore によるオプション値の管理
5. プロジェクトシステム（CPS）との統合
6. テーマ、テレメトリ、診断パネルなどの共通 UI コンポーネント

**関連システム・外部連携**：Visual Studio Shell、プロジェクトシステム（CPS/レガシー）、MSBuild、EnvDTE オートメーションモデル、Visual Studio テーマシステム、テレメトリシステムと連携する。

**権限による制御**：特定の権限制御はなし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 52 | 詳細エラー情報ダイアログ | 主画面 | エラー詳細情報・スタックトレースの表示とコピー |
| 54 | VSテーマ辞書 | 補助機能 | Visual Studioテーマ対応の共通スタイル定義 |
| 56 | プロジェクションバッファマージン | 主画面 | プロジェクションバッファの診断表示 |
| 57 | テレメトリパネル | 主画面 | テレメトリ情報の診断表示 |

## 機能種別

基盤機能 / 統合レイヤー / サービス提供

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| solution | Solution | Yes | 現在のソリューション | null チェック |
| projectId | ProjectId | Yes | プロジェクト識別子 | 存在チェック |
| documentId | DocumentId | Yes | ドキュメント識別子 | 存在チェック |

### 入力データソース

- Visual Studio プロジェクトシステム
- MSBuild プロジェクトファイル
- ユーザー設定（Visual Studio オプション）
- テキストバッファ（エディタ）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Workspace | VisualStudioWorkspace | VS 統合ワークスペース |
| ProjectCodeModel | IProjectCodeModel | プロジェクトのコードモデル |
| FileCodeModel | FileCodeModel | ファイルのコードモデル |
| OptionStore | OptionStore | オプション値ストア |

### 出力先

- Visual Studio サービスコンテナ
- EnvDTE オートメーションインターフェース
- Roslyn Workspace

## 処理フロー

### 処理シーケンス

```
1. Visual Studio 起動・ソリューション読み込み
   └─ RoslynVisualStudioWorkspace が初期化される
2. ワークスペース変更イベントの処理
   └─ ProjectCodeModelFactory がドキュメント変更を監視
3. コードモデルへのアクセス要求
   └─ GetOrCreateFileCodeModel でコードモデルを生成
4. 定義への移動などのナビゲーション
   └─ TryGoToDefinitionAsync でシンボル位置に移動
5. オプション変更の反映
   └─ OptionStore から IGlobalOptionService へ同期
```

### フローチャート

```mermaid
flowchart TD
    A[VS ソリューション読み込み] --> B[RoslynVisualStudioWorkspace 初期化]
    B --> C[プロジェクト/ドキュメント登録]
    C --> D{操作種別}
    D -->|ナビゲーション| E[TryGoToDefinitionAsync]
    D -->|コードモデル| F[GetOrCreateFileCodeModel]
    D -->|参照検索| G[TryFindAllReferences]
    D -->|オプション変更| H[OptionStore 更新]
    E --> I[結果を返す]
    F --> I
    G --> I
    H --> I
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-103-01 | ワークスペース単一性 | アプリケーションドメイン内でワークスペースは単一 | 常時 |
| BR-103-02 | スレッド安全性 | UI スレッドを必要とする操作は明示的に切り替え | 非同期操作時 |
| BR-103-03 | コードモデルキャッシュ | FileCodeModel はキャッシュして再利用 | コードモデルアクセス時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし（インメモリ処理のみ）

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | InvalidOperationException | ドキュメントがワークスペースに存在しない | エラーメッセージを表示 |
| - | Contract.ThrowIfNull | 必須パラメータが null | 例外をスロー |

### リトライ仕様

リトライなし

## トランザクション仕様

- InvisibleEditor を使用した編集は Global Undo Transaction 内で実行可能
- 生成コードの編集時は Undo を無効化

## パフォーマンス要件

- ワークスペース変更イベントの処理はバッチ処理で効率化
- UI スレッドでの処理は最大 15ms 以内に制限
- 入力待ちキューをチェックして長時間の UI ブロックを回避

## セキュリティ考慮事項

- サービスは Visual Studio プロセス内で実行
- ファイルアクセスは Visual Studio の権限に従う

## 備考

- RoslynVisualStudioWorkspace は MEF でエクスポートされる
- ProjectCodeModelFactory はドキュメント変更を非同期で監視し、コードモデルイベントを発火

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: ワークスペース管理を理解する

まず、Visual Studio とRoslyn ワークスペースの統合ポイントを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | RoslynVisualStudioWorkspace.cs | `src/VisualStudio/Core/Impl/RoslynVisualStudioWorkspace.cs` | VisualStudioWorkspaceImpl を継承、ナビゲーション・参照検索の実装 |

**読解のコツ**: `TryGoToDefinitionAsync` と `OpenInvisibleEditor` がナビゲーションと編集の中心的なメソッド。

**主要処理フロー**:
1. **44-53行目**: コンストラクタでスレッディングコンテキストとプレゼンターを注入
2. **55-88行目**: OpenInvisibleEditor で不可視エディタを開く
3. **94-110行目**: TryGoToDefinitionAsync でシンボル定義への移動を実行
4. **125-191行目**: GetBrowseObjectAsync でオブジェクトブラウザ用のオブジェクトを取得

#### Step 2: コードモデルを理解する

EnvDTE コードモデルの生成と管理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ProjectCodeModelFactory.cs | `src/VisualStudio/Core/Impl/CodeModel/ProjectCodeModelFactory.cs` | コードモデルファクトリの実装 |
| 2-2 | ProjectCodeModel.cs | `src/VisualStudio/Core/Impl/CodeModel/ProjectCodeModel.cs` | プロジェクトごとのコードモデル |
| 2-3 | FileCodeModel.cs | `src/VisualStudio/Core/Impl/CodeModel/FileCodeModel.cs` | ファイルごとのコードモデル |

**主要処理フロー**:
- **57-61行目（ProjectCodeModelFactory.cs）**: AsyncBatchingWorkQueue でワークスペース変更をバッチ処理
- **139-176行目**: FireEventsForChangedDocumentsAsync で UI スレッドでイベントを発火
- **239-248行目**: CreateProjectCodeModel でプロジェクトコードモデルを生成
- **272-273行目**: GetOrCreateFileCodeModel でファイルコードモデルを取得または生成

#### Step 3: オプション管理を理解する

オプションページの共通基盤を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AbstractOptionPage.cs | `src/VisualStudio/Core/Impl/Options/AbstractOptionPage.cs` | オプションページの抽象基底クラス |
| 3-2 | OptionStore.cs | `src/VisualStudio/Core/Impl/Options/OptionStore.cs` | オプション値のストア |
| 3-3 | OptionBinding.cs | `src/VisualStudio/Core/Impl/Options/OptionBinding.cs` | オプションと UI のバインディング |

### プログラム呼び出し階層図

```
RoslynVisualStudioWorkspace (エントリーポイント)
    │
    ├─ TryGoToDefinitionAsync
    │      └─ GoToDefinitionHelpers.TryNavigateToLocationAsync
    │
    ├─ OpenInvisibleEditor
    │      └─ InvisibleEditor
    │
    ├─ GetBrowseObjectAsync
    │      ├─ SymbolListItem.GetCompilationAsync
    │      └─ FileCodeModel.GetOrCreateCodeElement
    │
    └─ ProjectCodeModelFactory
           ├─ ProcessNextWorkspaceChangeEventBatchAsync
           │      └─ FireEventsForChangedDocumentsAsync
           │
           └─ CreateProjectCodeModel
                  └─ ProjectCodeModel
                         └─ FileCodeModel
```

### データフロー図

```
[入力]                      [処理]                           [出力]

VS プロジェクトシステム ─▶ VisualStudioWorkspace ───────▶ Roslyn Solution
                               │
ドキュメント変更 ─────────▶ ProjectCodeModelFactory ────▶ CodeModel イベント
                               │
シンボル検索要求 ─────────▶ TryGoToDefinitionAsync ─────▶ ナビゲーション実行
                               │
オプション変更 ───────────▶ OptionStore ─────────────────▶ IGlobalOptionService
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RoslynVisualStudioWorkspace.cs | `src/VisualStudio/Core/Impl/RoslynVisualStudioWorkspace.cs` | ソース | VS 統合ワークスペースのメイン実装 |
| ProjectCodeModelFactory.cs | `src/VisualStudio/Core/Impl/CodeModel/ProjectCodeModelFactory.cs` | ソース | コードモデルファクトリ |
| ProjectCodeModel.cs | `src/VisualStudio/Core/Impl/CodeModel/ProjectCodeModel.cs` | ソース | プロジェクトコードモデル |
| FileCodeModel.cs | `src/VisualStudio/Core/Impl/CodeModel/FileCodeModel.cs` | ソース | ファイルコードモデル |
| AbstractOptionPage.cs | `src/VisualStudio/Core/Impl/Options/AbstractOptionPage.cs` | ソース | オプションページ基底クラス |
| OptionStore.cs | `src/VisualStudio/Core/Impl/Options/OptionStore.cs` | ソース | オプションストア |
| CPSProjectFactory.cs | `src/VisualStudio/Core/Impl/ProjectSystem/CPS/CPSProjectFactory.cs` | ソース | CPS プロジェクトファクトリ |
| AbstractCodeModelService.cs | `src/VisualStudio/Core/Impl/CodeModel/AbstractCodeModelService.cs` | ソース | コードモデルサービス基底クラス |
