# 機能設計書 104-CodeLens拡張

## 概要

本ドキュメントは、Roslyn における Visual Studio CodeLens 統合機能の設計を記述する。この機能はエディタ内にシンボルの参照数などのインライン情報を表示する。

### 本機能の処理概要

CodeLens 拡張は、Visual Studio のエディタ内でメソッド、プロパティ、型などの定義の上部に参照数やその他のメトリクスをインライン表示する機能を提供する。Roslyn の静的解析機能と連携して、リアルタイムでコード情報を収集・表示する。

**業務上の目的・背景**：開発者がコードの利用状況を即座に把握できるようにすることで、リファクタリングの影響範囲の判断やコードレビューの効率化を支援する。特に大規模なコードベースにおいて、特定のシンボルがどこでどれだけ使用されているかを把握することは重要である。

**機能の利用シーン**：Visual Studio でコードを編集している際に、メソッドやクラスの定義行の上部に「3 references」のような参照数が表示される。これをクリックすると参照一覧が表示され、各参照箇所に移動できる。

**主要な処理内容**：
1. ReferenceCodeLensProvider による CodeLens データポイントの提供
2. 参照数の計算と表示テキストの生成
3. 参照一覧の取得と詳細情報の表示
4. プロジェクト変更時のデータ更新（ポーリングによる監視）
5. CodeLensCallbackService を通じた devenv プロセスとの通信

**関連システム・外部連携**：Visual Studio CodeLens サブシステム、Roslyn ワークスペース、参照検索機能と連携する。

**権限による制御**：ユーザー設定で CodeLens の表示/非表示を切り替え可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | エディタ内 CodeLens 表示 | 主画面 | 参照数のインライン表示 |
| - | 参照一覧ポップアップ | 結果表示画面 | 参照詳細の一覧表示 |

## 機能種別

情報表示 / リアルタイム解析

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| descriptor | CodeLensDescriptor | Yes | CodeLens のコンテキスト情報 | null チェック |
| descriptorContext | CodeLensDescriptorContext | Yes | 適用範囲のスパン情報 | ApplicableSpan の存在チェック |

### 入力データソース

- エディタのテキストバッファ
- Roslyn Workspace のシンボル情報
- プロジェクトのバージョン情報

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Description | string | 表示テキスト（例: "3 references"） |
| IntValue | int | 参照数 |
| TooltipText | string | ツールチップテキスト |
| Details | CodeLensDetailsDescriptor | 参照一覧の詳細情報 |

### 出力先

- エディタ内の CodeLens アドーンメント
- 参照一覧ポップアップ

## 処理フロー

### 処理シーケンス

```
1. エディタでドキュメントを開く
   └─ CodeLens エンジンがタガーを呼び出し
2. CanCreateDataPointAsync でサポート確認
   └─ ApplicableSpan が存在すれば true を返す
3. CreateDataPointAsync でデータポイント生成
   └─ DataPoint インスタンスを生成してキャッシュに追加
4. GetDataAsync で参照数を取得
   └─ CallbackService 経由で devenv にリクエスト
5. プロジェクト変更のポーリング
   └─ PollForUpdatesAsync で定期的にバージョンチェック
6. 変更検出時にデータポイント無効化
   └─ Invalidate() で更新をトリガー
```

### フローチャート

```mermaid
flowchart TD
    A[ドキュメントを開く] --> B[CodeLens タガー呼び出し]
    B --> C{CanCreateDataPointAsync}
    C -->|Yes| D[CreateDataPointAsync]
    C -->|No| E[終了]
    D --> F[DataPoint 生成]
    F --> G[GetDataAsync で参照数取得]
    G --> H[参照数を表示]
    H --> I{プロジェクト変更?}
    I -->|Yes| J[Invalidate]
    J --> G
    I -->|No| K[1.5秒待機]
    K --> I
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-104-01 | ポーリング間隔 | 1.5秒間隔でプロジェクト変更をチェック | 常時 |
| BR-104-02 | コード要素種別対応 | Method, Type, Property に対応 | CodeLens 表示時 |
| BR-104-03 | バージョン比較 | プロジェクトバージョンが変わったらデータを無効化 | ポーリング時 |

### 計算ロジック

参照数は Roslyn の FindReferences 機能を使用して計算される。上限値が設定されている場合は "X+ references" のように表示される。

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし（インメモリ処理のみ）

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | NotSupportedException | 未サポートのコード要素種別 | 例外をスローしてデータポイント非表示 |
| - | キャンセル | ユーザーキャンセルまたはタイムアウト | 処理を中断 |

### リトライ仕様

ポーリングによる定期的な再取得が行われるため、明示的なリトライなし

## トランザクション仕様

トランザクションなし

## パフォーマンス要件

- ポーリング間隔は 1.5 秒
- 参照数の計算は非同期で実行
- キャッシュを活用して重複計算を回避

## セキュリティ考慮事項

- OOP（Out-of-Process）設計により、CodeLens 処理のクラッシュが Visual Studio 本体に影響しない
- ローカルのソースコードのみを対象

## 備考

- 現在の CodeLens OOP 設計では WorkspaceChanged イベントのハンドラ登録ができないため、ポーリング方式を採用
- LSP ベースの CodeLens への移行が予定されている

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: プロバイダーの構造を理解する

まず、CodeLens プロバイダーの基本構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ReferenceCodeLensProvider.cs | `src/VisualStudio/CodeLens/ReferenceCodeLensProvider.cs` | IAsyncCodeLensDataPointProvider の実装、MEF エクスポート |

**読解のコツ**: `[Export(typeof(IAsyncCodeLensDataPointProvider))]` 属性と `[ContentType]` 属性が C# と VB の両方に対応していることを確認。

**主要処理フロー**:
1. **31-39行目**: クラス定義と MEF 属性
2. **52-58行目**: コンストラクタで CodeLensCallbackService を注入
3. **65-76行目**: CanCreateDataPointAsync で作成可否を判定
4. **78-88行目**: CreateDataPointAsync でデータポイントを生成

#### Step 2: ポーリングメカニズムを理解する

プロジェクト変更の検出とデータ更新の仕組みを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ReferenceCodeLensProvider.cs | `src/VisualStudio/CodeLens/ReferenceCodeLensProvider.cs` | PollForUpdatesAsync メソッド |

**主要処理フロー**:
- **95-128行目**: PollForUpdatesAsync でポーリングループ
- **99行目**: 1.5秒の待機
- **107-111行目**: GetProjectVersionsAsync でバージョン取得
- **115-126行目**: バージョン変更時に Invalidate() を呼び出し

#### Step 3: DataPoint クラスを理解する

実際のデータ取得と表示ロジックを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ReferenceCodeLensProvider.cs | `src/VisualStudio/CodeLens/ReferenceCodeLensProvider.cs` | 内部クラス DataPoint |

**主要処理フロー**:
- **154-170行目**: ヘッダー定義（参照一覧の列情報）
- **197-240行目**: GetDataAsync で参照数を取得して表示情報を生成
- **242-304行目**: GetDetailsAsync で参照一覧の詳細を取得
- **306-311行目**: Invalidate で更新をトリガー

### プログラム呼び出し階層図

```
ReferenceCodeLensProvider (エントリーポイント)
    │
    ├─ CanCreateDataPointAsync
    │      └─ ApplicableSpan チェック
    │
    ├─ CreateDataPointAsync
    │      └─ DataPoint 生成
    │             │
    │             ├─ GetDataAsync
    │             │      └─ CallbackService.InvokeAsync("GetReferenceCountAsync")
    │             │
    │             └─ GetDetailsAsync
    │                    └─ CallbackService.InvokeAsync("FindReferenceLocationsAsync")
    │
    └─ PollForUpdatesAsync
           └─ CallbackService.InvokeAsync("GetProjectVersionsAsync")
                  └─ DataPoint.Invalidate
```

### データフロー図

```
[入力]                    [処理]                           [出力]

エディタバッファ ────────▶ CodeLens タガー ──────────────▶ CodeLens 表示
                               │
シンボル情報 ──────────────▶ GetDataAsync ─────────────────▶ 参照数
                               │
参照検索要求 ──────────────▶ GetDetailsAsync ─────────────▶ 参照一覧
                               │
プロジェクト変更 ─────────▶ PollForUpdatesAsync ──────────▶ Invalidate
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ReferenceCodeLensProvider.cs | `src/VisualStudio/CodeLens/ReferenceCodeLensProvider.cs` | ソース | CodeLens プロバイダーのメイン実装 |
| CodeLensCallbackService.cs | `src/Features/Core/Portable/CodeLens/CodeLensCallbackService.cs` | ソース | Callback サービス |
| ReferenceCount.cs | `src/Features/Core/Portable/CodeLens/ReferenceCount.cs` | ソース | 参照数データ構造 |
| ReferenceLocationDescriptor.cs | `src/Features/Core/Portable/CodeLens/ReferenceLocationDescriptor.cs` | ソース | 参照位置データ構造 |
