# 機能設計書 105-LiveShare連携

## 概要

本ドキュメントは、Roslyn における Visual Studio LiveShare 統合機能の設計を記述する。この機能はリアルタイムコラボレーション機能である LiveShare と Roslyn 言語サービスの連携を提供する。

### 本機能の処理概要

LiveShare 連携機能は、Visual Studio LiveShare でリモートコラボレーションセッション中に、C# および Visual Basic の言語サービス機能（参照の検索など）を提供する。Language Server Protocol (LSP) を介してホストとゲスト間で言語サービス機能を共有する。

**業務上の目的・背景**：リモートワークやペアプログラミングの際に、複数の開発者が同一のコードベースに対してリアルタイムで共同作業を行うことが増えている。LiveShare はこのシナリオを支援するが、ホストとゲストの両方で言語サービスが適切に動作することが必要である。

**機能の利用シーン**：Visual Studio LiveShare セッション中にゲストがホストのコードに対して「参照の検索」などの操作を行う場合に使用される。ゲストはホストのワークスペースにアクセスし、LSP 経由で言語サービスを利用できる。

**主要な処理内容**：
1. LiveShareInitializeHandler による LSP 初期化処理
2. ProjectsHandler によるプロジェクト情報の提供
3. RoslynLSPClientService によるクライアントサービスの提供
4. RemoteLanguageServiceWorkspace によるリモートワークスペースの管理
5. Razor 連携のための CSharpLspContainedLanguageProvider

**関連システム・外部連携**：Visual Studio LiveShare、Language Server Protocol、Roslyn ワークスペース、Razor と連携する。

**権限による制御**：LiveShare セッションの参加者権限に従う（読み取り専用/編集可能）。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | LiveShare セッション | 主画面 | リモートコラボレーションのメイン画面 |

## 機能種別

リモート通信 / 言語サービス統合

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| InitializeParams | InitializeParams | Yes | LSP 初期化パラメータ | - |
| Solution | Solution | Yes | ソリューション情報 | null チェック |

### 入力データソース

- LiveShare セッション情報
- ホストのワークスペース
- LSP リクエスト

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| InitializeResult | InitializeResult | サーバー機能情報 |
| ServerCapabilities | ServerCapabilities | 提供可能な機能 |

### 出力先

- LiveShare クライアント（ゲスト）
- LSP レスポンス

## 処理フロー

### 処理シーケンス

```
1. LiveShare セッション開始
   └─ ホストが言語サービスを初期化
2. ゲストが接続
   └─ Initialize リクエストを送信
3. LiveShareInitializeHandler が処理
   └─ ServerCapabilities を返却
4. ゲストが言語機能を使用
   └─ 参照検索などのリクエストを送信
5. ホストが処理して結果を返却
   └─ LSP レスポンスとして送信
```

### フローチャート

```mermaid
flowchart TD
    A[LiveShare セッション開始] --> B[ゲスト接続]
    B --> C[Initialize リクエスト]
    C --> D[LiveShareInitializeHandler]
    D --> E[ServerCapabilities 返却]
    E --> F{言語機能リクエスト}
    F -->|参照検索| G[References 処理]
    F -->|その他| H[対応ハンドラ]
    G --> I[結果返却]
    H --> I
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-105-01 | サポート機能制限 | CodeAction と Rename は無効 | LiveShare セッション中 |
| BR-105-02 | 参照検索サポート | ReferencesProvider は有効 | LiveShare セッション中 |
| BR-105-03 | 後方互換性 | 旧 LiveShare クライアントとの互換性を維持 | 常時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 通信エラー | ネットワーク切断 | セッション再接続 |
| - | タイムアウト | 応答がない場合 | リクエストをキャンセル |

### リトライ仕様

LiveShare フレームワークのリトライ機構に依存

## トランザクション仕様

トランザクションなし

## パフォーマンス要件

- LSP リクエストは非同期で処理
- ネットワーク遅延を考慮した設計

## セキュリティ考慮事項

- LiveShare セッションのセキュリティポリシーに従う
- ゲストのアクセス権限を制御
- 機密性の高いコードへのアクセスを制限可能

## 備考

- 一部のハンドラは `[Obsolete]` 属性が付与されており、旧 LiveShare クライアントとの後方互換性のために維持されている
- TypeScript など他の言語サービスとの連携も可能（ExternalAccess.VSTypeScript）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 初期化処理を理解する

まず、LiveShare の LSP 初期化処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | LiveShareInitializeHandler.cs | `src/VisualStudio/LiveShare/Impl/LiveShareInitializeHandler.cs` | LSP 初期化ハンドラ |

**読解のコツ**: `ILspRequestHandler` を実装しており、`InitializeParams` を受け取って `InitializeResult` を返す。

**主要処理フロー**:
1. **16-30行目**: LiveShareInitializeHandler クラスで LSP 初期化を処理
2. **18-26行目**: ServerCapabilities を定義（CodeAction=false, References=true, Rename=false）
3. **28-29行目**: HandleAsync で初期化結果を返却

#### Step 2: 各言語用のハンドラを理解する

C# と VB 用の個別ハンドラを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | LiveShareInitializeHandler.cs | `src/VisualStudio/LiveShare/Impl/LiveShareInitializeHandler.cs` | CSharpInitializeHandlerShim, VisualBasicInitializeHandlerShim |

**主要処理フロー**:
- **32-41行目**: RoslynInitializeHandlerShim（後方互換性用、Obsolete）
- **43-51行目**: CSharpInitializeHandlerShim（C# 用）
- **53-61行目**: VisualBasicInitializeHandlerShim（VB 用）

#### Step 3: クライアントサービスを理解する

ゲスト側のクライアントサービスを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | RoslynLSPClientService.cs | `src/VisualStudio/LiveShare/Impl/Client/RoslynLSPClientService.cs` | クライアントサービスの実装 |
| 3-2 | RemoteLanguageServiceWorkspace.cs | `src/VisualStudio/LiveShare/Impl/Client/RemoteLanguageServiceWorkspace.cs` | リモートワークスペース管理 |

### プログラム呼び出し階層図

```
LiveShareInitializeHandler (エントリーポイント)
    │
    ├─ CSharpInitializeHandlerShim
    │      └─ HandleAsync → InitializeResult
    │
    ├─ VisualBasicInitializeHandlerShim
    │      └─ HandleAsync → InitializeResult
    │
    └─ RoslynInitializeHandlerShim (Obsolete)
           └─ HandleAsync → InitializeResult

クライアント側:
RoslynLSPClientService
    │
    └─ RemoteLanguageServiceWorkspace
           └─ リモートワークスペース操作
```

### データフロー図

```
[入力]                    [処理]                           [出力]

LiveShare セッション ────▶ ホスト言語サービス ──────────▶ LSP レスポンス
                               │
ゲストリクエスト ────────▶ LiveShareInitializeHandler ──▶ Capabilities
                               │
参照検索リクエスト ──────▶ References Handler ───────────▶ 参照一覧
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| LiveShareInitializeHandler.cs | `src/VisualStudio/LiveShare/Impl/LiveShareInitializeHandler.cs` | ソース | LSP 初期化ハンドラ |
| LiveShareConstants.cs | `src/VisualStudio/LiveShare/Impl/LiveShareConstants.cs` | ソース | 定数定義 |
| ProjectsHandler.cs | `src/VisualStudio/LiveShare/Impl/ProjectsHandler.cs` | ソース | プロジェクト情報ハンドラ |
| RoslynLSPClientService.cs | `src/VisualStudio/LiveShare/Impl/Client/RoslynLSPClientService.cs` | ソース | クライアントサービス |
| RemoteLanguageServiceWorkspace.cs | `src/VisualStudio/LiveShare/Impl/Client/RemoteLanguageServiceWorkspace.cs` | ソース | リモートワークスペース |
| CSharpLspContainedLanguageProvider.cs | `src/VisualStudio/LiveShare/Impl/Client/Razor/CSharpLspContainedLanguageProvider.cs` | ソース | Razor C# 統合 |
