# 機能設計書 107-XAML連携

## 概要

本ドキュメントは、Roslyn における XAML 言語サポート統合機能の設計を記述する。この機能は XAML ファイルに対して言語サービス機能を提供し、WPF/UWP/Xamarin などの XAML ベースのアプリケーション開発を支援する。

### 本機能の処理概要

XAML 連携機能は、XAML ファイル（.xaml）に対して、コード補完、定義への移動、クイック情報、診断、フォーマットなどの言語サービス機能を提供する。XamlProjectService がプロジェクトとドキュメントの管理を行い、各種サービスインターフェースを通じて機能を提供する。

**業務上の目的・背景**：WPF、UWP、Xamarin.Forms、MAUI などのフレームワークでは、UI 定義に XAML が広く使用されている。開発者が XAML ファイルを効率的に編集できるよう、IntelliSense やナビゲーションなどの言語サービス機能を提供する必要がある。

**機能の利用シーン**：Visual Studio で XAML ファイルを編集している際に、要素名やプロパティ名の補完、バインディング式の入力支援、コードビハインドへの移動、不要な名前空間の削除などの機能を利用する場面で使用される。

**主要な処理内容**：
1. XamlProjectService による XAML プロジェクトとドキュメントの管理
2. IXamlCompletionService によるコード補完
3. IXamlGoToDefinitionService による定義への移動
4. IXamlQuickInfoService によるクイック情報表示
5. IXamlFormattingService によるフォーマット
6. IXamlPullDiagnosticService による診断

**関連システム・外部連携**：Visual Studio XAML デザイナー、ワークスペース、RunningDocumentTable (RDT)、ソリューションイベントと連携する。

**権限による制御**：特定の権限制御なし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | XAML エディタ | 主画面 | .xaml ファイルの編集 |
| - | XAML デザイナー | 関連画面 | ビジュアルデザイン |

## 機能種別

言語サービス統合 / ドキュメント管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| filePath | string | Yes | XAML ファイルパス | 空チェック |
| position | int | Yes | カーソル位置 | 範囲チェック |
| document | XamlDocument | Yes | XAML ドキュメント | null チェック |

### 入力データソース

- XAML ファイルのテキストバッファ
- Visual Studio プロジェクトシステム
- RunningDocumentTable

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| XamlCompletionResult | XamlCompletionResult | 補完結果 |
| XamlDefinition | XamlDefinition | 定義情報 |
| XamlQuickInfo | XamlQuickInfo | クイック情報 |
| XamlDiagnosticReport | XamlDiagnosticReport | 診断レポート |

### 出力先

- XAML エディタ
- Visual Studio 診断システム

## 処理フロー

### 処理シーケンス

```
1. XAML ファイルを開く
   └─ XamlProjectService.TrackOpenDocument でドキュメントを追跡
2. プロジェクトの確認と登録
   └─ EnsureDocument でプロジェクトとドキュメントを登録
3. 言語サービス機能の要求
   └─ 各種 IXaml*Service を通じて機能を提供
4. ドキュメントのクローズ
   └─ OnDocumentClosed でクリーンアップ
5. プロジェクトのクローズ
   └─ OnProjectClosing でプロジェクトを削除
```

### フローチャート

```mermaid
flowchart TD
    A[XAML ファイルを開く] --> B[TrackOpenDocument]
    B --> C{ドキュメント登録済み?}
    C -->|Yes| D[DocumentId を返す]
    C -->|No| E[EnsureDocument]
    E --> F[プロジェクト登録]
    F --> G[ドキュメント追加]
    G --> D
    D --> H{言語サービス要求}
    H -->|補完| I[IXamlCompletionService]
    H -->|定義移動| J[IXamlGoToDefinitionService]
    H -->|診断| K[IXamlPullDiagnosticService]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-107-01 | ファイルパス必須 | 空のファイルパスは追跡不可 | TrackOpenDocument 時 |
| BR-107-02 | RDT 依存 | ドキュメントは RDT に存在する必要あり | EnsureDocument 時 |
| BR-107-03 | モニカー変更対応 | ファイル名変更時は再登録 | OnDocumentMonikerChanged 時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ArgumentException | RDT にドキュメントがない | null を返す |
| - | null 返却 | ファイルパスが空 | 処理をスキップ |

### リトライ仕様

リトライなし

## トランザクション仕様

トランザクションなし

## パフォーマンス要件

- ドキュメント追跡は ConcurrentDictionary で効率化
- メインスレッドが必要な処理は明示的に切り替え

## セキュリティ考慮事項

- ローカルファイルシステムへのアクセスのみ
- Visual Studio プロセス内で実行

## 備考

- XAML ドキュメントは Roslyn の通常ワークスペースとは別の XamlLanguageName として管理される
- Edit and Continue のサポートは IXamlEditAndContinueSolutionProvider を通じて提供

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: プロジェクトサービスを理解する

まず、XAML プロジェクトとドキュメントの管理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | XamlProjectService.cs | `src/VisualStudio/Xaml/Impl/Implementation/XamlProjectService.cs` | MEF エクスポート、ドキュメント管理 |

**読解のコツ**: `TrackOpenDocument` と `EnsureDocument` がドキュメント管理の中心。RDT と IVsSolution イベントを監視している。

**主要処理フロー**:
1. **44-64行目**: コンストラクタで依存性注入とイベントハンドラ登録
2. **71-108行目**: TrackOpenDocument でドキュメントを追跡開始
3. **110-194行目**: EnsureDocument でプロジェクトとドキュメントを登録
4. **196-213行目**: OnDocumentClosed でクリーンアップ
5. **224-261行目**: OnDocumentMonikerChanged でファイル名変更に対応

#### Step 2: サービスインターフェースを理解する

提供される言語サービス機能を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | IXamlCompletionService.cs | `src/VisualStudio/Xaml/Impl/Features/Completion/IXamlCompletionService.cs` | 補完サービスインターフェース |
| 2-2 | IXamlGoToDefinitionService.cs | `src/VisualStudio/Xaml/Impl/Features/Definitions/IXamlGoToDefinitionService.cs` | 定義移動サービス |
| 2-3 | IXamlQuickInfoService.cs | `src/VisualStudio/Xaml/Impl/Features/QuickInfo/IXamlQuickInfoService.cs` | クイック情報サービス |

#### Step 3: データ構造を理解する

各機能で使用されるデータ構造を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | XamlCompletionItem.cs | `src/VisualStudio/Xaml/Impl/Features/Completion/XamlCompletionItem.cs` | 補完項目 |
| 3-2 | XamlDefinition.cs | `src/VisualStudio/Xaml/Impl/Features/Definitions/XamlDefinition.cs` | 定義情報 |
| 3-3 | XamlDiagnostic.cs | `src/VisualStudio/Xaml/Impl/Features/Diagnostics/XamlDiagnostic.cs` | 診断情報 |

### プログラム呼び出し階層図

```
XamlProjectService (エントリーポイント)
    │
    ├─ TrackOpenDocument
    │      └─ EnsureDocument
    │             ├─ RDT.FindDocument
    │             ├─ VisualStudioProjectFactory.CreateAndAddToWorkspaceAsync
    │             └─ project.AddSourceFile
    │
    ├─ OnDocumentClosed
    │      └─ project.RemoveSourceFile
    │
    ├─ OnProjectClosing
    │      └─ project.RemoveFromWorkspace
    │
    └─ OnDocumentMonikerChanged
           ├─ project.RemoveSourceFile (old)
           └─ project.AddSourceFile (new)

言語サービス:
IXamlCompletionService ───▶ XamlCompletionResult
IXamlGoToDefinitionService ───▶ XamlDefinition
IXamlQuickInfoService ───▶ XamlQuickInfo
IXamlPullDiagnosticService ───▶ XamlDiagnosticReport
```

### データフロー図

```
[入力]                      [処理]                           [出力]

XAML ファイルを開く ────────▶ XamlProjectService ───────────▶ DocumentId
                                 │
補完要求 ────────────────────▶ IXamlCompletionService ──────▶ 補完リスト
                                 │
定義移動要求 ────────────────▶ IXamlGoToDefinitionService ──▶ 定義位置
                                 │
診断要求 ────────────────────▶ IXamlPullDiagnosticService ──▶ 診断一覧
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| XamlProjectService.cs | `src/VisualStudio/Xaml/Impl/Implementation/XamlProjectService.cs` | ソース | プロジェクトサービスのメイン実装 |
| XamlProjectService_IVsSolutionEvents.cs | `src/VisualStudio/Xaml/Impl/Implementation/XamlProjectService_IVsSolutionEvents.cs` | ソース | ソリューションイベント処理 |
| XamlProjectService_IVsRunningDocTableEvents3.cs | `src/VisualStudio/Xaml/Impl/Implementation/XamlProjectService_IVsRunningDocTableEvents3.cs` | ソース | RDT イベント処理 |
| IXamlCompletionService.cs | `src/VisualStudio/Xaml/Impl/Features/Completion/IXamlCompletionService.cs` | ソース | 補完サービスインターフェース |
| IXamlGoToDefinitionService.cs | `src/VisualStudio/Xaml/Impl/Features/Definitions/IXamlGoToDefinitionService.cs` | ソース | 定義移動サービス |
| IXamlQuickInfoService.cs | `src/VisualStudio/Xaml/Impl/Features/QuickInfo/IXamlQuickInfoService.cs` | ソース | クイック情報サービス |
| IXamlFormattingService.cs | `src/VisualStudio/Xaml/Impl/Features/Formatting/IXamlFormattingService.cs` | ソース | フォーマットサービス |
| XamlDocumentDiagnosticAnalyzer.cs | `src/VisualStudio/Xaml/Impl/Diagnostics/Analyzers/XamlDocumentDiagnosticAnalyzer.cs` | ソース | 診断アナライザー |
