# 機能設計書 108-エディタ機能基盤

## 概要

本ドキュメントは、Roslyn におけるエディタ統合の共通機能基盤の設計を記述する。この機能は Visual Studio エディタと Roslyn 言語サービスを統合するための共通インフラストラクチャを提供する。

### 本機能の処理概要

エディタ機能基盤は、コード分類（シンタックスハイライト）、インラインリネーム、バックグラウンド作業インジケーター、言語サーバープロトコル（LSP）クライアントなど、エディタ統合に必要な共通機能を提供する。C# と Visual Basic の両言語で共有される。

**業務上の目的・背景**：Visual Studio のエディタと Roslyn 言語サービスをシームレスに統合するために、共通の基盤機能が必要である。シンタックスハイライト、インラインリネーム、コマンドハンドリングなどのエディタ機能は、言語に依存しない共通実装として提供することで、コードの重複を避け、一貫した動作を保証する。

**機能の利用シーン**：Visual Studio でコードを編集するすべての場面で使用される。具体的には、コードの色分け表示、シンボル名のインライン編集（リネーム）、コード補完、ナビゲーションなどの機能で動作する。

**主要な処理内容**：
1. SyntacticClassificationTaggerProvider によるシンタックスハイライト
2. InlineRenameService によるインラインリネーム機能
3. AbstractInProcLanguageClient による LSP クライアント
4. BackgroundWorkIndicatorFactory によるバックグラウンド処理表示
5. EditorOptionsService によるエディタオプション管理

**関連システム・外部連携**：Visual Studio エディタ、MEF、ITextBuffer、ITextView、Language Server Protocol と連携する。

**権限による制御**：ユーザー設定によりシンタックスカラーリングの有効/無効を切り替え可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 21 | リネームフライアウト | 主画面 | エディタ内でのインラインリネーム入力とオプション設定 |
| 22 | リネームユーザー入力テキストボックス | 補助機能 | リネーム名入力のテキストボックスコンポーネント |

## 機能種別

エディタ統合 / 基盤機能 / タガー提供

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| buffer | ITextBuffer | Yes | テキストバッファ | null チェック |
| textSpan | TextSpan | Yes | 対象範囲 | 範囲チェック |
| document | Document | Yes | ドキュメント | null チェック |

### 入力データソース

- テキストバッファ
- Roslyn Document
- ユーザー操作（キーボード/マウス）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| IClassificationTag | IClassificationTag | 分類タグ |
| InlineRenameSession | InlineRenameSession | リネームセッション |
| BackgroundWorkIndicator | IBackgroundWorkIndicatorContext | 進行表示 |

### 出力先

- エディタのビジュアル表示
- Visual Studio ステータスバー

## 処理フロー

### 処理シーケンス

```
1. エディタがバッファを開く
   └─ TaggerProvider がタガーを生成
2. テキスト変更を検出
   └─ TagComputer が分類を再計算
3. タグを返却
   └─ エディタがハイライトを表示
4. リネームコマンド実行
   └─ InlineRenameService がセッションを開始
5. 新しい名前を入力
   └─ すべての参照を更新
```

### フローチャート

```mermaid
flowchart TD
    A[バッファを開く] --> B[TaggerProvider]
    B --> C[Tagger 生成]
    C --> D{テキスト変更?}
    D -->|Yes| E[TagComputer 再計算]
    E --> F[タグ返却]
    F --> D
    D -->|No| G[待機]
    G --> D

    H[リネームコマンド] --> I[InlineRenameService]
    I --> J[セッション開始]
    J --> K[UI 表示]
    K --> L{確定?}
    L -->|Yes| M[参照更新]
    L -->|No| N[キャンセル]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-108-01 | シンタックスカラー設定 | SyntacticColorizerOptionsStorage で有効/無効を制御 | 分類時 |
| BR-108-02 | アクティブセッション排他 | インラインリネームは同時に1セッションのみ | リネーム開始時 |
| BR-108-03 | UI スレッド必須 | タガー生成は UI スレッドで実行 | 初期化時 |

### 計算ロジック

- シンタックス分類はキャッシュされ、変更のあった行のみ再計算

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | InvalidOperationException | アクティブなリネームセッションが存在 | エラーメッセージを表示 |
| - | null 返却 | オプションで無効化されている | タガーを生成しない |

### リトライ仕様

リトライなし

## トランザクション仕様

トランザクションなし

## パフォーマンス要件

- シンタックス分類は増分更新でパフォーマンスを最適化
- バックグラウンド処理は非同期で実行

## セキュリティ考慮事項

- ローカルファイルのみを対象
- Visual Studio プロセス内で実行

## 備考

- SyntacticClassificationTaggerProvider は TotalClassificationTaggerProvider から使用される（直接 MEF エクスポートされない）
- InlineRenameService は言語固有の IEditorInlineRenameService を使用

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: シンタックス分類を理解する

まず、シンタックスハイライトの仕組みを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SyntacticClassificationTaggerProvider.cs | `src/EditorFeatures/Core/Classification/Syntactic/SyntacticClassificationTaggerProvider.cs` | タガープロバイダーの実装 |

**読解のコツ**: `CreateTagger` メソッドがタガーを生成し、`TagComputer` が実際の分類計算を行う。

**主要処理フロー**:
1. **18-21行目**: コンストラクタでTaggerHostとTypeMapを受け取る
2. **27-35行目**: CreateTagger でオプションをチェックしてタガーを生成
3. **30-31行目**: SyntacticColorizerOptionsStorage でオプション確認

#### Step 2: インラインリネームを理解する

リネーム機能の実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | InlineRenameService.cs | `src/EditorFeatures/Core/InlineRename/InlineRenameService.cs` | リネームサービスのメイン実装 |

**主要処理フロー**:
- **30-37行目**: コンストラクタで依存性を注入
- **50-56行目**: StartInlineSession でリネームセッションを開始
- **58-114行目**: StartInlineSessionAsync で非同期にセッションを開始
- **160-181行目**: ActiveSession プロパティでアクティブセッションを管理

#### Step 3: LSP クライアントを理解する

Language Server Protocol クライアントの実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AbstractInProcLanguageClient.cs | `src/EditorFeatures/Core/LanguageServer/AbstractInProcLanguageClient.cs` | LSP クライアント基盤 |

### プログラム呼び出し階層図

```
SyntacticClassificationTaggerProvider
    │
    └─ CreateTagger
           └─ TagComputer.GetOrCreate
                  └─ Tagger

InlineRenameService
    │
    ├─ StartInlineSession
    │      └─ StartInlineSessionAsync
    │             ├─ IEditorInlineRenameService.GetRenameInfoAsync
    │             └─ InlineRenameSession
    │
    └─ ActiveSession (管理)

AbstractInProcLanguageClient
    │
    ├─ ActivateAsync
    └─ OnServerInitializedAsync
```

### データフロー図

```
[入力]                      [処理]                           [出力]

テキストバッファ ───────────▶ TaggerProvider ────────────────▶ 分類タグ
                                 │
リネームコマンド ───────────▶ InlineRenameService ───────────▶ セッション
                                 │
新しい名前 ─────────────────▶ RenameSession ─────────────────▶ 参照更新
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SyntacticClassificationTaggerProvider.cs | `src/EditorFeatures/Core/Classification/Syntactic/SyntacticClassificationTaggerProvider.cs` | ソース | シンタックス分類タガー |
| SyntacticClassificationTaggerProvider.TagComputer.cs | `src/EditorFeatures/Core/Classification/Syntactic/SyntacticClassificationTaggerProvider.TagComputer.cs` | ソース | タグ計算 |
| InlineRenameService.cs | `src/EditorFeatures/Core/InlineRename/InlineRenameService.cs` | ソース | インラインリネームサービス |
| InlineRenameSession.cs | `src/EditorFeatures/Core/InlineRename/InlineRenameSession.cs` | ソース | リネームセッション |
| AbstractInProcLanguageClient.cs | `src/EditorFeatures/Core/LanguageServer/AbstractInProcLanguageClient.cs` | ソース | LSP クライアント基盤 |
| EditorOptionsService.cs | `src/EditorFeatures/Core/Options/EditorOptionsService.cs` | ソース | エディタオプション |
| RenameFlyout.xaml.cs | `src/EditorFeatures/Core/InlineRename/UI/Adornment/RenameFlyout.xaml.cs` | ソース | リネームUI |
