# 機能設計書 109-C#エディタ機能

## 概要

本ドキュメントは、Roslyn における C# 固有のエディタ機能の設計を記述する。この機能は C# 言語に特化したエディタ統合機能を提供する。

### 本機能の処理概要

C# エディタ機能は、C# コード編集に特化した機能群を提供する。インラインリネーム、コード補完、ドキュメントコメント、ブロックコメント編集、文字列コピーペースト、イベントフックアップ、生文字列リテラルなど、C# 固有の言語機能に対応したエディタ操作を実装する。

**業務上の目的・背景**：C# には言語固有の構文や機能（using ディレクティブ、XML ドキュメントコメント、生文字列リテラル、レコード型など）が存在し、これらに対応した専用のエディタ機能が必要である。共通エディタ機能を継承しながら、C# 固有の動作を追加する。

**機能の利用シーン**：Visual Studio で C# ファイル（.cs, .csx）を編集している際に使用される。具体的には、イベントハンドラの自動生成、XML ドキュメントコメントの補完、生文字列リテラルの入力支援、名前空間変換などの場面で動作する。

**主要な処理内容**：
1. CSharpEditorInlineRenameService による C# 固有リネーム機能
2. DocumentationCommentCommandHandler による XML ドキュメントコメント
3. BlockCommentEditingCommandHandler によるブロックコメント編集
4. StringCopyPasteCommandHandler による文字列コピーペースト処理
5. EventHookupCommandHandler によるイベントハンドラ自動生成
6. RawStringLiteralCommandHandler による生文字列リテラル入力支援

**関連システム・外部連携**：エディタ機能基盤、Roslyn C# 構文解析、コマンドハンドリングシステムと連携する。

**権限による制御**：特定の権限制御なし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 21 | リネームフライアウト | 主画面 | C# シンボルのインラインリネーム |

## 機能種別

言語固有機能 / エディタ統合 / コマンドハンドラ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| document | Document | Yes | C# ドキュメント | null チェック |
| textSpan | TextSpan | Yes | 対象範囲 | 範囲チェック |
| inlineRenameInfo | IInlineRenameInfo | Yes | リネーム情報 | - |

### 入力データソース

- C# ソースファイル
- ユーザーキーボード入力
- リファクタリング要求

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| RenameContext | ImmutableDictionary | リネームコンテキスト情報 |
| DocumentationComment | string | 生成されたドキュメントコメント |
| EventHandler | MethodDeclaration | 生成されたイベントハンドラ |

### 出力先

- エディタバッファ
- ワークスペース

## 処理フロー

### 処理シーケンス

```
1. C# ファイルでリネームを開始
   └─ CSharpEditorInlineRenameService.GetRenameInfoAsync
2. リネームコンテキストを収集
   └─ GetRenameContextAsync で定義/参照/ドキュメントを取得
3. 新しい名前を適用
   └─ すべての参照を更新
4. イベント += で Tab キー
   └─ EventHookupCommandHandler がハンドラを生成
5. /// を入力
   └─ DocumentationCommentCommandHandler がテンプレートを生成
```

### フローチャート

```mermaid
flowchart TD
    A[C# ファイル編集] --> B{操作種別}
    B -->|リネーム| C[CSharpEditorInlineRenameService]
    B -->|イベント| D[EventHookupCommandHandler]
    B -->|ドキュメント| E[DocumentationCommentCommandHandler]
    B -->|生文字列| F[RawStringLiteralCommandHandler]
    C --> G[GetRenameContextAsync]
    G --> H[定義/参照/ドキュメント収集]
    D --> I[イベントハンドラ生成]
    E --> J[XMLドキュメント生成]
    F --> K[リテラル補完]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-109-01 | コンテキスト行数制限 | 定義/参照周辺の最大20行を取得 | GetRenameContextAsync |
| BR-109-02 | 最大定義数 | 最大10個の定義を収集 | GetRenameContextAsync |
| BR-109-03 | 最大参照数 | 最大50個の参照を収集 | GetRenameContextAsync |

### 計算ロジック

リネームコンテキストでは、定義と参照の周辺コードを収集し、Copilot などの AI 支援リネーム機能に提供する。

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | キャンセル | ユーザーキャンセル | 処理を中断 |
| - | 読み取り専用 | 読み取り専用ファイル | エラーメッセージ表示 |

### リトライ仕様

リトライなし

## トランザクション仕様

トランザクションなし

## パフォーマンス要件

- リネームコンテキスト収集は非同期で実行
- 大量の参照がある場合は制限を適用

## セキュリティ考慮事項

- ローカルソースコードのみを対象
- Copilot 連携時はコードスニペットを送信

## 備考

- CSharpEditorInlineRenameService は Copilot のスマートリネーム機能と連携してリネームコンテキストを提供
- イベントフックアップは += の後に Tab キーでイベントハンドラを自動生成

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: インラインリネームを理解する

まず、C# 固有のインラインリネーム実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | CSharpEditorInlineRenameService.cs | `src/EditorFeatures/CSharp/InlineRename/CSharpEditorInlineRenameService.cs` | AbstractEditorInlineRenameService を継承 |

**読解のコツ**: `GetRenameContextAsync` が Copilot 連携のためにコンテキスト情報を収集する。

**主要処理フロー**:
1. **24-28行目**: クラス定義とエクスポート
2. **30-33行目**: 定数定義（コンテキスト行数、最大定義数、最大参照数）
3. **38-108行目**: GetRenameContextAsync でリネームコンテキストを収集
4. **46-77行目**: 定義周辺のコードスニペットを収集
5. **79-92行目**: 参照周辺のコードスニペットを収集

#### Step 2: コマンドハンドラを理解する

各種コマンドハンドラの実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | DocumentationCommentCommandHandler.cs | `src/EditorFeatures/CSharp/DocumentationComments/DocumentationCommentCommandHandler.cs` | XMLドキュメントコメント |
| 2-2 | EventHookupCommandHandler.cs | `src/EditorFeatures/CSharp/EventHookup/EventHookupCommandHandler.cs` | イベントハンドラ自動生成 |
| 2-3 | RawStringLiteralCommandHandler.cs | `src/EditorFeatures/CSharp/RawStringLiteral/RawStringLiteralCommandHandler.cs` | 生文字列リテラル |

#### Step 3: 文字列処理を理解する

文字列コピーペーストの特殊処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | StringCopyPasteCommandHandler.cs | `src/EditorFeatures/CSharp/StringCopyPaste/StringCopyPasteCommandHandler.cs` | 文字列内でのコピーペースト処理 |

### プログラム呼び出し階層図

```
CSharpEditorInlineRenameService
    │
    └─ GetRenameContextAsync
           ├─ TryGetSurroundingNodeSpanAsync (定義)
           ├─ TryGetSurroundingNodeSpanAsync (参照)
           └─ GetDocumentationCommentXml

EventHookupCommandHandler
    │
    ├─ HandleTypeCharCommand
    │      └─ EventHookupSessionManager
    │
    └─ HandleTabKeyCommand
           └─ イベントハンドラ生成

DocumentationCommentCommandHandler
    │
    └─ HandleCommand
           └─ XML ドキュメントテンプレート生成
```

### データフロー図

```
[入力]                      [処理]                           [出力]

リネーム要求 ───────────────▶ CSharpEditorInlineRenameService ─▶ コンテキスト
                                 │
イベント += Tab ───────────▶ EventHookupCommandHandler ──────▶ ハンドラ生成
                                 │
/// 入力 ───────────────────▶ DocumentationCommentCommandHandler ─▶ XML テンプレート
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CSharpEditorInlineRenameService.cs | `src/EditorFeatures/CSharp/InlineRename/CSharpEditorInlineRenameService.cs` | ソース | C# インラインリネーム |
| DocumentationCommentCommandHandler.cs | `src/EditorFeatures/CSharp/DocumentationComments/DocumentationCommentCommandHandler.cs` | ソース | XMLドキュメントコメント |
| EventHookupCommandHandler.cs | `src/EditorFeatures/CSharp/EventHookup/EventHookupCommandHandler.cs` | ソース | イベントハンドラ生成 |
| RawStringLiteralCommandHandler.cs | `src/EditorFeatures/CSharp/RawStringLiteral/RawStringLiteralCommandHandler.cs` | ソース | 生文字列リテラル |
| StringCopyPasteCommandHandler.cs | `src/EditorFeatures/CSharp/StringCopyPaste/StringCopyPasteCommandHandler.cs` | ソース | 文字列コピーペースト |
| BlockCommentEditingCommandHandler.cs | `src/EditorFeatures/CSharp/BlockCommentEditing/BlockCommentEditingCommandHandler.cs` | ソース | ブロックコメント編集 |
| AutomaticLineEnderCommandHandler.cs | `src/EditorFeatures/CSharp/AutomaticCompletion/AutomaticLineEnderCommandHandler.cs` | ソース | 自動行末処理 |
