# 機能設計書 11-シグネチャヘルプ

## 概要

本ドキュメントは、Roslynのシグネチャヘルプ機能の設計について記述する。シグネチャヘルプは、メソッドや関数の呼び出し時にパラメータ情報をリアルタイムで表示するIDE機能である。

### 本機能の処理概要

シグネチャヘルプ機能は、開発者がメソッド呼び出しやコンストラクタ呼び出しを行う際に、利用可能なオーバーロードとそのパラメータ情報をポップアップ表示する機能である。

**業務上の目的・背景**：開発者がコードを記述する際、メソッドのパラメータ名・型・順序・オプション情報を即座に確認できることで、APIドキュメントを参照する手間を省き、コーディング効率を大幅に向上させる。特に、オーバーロードが多いAPIや、初めて使用するライブラリを扱う際に不可欠な機能である。

**機能の利用シーン**：
- メソッド呼び出し時に開き括弧 `(` を入力したとき
- コンストラクタ呼び出し時（`new ClassName(`）
- デリゲート呼び出し時
- インデクサアクセス時（`array[`）
- 属性のパラメータ指定時
- コレクション初期化子の使用時

**主要な処理内容**：
1. トリガー文字（`(`、`,`、`)`）の検出とシグネチャヘルプセッションの開始・更新・終了
2. カーソル位置のシンボル解析と適用可能なオーバーロードの収集
3. 現在のパラメータ位置の特定と該当パラメータのハイライト
4. 名前付き引数の解析とフィルタリング
5. マルチターゲットプロジェクトにおけるプラットフォーム可用性の表示
6. XMLドキュメントコメントからのパラメータ説明取得

**関連システム・外部連携**：
- セマンティック解析エンジン（シンボル解決）
- XMLドキュメント解析システム
- LSP（Language Server Protocol）エンドポイント
- Visual Studio IntelliSenseシステム

**権限による制御**：特になし。すべての開発者が利用可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | エディタ内ポップアップ | 主画面 | シグネチャヘルプ情報の表示 |

## 機能種別

リアルタイムコード解析 / UI情報提供

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| document | Document | Yes | 対象ドキュメント | null不可 |
| position | int | Yes | カーソル位置 | 0以上、ドキュメント長以下 |
| triggerInfo | SignatureHelpTriggerInfo | Yes | トリガー情報（理由・文字） | トリガー理由必須 |
| options | MemberDisplayOptions | Yes | メンバー表示オプション | - |
| cancellationToken | CancellationToken | Yes | キャンセルトークン | - |

### 入力データソース

- エディタからのカーソル位置情報
- ユーザー入力（トリガー文字）
- ドキュメントのセマンティックモデル

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Items | IList\<SignatureHelpItem\> | シグネチャヘルプアイテムのリスト |
| ApplicableSpan | TextSpan | セッションが有効なテキスト範囲 |
| SemanticParameterIndex | int | 現在のパラメータインデックス |
| SyntacticArgumentCount | int | 構文的な引数の数 |
| ArgumentName | string? | 名前付き引数の名前 |
| SelectedItemIndex | int? | 選択されるべきアイテムのインデックス |

### 出力先

- エディタのシグネチャヘルプポップアップUI
- LSPクライアント（VSCode等）

## 処理フロー

### 処理シーケンス

```
1. トリガー検出
   └─ ユーザーがトリガー文字を入力、またはコマンド実行
2. プロバイダ選択
   └─ 言語に応じたISignatureHelpProviderを取得
3. シンボル解析
   └─ カーソル位置のシンボルを解決
4. オーバーロード収集
   └─ 適用可能なすべてのオーバーロードを収集
5. パラメータ位置特定
   └─ 現在カーソルがどのパラメータにあるか特定
6. フィルタリング
   └─ 名前付き引数に基づくフィルタリング
7. プラットフォーム検証
   └─ マルチターゲット時の可用性チェック
8. 結果生成
   └─ SignatureHelpItemsの構築と返却
```

### フローチャート

```mermaid
flowchart TD
    A[トリガー文字入力] --> B{有効なトリガー?}
    B -->|No| Z[終了]
    B -->|Yes| C[プロバイダ取得]
    C --> D[シンボル解析]
    D --> E{シンボル発見?}
    E -->|No| Z
    E -->|Yes| F[オーバーロード収集]
    F --> G[パラメータ位置特定]
    G --> H{名前付き引数?}
    H -->|Yes| I[フィルタリング]
    H -->|No| J[全候補保持]
    I --> K[結果生成]
    J --> K
    K --> L[UI表示]
    L --> Z
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | トリガー文字 | `(`、`,`がシグネチャヘルプの開始/更新トリガー | メソッド呼び出しコンテキスト |
| BR-02 | 終了トリガー | `)` が入力された時点でセッション終了判断 | シグネチャヘルプセッション中 |
| BR-03 | パラメータハイライト | 現在のカーソル位置に対応するパラメータを強調 | 常時 |
| BR-04 | 可変長パラメータ | paramsパラメータは最後として扱い、超過引数も対応 | Variadic=true |
| BR-05 | 名前付き引数フィルタ | 名前付き引数使用時は該当パラメータを持つオーバーロードのみ表示 | 名前付き引数使用時 |

### 計算ロジック

- パラメータインデックスの計算: カンマの数を数え、名前付き引数の位置を考慮
- 最適オーバーロード選択: 引数の数とマッチするオーバーロードを優先

## データベース操作仕様

該当なし（メモリ内処理のみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | シンボル未解決 | 対象シンボルが見つからない | 空結果を返却 |
| - | 構文エラー | コードが不完全な状態 | 部分的な結果を返却 |
| - | タイムアウト | 解析に時間がかかりすぎ | キャンセルトークンで中断 |

### リトライ仕様

特になし。ユーザーの再入力で自動的に再試行される。

## トランザクション仕様

該当なし（読み取り専用処理）

## パフォーマンス要件

- レスポンス時間: 100ms以内（ユーザー入力に対するインタラクティブ性確保）
- OOP（Out-of-Process）実行でメインUIスレッドをブロックしない

## セキュリティ考慮事項

特になし（ローカルコード解析のみ）

## 備考

- C#とVBで共通の基盤を使用
- LSP対応により、VSCode等の外部エディタでも利用可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、シグネチャヘルプで使用されるデータ構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SignatureHelpItem.cs | `src/Features/Core/Portable/SignatureHelp/SignatureHelpItem.cs` | 個々のシグネチャ（オーバーロード）を表すクラス。IsVariadic、Prefix/Suffix/SeparatorDisplayParts、Parametersを理解する |
| 1-2 | SignatureHelpParameter.cs | `src/Features/Core/Portable/SignatureHelp/SignatureHelpParameter.cs` | パラメータ情報を保持するクラス。Name、IsOptional、DisplayParts、DocumentationFactoryを理解する |
| 1-3 | SignatureHelpItems.cs | `src/Features/Core/Portable/SignatureHelp/SignatureHelpItems.cs` | 複数のシグネチャをまとめて保持するクラス。ApplicableSpan、SemanticParameterIndex、SelectedItemIndexを理解する |
| 1-4 | SignatureHelpTriggerInfo.cs | `src/Features/Core/Portable/SignatureHelp/SignatureHelpTriggerInfo.cs` | トリガー情報（理由と文字）を保持する構造体 |
| 1-5 | SignatureHelpTriggerReason.cs | `src/Features/Core/Portable/SignatureHelp/SignatureHelpTriggerReason.cs` | トリガー理由の列挙型（InvokeSignatureHelpCommand、TypeCharCommand、RetriggerCommand） |

**読解のコツ**: SignatureHelpItemが個々のオーバーロード、SignatureHelpItemsがセッション全体の情報を表す。両者の関係を理解することが重要。

#### Step 2: インターフェースを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ISignatureHelpProvider.cs | `src/Features/Core/Portable/SignatureHelp/ISignatureHelpProvider.cs` | シグネチャヘルププロバイダの契約。TriggerCharacters、RetriggerCharacters、GetItemsAsyncメソッドを確認 |

**主要処理フロー**:
- **11-17行目**: TriggerCharactersプロパティ - セッション開始トリガー文字（例: `(`、`,`）
- **19-23行目**: RetriggerCharactersプロパティ - セッション更新/終了トリガー文字（例: `)`）
- **28行目**: GetItemsAsyncメソッド - 位置に対するシグネチャヘルプアイテムを取得

#### Step 3: サービス層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SignatureHelpService.cs | `src/Features/Core/Portable/SignatureHelp/SignatureHelpService.cs` | MEFでエクスポートされるサービス。言語に応じたプロバイダを管理し、最適な結果を選択する |

**主要処理フロー**:
- **25-36行目**: 言語ごとにプロバイダをキャッシュ
- **42-54行目**: GetSignatureHelpAsync - 言語に応じたプロバイダ群を取得し呼び出し
- **60-106行目**: 静的GetSignatureHelpAsync - 各プロバイダを順に呼び出し、最も適切な結果（ApplicableSpan.Startが最も大きい）を選択

#### Step 4: 抽象基底クラスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | AbstractSignatureHelpProvider.cs | `src/Features/Core/Portable/SignatureHelp/AbstractSignatureHelpProvider.cs` | 言語固有プロバイダの基底クラス。CreateSignatureHelpItemsメソッド、関連ドキュメント処理を理解する |

**主要処理フロー**:
- **36-66行目**: CreateSignatureHelpItems - フィルタリングとパラメータインデックス調整を行いSignatureHelpItemsを生成
- **93-108行目**: Filter - 名前付き引数に基づくフィルタリング
- **147-224行目**: CreateItem / CreateItemImpl - シンボルからSignatureHelpItemを生成（匿名型・タプル型の表示処理含む）
- **240-301行目**: GetItemsAsync - リンクドファイル（共有プロジェクト）対応の処理

### プログラム呼び出し階層図

```
SignatureHelpService.GetSignatureHelpAsync()
    │
    ├─ GetProviders(language)
    │      └─ _allProviders から言語に一致するプロバイダをフィルタ
    │
    └─ foreach (provider in providers)
           │
           └─ ISignatureHelpProvider.GetItemsAsync()
                  │ (AbstractSignatureHelpProvider)
                  │
                  ├─ GetItemsWorkerAsync() [言語固有実装]
                  │      └─ シンボル解析・オーバーロード収集
                  │
                  ├─ FindActiveRelatedDocumentsAsync()
                  │      └─ リンクドファイルの取得
                  │
                  └─ プラットフォーム可用性の判定
                         └─ SupportedPlatformDataの生成
```

### データフロー図

```
[入力]                      [処理]                           [出力]

Document ─────────┐
                  │
Position ─────────┼──▶ SignatureHelpService ──┐
                  │         │                  │
TriggerInfo ──────┤         ▼                  │
                  │    プロバイダ選択          │
MemberDisplayOptions      │                    │
                          ▼                    │
                    シンボル解析              │
                          │                    │
                          ▼                    ▼
                    オーバーロード収集 ──▶ SignatureHelpItems
                          │                    │
                          ▼                    │
                    パラメータ位置計算         │
                          │                    │
                          ▼                    │
                    名前付き引数フィルタ ──────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SignatureHelpService.cs | `src/Features/Core/Portable/SignatureHelp/SignatureHelpService.cs` | ソース | サービスのエントリーポイント |
| ISignatureHelpProvider.cs | `src/Features/Core/Portable/SignatureHelp/ISignatureHelpProvider.cs` | ソース | プロバイダインターフェース |
| AbstractSignatureHelpProvider.cs | `src/Features/Core/Portable/SignatureHelp/AbstractSignatureHelpProvider.cs` | ソース | プロバイダ基底クラス |
| SignatureHelpItem.cs | `src/Features/Core/Portable/SignatureHelp/SignatureHelpItem.cs` | ソース | シグネチャアイテムモデル |
| SignatureHelpItems.cs | `src/Features/Core/Portable/SignatureHelp/SignatureHelpItems.cs` | ソース | シグネチャアイテム集合モデル |
| SignatureHelpParameter.cs | `src/Features/Core/Portable/SignatureHelp/SignatureHelpParameter.cs` | ソース | パラメータモデル |
| SignatureHelpTriggerInfo.cs | `src/Features/Core/Portable/SignatureHelp/SignatureHelpTriggerInfo.cs` | ソース | トリガー情報構造体 |
| SignatureHelpTriggerReason.cs | `src/Features/Core/Portable/SignatureHelp/SignatureHelpTriggerReason.cs` | ソース | トリガー理由列挙型 |
| SignatureHelpState.cs | `src/Features/Core/Portable/SignatureHelp/SignatureHelpState.cs` | ソース | セッション状態 |
| CommonSignatureHelpUtilities.cs | `src/Features/Core/Portable/SignatureHelp/CommonSignatureHelpUtilities.cs` | ソース | 共通ユーティリティ |
| ExportSignatureHelpProviderAttribute.cs | `src/Features/Core/Portable/SignatureHelp/ExportSignatureHelpProviderAttribute.cs` | ソース | MEFエクスポート属性 |
