# 機能設計書 110-VBエディタ機能

## 概要

本ドキュメントは、Roslyn における Visual Basic 固有のエディタ機能の設計を記述する。この機能は Visual Basic 言語に特化したエディタ統合機能を提供する。

### 本機能の処理概要

VB エディタ機能は、Visual Basic コード編集に特化した機能群を提供する。C# エディタ機能と同様に、エディタ機能基盤を継承しながら、VB 固有の言語構文（End ステートメント自動挿入、With ブロック、イベント構文など）に対応したエディタ操作を実装する。

**業務上の目的・背景**：Visual Basic には言語固有の構文や機能（End Sub/End Function の自動挿入、With ブロック、Handles 句によるイベント、XML リテラルなど）が存在し、これらに対応した専用のエディタ機能が必要である。共通エディタ機能を継承しながら、VB 固有の動作を追加する。

**機能の利用シーン**：Visual Studio で Visual Basic ファイル（.vb, .vbx）を編集している際に使用される。具体的には、Sub/Function の入力後に End ステートメントを自動挿入、XMLドキュメントコメントの補完、コード構造の自動補完などの場面で動作する。

**主要な処理内容**：
1. VB 固有のインラインリネーム機能
2. End ステートメントの自動生成
3. VB 固有のドキュメントコメント処理
4. コード構造の自動補完
5. VB 固有のフォーマット処理

**関連システム・外部連携**：エディタ機能基盤、Roslyn VB 構文解析、コマンドハンドリングシステムと連携する。

**権限による制御**：特定の権限制御なし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 21 | リネームフライアウト | 主画面 | VB シンボルのインラインリネーム |

## 機能種別

言語固有機能 / エディタ統合 / コマンドハンドラ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| document | Document | Yes | VB ドキュメント | null チェック |
| textSpan | TextSpan | Yes | 対象範囲 | 範囲チェック |
| syntaxNode | SyntaxNode | Yes | VB 構文ノード | 型チェック |

### 入力データソース

- Visual Basic ソースファイル
- ユーザーキーボード入力
- リファクタリング要求

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| EndStatement | SyntaxNode | 生成された End ステートメント |
| DocumentationComment | string | 生成されたドキュメントコメント |
| FormattedCode | string | フォーマット済みコード |

### 出力先

- エディタバッファ
- ワークスペース

## 処理フロー

### 処理シーケンス

```
1. VB ファイルで Sub/Function を入力
   └─ EndConstructGenerationService が End を生成
2. Enter キーを押下
   └─ 適切な位置に End ステートメントを挿入
3. リネームを開始
   └─ VB 固有のリネーム処理を実行
4. ''' を入力
   └─ VB 用 XML ドキュメントを生成
```

### フローチャート

```mermaid
flowchart TD
    A[VB ファイル編集] --> B{操作種別}
    B -->|Sub/Function 入力| C[EndConstructGenerationService]
    B -->|リネーム| D[VB InlineRenameService]
    B -->|ドキュメント| E[DocumentationCommentHandler]
    B -->|フォーマット| F[VB FormattingService]
    C --> G[End ステートメント生成]
    D --> H[参照更新]
    E --> I[XML ドキュメント生成]
    F --> J[コードフォーマット]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-110-01 | End 自動挿入 | Sub/Function/If/For 等の入力後に End を自動挿入 | 構文入力後 |
| BR-110-02 | C# との共通基盤 | 共通エディタ機能は C# と共有 | 全機能 |
| BR-110-03 | VB 構文対応 | VB 固有の構文（With, Handles 等）に対応 | VB コード編集時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | キャンセル | ユーザーキャンセル | 処理を中断 |
| - | 読み取り専用 | 読み取り専用ファイル | エラーメッセージ表示 |

### リトライ仕様

リトライなし

## トランザクション仕様

トランザクションなし

## パフォーマンス要件

- C# エディタ機能と同等のパフォーマンス特性
- 構文解析は増分更新で効率化

## セキュリティ考慮事項

- ローカルソースコードのみを対象
- Visual Studio プロセス内で実行

## 備考

- VB エディタ機能は C# エディタ機能と同様の構造を持つが、VB 固有の構文に対応
- 機能一覧.csv によると `src/EditorFeatures/VisualBasic` に配置されているが、リポジトリ内で直接確認できなかった
- 共通エディタ機能基盤（EditorFeatures/Core）を継承して実装されている

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 共通基盤を理解する

VB エディタ機能は共通エディタ機能基盤を継承しているため、まず共通部分を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AbstractEditorInlineRenameService.cs | `src/EditorFeatures/Core/InlineRename/AbstractEditorInlineRenameService.cs` | リネームサービス基底クラス |

**読解のコツ**: C# 実装との差分に注目し、VB 固有の構文対応部分を確認する。

#### Step 2: VB 固有実装を理解する

VB 言語に固有の機能と実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | VBEditorInlineRenameService.vb | `src/EditorFeatures/VisualBasic/InlineRename/VBEditorInlineRenameService.vb` | VB インラインリネーム（存在する場合） |
| 2-2 | EndConstructGenerationService.vb | `src/EditorFeatures/VisualBasic/EndConstruct/EndConstructGenerationService.vb` | End ステートメント生成（存在する場合） |

#### Step 3: C# 実装との比較

C# 実装と比較して VB 固有の差分を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CSharpEditorInlineRenameService.cs | `src/EditorFeatures/CSharp/InlineRename/CSharpEditorInlineRenameService.cs` | C# 実装（参考） |

### プログラム呼び出し階層図

```
VBEditorInlineRenameService (想定)
    │
    └─ AbstractEditorInlineRenameService
           └─ GetRenameInfoAsync
                  └─ 参照更新

EndConstructGenerationService (想定)
    │
    └─ GenerateEndConstruct
           ├─ Sub → End Sub
           ├─ Function → End Function
           ├─ If → End If
           └─ For → Next
```

### データフロー図

```
[入力]                      [処理]                           [出力]

Sub/Function 入力 ──────────▶ EndConstructGenerationService ─▶ End ステートメント
                                 │
リネーム要求 ───────────────▶ VBEditorInlineRenameService ────▶ 参照更新
                                 │
''' 入力 ───────────────────▶ DocumentationCommentHandler ────▶ XML テンプレート
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AbstractEditorInlineRenameService.cs | `src/EditorFeatures/Core/InlineRename/AbstractEditorInlineRenameService.cs` | ソース | リネーム基底クラス |
| InlineRenameService.cs | `src/EditorFeatures/Core/InlineRename/InlineRenameService.cs` | ソース | 共通リネームサービス |
| VBEditorInlineRenameService.vb | `src/EditorFeatures/VisualBasic/InlineRename/VBEditorInlineRenameService.vb` | ソース | VB インラインリネーム（想定） |
| EndConstructGenerationService.vb | `src/EditorFeatures/VisualBasic/EndConstruct/EndConstructGenerationService.vb` | ソース | End ステートメント生成（想定） |
