# 機能設計書 113-C#アナライザー

## 概要

本ドキュメントは、C#言語固有のコード分析ルール（Analyzers/CSharp）の機能設計を定義する。IDE診断機能やコードスタイル検証において、C#特有の構文・セマンティクスに基づいた分析を提供する。

### 本機能の処理概要

C#アナライザーは、C#言語に特化したコード品質分析ルールを実装し、モダンなC#構文の活用促進、潜在的なバグの検出、コードスタイルの統一を支援する診断機能を提供する。

**業務上の目的・背景**：C#言語は継続的に進化しており、新しい言語機能の活用やベストプラクティスへの準拠を促進する必要がある。本機能は、開発者がより保守性・可読性の高いコードを書けるよう支援する。

**機能の利用シーン**：
- エディタでのリアルタイムコード分析と診断表示
- ビルド時の警告・エラー検出
- コードフィックスによる自動修正の提供
- EditorConfig設定に基づくプロジェクト固有のルール適用

**主要な処理内容**：
1. パターンマッチング推奨（is式、switch式への変換）
2. 最新C#構文への変換（varの使用、簡潔な記法）
3. 不要コードの検出（未使用変数、冗長な修飾子）
4. 名前空間・using整理
5. 新しいC#機能の活用促進（レコード、init-only等）

**関連システム・外部連携**：Roslyn Diagnostics API、Visual Studio IDE、EditorConfig

**権限による制御**：特になし。プロジェクト設定に基づいて動作。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | コードエディタ | 主画面 | 診断結果の表示とコードフィックス |

## 機能種別

コード分析 / 診断 / コードフィックス

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| SyntaxTree | SyntaxTree | Yes | C#構文木 | null不可 |
| SemanticModel | SemanticModel | Yes | セマンティックモデル | null不可 |
| AnalyzerOptions | AnalyzerOptions | No | EditorConfig設定等 | - |

### 入力データソース

- C#ソースコード
- EditorConfigファイル
- プロジェクトコンパイル設定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Diagnostic | Diagnostic | 検出された問題の診断情報 |
| CodeAction | CodeAction | 自動修正アクション |
| DocumentChanges | IEnumerable<DocumentChange> | ドキュメント変更内容 |

### 出力先

Visual Studioエラーリスト、エディタ内診断表示

## 処理フロー

### 処理シーケンス

```
1. 構文解析フェーズ
   └─ SyntaxTreeActionsの実行
   └─ 構文パターンの検出

2. セマンティック解析フェーズ
   └─ SymbolActionsの実行
   └─ 型情報・参照情報の分析

3. 診断レポート
   └─ DiagnosticDescriptorに基づく診断生成
   └─ EditorConfig設定による重大度調整
```

### フローチャート

```mermaid
flowchart TD
    A[C#ソースコード] --> B[SyntaxTree取得]
    B --> C[SyntaxNodeAction実行]
    C --> D{パターンマッチ?}
    D -->|Yes| E[診断生成]
    D -->|No| F[次のノード]
    E --> G[CodeFix登録]
    G --> H[結果表示]
    F --> H
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | IDE診断ID | IDE0001-IDE0999の範囲で診断IDを割り当て | 常時 |
| BR-002 | 重大度継承 | EditorConfigで指定された重大度を優先 | EditorConfig存在時 |
| BR-003 | Fading効果 | 不要コードはグレーアウト表示（Fade）| IDE設定有効時 |

### 計算ロジック

- パターンマッチング：C#構文木のノード種別と構造を分析して対象パターンを検出

## データベース操作仕様

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| IDE0001 | Info | 型名の簡略化が可能 | 名前空間修飾を削除 |
| IDE0003 | Info | this/Meの削除可能 | 冗長な修飾子を削除 |
| IDE0019 | Info | パターンマッチング使用可能 | is式へ変換 |
| IDE0066 | Info | switch式に変換可能 | switch式へリファクタ |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- インクリメンタル分析対応
- 並行実行サポート（EnableConcurrentExecution）

## セキュリティ考慮事項

特になし

## 備考

- Core Analyzersと連携して言語非依存ルールも適用
- C# 9.0以降の新機能に対するアナライザーを継続的に追加

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | CSharpAnalyzerOptionsProvider.cs | `src/Analyzers/CSharp/Analyzers/CodeStyle/CSharpAnalyzerOptionsProvider.cs` | C#固有のアナライザーオプション |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CSharpUsePatternMatchingDiagnosticAnalyzer系 | `src/Analyzers/CSharp/Analyzers/UsePatternMatching/` | パターンマッチングアナライザーの構造 |

#### Step 3: 代表的なアナライザー実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CSharpUseImplicitTypeDiagnosticAnalyzer.cs | `src/Analyzers/CSharp/Analyzers/UseImplicitOrExplicitType/CSharpUseImplicitTypeDiagnosticAnalyzer.cs` | var使用推奨 |
| 3-2 | UseSimpleUsingStatementDiagnosticAnalyzer.cs | `src/Analyzers/CSharp/Analyzers/UseSimpleUsingStatement/UseSimpleUsingStatementDiagnosticAnalyzer.cs` | using宣言推奨 |
| 3-3 | CSharpInlineDeclarationDiagnosticAnalyzer.cs | `src/Analyzers/CSharp/Analyzers/InlineDeclaration/CSharpInlineDeclarationDiagnosticAnalyzer.cs` | インライン宣言推奨 |

### プログラム呼び出し階層図

```
DiagnosticAnalyzer.Initialize()
    │
    ├─ RegisterSyntaxNodeAction<SyntaxKind>()
    │      └─ 特定のC#構文ノードに対する分析
    │
    └─ RegisterCompilationStartAction()
           └─ CSharpAnalyzerOptionsProvider.GetOptions()
                  └─ EditorConfig設定の取得
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CSharpUseImplicitTypeDiagnosticAnalyzer.cs | `src/Analyzers/CSharp/Analyzers/UseImplicitOrExplicitType/` | ソース | var使用分析 |
| CSharpAsAndNullCheckDiagnosticAnalyzer.cs | `src/Analyzers/CSharp/Analyzers/UsePatternMatching/` | ソース | パターンマッチング分析 |
| ConvertSwitchStatementToExpressionDiagnosticAnalyzer.cs | `src/Analyzers/CSharp/Analyzers/ConvertSwitchStatementToExpression/` | ソース | switch式変換 |
| CSharpRemoveUnnecessaryImportsDiagnosticAnalyzer.cs | `src/Analyzers/CSharp/Analyzers/RemoveUnnecessaryImports/` | ソース | 不要using削除 |
| CSharpFormattingAnalyzer.cs | `src/Analyzers/CSharp/Analyzers/Formatting/` | ソース | フォーマット分析 |
