# 機能設計書 114-VBアナライザー

## 概要

本ドキュメントは、Visual Basic言語固有のコード分析ルール（Analyzers/VisualBasic）の機能設計を定義する。VB言語特有の構文・セマンティクスに基づいた分析を提供する。

### 本機能の処理概要

VBアナライザーは、Visual Basic言語に特化したコード品質分析ルールを実装し、VB特有の構文パターンに対する診断とコードフィックスを提供する。C#アナライザーと共通のコアアナライザー基盤を活用しつつ、VB固有の言語機能に対応する。

**業務上の目的・背景**：Visual Basicは多くの企業システムで使用されており、C#と同等のコード品質分析機能を提供する必要がある。本機能により、VB開発者も最新のベストプラクティスに準拠したコードを書くことが可能になる。

**機能の利用シーン**：
- VBプロジェクトでのリアルタイムコード分析
- ビルド時の診断実行
- コードスタイルの統一

**主要な処理内容**：
1. VB固有構文のパターン分析
2. コアアナライザーのVB言語バインディング
3. VB特有のコードフィックス提供

**関連システム・外部連携**：Roslyn Diagnostics API、Core Analyzers

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | コードエディタ | 主画面 | VBコードの診断表示 |

## 機能種別

コード分析 / 診断

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| SyntaxTree | SyntaxTree | Yes | VB構文木 | null不可 |
| SemanticModel | SemanticModel | Yes | セマンティックモデル | null不可 |

### 入力データソース

Visual Basicソースコード

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Diagnostic | Diagnostic | VB固有の診断情報 |

### 出力先

Visual Studioエラーリスト

## 処理フロー

### 処理シーケンス

```
1. VB SyntaxTree取得
2. VB固有パターン分析
3. 診断レポート生成
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | VB構文対応 | VB構文ノードに対応した分析を実行 | VBプロジェクト |

## データベース操作仕様

該当なし

## エラー処理

C#アナライザーと同様のIDE診断IDを使用

## トランザクション仕様

該当なし

## パフォーマンス要件

C#アナライザーと同等

## セキュリティ考慮事項

特になし

## 備考

機能一覧.csvではsrc/Analyzers/VisualBasicが参照先として記載されているが、Glob検索では該当ディレクトリにファイルが見つからなかった。C#アナライザーからの移植または共有実装の可能性がある。

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: 共通基盤を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Core Analyzers | `src/Analyzers/Core/Analyzers/` | VBと共有される基盤クラス |

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AbstractBuiltInCodeStyleDiagnosticAnalyzer.cs | `src/Analyzers/Core/Analyzers/` | ソース | VB/C#共通の基底クラス |
