# 機能設計書 115-コアアナライザー

## 概要

本ドキュメントは、言語共通の分析ルール（Analyzers/Core）の機能設計を定義する。C#とVisual Basicで共有される基盤アナライザークラスと言語非依存の診断ルールを提供する。

### 本機能の処理概要

コアアナライザーは、C#とVBで共通して使用できる抽象基底クラス群と、言語に依存しないコード品質分析ルールを提供する。これにより、両言語で一貫したコード品質基準を適用でき、実装の重複を避けることができる。

**業務上の目的・背景**：C#とVBの両方で同じコード品質基準を維持するには、共通の分析ロジックが必要である。本機能は、両言語向けアナライザーの基盤として、一貫性のある診断機能を提供する。

**機能の利用シーン**：
- C#/VBアナライザーの基底クラスとして使用
- 言語非依存の診断ルールの実行
- EditorConfigとの連携設定

**主要な処理内容**：
1. AbstractBuiltInCodeStyleDiagnosticAnalyzer：コードスタイル診断の基底クラス
2. 言語非依存のパターン分析（使用されていないメンバー、冗長な括弧等）
3. コードフィックスの共通基盤
4. DiagnosticDescriptorの管理とEditorConfig連携

**関連システム・外部連携**：Roslyn Diagnostics API、EditorConfig

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 直接の画面関連なし（基盤機能） |

## 機能種別

基盤クラス / 共通診断ルール

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| diagnosticId | string | Yes | 診断ID | IDE診断ID形式 |
| enforceOnBuild | EnforceOnBuild | Yes | ビルド時強制フラグ | 列挙値 |
| option | IOption2 | No | EditorConfigオプション | - |

### 入力データソース

言語固有アナライザーからの継承呼び出し

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| DiagnosticDescriptor | DiagnosticDescriptor | 診断記述子 |
| DiagnosticAnalyzerCategory | DiagnosticAnalyzerCategory | 分析カテゴリ |

### 出力先

派生クラス（C#/VBアナライザー）

## 処理フロー

### 処理シーケンス

```
1. 診断IDとオプションのマッピング登録
   └─ AddDiagnosticIdToOptionMapping

2. DiagnosticDescriptor生成
   └─ タイトル、メッセージ、重大度の設定

3. 分析カテゴリ決定
   └─ GetAnalyzerCategory抽象メソッド
```

### フローチャート

```mermaid
flowchart TD
    A[派生クラスコンストラクタ] --> B[基底クラスコンストラクタ呼び出し]
    B --> C[DiagnosticDescriptor生成]
    C --> D[オプションマッピング登録]
    D --> E[IDEDiagnosticIdToOptionMappingHelper]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | オプション必須 | コードスタイルオプションがあればマッピング登録 | option != null |
| BR-002 | カスタム重大度 | CustomSeverityConfigurableタグ付与 | コードスタイルオプション使用時 |

### 計算ロジック

- オプションマッピング：診断IDと対応するEditorConfigオプションを関連付け

## データベース操作仕様

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Debug.Assert | 複数オプション指定時にカウントが2以上でない | オプション数を確認 |

## トランザクション仕様

該当なし

## パフォーマンス要件

基盤クラスとして軽量な実装

## セキュリティ考慮事項

特になし

## 備考

- AbstractBuiltInCodeStyleDiagnosticAnalyzer_Core.csに追加の基底実装あり
- IDEDiagnosticIdToOptionMappingHelperで診断ID-オプションマッピングを管理

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 基底クラスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AbstractBuiltInCodeStyleDiagnosticAnalyzer.cs | `src/Analyzers/Core/Analyzers/AbstractBuiltInCodeStyleDiagnosticAnalyzer.cs` | メインの基底クラス |
| 1-2 | AbstractBuiltInCodeStyleDiagnosticAnalyzer_Core.cs | `src/Analyzers/Core/Analyzers/AbstractBuiltInCodeStyleDiagnosticAnalyzer_Core.cs` | 追加の基底実装 |

**主要処理フロー（AbstractBuiltInCodeStyleDiagnosticAnalyzer.cs）**:
1. **33-45行目**: 単一診断ID・単一オプションのコンストラクタ
2. **63-77行目**: 単一診断ID・複数オプションのコンストラクタ
3. **82-90行目**: 複数診断記述子とオプションのコンストラクタ
4. **107-113行目**: AddDiagnosticIdToOptionMapping - 静的マッピング登録
5. **118行目**: GetAnalyzerCategory - 抽象メソッド（派生クラスで実装）

#### Step 2: 具体的なアナライザー実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AbstractUseAutoPropertyAnalyzer.cs | `src/Analyzers/Core/Analyzers/UseAutoProperty/AbstractUseAutoPropertyAnalyzer.cs` | 自動プロパティ推奨の共通実装 |
| 2-2 | AbstractRemoveUnnecessaryImportsDiagnosticAnalyzer.cs | `src/Analyzers/Core/Analyzers/RemoveUnnecessaryImports/AbstractRemoveUnnecessaryImportsDiagnosticAnalyzer.cs` | 不要import削除の共通実装 |

#### Step 3: コードフィックス基盤を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | 各CodeFixesディレクトリ | `src/Analyzers/Core/CodeFixes/` | 共通コードフィックス |

### プログラム呼び出し階層図

```
AbstractBuiltInCodeStyleDiagnosticAnalyzer (Core)
    │
    ├─ CSharp派生クラス (Analyzers/CSharp)
    │      └─ CSharpUseImplicitTypeDiagnosticAnalyzer
    │      └─ CSharpAsAndNullCheckDiagnosticAnalyzer
    │      └─ ...
    │
    └─ VisualBasic派生クラス (Analyzers/VisualBasic)
           └─ (VB固有アナライザー)

IDEDiagnosticIdToOptionMappingHelper
    └─ AddOptionMapping(diagnosticId, options)
           └─ 診断ID → EditorConfigオプション マッピング管理
```

### データフロー図

```
[入力]                      [処理]                           [出力]

diagnosticId ─────────▶ AbstractBuiltInCodeStyle... ─────▶ DiagnosticDescriptor
IOption2 ────────────┘         │                              │
                               ▼                              ▼
                    IDEDiagnosticIdToOptionMappingHelper   派生アナライザー
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AbstractBuiltInCodeStyleDiagnosticAnalyzer.cs | `src/Analyzers/Core/Analyzers/` | ソース | コードスタイル診断基底クラス |
| AbstractBuiltInCodeStyleDiagnosticAnalyzer_Core.cs | `src/Analyzers/Core/Analyzers/` | ソース | 追加基底実装 |
| AbstractBuiltInUnnecessaryCodeStyleDiagnosticAnalyzer.cs | `src/Analyzers/Core/Analyzers/` | ソース | 不要コード診断基底クラス |
| AbstractCodeQualityDiagnosticAnalyzer.cs | `src/Analyzers/Core/Analyzers/` | ソース | コード品質診断基底クラス |
| IDEDiagnosticIdToOptionMappingHelper.cs | `src/Analyzers/Core/Analyzers/` | ソース | ID-オプションマッピング |
| IDEDiagnosticIds.cs | `src/Analyzers/Core/Analyzers/` | ソース | 診断ID定数 |
| EnforceOnBuild.cs | `src/Analyzers/Core/Analyzers/` | ソース | ビルド強制設定 |
| DiagnosticCustomTags.cs | `src/Analyzers/Core/Analyzers/` | ソース | カスタムタグ定義 |
