# 機能設計書 116-コードスタイル分析

## 概要

本ドキュメントは、EditorConfig・コードスタイル設定の適用機能（CodeStyle）の機能設計を定義する。プロジェクト・ソリューション全体で一貫したコードスタイルを維持するための設定管理と分析機能を提供する。

### 本機能の処理概要

コードスタイル分析は、EditorConfigファイルに定義されたコードスタイル設定を読み込み、ソースコードがその設定に準拠しているかを分析する機能である。命名規則、フォーマット、コード品質ルールなどの広範なスタイル設定をサポートする。

**業務上の目的・背景**：チーム開発において、コードスタイルの統一は可読性・保守性の向上に不可欠である。EditorConfigを使用することで、IDE非依存でプロジェクト固有のスタイル設定を管理でき、開発者間の一貫性を確保できる。

**機能の利用シーン**：
- 新規コード作成時のスタイルガイド適用
- 既存コードのスタイル違反検出
- コードレビュー時の自動スタイルチェック
- CIパイプラインでのスタイル検証

**主要な処理内容**：
1. EditorConfigファイルの解析と設定読み込み
2. 命名規則（NamingStyle）の定義と検証
3. コードスタイルオプションの適用
4. MEFホストサービスによる言語サービス統合
5. コードフィックスによる自動修正

**関連システム・外部連携**：EditorConfig、Visual Studio IDE、MEF

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 27 | グリッドオプションプレビューコントロール | 主機能 | コードスタイルオプションのグリッド形式プレビュー表示 |
| 28 | オプションプレビューコントロール | 主機能 | オプション設定のプレビューエディタ表示 |
| 29 | コードスタイル通知テキストブロック | 補助機能 | EditorConfig優先設定の警告通知表示 |
| 30 | 命名スタイルオプションページコントロール | 主機能 | 命名規則の追加・編集・管理 |
| 31 | 命名スタイルダイアログ | 主機能 | 命名スタイルの編集 |
| 32 | シンボル仕様ダイアログ | 主機能 | シンボル種類・修飾子の仕様編集 |
| 37 | 設定エディタコントロール | 主機能 | EditorConfigファイルの設定編集 |
| 38-46 | 各種設定ビュー | 主機能/補助機能 | 空白・コードスタイル・命名スタイル設定 |

## 機能種別

設定管理 / コード分析 / コードフィックス

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| languageName | string | Yes | 言語名（CSharp/VisualBasic） | 有効な言語名 |
| editorConfigPath | string | No | EditorConfigファイルパス | 存在するパス |

### 入力データソース

- .editorconfig ファイル
- Visual Studio設定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| HostLanguageServices | HostLanguageServices | 言語サービス |
| CodeStyleOptions | CodeStyleOption | コードスタイル設定値 |

### 出力先

Roslynアナライザー、Visual Studio IDE

## 処理フロー

### 処理シーケンス

```
1. EditorConfigファイル検出
   └─ プロジェクトディレクトリから上位へ探索

2. 設定解析
   └─ キー・値ペアの解析
   └─ 言語固有設定のフィルタリング

3. オプションオブジェクト生成
   └─ CodeStyleOption<T>インスタンス化
   └─ 重大度設定の適用

4. 分析への適用
   └─ アナライザーオプションとして提供
```

### フローチャート

```mermaid
flowchart TD
    A[EditorConfig検出] --> B[ファイル解析]
    B --> C[言語フィルタリング]
    C --> D[オプション生成]
    D --> E[アナライザー適用]
    E --> F[診断生成]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 継承優先度 | 近いディレクトリのEditorConfigが優先 | 複数EditorConfig存在時 |
| BR-002 | root=true | root=trueで上位探索を停止 | 設定あり |
| BR-003 | 言語セクション | [*.cs]などでC#固有設定を定義 | 言語別設定時 |

### 計算ロジック

- 設定マージ：近いファイルから順に設定をマージし、既存キーは上書き

## データベース操作仕様

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Warning | 無効なEditorConfig構文 | 構文を修正 |

## トランザクション仕様

該当なし

## パフォーマンス要件

- EditorConfigのキャッシュ
- インクリメンタルな設定更新

## セキュリティ考慮事項

特になし

## 備考

- dotnet_style_*、csharp_style_*などのプレフィックスで設定を分類
- IDE固有設定とビルド時設定で重大度が異なる場合がある

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: MEFホストサービスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | CodeStyleHostLanguageServices.cs | `src/CodeStyle/Core/CodeFixes/Host/Mef/CodeStyleHostLanguageServices.cs` | 言語サービスのホスト |
| 1-2 | CodeStyleHostLanguageServices.MefHostExportProvider.cs | `src/CodeStyle/Core/CodeFixes/Host/Mef/CodeStyleHostLanguageServices.MefHostExportProvider.cs` | MEFエクスポートプロバイダー |

**主要処理フロー（MefHostExportProvider.cs）**:
1. **28-32行目**: Create - 言語別のアセンブリをロード
2. **35-52行目**: CreateAssemblies - C#/VB別のアセンブリ名リスト作成
3. **55-56行目**: GetExports - MEFエクスポートの取得

#### Step 2: ツールプログラムを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Program.cs (Tools) | `src/CodeStyle/Tools/Program.cs` | コードスタイルツールのエントリーポイント |

### プログラム呼び出し階層図

```
CodeStyleHostLanguageServices
    │
    ├─ MefHostExportProvider.Create(languageName)
    │      ├─ CreateAssemblies() [アセンブリリスト生成]
    │      │      └─ Microsoft.CodeAnalysis.CodeStyle.Fixes
    │      │      └─ Microsoft.CodeAnalysis.CSharp.CodeStyle.Fixes (C#の場合)
    │      │      └─ Microsoft.CodeAnalysis.VisualBasic.CodeStyle.Fixes (VBの場合)
    │      │
    │      └─ ContainerConfiguration.CreateContainer()
    │
    └─ GetExports<TExtension>()
           └─ MEFコンポーネントの解決
```

### データフロー図

```
[入力]                      [処理]                          [出力]

.editorconfig ────────▶ EditorConfig解析 ──────▶ AnalyzerConfigOptions
                              │
languageName ─────────▶ MefHostExportProvider ──▶ HostLanguageServices
                              │
                              ▼
                    CodeStyleOption<T> ──────▶ アナライザー設定
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CodeStyleHostLanguageServices.cs | `src/CodeStyle/Core/CodeFixes/Host/Mef/CodeStyleHostLanguageServices.cs` | ソース | 言語サービスホスト |
| CodeStyleHostLanguageServices.MefHostExportProvider.cs | `src/CodeStyle/Core/CodeFixes/Host/Mef/CodeStyleHostLanguageServices.MefHostExportProvider.cs` | ソース | MEFプロバイダー |
| Program.cs | `src/CodeStyle/Tools/Program.cs` | ソース | ツールエントリーポイント |
| AbstractCSharpDiagnosticProviderBasedUserDiagnosticTest_OptionHelpers.cs | `src/CodeStyle/CSharp/Tests/` | テスト | テストヘルパー |
