# 機能設計書 117-AnalyzerRunner

## 概要

本ドキュメントは、アナライザー実行・パフォーマンス計測ツール（Tools/AnalyzerRunner）の機能設計を定義する。Visual Studioなしでソリューション全体に対してアナライザーを実行し、パフォーマンスを計測できる開発者向けツールである。

### 本機能の処理概要

AnalyzerRunnerは、Roslynアナライザーをコマンドラインから実行し、診断結果の収集とパフォーマンス計測を行うツールである。Visual Studioのオーバーヘッドなしにアナライザーの動作確認とパフォーマンステストが可能。

**業務上の目的・背景**：アナライザー開発時には、実際のソリューションに対するパフォーマンス特性を把握する必要がある。本ツールは、IDE環境なしで大規模ソリューションに対するアナライザー実行時間やリソース消費を計測し、最適化の指標を提供する。

**機能の利用シーン**：
- 新規アナライザーのパフォーマンステスト
- 大規模ソリューションでの診断数カウント
- 並行実行 vs 逐次実行の比較
- ドキュメント単位のエディタ編集シミュレーション
- インクリメンタルアナライザー（IIncrementalAnalyzer）のテスト

**主要な処理内容**：
1. MSBuildWorkspaceを使用したソリューション読み込み
2. DiagnosticAnalyzerRunnerによる診断分析実行
3. IncrementalAnalyzerRunnerによるインクリメンタル分析テスト
4. CodeRefactoringRunnerによるリファクタリング機能テスト
5. テレメトリ情報の収集と表示

**関連システム・外部連携**：MSBuild、Roslyn Diagnostics API

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | CLIツール（画面なし） |

## 機能種別

コマンドラインツール / パフォーマンス計測

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| AnalyzerAssemblyOrFolder | string | Yes | アナライザーアセンブリまたはフォルダパス | 存在するパス |
| Solution | string | Yes | ソリューションファイルパス（.sln） | 存在する.slnファイル |
| /all | flag | No | 無効化されているアナライザーも実行 | - |
| /stats | flag | No | ソリューション統計を表示 | - |
| /a <name> | string | No | 特定のアナライザーのみ有効化 | 有効なアナライザー名 |
| /concurrent | flag | No | 並行実行モード | - |
| /suppressed | flag | No | 抑制された診断も報告 | - |
| /log <file> | string | No | ログファイルパス | 書き込み可能なパス |
| /editperf[:<match>] | string | No | エディタパフォーマンステスト | オプションで正規表現 |
| /edititer:<n> | int | No | エディタテストの繰り返し回数（デフォルト10） | 正の整数 |
| /persist | flag | No | 永続ストレージ有効化（SQLite） | - |
| /fsa | flag | No | フルソリューション分析有効化 | - |
| /ia <name> | string | No | インクリメンタルアナライザー名 | 有効なアナライザー名 |

### 入力データソース

- ソリューションファイル（.sln）
- アナライザーアセンブリ（.dll）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 診断カウント | int | 検出された診断の総数 |
| 実行時間 | TimeSpan | 分析にかかった時間 |
| メモリ使用量 | long | 分析中のメモリ消費 |
| テレメトリ情報 | AnalyzerTelemetryInfo | 各アナライザーの詳細統計 |

### 出力先

- コンソール出力
- ログファイル（オプション）

## 処理フロー

### 処理シーケンス

```
1. オプション解析
   └─ Options.Create(args)

2. ワークスペース作成
   └─ AnalyzerRunnerHelper.CreateWorkspace()

3. ソリューション読み込み
   └─ workspace.OpenSolutionAsync(solutionPath)

4. アナライザー実行
   └─ IncrementalAnalyzerRunner.RunAsync() [インクリメンタル分析]
   └─ DiagnosticAnalyzerRunner.RunAllAsync() [診断分析]
   └─ CodeRefactoringRunner.RunAsync() [リファクタリングテスト]

5. 結果表示
   └─ 診断数、実行時間、テレメトリ情報の出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[オプション解析]
    B --> C{有効なオプション?}
    C -->|No| D[ヘルプ表示]
    C -->|Yes| E[Workspace作成]
    E --> F[ソリューション読み込み]
    F --> G{統計表示?}
    G -->|Yes| H[ソリューション統計出力]
    G -->|No| I[アナライザー実行]
    H --> I
    I --> J[IncrementalAnalyzer]
    J --> K[DiagnosticAnalyzer]
    K --> L[CodeRefactoring]
    L --> M[結果・テレメトリ出力]
    M --> N[終了]
    D --> N
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | AD0001/AD0002エラー化 | アナライザー例外診断をエラーとして扱う | 常時 |
| BR-002 | 言語フィルタ | C#/VBプロジェクトのみ分析対象 | 常時 |
| BR-003 | 5秒待機 | 分析開始前に5秒間待機（安定化のため） | 常時 |

### 計算ロジック

- EditsPerSecond = 繰り返し回数 / 経過秒数
- AllocatedBytesPerEdit = 総割り当てバイト / 繰り返し回数

## データベース操作仕様

該当なし（ただし/persistオプションでSQLiteを使用可能）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| InvalidDataException | 引数エラー | 無効なオプション | ヘルプ参照 |
| FileNotFoundException | ファイルエラー | ソリューションが見つからない | パス確認 |
| AD0001 | 診断エラー | アナライザー例外発生 | アナライザー修正 |

### リトライ仕様

リトライなし

## トランザクション仕様

該当なし

## パフォーマンス要件

- プロファイリング対応（/profileroot オプション）
- 並行実行サポート（/concurrent オプション）

## セキュリティ考慮事項

特になし

## 備考

- PerformanceTrackerクラスで時間・メモリ計測を管理
- AnalyzerTelemetryInfoで各アナライザーの詳細統計を収集

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Program.cs | `src/Tools/AnalyzerRunner/Program.cs` | メインエントリーポイント |
| 1-2 | Options.cs | `src/Tools/AnalyzerRunner/Options.cs` | コマンドラインオプション定義 |

**主要処理フロー（Program.cs）**:
1. **29-40行目**: Main - オプション解析とエラーハンドリング
2. **42-48行目**: キャンセル処理の設定
3. **58-63行目**: 各Runnerの初期化
4. **64-69行目**: アナライザーの有無確認
5. **78行目**: ソリューション読み込み
6. **105-133行目**: 各Runnerの実行

#### Step 2: アナライザーランナーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | DiagnosticAnalyzerRunner.cs | `src/Tools/AnalyzerRunner/DiagnosticAnalyzerRunner.cs` | 診断アナライザー実行 |
| 2-2 | IncrementalAnalyzerRunner.cs | `src/Tools/AnalyzerRunner/IncrementalAnalyzerRunner.cs` | インクリメンタル分析 |
| 2-3 | CodeRefactoringRunner.cs | `src/Tools/AnalyzerRunner/CodeRefactoringRunner.cs` | リファクタリングテスト |

**主要処理フロー（DiagnosticAnalyzerRunner.cs）**:
1. **29-36行目**: コンストラクタ - アナライザーの取得とフィルタリング
2. **40-57行目**: SetOptions - AD0001/AD0002のエラー化
3. **73-176行目**: RunAllAsync - 診断実行とドキュメントテスト
4. **178-198行目**: TestDocumentPerformanceAsync - エディタパフォーマンステスト
5. **285-312行目**: GetDiagnosticAnalyzers - アセンブリからアナライザー読み込み
6. **407-441行目**: WriteTelemetry - テレメトリ情報出力

#### Step 3: ヘルパー・統計を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | PerformanceTracker.cs | `src/Tools/AnalyzerRunner/PerformanceTracker.cs` | パフォーマンス計測 |
| 3-2 | Statistic.cs | `src/Tools/AnalyzerRunner/Statistic.cs` | 統計データ構造 |

### プログラム呼び出し階層図

```
Program.Main(args)
    │
    ├─ Options.Create(args)
    │
    ├─ AnalyzerRunnerHelper.CreateWorkspace()
    │
    ├─ workspace.OpenSolutionAsync()
    │
    ├─ IncrementalAnalyzerRunner
    │      └─ RunAsync()
    │
    ├─ DiagnosticAnalyzerRunner
    │      ├─ RunAllAsync()
    │      │      ├─ GetAnalysisResultAsync()
    │      │      │      └─ GetProjectAnalysisResultAsync() [各プロジェクト]
    │      │      └─ TestDocumentPerformanceAsync() [/editperfオプション時]
    │      │
    │      ├─ GetDiagnosticAnalyzers()
    │      │      └─ GetDiagnosticAnalyzersFromFile()
    │      │
    │      └─ WriteTelemetry()
    │
    └─ CodeRefactoringRunner
           └─ RunAsync()
```

### データフロー図

```
[入力]                         [処理]                          [出力]

.sln ファイル ─────────▶ MSBuildWorkspace ─────▶ Solution
                               │
Analyzer .dll ─────────▶ AnalyzerFileReference ─▶ DiagnosticAnalyzer[]
                               │
                               ▼
                    CompilationWithAnalyzers
                               │
                               ▼
                    ─────────▶ AnalysisResult ─────▶ 診断カウント
                                                     実行時間
                                                     テレメトリ
                                                     │
                                                     ▼
                                              コンソール/ログファイル
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Program.cs | `src/Tools/AnalyzerRunner/Program.cs` | ソース | メインエントリーポイント |
| Options.cs | `src/Tools/AnalyzerRunner/Options.cs` | ソース | オプション定義 |
| DiagnosticAnalyzerRunner.cs | `src/Tools/AnalyzerRunner/DiagnosticAnalyzerRunner.cs` | ソース | 診断アナライザー実行 |
| IncrementalAnalyzerRunner.cs | `src/Tools/AnalyzerRunner/IncrementalAnalyzerRunner.cs` | ソース | インクリメンタル分析 |
| CodeRefactoringRunner.cs | `src/Tools/AnalyzerRunner/CodeRefactoringRunner.cs` | ソース | リファクタリングテスト |
| AnalyzerRunnerHelper.cs | `src/Tools/AnalyzerRunner/AnalyzerRunnerHelper.cs` | ソース | ヘルパーメソッド |
| PerformanceTracker.cs | `src/Tools/AnalyzerRunner/PerformanceTracker.cs` | ソース | パフォーマンス計測 |
| Statistic.cs | `src/Tools/AnalyzerRunner/Statistic.cs` | ソース | 統計構造体 |
| AssemblyLoader.cs | `src/Tools/AnalyzerRunner/AssemblyLoader.cs` | ソース | アセンブリローダー |
