# 機能設計書 118-BuildBoss

## 概要

本ドキュメントは、ビルド構成検証ツール（Tools/BuildBoss）の機能設計を定義する。Roslynリポジトリのソリューション・プロジェクトファイル、ターゲット、パッケージ構成の整合性を検証するツールである。

### 本機能の処理概要

BuildBossは、Roslynビルドシステムの構成ファイルを検証し、プロジェクト参照の重複、ターゲットファイルの整合性、パッケージ構成、OptProf入力などをチェックするCIツールである。

**業務上の目的・背景**：大規模なRoslynソリューションでは、プロジェクトファイルの整合性やビルド構成の正確性を手動で確認することが困難である。BuildBossは自動化された検証を提供し、ビルド問題を早期に検出する。

**機能の利用シーン**：
- CIパイプラインでのビルド前検証
- プロジェクト追加・変更時の整合性確認
- パッケージ構成の妥当性チェック
- 構造化ログの検証

**主要な処理内容**：
1. ソリューションファイル（.sln）の解析と重複プロジェクト検出
2. プロジェクトファイル（.csproj/.vbproj）の検証
3. ターゲットファイル（eng/targets）の検証
4. NuGet/VSIXパッケージ内容の検証
5. 構造化ログ（Build.binlog）の検証
6. OptProf入力ファイルの検証

**関連システム・外部連携**：MSBuild、MSBuildLocator

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | CLIツール（画面なし） |

## 機能種別

コマンドラインツール / ビルド検証

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| -r, --root | string | No | リポジトリルートパス | global.jsonが存在するディレクトリ |
| -c, --configuration | string | No | ビルド構成（Debug/Release） | Debug または Release |
| -p, --primary | string | No | プライマリソリューション名 | - |
| solutionFiles | string[] | No | 検証するソリューションファイル | 存在する.slnファイル |

### 入力データソース

- ソリューションファイル（.sln）
- プロジェクトファイル（.csproj/.vbproj/.shproj）
- ターゲットファイル（eng/targets/*.targets）
- パッケージファイル（*.nupkg, *.vsix）
- 構造化ログ（Build.binlog）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 検証結果 | bool | 全検証がパスしたかどうか |
| エラーメッセージ | string | 検証失敗時の詳細メッセージ |

### 出力先

コンソール出力（標準出力・標準エラー）

## 処理フロー

### 処理シーケンス

```
1. オプション解析
   └─ Mono.Options.OptionSet

2. リポジトリルート検出
   └─ global.jsonを探索

3. ソリューション処理
   └─ ProcessSolution → SolutionCheckerUtil

4. ターゲット処理
   └─ ProcessTargets → TargetsCheckerUtil

5. パッケージ処理
   └─ ProcessPackages → PackageContentsChecker

6. 構造化ログ処理
   └─ ProcessStructuredLog → StructuredLoggerCheckerUtil

7. OptProf処理
   └─ ProcessOptProf → OptProfCheckerUtil
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[オプション解析]
    B --> C[リポジトリルート検出]
    C --> D{ルート見つかった?}
    D -->|No| E[エラー終了]
    D -->|Yes| F[ソリューション検証]
    F --> G[ターゲット検証]
    G --> H[パッケージ検証]
    H --> I[構造化ログ検証]
    I --> J[OptProf検証]
    J --> K{全て成功?}
    K -->|Yes| L[成功終了 (0)]
    K -->|No| M[失敗終了 (1)]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 重複プロジェクト禁止 | 同一ソリューション内に重複プロジェクトは禁止 | 常時 |
| BR-002 | プロジェクトGUID一致 | .slnのプロジェクトGUIDは正しい形式である必要 | 常時 |
| BR-003 | 同一ディレクトリ禁止 | 複数プロジェクトが同じディレクトリに存在してはならない | .shproj以外 |
| BR-004 | global.json必須 | リポジトリルートにglobal.jsonが必要 | 常時 |

### 計算ロジック

- 検証結果：各CheckerUtilのCheck()メソッドの戻り値をAND結合

## データベース操作仕様

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 検証失敗 | いずれかのチェックが失敗 | エラーメッセージに従って修正 |
| 1 | 引数エラー | 無効な構成オプション | Debug/Releaseを指定 |

### リトライ仕様

リトライなし

## トランザクション仕様

該当なし

## パフォーマンス要件

CI環境での実行を想定（数秒〜数分）

## セキュリティ考慮事項

特になし

## 備考

- MSBuildLocator.RegisterDefaults()でMSBuildを自動検出
- .NET SDKの制限により同一ディレクトリに複数プロジェクトは非推奨

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Program.cs | `src/Tools/BuildBoss/Program.cs` | メインエントリーポイント |

**主要処理フロー（Program.cs）**:
1. **18-30行目**: Main - エントリーポイントとエラーハンドリング
2. **32-83行目**: MainCore - オプション解析とリポジトリルート検出
3. **85-94行目**: FindRepositoryRoot - global.jsonを探索
4. **96-117行目**: Go - 各検証処理の呼び出し
5. **119-134行目**: CheckCore - 検証ユーティリティの実行
6. **136-166行目**: 各Process*メソッド - 個別の検証処理

#### Step 2: チェッカーユーティリティを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SolutionCheckerUtil.cs | `src/Tools/BuildBoss/SolutionCheckerUtil.cs` | ソリューション検証 |
| 2-2 | ProjectCheckerUtil.cs | `src/Tools/BuildBoss/ProjectCheckerUtil.cs` | プロジェクト検証 |
| 2-3 | TargetsCheckerUtil.cs | `src/Tools/BuildBoss/TargetsCheckerUtil.cs` | ターゲット検証 |
| 2-4 | PackageContentsChecker.cs | `src/Tools/BuildBoss/PackageContentsChecker.cs` | パッケージ検証 |

**主要処理フロー（SolutionCheckerUtil.cs）**:
1. **39-48行目**: Check - メイン検証処理
2. **51-77行目**: CheckProjects - プロジェクト検証
3. **79-104行目**: CheckDuplicate - 重複検出
4. **109-136行目**: CheckProjectSystemGuid - プロジェクトGUID検証
5. **144-165行目**: CheckSameDirectory - 同一ディレクトリチェック

### プログラム呼び出し階層図

```
Program.Main(args)
    │
    ├─ MainCore(args)
    │      ├─ MSBuildLocator.RegisterDefaults()
    │      ├─ OptionSet.Parse()
    │      ├─ FindRepositoryRoot()
    │      └─ Go()
    │
    └─ Go(repositoryDirectory, configuration, primarySolution, solutionFiles)
           │
           ├─ ProcessSolution() [各ソリューション]
           │      └─ SolutionCheckerUtil.Check()
           │             ├─ CheckDuplicate()
           │             ├─ CheckProjects()
           │             │      └─ ProjectCheckerUtil.Check()
           │             ├─ CheckProjectSystemGuid()
           │             └─ CheckSameDirectory()
           │
           ├─ ProcessTargets()
           │      └─ TargetsCheckerUtil.Check()
           │
           ├─ ProcessPackages()
           │      └─ PackageContentsChecker.Check()
           │
           ├─ ProcessStructuredLog()
           │      └─ StructuredLoggerCheckerUtil.Check()
           │
           └─ ProcessOptProf()
                  └─ OptProfCheckerUtil.Check()
```

### データフロー図

```
[入力]                         [処理]                        [出力]

*.sln ─────────────────▶ SolutionCheckerUtil ─────▶ 重複/GUID/ディレクトリ検証結果
                               │
*.csproj/*.vbproj ────▶ ProjectCheckerUtil ───────▶ プロジェクト設定検証結果
                               │
eng/targets/*.targets ▶ TargetsCheckerUtil ────────▶ ターゲット検証結果
                               │
*.nupkg/*.vsix ────────▶ PackageContentsChecker ───▶ パッケージ内容検証結果
                               │
Build.binlog ──────────▶ StructuredLoggerChecker ──▶ ログ検証結果
                               │
OptProf inputs ────────▶ OptProfCheckerUtil ───────▶ OptProf検証結果
                               │
                               ▼
                         全検証結果の集約 ─────────▶ 終了コード (0/1)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Program.cs | `src/Tools/BuildBoss/Program.cs` | ソース | メインエントリーポイント |
| SolutionCheckerUtil.cs | `src/Tools/BuildBoss/SolutionCheckerUtil.cs` | ソース | ソリューション検証 |
| ProjectCheckerUtil.cs | `src/Tools/BuildBoss/ProjectCheckerUtil.cs` | ソース | プロジェクト検証 |
| TargetsCheckerUtil.cs | `src/Tools/BuildBoss/TargetsCheckerUtil.cs` | ソース | ターゲット検証 |
| PackageContentsChecker.cs | `src/Tools/BuildBoss/PackageContentsChecker.cs` | ソース | パッケージ検証 |
| StructuredLoggerCheckerUtil.cs | `src/Tools/BuildBoss/StructuredLoggerCheckerUtil.cs` | ソース | 構造化ログ検証 |
| OptProfCheckerUtil.cs | `src/Tools/BuildBoss/OptProfCheckerUtil.cs` | ソース | OptProf検証 |
| ICheckerUtil.cs | `src/Tools/BuildBoss/ICheckerUtil.cs` | ソース | チェッカーインターフェース |
| SolutionUtil.cs | `src/Tools/BuildBoss/SolutionUtil.cs` | ソース | ソリューション解析ヘルパー |
| ProjectEntry.cs | `src/Tools/BuildBoss/ProjectEntry.cs` | ソース | プロジェクトエントリ構造 |
| ProjectData.cs | `src/Tools/BuildBoss/ProjectData.cs` | ソース | プロジェクトデータ構造 |
| ProjectKey.cs | `src/Tools/BuildBoss/ProjectKey.cs` | ソース | プロジェクトキー構造 |
