# 機能設計書 119-BuildValidator

## 概要

本ドキュメントは、ビルド再現性検証ツール（Tools/BuildValidator）の機能設計を定義する。Roslynビルド出力のアセンブリから元のソースとコンパイルオプションを抽出し、再ビルドして一致性を検証するツールである。

### 本機能の処理概要

BuildValidatorは、ビルドの再現性（Deterministic Build）を検証するツールである。PEファイルからPDB情報を抽出し、元のコンパイルオプションを復元して再コンパイルを実行し、出力が元のバイナリと一致するかを検証する。

**業務上の目的・背景**：決定論的ビルド（Deterministic Build）は、セキュリティとビルド監査において重要である。同じソースとオプションから同一のバイナリが生成されることを検証することで、ビルドパイプラインの信頼性を確保する。

**機能の利用シーン**：
- CIパイプラインでのビルド再現性検証
- リリースビルドの監査
- コンパイラの決定論的動作の確認
- ビルド問題のデバッグ

**主要な処理内容**：
1. PEファイルからのメタデータ・PDB情報抽出
2. CompilationOptionsReaderによるコンパイルオプション復元
3. RebuildArtifactResolverによるソース・参照の解決
4. CompilationFactoryによる再コンパイル実行
5. バイナリ比較と差分レポート生成

**関連システム・外部連携**：Roslyn Compilation API、System.Reflection.Metadata、PDB API

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | CLIツール（画面なし） |

## 機能種別

コマンドラインツール / ビルド検証

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| --assembliesPath | string[] | Yes | 検証するアセンブリのパス | 存在するパス |
| --sourcePath | string | Yes | ソースコードのパス | 存在するディレクトリ |
| --referencesPath | string[] | No | 参照アセンブリのパス | 存在するパス |
| --exclude | string[] | No | 除外するアセンブリ（部分一致） | - |
| --verbose | flag | No | 詳細ログ出力 | - |
| --quiet | flag | No | エラーのみ出力 | - |
| --debug | flag | No | デバッグ情報出力 | - |
| --debugPath | string | No | デバッグ出力先パス | 書き込み可能なパス |

### 入力データソース

- PEファイル（.exe/.dll）
- PDBファイル（ポータブルPDB/埋め込みPDB）
- ソースコード
- 参照アセンブリ

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 検証結果 | int | 成功時0、失敗時1 |
| 成功リスト | string[] | 再現に成功したアセンブリ |
| 差分リスト | string[] | 出力差異があったアセンブリ |
| エラーリスト | string[] | コンパイルエラーのあったアセンブリ |
| 参照不足リスト | string[] | 参照が見つからなかったアセンブリ |

### 出力先

- コンソール出力
- デバッグ出力フォルダ（オプション）

## 処理フロー

### 処理シーケンス

```
1. オプション解析
   └─ System.CommandLine.RootCommand

2. アセンブリ列挙
   └─ GetAssemblyInfos()
   └─ 除外フィルタ適用

3. 各アセンブリの検証
   └─ ValidateFile()
      └─ PEReader.TryOpenAssociatedPortablePdb()
      └─ CompilationOptionsReader()
      └─ CompilationFactory.Create()
      └─ CompilationDiff.Create()

4. 結果サマリー
   └─ 成功/差異/エラー/参照不足の集計
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[オプション解析]
    B --> C[アセンブリ列挙]
    C --> D{各アセンブリ}
    D --> E[PDB読み込み]
    E --> F{PDB見つかった?}
    F -->|No| G[MiscError]
    F -->|Yes| H[コンパイルオプション抽出]
    H --> I[ソース/参照解決]
    I --> J[再コンパイル]
    J --> K{成功?}
    K -->|No| L[CompilationError]
    K -->|Yes| M[バイナリ比較]
    M --> N{一致?}
    N -->|Yes| O[Success]
    N -->|No| P[BinaryDifference]
    G --> Q[次のアセンブリ]
    L --> Q
    O --> Q
    P --> Q
    Q --> D
    D -->|完了| R[サマリー出力]
    R --> S[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 除外パターン | runtimes/, .resources.dllはデフォルト除外 | 常時 |
| BR-002 | ReadyToRun除外 | ReadyToRunアセンブリはスキップ | 常時 |
| BR-003 | 参照アセンブリ除外 | 参照アセンブリはスキップ | 常時 |
| BR-004 | 重複MVID | 同一MVIDのアセンブリは1つのみ検証 | 常時 |

### 計算ロジック

- バイナリ比較：byte[]配列のSequenceEqualで完全一致を確認

## データベース操作仕様

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| MiscError | その他エラー | PDBが見つからない等 | PDBを配置 |
| CompilationError | コンパイルエラー | 再コンパイル時に診断エラー | ソース/参照確認 |
| MissingReferences | 参照不足 | 必要な参照が見つからない | 参照パスを追加 |
| BinaryDifference | 差異検出 | 再ビルド結果が元と異なる | デバッグ出力で分析 |

### リトライ仕様

リトライなし

## トランザクション仕様

該当なし

## パフォーマンス要件

大規模ソリューションでの実行を想定

## セキュリティ考慮事項

ビルド監査ツールとして、信頼できる環境での実行を想定

## 備考

- 圧縮方式の違いによるPDB差異は既知の問題として検出
- デバッグ出力にはIL逆アセンブル結果、メタデータビジュアライズを含む

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Program.cs | `src/Tools/BuildValidator/Program.cs` | メインエントリーポイント |

**主要処理フロー（Program.cs）**:
1. **31-98行目**: Main - オプション定義とコマンド設定
2. **101-176行目**: HandleCommand - メイン処理ロジック
3. **178-233行目**: GetAssemblyInfos - アセンブリ列挙
4. **235-306行目**: ValidateFiles - 検証実行とサマリー
5. **308-361行目**: ValidateFile - 個別アセンブリ検証
6. **363-401行目**: ResolveSourceLinks - ソースリンク解決

#### Step 2: 検証ロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CompilationDiff.cs | `src/Tools/BuildValidator/CompilationDiff.cs` | コンパイル差分管理 |
| 2-2 | CompilationFactory.cs | `src/Tools/BuildValidator/CompilationFactory.cs` | コンパイル実行 |
| 2-3 | CompilationOptionsReader.cs | `src/Tools/BuildValidator/CompilationOptionsReader.cs` | オプション読み取り |

**主要処理フロー（CompilationDiff.cs）**:
1. **31-39行目**: BuildInfo record - ビルド情報構造
2. **41-46行目**: BuildDataFiles record - デバッグファイルパス
3. **59行目**: RebuildResult enum - 検証結果種別
4. **126-189行目**: Create - 再コンパイルと比較
5. **199-410行目**: WriteArtifacts - デバッグ出力生成
6. **416-449行目**: SearchForKnownIssues - 既知の問題検出

#### Step 3: リゾルバーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | LocalReferenceResolver.cs | `src/Tools/BuildValidator/LocalReferenceResolver.cs` | 参照解決 |
| 3-2 | LocalSourceResolver.cs | `src/Tools/BuildValidator/LocalSourceResolver.cs` | ソース解決 |
| 3-3 | RebuildArtifactResolver.cs | `src/Tools/BuildValidator/RebuildArtifactResolver.cs` | アーティファクト解決 |

### プログラム呼び出し階層図

```
Program.Main(args)
    │
    ├─ RootCommand.Parse(args).Invoke()
    │      └─ HandleCommand()
    │             ├─ GetAssemblyInfos()
    │             │      └─ Util.GetPortableExecutableInfo()
    │             │
    │             └─ ValidateFiles()
    │                    └─ ValidateFile() [各アセンブリ]
    │                           ├─ PEReader.TryOpenAssociatedPortablePdb()
    │                           ├─ CompilationOptionsReader()
    │                           ├─ ResolveSourceLinks()
    │                           ├─ LocalSourceResolver()
    │                           ├─ RebuildArtifactResolver()
    │                           └─ CompilationDiff.Create()
    │                                  ├─ CompilationFactory.Create()
    │                                  ├─ CompilationFactory.CreateCompilation()
    │                                  ├─ CompilationFactory.Emit()
    │                                  └─ byte[].SequenceEqual() [比較]
    │
    └─ CompilationDiff.WriteArtifacts() [差異時]
           ├─ createBuildArtifacts()
           ├─ PdbToXmlConverter.ToXml()
           ├─ MetadataVisualizer.Visualize()
           └─ Ildasm [IL逆アセンブル]
```

### データフロー図

```
[入力]                          [処理]                           [出力]

*.dll/*.exe ────────────▶ PEReader ──────────▶ Compilation Options
*.pdb (embedded) ────────┘    │
                              ▼
Source Files ───────────▶ LocalSourceResolver ──▶ SyntaxTrees
                              │
Reference DLLs ─────────▶ LocalReferenceResolver ▶ MetadataReferences
                              │
                              ▼
                    CompilationFactory.Create()
                              │
                              ▼
                    CompilationFactory.Emit()
                              │
                              ▼
                    byte[] comparison ─────────▶ RebuildResult
                              │
                              ▼ (差異時)
                    WriteArtifacts()
                              │
                              ▼
                         Debug Output
                         ├─ *.mdv (metadata)
                         ├─ *.il (disassembly)
                         ├─ *.pdb.xml
                         └─ sources/
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Program.cs | `src/Tools/BuildValidator/Program.cs` | ソース | メインエントリーポイント |
| CompilationDiff.cs | `src/Tools/BuildValidator/CompilationDiff.cs` | ソース | コンパイル差分管理 |
| CompilationFactory.cs | `src/Tools/BuildValidator/CompilationFactory.cs` | ソース | コンパイル実行 |
| CompilationOptionsReader.cs | `src/Tools/BuildValidator/CompilationOptionsReader.cs` | ソース | オプション読み取り |
| LocalReferenceResolver.cs | `src/Tools/BuildValidator/LocalReferenceResolver.cs` | ソース | 参照解決 |
| LocalSourceResolver.cs | `src/Tools/BuildValidator/LocalSourceResolver.cs` | ソース | ソース解決 |
| RebuildArtifactResolver.cs | `src/Tools/BuildValidator/RebuildArtifactResolver.cs` | ソース | アーティファクト解決 |
| AssemblyInfo.cs | `src/Tools/BuildValidator/AssemblyInfo.cs` | ソース | アセンブリ情報 |
| Options.cs | `src/Tools/BuildValidator/Options.cs` | ソース | オプション構造 |
| Util.cs | `src/Tools/BuildValidator/Util.cs` | ソース | ユーティリティ |
| DemoLoggerProvider.cs | `src/Tools/BuildValidator/DemoLoggerProvider.cs` | ソース | ログプロバイダー |
| EmptyLogger.cs | `src/Tools/BuildValidator/EmptyLogger.cs` | ソース | 空ログ実装 |
| SourceLinkEntry.cs | `src/Tools/BuildValidator/SourceLinkEntry.cs` | ソース | ソースリンク情報 |
