# 機能設計書 12-定義へ移動

## 概要

本ドキュメントは、Roslynの「定義へ移動」（Go To Definition）機能の設計について記述する。コード内のシンボルから、その定義場所へ即座にナビゲートするIDE機能である。

### 本機能の処理概要

定義へ移動機能は、開発者がカーソル位置のシンボル（変数、メソッド、クラス等）の定義場所へ即座にジャンプできる機能である。F12キーやCtrl+クリックで呼び出される。

**業務上の目的・背景**：大規模なコードベースにおいて、シンボルの定義を探す作業は頻繁に発生する。この機能により、開発者はファイル検索やテキスト検索を行うことなく、即座に定義場所へ移動でき、コード理解とナビゲーション効率を大幅に向上させる。

**機能の利用シーン**：
- 変数やフィールドの定義を確認したいとき
- メソッドの実装を確認したいとき
- クラスやインターフェースの宣言を確認したいとき
- 外部ライブラリのメタデータを参照したいとき
- 部分型（partial）の他の定義を確認したいとき
- 制御フローキーワード（break、continue、return等）の対応箇所へ移動したいとき

**主要な処理内容**：
1. カーソル位置のシンボル特定とセマンティック解析
2. シンボルの定義場所（ソース/メタデータ）の特定
3. エイリアスシンボルの解決（usingエイリアス等）
4. 制御フローキーワードの対応位置特定
5. メタデータシンボルのソース定義検索
6. 複数定義がある場合のFind Usagesウィンドウ表示
7. サードパーティナビゲーション拡張のサポート

**関連システム・外部連携**：
- セマンティック解析エンジン（SymbolFinder）
- メタデータ・アズ・ソース機能
- Find Usagesウィンドウ
- LSP（Language Server Protocol）
- サードパーティナビゲーションプロバイダ（XAMLなど）

**権限による制御**：特になし。すべての開発者が利用可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | エディタ | 主画面 | 定義場所へのナビゲーション |
| - | Find Usagesウィンドウ | 結果表示画面 | 複数定義がある場合の一覧表示 |

## 機能種別

ナビゲーション / シンボル解析

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| document | Document | Yes | 対象ドキュメント | null不可 |
| semanticModel | SemanticModel | Yes | セマンティックモデル | null不可 |
| position | int | Yes | カーソル位置 | 0以上 |
| cancellationToken | CancellationToken | Yes | キャンセルトークン | - |

### 入力データソース

- エディタからのカーソル位置情報
- ドキュメントのセマンティックモデル
- プロジェクトのコンパイレーション

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| symbol | ISymbol? | 定義先シンボル |
| project | Project | シンボルが属するプロジェクト |
| boundSpan | TextSpan | バインドされたトークンの範囲 |
| definitions | ImmutableArray\<DefinitionItem\> | 定義アイテムのリスト |

### 出力先

- エディタ（定義場所へのナビゲーション）
- Find Usagesウィンドウ（複数定義の場合）

## 処理フロー

### 処理シーケンス

```
1. シンボル取得
   └─ カーソル位置のシンボルをセマンティック解析で取得
2. 制御フロー判定
   └─ break/continue/return等の制御フローキーワードか判定
3. シンボルマッピング
   └─ Source Linkなどのマッピングサービスでシンボル変換
4. エイリアス解決
   └─ usingエイリアスの場合はターゲットを取得
5. ソース定義検索
   └─ メタデータシンボルのソース定義を検索
6. 定義アイテム生成
   └─ DefinitionItemを生成
7. サードパーティ拡張
   └─ 外部定義プロバイダを呼び出し
8. ナビゲーション実行
   └─ 単一定義の場合は直接移動、複数の場合はFind Usages表示
```

### フローチャート

```mermaid
flowchart TD
    A[Go To Definition実行] --> B[カーソル位置のシンボル取得]
    B --> C{制御フローキーワード?}
    C -->|Yes| D[対応する制御文へ移動]
    C -->|No| E[シンボルマッピング]
    E --> F{エイリアス?}
    F -->|Yes| G[ターゲットシンボル取得]
    F -->|No| H[元のシンボル使用]
    G --> I[ソース定義検索]
    H --> I
    I --> J[DefinitionItem生成]
    J --> K{サードパーティ拡張?}
    K -->|Yes| L[外部定義追加]
    K -->|No| M{複数定義?}
    L --> M
    M -->|Yes| N[Find Usagesウィンドウ表示]
    M -->|No| O[定義場所へ移動]
    D --> P[終了]
    N --> P
    O --> P
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 参照優先 | 参照と定義が同じ位置にある場合、参照として扱う | 匿名型メンバー宣言など |
| BR-02 | エイリアス解決 | usingエイリアスのソース位置が取得できない場合はターゲットを使用 | VBグローバルインポートなど |
| BR-03 | グローバル名前空間 | グローバル名前空間へのエイリアスはnullを返す | エイリアスのターゲットがグローバル名前空間 |
| BR-04 | 制御フロー | break/continue/returnはソース位置が不明な場合、対応する制御構造へ移動 | 制御フローキーワード上でのGo To Definition |
| BR-05 | 複数定義 | partial型など複数の定義がある場合はFind Usagesで表示 | 定義が2つ以上 |

### 計算ロジック

特になし

## データベース操作仕様

該当なし（メモリ内処理のみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | シンボル未解決 | カーソル位置にシンボルがない | 何も行わない |
| - | エラー型 | シンボルがエラー型 | 何も行わない |
| - | 定義なし | ソース/メタデータ定義が見つからない | 何も行わない |

### リトライ仕様

特になし

## トランザクション仕様

該当なし（読み取り専用処理）

## パフォーマンス要件

- レスポンス時間: 即座（ユーザー体感で遅延なし）
- 非同期処理でUIスレッドをブロックしない

## セキュリティ考慮事項

特になし（ローカルコード解析のみ）

## 備考

- C#とVBで共通の基盤を使用
- メタデータシンボルの場合、メタデータ・アズ・ソースまたは逆コンパイル表示が利用される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: インターフェースを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | IGoToDefinitionSymbolService.cs | `src/Features/Core/Portable/GoToDefinition/IGoToDefinitionSymbolService.cs` | 言語サービスのインターフェース。GetSymbolProjectAndBoundSpanAsync、GetTargetIfControlFlowAsyncを理解する |

**読解のコツ**: このインターフェースは言語固有の実装を抽象化している。2つのメソッドの役割を理解することが重要。

#### Step 2: 抽象基底クラスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AbstractGoToDefinitionSymbolService.cs | `src/Features/Core/Portable/GoToDefinition/AbstractGoToDefinitionSymbolService.cs` | 言語共通の実装。シンボル取得、マッピング、制御フロー処理を理解する |

**主要処理フロー**:
- **22-62行目**: GetSymbolProjectAndBoundSpanAsync - シンボル取得のメイン処理
- **28行目**: SymbolFinder.GetSemanticInfoAtPositionAsync - 位置のセマンティック情報取得
- **34-37行目**: シンボル優先順位（エイリアス → 参照 → 宣言 → 型）
- **50-51行目**: ISymbolMappingService - Source Link対応のシンボルマッピング
- **64-76行目**: GetTargetIfControlFlowAsync - 制御フローキーワードの処理

#### Step 3: ヘルパー関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | GoToDefinitionFeatureHelpers.cs | `src/Features/Core/Portable/GoToDefinition/GoToDefinitionFeatureHelpers.cs` | 定義取得のヘルパー。TryGetPreferredSymbolAsync、GetDefinitionsAsyncを理解する |

**主要処理フロー**:
- **18-50行目**: TryGetPreferredSymbolAsync - 優先シンボルの取得（エイリアス解決含む）
- **29-31行目**: グローバル名前空間へのエイリアスはnullを返す
- **37-43行目**: ソース位置がない場合はエイリアスターゲットを使用
- **46行目**: SymbolFinder.FindSourceDefinitionAsync - ソース定義検索
- **52-98行目**: GetDefinitionsAsync - 定義アイテムリストの生成

### プログラム呼び出し階層図

```
GoToDefinitionCommand（エディタコマンド）
    │
    └─ IGoToDefinitionSymbolService.GetSymbolProjectAndBoundSpanAsync()
           │ (AbstractGoToDefinitionSymbolService)
           │
           ├─ SymbolFinder.GetSemanticInfoAtPositionAsync()
           │      └─ セマンティック情報からシンボル取得
           │
           ├─ ISymbolMappingService.MapSymbolAsync()
           │      └─ Source Link対応のマッピング
           │
           └─ FindRelatedExplicitlyDeclaredSymbolAsync()
                  └─ 明示的宣言シンボルの検索

GoToDefinitionFeatureHelpers.GetDefinitionsAsync()
    │
    ├─ TryGetPreferredSymbolAsync()
    │      ├─ エイリアス解決
    │      └─ SymbolFinder.FindSourceDefinitionAsync()
    │
    ├─ symbol.ToNonClassifiedDefinitionItemAsync()
    │      └─ DefinitionItem生成
    │
    └─ IExternalDefinitionItemProvider.GetThirdPartyDefinitionItemAsync()
           └─ サードパーティ拡張（XAML等）
```

### データフロー図

```
[入力]                      [処理]                           [出力]

Document ─────────┐
                  │
Position ─────────┼──▶ IGoToDefinitionSymbolService ──┐
                  │         │                          │
SemanticModel ────┘         ▼                          │
                    シンボル解析                       │
                          │                            │
                          ▼                            │
                    シンボルマッピング                 │
                          │                            │
                          ▼                            ▼
                    ソース定義検索 ──────────▶ DefinitionItem[]
                          │                            │
                          ▼                            │
                    サードパーティ拡張 ────────────────┘
                          │
                          ▼
                    ナビゲーション実行
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| IGoToDefinitionSymbolService.cs | `src/Features/Core/Portable/GoToDefinition/IGoToDefinitionSymbolService.cs` | ソース | サービスインターフェース |
| AbstractGoToDefinitionSymbolService.cs | `src/Features/Core/Portable/GoToDefinition/AbstractGoToDefinitionSymbolService.cs` | ソース | 抽象基底クラス |
| GoToDefinitionFeatureHelpers.cs | `src/Features/Core/Portable/GoToDefinition/GoToDefinitionFeatureHelpers.cs` | ソース | ヘルパー関数 |
| DefinitionItem.cs | `src/Features/Core/Portable/FindUsages/DefinitionItem.cs` | ソース | 定義アイテムモデル |
| SymbolFinder.cs | `src/Workspaces/Core/Portable/FindSymbols/SymbolFinder.cs` | ソース | シンボル検索エンジン |
| ISymbolMappingService.cs | `src/Workspaces/Core/Portable/SymbolMapping/ISymbolMappingService.cs` | ソース | シンボルマッピングサービス |
