# 機能設計書 120-dotnet-format

## 概要

本ドキュメントは、コードフォーマットツール（Tools/dotnet-format）の機能設計を定義する。.NETプロジェクトのソースコードをEditorConfigルールに基づいて自動フォーマットするCLIツールである。

### 本機能の処理概要

dotnet-formatは、.NETソリューション・プロジェクトのソースコードをEditorConfig設定に基づいて自動的にフォーマットするツールである。コードスタイルの統一、フォーマット違反の検出・修正を自動化する。

**業務上の目的・背景**：チーム開発において、コードフォーマットの統一は重要である。dotnet-formatは、EditorConfig設定に基づいてソースコードを自動フォーマットし、一貫したコードスタイルを維持する。

**機能の利用シーン**：
- CIパイプラインでのフォーマットチェック
- プルリクエスト前のコードフォーマット
- エディタ保存時の自動フォーマット連携
- 既存コードベースへの一括フォーマット適用

**主要な処理内容**：
1. ソリューション/プロジェクトファイルの読み込み
2. EditorConfig設定の解析
3. コードアナライザーによるフォーマット違反検出
4. コードフィックスの適用
5. 変更されたファイルの書き戻し

**関連システム・外部連携**：.NET SDK、EditorConfig、Roslyn Formatting API

**権限による制御**：特になし

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | CLIツール（画面なし） |

## 機能種別

コマンドラインツール / コードフォーマット

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| <workspace> | string | No | ソリューション/プロジェクトパス | 存在するファイル |
| --no-restore | flag | No | 復元をスキップ | - |
| --verify-no-changes | flag | No | 変更がないことを確認（CIモード） | - |
| --include | string[] | No | 含めるファイルパターン | - |
| --exclude | string[] | No | 除外するファイルパターン | - |
| --severity | string | No | 最小重大度（info/warning/error） | - |
| --diagnostics | string[] | No | 修正する診断ID | - |
| --verbosity | string | No | ログ詳細度 | - |
| --binarylog | string | No | バイナリログファイル | - |
| --report | string | No | レポート出力パス | - |

### 入力データソース

- ソリューションファイル（.sln）
- プロジェクトファイル（.csproj/.vbproj）
- ソースファイル（.cs/.vb）
- EditorConfigファイル（.editorconfig）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 終了コード | int | 成功時0、変更あり/失敗時非0 |
| フォーマット済みファイル | ファイル | 修正されたソースファイル |
| レポート | JSON | フォーマット結果レポート（オプション） |

### 出力先

- ソースファイル（上書き更新）
- コンソール出力
- レポートファイル（オプション）

## 処理フロー

### 処理シーケンス

```
1. ワークスペース読み込み
   └─ MSBuildWorkspace.OpenSolutionAsync/OpenProjectAsync

2. EditorConfig解析
   └─ AnalyzerConfigOptionsProvider

3. ドキュメント分析
   └─ 各ドキュメントに対してアナライザー実行

4. フォーマット違反検出
   └─ Formatter.GetFormattedTextChangesAsync

5. コードフィックス適用
   └─ CodeFixProvider.RegisterCodeFixesAsync

6. ファイル書き戻し
   └─ 変更されたファイルを保存
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[ワークスペース読み込み]
    B --> C[EditorConfig解析]
    C --> D{各ドキュメント}
    D --> E[フォーマット分析]
    E --> F{違反あり?}
    F -->|Yes| G[コードフィックス適用]
    F -->|No| H[スキップ]
    G --> I[変更記録]
    H --> I
    I --> D
    D -->|完了| J{--verify-no-changes?}
    J -->|Yes| K{変更あり?}
    K -->|Yes| L[エラー終了]
    K -->|No| M[成功終了]
    J -->|No| N[ファイル書き戻し]
    N --> M
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 復元優先 | デフォルトでNuGet復元を実行 | --no-restore未指定時 |
| BR-002 | 重大度フィルタ | 指定重大度以上の診断のみ修正 | --severity指定時 |
| BR-003 | 診断ID限定 | 指定した診断IDのみ修正 | --diagnostics指定時 |
| BR-004 | CIモード | ファイル変更せず差分があればエラー | --verify-no-changes時 |

### 計算ロジック

- フォーマット適用：Roslyn Formatter APIを使用してテキスト変更を生成

## データベース操作仕様

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | フォーマット変更あり | --verify-no-changesで変更検出 | dotnet formatを実行 |
| 非0 | ワークスペースエラー | ソリューション読み込み失敗 | プロジェクト構成確認 |

### リトライ仕様

リトライなし

## トランザクション仕様

該当なし

## パフォーマンス要件

大規模ソリューションでの実行を想定（並列処理サポート）

## セキュリティ考慮事項

特になし

## 備考

- dotnet-formatは.NET SDK 6.0以降に組み込まれている
- src/Tools/dotnet-formatディレクトリは機能一覧.csvに記載されているが、Glob検索ではファイルが見つからなかった。別リポジトリまたは別の配置場所の可能性がある

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

**注意**: 機能一覧.csvにはsrc/Tools/dotnet-formatが記載されているが、このディレクトリ内にソースファイルが見つからなかった。dotnet-formatは別のリポジトリ（https://github.com/dotnet/format）で管理されている可能性がある。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | (参照先未確認) | `src/Tools/dotnet-format/` | メインエントリーポイント |

### プログラム呼び出し階層図

```
dotnet format <workspace>
    │
    ├─ CommandLineParser
    │      └─ オプション解析
    │
    ├─ MSBuildWorkspace.Create()
    │      └─ OpenSolutionAsync() / OpenProjectAsync()
    │
    ├─ 各Document処理
    │      ├─ AnalyzerConfigOptionsProvider.GetOptions()
    │      ├─ Formatter.GetFormattedTextChangesAsync()
    │      └─ CodeFix適用
    │
    └─ ファイル書き戻し
           └─ File.WriteAllText()
```

### データフロー図

```
[入力]                         [処理]                          [出力]

*.sln / *.csproj ─────▶ MSBuildWorkspace ──────▶ Solution/Project
                              │
.editorconfig ────────▶ AnalyzerConfigOptions ──▶ フォーマット設定
                              │
*.cs / *.vb ──────────▶ Formatter ──────────────▶ TextChanges
                              │
                              ▼
                    CodeFixProvider.Apply()
                              │
                              ▼
                    ─────────▶ フォーマット済みソース
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| (未確認) | `src/Tools/dotnet-format/` | - | ソースファイルが見つからなかった |

**備考**: dotnet-formatの詳細な実装は、GitHub上の別リポジトリ（dotnet/format）を参照する必要がある可能性がある。
