# 機能設計書 121-IDEベンチマーク

## 概要

本ドキュメントは、RoslynプロジェクトにおけるIDEベンチマーク機能の設計仕様を記載する。IDE機能のパフォーマンス計測を行うためのベンチマークスイートを提供し、各種IDE機能の性能特性を定量的に評価する。

### 本機能の処理概要

IDEベンチマーク機能は、RoslynベースのIDE機能（コード補完、フォーマッティング、継承マージン、SQLite永続ストレージなど）のパフォーマンスを計測・分析するためのツールである。

**業務上の目的・背景**：IDE機能は開発者の生産性に直結するため、応答時間やメモリ使用量の最適化が重要である。本機能は、パフォーマンスリグレッションの早期検出、最適化施策の効果測定、ボトルネックの特定を可能にする。BenchmarkDotNetフレームワークを活用し、再現性のある科学的なパフォーマンス計測を実現する。

**機能の利用シーン**：開発者がIDE機能の新機能追加やリファクタリング後にパフォーマンス影響を検証する際に使用する。CI/CDパイプラインに組み込んでリグレッション検出を自動化したり、リリース前のパフォーマンス検証にも活用される。

**主要な処理内容**：
1. BenchmarkDotNetを使用した各種ベンチマークの実行
2. フォーマッター、正規表現分類器、SQLiteストレージなど複数のIDE機能の計測
3. LSP（Language Server Protocol）関連機能のベンチマーク
4. 継承マージン機能のパフォーマンス評価
5. メモリ使用量の診断と分析

**関連システム・外部連携**：BenchmarkDotNetフレームワークと連携し、計測結果をコンソールまたはファイルに出力する。Visual Studio統合テストと連携してワークスペースをセットアップする。

**権限による制御**：特になし。開発者ツールとして自由に実行可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 55 | ステータスインジケーター | 主機能 | パフォーマンス状態のインジケーター表示 |

## 機能種別

計算処理 / パフォーマンス計測 / データ連携

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| args | string[] | No | コマンドライン引数（ベンチマーク選択用） | BenchmarkDotNetの引数形式 |
| Document | string | Yes | 計測対象のドキュメント名（FormatterBenchmarks） | 事前定義されたドキュメント名のみ |
| ReadPercentage | int | Yes | 読み取り割合（SQLiteBenchmarks） | 0-100の範囲 |
| StringLength | int | Yes | 文字列長（RegexClassifier） | 0以上の整数 |
| RepeatElement | char | Yes | 繰り返し文字（RegexClassifier） | 任意の文字 |

### 入力データソース

- コマンドライン引数からベンチマーク選択
- ソリューションファイル（.sln）からワークスペース構築
- 生成されたソースコード（Compilers/CSharp/Portable/Generated）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Mean | TimeSpan | 平均実行時間 |
| Error | TimeSpan | 誤差範囲 |
| StdDev | TimeSpan | 標準偏差 |
| Allocated | bytes | メモリ割り当て量 |

### 出力先

- コンソール出力（デフォルト）
- BenchmarkDotNet結果ファイル（Markdown、HTML、CSV形式）

## 処理フロー

### 処理シーケンス

```
1. プログラム起動（Program.Main）
   └─ 環境変数ROSLYN_SOURCE_ROOT_PATHを設定
2. BenchmarkSwitcherの初期化
   └─ アセンブリ内のベンチマーククラスを検出
3. ベンチマーク選択と実行
   └─ コマンドライン引数に基づくベンチマーク選択
4. IterationSetup実行
   └─ UseExportProviderAttributeによるMEF初期化
5. ベンチマークメソッド実行
   └─ 計測対象の処理を複数回実行
6. IterationCleanup実行
   └─ リソースの解放とMEFクリーンアップ
7. 結果の集計と出力
   └─ 統計情報の計算とレポート生成
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[環境変数設定]
    B --> C[BenchmarkSwitcher初期化]
    C --> D{ベンチマーク選択}
    D --> E[IterationSetup]
    E --> F[ベンチマーク実行]
    F --> G[IterationCleanup]
    G --> H{反復完了?}
    H -->|No| E
    H -->|Yes| I[結果集計]
    I --> J[レポート出力]
    J --> K[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | ウォームアップ実行 | 本計測前にウォームアップ実行を行う | BenchmarkDotNetのデフォルト設定 |
| BR-002 | GCサーバーモード | サーバーGCモードでベンチマークを実行 | [GcServer(true)]属性指定時 |
| BR-003 | メモリ診断 | メモリ使用量を計測する | [MemoryDiagnoser]属性指定時 |

### 計算ロジック

統計情報はBenchmarkDotNetが自動計算:
- 平均値 = 全実行時間の合計 / 実行回数
- 標準偏差 = sqrt(分散)
- 誤差 = t分布に基づく信頼区間

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| SQLitePersistentStorageBenchmark | SQLiteDB | READ/WRITE | ストレージパフォーマンス計測 |

### テーブル別操作詳細

#### SQLitePersistentStorage

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| WRITE | document_data | 1000バイトのテストデータ | ベンチマーク用 |
| READ | document_data | ドキュメントキーで取得 | 読み取り性能計測 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | FileNotFoundException | ソリューションファイルが見つからない | 正しいパスを環境変数で設定 |
| - | InvalidOperationException | ワークスペースが未初期化 | GlobalSetup実行を確認 |

### リトライ仕様

ベンチマーク失敗時のリトライは行わない。BenchmarkDotNetが自動的に統計的に有意な結果を得るまで反復実行する。

## トランザクション仕様

SQLiteベンチマークでは各書き込み操作が個別のトランザクションとして実行される。

## パフォーマンス要件

ベンチマーク計測ツールのため、特定のパフォーマンス要件は定義しない。計測対象の機能に対する基準値はベンチマーク結果から導出される。

## セキュリティ考慮事項

開発者ツールとして使用されるため、本番環境では使用しない。計測結果に機密情報は含まれない。

## 備考

- DEBUGビルドでは`DebugInProcessConfig`を使用し、デバッガーアタッチ状態での計測が可能
- 環境変数`ROSLYN_SOURCE_ROOT_PATH`でRoslynルートディレクトリを設定

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Program.cs | `src/Tools/IdeBenchmarks/Program.cs` | ベンチマーク実行のエントリーポイント |

**主要処理フロー**:
1. **20-24行目**: `GetRoslynRootLocation`メソッドでRoslynルートパスを取得
2. **26-28行目**: DEBUG時は`DebugInProcessConfig`を使用
3. **34-35行目**: 環境変数設定とBenchmarkSwitcher起動

#### Step 2: ベンチマーク設定を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MemoryDiagnoserConfig.cs | `src/Tools/IdeBenchmarks/MemoryDiagnoserConfig.cs` | メモリ診断設定 |

**主要処理フロー**:
- **14-17行目**: `MemoryDiagnoser.Default`を診断ツールとして追加

#### Step 3: 各ベンチマーククラスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | FormatterBenchmarks.cs | `src/Tools/IdeBenchmarks/FormatterBenchmarks.cs` | フォーマッター性能計測 |
| 3-2 | RegexClassifierBenchmarks.cs | `src/Tools/IdeBenchmarks/RegexClassifierBenchmarks.cs` | 正規表現分類器性能計測 |
| 3-3 | SQLitePersistentStorageBenchmark.cs | `src/Tools/IdeBenchmarks/SQLitePersistentStorageBenchmark.cs` | SQLiteストレージ性能計測 |
| 3-4 | LspCompletionBenchmarks.cs | `src/Tools/IdeBenchmarks/Lsp/LspCompletionBenchmarks.cs` | LSP補完機能性能計測 |
| 3-5 | InheritanceMarginServiceBenchmarks.cs | `src/Tools/IdeBenchmarks/InheritanceMargin/InheritanceMarginServiceBenchmarks.cs` | 継承マージン性能計測 |

**FormatterBenchmarks読解ポイント**:
- **21-26行目**: `[Params]`属性で計測対象ドキュメントを指定
- **38-48行目**: `FormatCSharp`メソッドでC#フォーマット性能を計測
- **50-61行目**: `FormatVisualBasic`メソッドでVBフォーマット性能を計測

**SQLitePersistentStorageBenchmark読解ポイント**:
- **26-27行目**: `ReadPercentage`パラメータで読み書き比率を設定
- **94-124行目**: `PerfAsync`メソッドで並列読み書き性能を計測

### プログラム呼び出し階層図

```
Program.Main
    │
    ├─ Environment.SetEnvironmentVariable
    │      └─ ROSLYN_SOURCE_ROOT_PATH設定
    │
    └─ BenchmarkSwitcher.Run
           │
           ├─ FormatterBenchmarks
           │      ├─ IterationSetup
           │      ├─ FormatCSharp / FormatVisualBasic
           │      └─ IterationCleanup
           │
           ├─ RegexClassifierBenchmarks
           │      ├─ IterationSetup
           │      ├─ TestStringLiteral / TestEmptyRegexStringLiteral
           │      └─ IterationCleanup
           │
           ├─ SQLitePersistentStorageBenchmark
           │      ├─ GlobalSetup
           │      ├─ PerfAsync
           │      └─ GlobalCleanup
           │
           ├─ LspCompletionBenchmarks
           │      ├─ IterationSetup
           │      ├─ GetCompletionsWithTextEdits
           │      └─ CleanupAsync
           │
           └─ InheritanceMarginServiceBenchmarks
                  ├─ IterationSetup
                  ├─ BenchmarkInheritanceMarginServiceAsync
                  └─ IterationCleanup
```

### データフロー図

```
[入力]                    [処理]                         [出力]

コマンドライン引数 ───▶ BenchmarkSwitcher ───▶ ベンチマーク結果
                            │
ソリューションファイル ───▶ TestWorkspace ───▶ 統計レポート
                            │
ソースコード ───────────▶ 各ベンチマーク ───▶ メモリ使用量
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Program.cs | `src/Tools/IdeBenchmarks/Program.cs` | ソース | エントリーポイント |
| MemoryDiagnoserConfig.cs | `src/Tools/IdeBenchmarks/MemoryDiagnoserConfig.cs` | ソース | メモリ診断設定 |
| FormatterBenchmarks.cs | `src/Tools/IdeBenchmarks/FormatterBenchmarks.cs` | ソース | フォーマッターベンチマーク |
| RegexClassifierBenchmarks.cs | `src/Tools/IdeBenchmarks/RegexClassifierBenchmarks.cs` | ソース | 正規表現分類器ベンチマーク |
| SQLitePersistentStorageBenchmark.cs | `src/Tools/IdeBenchmarks/SQLitePersistentStorageBenchmark.cs` | ソース | SQLiteストレージベンチマーク |
| LspCompletionBenchmarks.cs | `src/Tools/IdeBenchmarks/Lsp/LspCompletionBenchmarks.cs` | ソース | LSP補完ベンチマーク |
| InheritanceMarginServiceBenchmarks.cs | `src/Tools/IdeBenchmarks/InheritanceMargin/InheritanceMarginServiceBenchmarks.cs` | ソース | 継承マージンベンチマーク |
| BenchmarksHelpers.cs | `src/Tools/IdeBenchmarks/InheritanceMargin/BenchmarksHelpers.cs` | ソース | ベンチマークヘルパー |
| AssemblyInfo.cs | `src/Tools/IdeBenchmarks/Properties/AssemblyInfo.cs` | ソース | アセンブリ情報 |
