# 機能設計書 123-セマンティック検索

## 概要

本ドキュメントは、Roslynプロジェクトにおけるセマンティック検索機能の設計仕様を記載する。コードのセマンティクス（意味論）に基づいてソリューション全体を検索し、特定のパターンや条件に一致するコード要素を発見する機能を提供する。

### 本機能の処理概要

セマンティック検索機能は、C#コードで記述されたクエリを使用して、ソリューション内のシンボル、型、メソッドなどをセマンティクスレベルで検索する高度な検索機能である。

**業務上の目的・背景**：大規模コードベースにおいて、単純なテキスト検索では発見困難なパターンを特定する必要がある。例えば「特定のインターフェースを実装するすべてのクラス」や「nullを返す可能性のあるメソッド」などのセマンティクスベースの検索が求められる。本機能は開発者がコードベースをより深く理解し、リファクタリングや品質改善の対象を特定することを支援する。

**機能の利用シーン**：開発者がコードレビュー、リファクタリング、バグ調査、コードパターン分析を行う際に使用する。Visual Studioのセマンティック検索ツールウィンドウから利用可能。Copilot連携により、自然言語でのクエリ生成も可能。

**主要な処理内容**：
1. C#クエリコードのコンパイル
2. ソリューション全体に対するクエリ実行
3. 検索結果の収集とDefinitionItemへの変換
4. 結果のUI表示とコードナビゲーション
5. リモートプロセス（OOP）でのクエリ実行

**関連システム・外部連携**：Visual Studio統合、Copilot連携（クエリ生成支援）、リモートワークスペースサービス（ServiceHub）。

**権限による制御**：特になし。ソリューション内のすべてのコードにアクセス可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | セマンティック検索ツールウィンドウ | 主機能 | クエリ入力と結果表示 |

## 機能種別

検索処理 / コード分析 / データ連携

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| query | string | Yes | C#クエリコード（トップレベルステートメント形式） | コンパイル可能なC#コード |
| targetLanguage | string | No | 検索対象言語（C#/VB）、nullで全言語 | "C#" または "VisualBasic" |
| referenceAssembliesDir | string | Yes | 参照アセンブリのディレクトリ | 存在するディレクトリパス |

### 入力データソース

- Visual Studioセマンティック検索ツールウィンドウからのクエリ入力
- 現在開いているソリューションのすべてのドキュメント
- 参照アセンブリ（SemanticSearchRefsディレクトリ）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| DefinitionItem | object | 発見されたシンボルの定義情報 |
| DocumentSpan | struct | シンボルの位置情報 |
| ClassifiedSpans | array | 構文ハイライト情報 |

### 出力先

- Visual Studio Find Results ウィンドウ
- セマンティック検索ツールウィンドウの結果リスト

## 処理フロー

### 処理シーケンス

```
1. クエリ入力の受付
   └─ SemanticSearchToolWindowからのクエリ取得
2. クエリのコンパイル（CompileQuery）
   ├─ 参照アセンブリのロード
   ├─ クエリコードの構文解析
   └─ コンパイル結果の返却（CompiledQueryId）
3. クエリの実行（ExecuteQuery）
   ├─ リモートプロセスへのソリューションチェックサム送信
   ├─ 各ドキュメントに対するクエリ適用
   └─ 結果のコールバック（OnDefinitionFound）
4. 結果の表示
   ├─ DefinitionItemのハイドレート
   └─ UIへの結果表示
5. リソース解放（DiscardQuery）
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[クエリ入力]
    B --> C[CompileQuery]
    C --> D{コンパイル成功?}
    D -->|No| E[エラー表示]
    D -->|Yes| F[ExecuteQuery]
    F --> G[リモートプロセス実行]
    G --> H[各ドキュメント検索]
    H --> I{結果あり?}
    I -->|Yes| J[OnDefinitionFound]
    J --> K[結果表示]
    I -->|No| L[完了]
    K --> L
    L --> M[DiscardQuery]
    M --> N[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | クエリ言語 | クエリはC#トップレベルステートメント形式 | 常時 |
| BR-002 | 対象言語フィルタ | targetLanguage指定で検索対象を限定可能 | targetLanguage非null時 |
| BR-003 | リモート実行 | パフォーマンスのためOOPで実行 | RemoteHostClient利用可能時 |
| BR-004 | 参照アセンブリ共有 | デザインタイムとコンパイルタイムで同一アセンブリを使用 | 常時 |

### 計算ロジック

クエリコンパイル:
- クエリコードをC#コンパイラでコンパイル
- 参照アセンブリを含むReferenceAssembliesDirectoryを使用
- コンパイル成功時にCompiledQueryIdを発行

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし（インメモリ処理）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | CompileQueryResult.Error | クエリコンパイル失敗 | コンパイルエラーメッセージを表示 |
| - | UserCodeExceptionInfo | クエリ実行中のユーザーコード例外 | 例外情報をコールバック |
| - | ExecuteQueryResult.Error | クエリ実行失敗 | エラー情報を返却 |

### リトライ仕様

リトライ処理は実装されていない。エラー発生時はユーザーにエラーを通知し、クエリ修正を促す。

## トランザクション仕様

トランザクション管理なし。読み取り専用の検索処理。

## パフォーマンス要件

- リモートプロセス（OOP）での実行により、IDEプロセスのブロッキングを回避
- キャンセレーショントークンによる中断サポート
- 進捗コールバック（AddItems/ItemsCompleted）による進捗表示

## セキュリティ考慮事項

- ユーザー定義のC#コードを実行するため、サンドボックス内で実行
- ソリューション外のファイルにはアクセス不可
- 参照アセンブリは事前定義されたディレクトリから読み込み

## 備考

- 参照アセンブリディレクトリはSemanticSearchWorkspace.ReferenceAssembliesDirectoryで定義
- Copilot連携により自然言語からクエリを生成する機能も提供

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: インターフェースを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ISemanticSearchQueryService.cs | `src/Features/Core/Portable/SemanticSearch/ISemanticSearchQueryService.cs` | クエリサービスのインターフェース定義 |
| 1-2 | IRemoteSemanticSearchService.cs | `src/Features/Core/Portable/SemanticSearch/IRemoteSemanticSearchService.cs` | リモート実行サービスのインターフェース |

**ISemanticSearchQueryService読解ポイント**:
- **20-26行目**: `CompileQuery`メソッドでクエリをコンパイル
- **35-41行目**: `ExecuteQueryAsync`メソッドでクエリを実行
- **47行目**: `DiscardQuery`メソッドでリソース解放

**IRemoteSemanticSearchService読解ポイント**:
- **24-31行目**: コールバックインターフェース定義
- **34-36行目**: リモート実行メソッド定義

#### Step 2: ワークスペースを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SemanticSearchWorkspace.cs | `src/Features/Core/Portable/SemanticSearch/SemanticSearchWorkspace.cs` | セマンティック検索用ワークスペース |

**主要処理フロー**:
- **21行目**: `ReferenceAssembliesDirectory`で参照アセンブリパスを定義
- **23-24行目**: `CanOpenDocuments`でドキュメントオープン可能
- **26-27行目**: `CanApplyChange`でChangeDocumentのみ許可
- **29-48行目**: `UpdateQueryDocumentAsync`でクエリドキュメントを更新

#### Step 3: リモート実行を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | RemoteSemanticSearchService.cs | `src/Workspaces/Remote/ServiceHub/Services/SemanticSearch/RemoteSemanticSearchService.cs` | リモートサービス実装 |

**読解のコツ**: CallbackDispatcherパターンでリモートプロセスからのコールバックを処理

#### Step 4: Visual Studio統合を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | SemanticSearchToolWindowController.cs | `src/VisualStudio/CSharp/Impl/SemanticSearch/SemanticSearchToolWindowController.cs` | ツールウィンドウコントローラー |
| 4-2 | SemanticSearchQueryExecutor.cs | `src/VisualStudio/CSharp/Impl/SemanticSearch/SemanticSearchQueryExecutor.cs` | クエリ実行ロジック |

### プログラム呼び出し階層図

```
SemanticSearchToolWindow
    │
    ├─ SemanticSearchToolWindowController
    │      └─ UpdateQueryDocumentAsync
    │
    └─ SemanticSearchQueryExecutor
           │
           ├─ RemoteSemanticSearchServiceProxy.CompileQueryAsync
           │      └─ IRemoteSemanticSearchService.CompileQueryAsync
           │
           ├─ RemoteSemanticSearchServiceProxy.ExecuteQueryAsync
           │      ├─ ServerCallback.OnDefinitionFoundAsync
           │      ├─ ServerCallback.OnUserCodeExceptionAsync
           │      ├─ ServerCallback.AddItemsAsync
           │      └─ ServerCallback.ItemsCompletedAsync
           │
           └─ RemoteSemanticSearchServiceProxy.DiscardQueryAsync
```

### データフロー図

```
[入力]                    [処理]                         [出力]

クエリ（C#コード） ────▶ CompileQuery ─────────▶ CompiledQueryId
                              │
ソリューション ───────────▶ ExecuteQuery ──────────▶ DefinitionItem[]
                              │
参照アセンブリ ───────────▶ リモートプロセス ────▶ 検索結果表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ISemanticSearchQueryService.cs | `src/Features/Core/Portable/SemanticSearch/ISemanticSearchQueryService.cs` | ソース | クエリサービスインターフェース |
| IRemoteSemanticSearchService.cs | `src/Features/Core/Portable/SemanticSearch/IRemoteSemanticSearchService.cs` | ソース | リモートサービスインターフェース |
| SemanticSearchWorkspace.cs | `src/Features/Core/Portable/SemanticSearch/SemanticSearchWorkspace.cs` | ソース | 検索用ワークスペース |
| ExecuteQueryResult.cs | `src/Features/Core/Portable/SemanticSearch/ExecuteQueryResult.cs` | ソース | 実行結果データ |
| QueryExecutionOptions.cs | `src/Features/Core/Portable/SemanticSearch/QueryExecutionOptions.cs` | ソース | 実行オプション |
| ISemanticSearchResultsObserver.cs | `src/Features/Core/Portable/SemanticSearch/ISemanticSearchResultsObserver.cs` | ソース | 結果オブザーバー |
| SemanticSearchToolWindowController.cs | `src/VisualStudio/CSharp/Impl/SemanticSearch/SemanticSearchToolWindowController.cs` | ソース | VSツールウィンドウ制御 |
| SemanticSearchQueryExecutor.cs | `src/VisualStudio/CSharp/Impl/SemanticSearch/SemanticSearchQueryExecutor.cs` | ソース | クエリ実行 |
| RemoteSemanticSearchService.cs | `src/Workspaces/Remote/ServiceHub/Services/SemanticSearch/RemoteSemanticSearchService.cs` | ソース | リモートサービス実装 |
