# 機能設計書 126-名前空間同期

## 概要

本ドキュメントは、Roslynプロジェクトにおける名前空間同期機能の設計仕様を記載する。プロジェクト間で名前空間をフォルダ構造に合わせて一括同期する機能を提供する。

### 本機能の処理概要

名前空間同期機能は、ソリューション内の複数プロジェクトにおいて、ファイルのフォルダ構造と名前空間宣言を一致させるためのリファクタリング機能である。「Match Folder and Namespace」診断ルールに基づき、不一致を検出して自動修正する。

**業務上の目的・背景**：大規模プロジェクトでは、ファイルの移動やリファクタリングにより、名前空間とフォルダ構造の不一致が発生しやすい。これはコードの可読性や保守性を低下させる。本機能は、プロジェクト全体またはソリューション全体で名前空間を一括同期することで、この問題を効率的に解決する。

**機能の利用シーン**：
- ソリューション全体の名前空間を一括で整理したい場合
- プロジェクト構造を変更した後の名前空間修正
- コードスタイル統一のための一括リファクタリング

**主要な処理内容**：
1. 対象プロジェクトの診断実行（MatchFolderAndNamespace）
2. フォルダ構造と名前空間の不一致検出
3. CodeFixの一括適用（FixAll）
4. 変更されたドキュメントの更新

**関連システム・外部連携**：Roslyn Analyzer、CodeFix Provider、FixAll Provider。

**権限による制御**：特になし。プロジェクト内のファイルに書き込み権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | コマンド/API呼び出しによる実行（UI直接なし） |

## 機能種別

リファクタリング / バッチ処理 / コード修正

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| projects | ImmutableArray<Project> | Yes | 同期対象プロジェクト | 同一言語のプロジェクト |
| progressTracker | IProgress<CodeAnalysisProgress> | Yes | 進捗追跡 | null不可 |
| cancellationToken | CancellationToken | Yes | キャンセルトークン | 有効なトークン |

### 入力データソース

- ソリューション内のプロジェクト
- 各ドキュメントのフォルダパス
- 各ドキュメントの名前空間宣言

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Solution | Solution | 更新されたソリューション |

### 出力先

- ワークスペースへの変更適用
- 修正されたドキュメントファイル

## 処理フロー

### 処理シーケンス

```
1. 診断アナライザーの準備
   └─ MatchFolderAndNamespaceDiagnosticAnalyzerをラップ
2. 各プロジェクトの診断実行
   ├─ コンパイル取得
   ├─ アナライザー実行
   └─ 診断結果収集
3. 診断結果の確認
   └─ 診断なしの場合は早期リターン
4. FixAllContextの構築
   ├─ 最初の診断からドキュメント取得
   ├─ CodeFixProviderから等価キー取得
   └─ DiagnosticProviderを作成
5. FixAllProviderによる一括修正
   ├─ GetFixAsync実行
   └─ ApplyChangesOperation取得
6. 更新されたソリューションの返却
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[プロジェクト言語確認]
    B --> C[診断アナライザー実行]
    C --> D{診断あり?}
    D -->|No| E[元のソリューション返却]
    D -->|Yes| F[FixAllContext構築]
    F --> G[CodeFixProvider取得]
    G --> H[FixAllProvider.GetFixAsync]
    H --> I[ApplyChangesOperation取得]
    I --> J[更新ソリューション返却]
    E --> K[終了]
    J --> K
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 同一言語制約 | 全プロジェクトが同一言語であること | 常時 |
| BR-002 | ソリューションスコープ | FixAllScope.Solutionで全体修正 | 常時 |
| BR-003 | 診断なし早期リターン | 診断がない場合は処理をスキップ | 診断結果が空の場合 |

### 計算ロジック

フォルダから名前空間の導出:
- プロジェクトルートからの相対パスを取得
- パス区切りを名前空間区切り（.）に変換
- ルート名前空間と連結

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ArgumentException | 異なる言語のプロジェクトが混在 | 同一言語のプロジェクトのみ指定 |
| - | OperationCanceledException | キャンセル要求 | 処理中断 |
| - | AssertionFailure | 診断にSourceTreeがない | 内部エラー |

### リトライ仕様

リトライ処理は実装されていない。エラー発生時は処理を中断。

## トランザクション仕様

Roslynのイミュータブルソリューションモデルにより、変更は新しいソリューションインスタンスとして返却。元のソリューションは変更されない。

## パフォーマンス要件

- 並列コンパイル（concurrentAnalysis: true）
- 進捗追跡による中断サポート
- プロジェクト単位での診断実行

## セキュリティ考慮事項

- ソリューション内のファイルのみ変更
- ファイルシステムへの書き込みはワークスペースを通じて実行

## 備考

- C#とVBで別々の実装（AbstractSyncNamespacesService<TSyntaxKind, TNamespaceSyntax>）
- HostAnalyzerとして実行可能（IsHostAnalyzer設定）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: サービスインターフェースを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ISyncNamespacesService.cs | `src/Features/Core/Portable/SyncNamespaces/ISyncNamespacesService.cs` | サービスインターフェース定義 |

#### Step 2: 抽象基底クラスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AbstractSyncNamespacesService.cs | `src/Features/Core/Portable/SyncNamespaces/AbstractSyncNamespacesService.cs` | 名前空間同期の実装 |

**主要処理フロー**:
- **22-26行目**: ジェネリック型パラメータでC#/VB抽象化
- **27-29行目**: 抽象プロパティで言語固有の実装を注入
- **32-56行目**: `SyncNamespacesAsync`メインメソッド
  - **38行目**: 同一言語アサーション
  - **42行目**: 診断アナライザー実行
  - **45-48行目**: 診断なしの場合早期リターン
  - **50-51行目**: FixAllContext構築
  - **55行目**: FixAll適用

**GetDiagnosticsByProjectAsync読解ポイント**:
- **58-73行目**: プロジェクトごとの診断取得
- **75-93行目**: `GetDiagnosticsAsync`でコンパイル＋アナライザー実行

**GetFixAllContextAsync読解ポイント**:
- **95-134行目**: FixAllContext構築
- **104-106行目**: 最初の診断からドキュメント取得
- **113-120行目**: CodeFixContext作成とアクション取得
- **121-133行目**: FixAllState構築

**ApplyCodeFixAsync読解ポイント**:
- **136-150行目**: FixAll実行と変更適用

#### Step 3: DiagnosticProviderを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| - | (同ファイル内) | - | DiagnosticProviderネストクラス |

**読解ポイント**:
- **152-181行目**: `DiagnosticProvider`内部クラス
- **163-166行目**: `GetAllDiagnosticsAsync`
- **168-173行目**: `GetDocumentDiagnosticsAsync`
- **175-179行目**: `GetProjectDiagnosticsAsync`

### プログラム呼び出し階層図

```
ISyncNamespacesService.SyncNamespacesAsync
    │
    ├─ GetDiagnosticsByProjectAsync
    │      └─ GetDiagnosticsAsync
    │             ├─ Project.GetCompilationAsync
    │             └─ CompilationWithAnalyzers.GetAnalyzerDiagnosticsAsync
    │
    ├─ GetFixAllContextAsync
    │      ├─ CodeFixProvider.RegisterCodeFixesAsync
    │      └─ FixAllState構築
    │
    └─ ApplyCodeFixAsync
           ├─ FixAllProvider.GetFixAsync
           └─ ApplyChangesOperation.ChangedSolution
```

### データフロー図

```
[入力]                      [処理]                         [出力]

ImmutableArray<Project> ──▶ GetDiagnosticsByProjectAsync ──▶ Diagnostic[]
        │                          │
        │                          ▼
        │                    GetFixAllContextAsync
        │                          │
        │                          ▼
        │                    ApplyCodeFixAsync
        │                          │
        └──────────────────────────┘
                                   ▼
                              Solution (更新済み)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ISyncNamespacesService.cs | `src/Features/Core/Portable/SyncNamespaces/ISyncNamespacesService.cs` | ソース | サービスインターフェース |
| AbstractSyncNamespacesService.cs | `src/Features/Core/Portable/SyncNamespaces/AbstractSyncNamespacesService.cs` | ソース | 抽象基底クラス |
| MatchFolderAndNamespaceDiagnosticAnalyzer | `src/Analyzers/Core/Analyzers/MatchFolderAndNamespace/` | ソース | 診断アナライザー |
| ChangeNamespaceToMatchFolderCodeFixProvider | `src/Analyzers/Core/CodeFixes/MatchFolderAndNamespace/` | ソース | CodeFix |
