# 機能設計書 127-マップコード

## 概要

本ドキュメントは、Roslynプロジェクトにおけるマップコード機能の設計仕様を記載する。AIモデルから取得したコードスニペットをターゲットドキュメントに識別・マッピング・統合する機能を提供する。

### 本機能の処理概要

マップコード機能は、AIが生成したコードスニペットをソースコードに統合するためのサービスである。既存コードの置換と新規コードの挿入を適切な位置で行うMapperの役割を果たす。

**業務上の目的・背景**：AIアシスタント（Copilotなど）が生成したコードを開発者のソースコードに統合する際、適切な挿入位置や既存コードとの整合性を判断する必要がある。本機能は、AIコードと既存コードのマッピングを自動化し、シームレスな統合を可能にする。

**機能の利用シーン**：
- Copilotが提案したコードの自動挿入
- AIによるコード補完結果の統合
- コードスニペットのインテリジェントな配置

**主要な処理内容**：
1. 既存コードとAI生成コードの比較
2. 置換すべきコードの特定
3. 新規コードの挿入位置決定
4. 優先フォーカス位置に基づくヒューリスティック適用
5. TextChangesとしての変更生成

**関連システム・外部連携**：GitHub Copilot、AI言語モデル、Roslyn言語サービス。

**権限による制御**：特になし。ドキュメント編集権限が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | APIサービス（UI直接なし） |

## 機能種別

コード変換 / AI統合 / リファクタリング支援

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| document | Document | Yes | ターゲットドキュメント | 有効なRoslynドキュメント |
| contents | ImmutableArray<string> | Yes | マッピング対象のコードスニペット | 空でない配列 |
| prioritizedFocusLocations | ImmutableArray<(Document, TextSpan)> | Yes | 優先フォーカス位置 | カーソル位置、関連クラスなど |
| cancellationToken | CancellationToken | Yes | キャンセルトークン | 有効なトークン |

### 入力データソース

- AI生成コードスニペット
- ターゲットドキュメント
- カーソル位置やビューポート情報

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| TextChange[] | ImmutableArray<TextChange>? | マッピング結果のテキスト変更、失敗時null |

### 出力先

- 呼び出し元へのTextChanges返却
- ドキュメントへの変更適用

## 処理フロー

### 処理シーケンス

```
1. コードスニペット解析
   └─ 各スニペットの構文解析
2. ターゲット位置の特定
   ├─ 優先フォーカス位置の評価
   └─ ヒューリスティックによる位置決定
3. 既存コードとのマッチング
   ├─ 置換候補の特定
   └─ 新規挿入位置の決定
4. TextChanges生成
   └─ 変更リストの構築
5. 結果返却
   └─ 失敗時はnull返却
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[コードスニペット解析]
    B --> C[優先フォーカス位置評価]
    C --> D[既存コードマッチング]
    D --> E{マッチあり?}
    E -->|Yes| F[置換TextChange生成]
    E -->|No| G[挿入位置決定]
    G --> H[挿入TextChange生成]
    F --> I[結果集約]
    H --> I
    I --> J{成功?}
    J -->|Yes| K[TextChanges返却]
    J -->|No| L[null返却]
    K --> M[終了]
    L --> M
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 置換優先 | 既存コードとマッチする場合は置換を優先 | 既存コード発見時 |
| BR-002 | フォーカス優先 | prioritizedFocusLocationsの早い項目を高優先 | 位置決定時 |
| BR-003 | 失敗時null | マッピング失敗時はnullを返却 | 処理失敗時 |

### 計算ロジック

優先フォーカス位置の評価:
- インデックスが小さいほど高優先
- カーソル位置 > 関連クラス > ビューポート

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | マッピング失敗 | 適切な挿入位置が見つからない | null返却 |
| - | 構文解析失敗 | コードスニペットが不正 | null返却 |
| - | キャンセル | CancellationToken発火 | OperationCanceledException |

### リトライ仕様

リトライ処理は実装されていない。失敗時はnull返却で呼び出し元が判断。

## トランザクション仕様

トランザクション管理なし。TextChangesとして返却するのみで、適用は呼び出し元の責任。

## パフォーマンス要件

- 非同期処理によるUI応答性維持
- CancellationTokenによる中断サポート

## セキュリティ考慮事項

- 入力コードスニペットはAIから受信
- ドキュメント変更は呼び出し元が制御

## 備考

- 言語固有の実装はIMapCodeServiceインターフェースを実装
- 失敗時のnull返却でマッピング不可を通知

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: インターフェースを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | IMapCodeService.cs | `src/Features/Core/Portable/MapCode/IMapCodeService.cs` | マップコードサービスのインターフェース |

**主要処理フロー**:
- **13-20行目**: サービスの役割説明（Replace existing / Insert new）
- **21行目**: `ILanguageService`を継承
- **30-34行目**: `MapCodeAsync`メソッド定義
  - `document`: ターゲットドキュメント
  - `contents`: マッピング対象コードスニペット
  - `prioritizedFocusLocations`: 優先フォーカス位置
  - 戻り値: `ImmutableArray<TextChange>?`（失敗時null）

**読解のコツ**:
- インターフェースのドキュメントコメントで責務を理解
- 言語サービスとしての位置づけを確認

### プログラム呼び出し階層図

```
IMapCodeService.MapCodeAsync
    │
    ├─ コードスニペット解析
    │      └─ 構文解析
    │
    ├─ ターゲット位置特定
    │      └─ prioritizedFocusLocations評価
    │
    ├─ 既存コードマッチング
    │      ├─ 置換候補特定
    │      └─ 挿入位置決定
    │
    └─ TextChanges生成
           └─ ImmutableArray<TextChange>返却
```

### データフロー図

```
[入力]                         [処理]                      [出力]

Document ─────────────────▶ MapCodeAsync ──────────▶ TextChange[]?
    │                            │
ImmutableArray<string> ─────────▶│
(contents)                       │
    │                            │
prioritizedFocusLocations ──────▶│
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| IMapCodeService.cs | `src/Features/Core/Portable/MapCode/IMapCodeService.cs` | ソース | サービスインターフェース |
