# 機能設計書 13-基底へ移動

## 概要

本ドキュメントは、Roslynの「基底へ移動」（Go To Base）機能の設計について記述する。派生クラスのメンバーから、その基底クラス/インターフェースの対応メンバーへナビゲートするIDE機能である。

### 本機能の処理概要

基底へ移動機能は、オーバーライドメソッドや実装メソッドから、それが継承または実装している基底クラス/インターフェースの対応メンバーへ即座にジャンプできる機能である。

**業務上の目的・背景**：オブジェクト指向プログラミングでは、継承とインターフェース実装が頻繁に使用される。派生クラスのメソッドを見ている際に、そのメソッドがどの基底クラスのメソッドをオーバーライドしているか、またはどのインターフェースを実装しているかを即座に確認できることで、コードの理解と保守性が向上する。

**機能の利用シーン**：
- overrideメソッドから基底クラスの仮想メソッドへ移動したいとき
- インターフェース実装メソッドからインターフェース定義へ移動したいとき
- 派生クラスから基底クラスの定義へ移動したいとき
- プロパティやイベントの基底定義を確認したいとき

**主要な処理内容**：
1. カーソル位置のシンボル特定とセマンティック解析
2. シンボルが型、メソッド、プロパティ、イベントのいずれかを判定
3. 型の場合は基底型/実装インターフェースを取得
4. メンバーの場合はオーバーライド元/インターフェース定義を取得
5. 定義アイテム生成とナビゲーション実行

**関連システム・外部連携**：
- セマンティック解析エンジン（SymbolFinder）
- Find Usagesウィンドウ
- LSP（Language Server Protocol）

**権限による制御**：特になし。すべての開発者が利用可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | エディタ | 主画面 | 基底定義場所へのナビゲーション |
| - | Find Usagesウィンドウ | 結果表示画面 | 複数の基底がある場合の一覧表示 |

## 機能種別

ナビゲーション / シンボル解析

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| document | Document | Yes | 対象ドキュメント | null不可 |
| position | int | Yes | カーソル位置 | 0以上 |
| cancellationToken | CancellationToken | Yes | キャンセルトークン | - |

### 入力データソース

- エディタからのカーソル位置情報
- ドキュメントのセマンティックモデル
- プロジェクトのコンパイレーション

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| definitions | ImmutableArray\<DefinitionItem\> | 基底定義アイテムのリスト |

### 出力先

- エディタ（基底定義場所へのナビゲーション）
- Find Usagesウィンドウ（複数基底の場合）

## 処理フロー

### 処理シーケンス

```
1. シンボル取得
   └─ カーソル位置のシンボルをセマンティック解析で取得
2. シンボル種別判定
   └─ 型、メソッド、プロパティ、イベントのいずれかを判定
3. 基底シンボル取得
   └─ シンボル種別に応じた基底取得メソッドを呼び出し
4. ソース定義検索
   └─ メタデータシンボルのソース定義を検索
5. 定義アイテム生成
   └─ DefinitionItemを生成
6. ナビゲーション実行
   └─ 単一の場合は直接移動、複数の場合はFind Usages表示
```

### フローチャート

```mermaid
flowchart TD
    A[Go To Base実行] --> B[カーソル位置のシンボル取得]
    B --> C{シンボル種別?}
    C -->|型| D[基底型を取得]
    C -->|メソッド| E[オーバーライド元を取得]
    C -->|プロパティ| F[オーバーライド元を取得]
    C -->|イベント| G[オーバーライド元を取得]
    C -->|その他| Z[終了]
    D --> H[インターフェース一覧を追加]
    E --> I[インターフェース実装を追加]
    F --> I
    G --> I
    H --> J[ソース定義検索]
    I --> J
    J --> K[DefinitionItem生成]
    K --> L{複数の基底?}
    L -->|Yes| M[Find Usagesウィンドウ表示]
    L -->|No| N[基底定義へ移動]
    M --> Z
    N --> Z
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 型の基底 | クラスの場合は基底クラスとすべての実装インターフェースを取得 | INamedTypeSymbol |
| BR-02 | メソッドの基底 | オーバーライド元メソッドと実装インターフェースメソッドを取得 | IMethodSymbol |
| BR-03 | プロパティの基底 | オーバーライド元プロパティと実装インターフェースプロパティを取得 | IPropertySymbol |
| BR-04 | イベントの基底 | オーバーライド元イベントと実装インターフェースイベントを取得 | IEventSymbol |
| BR-05 | Object除外 | System.Objectは基底として表示しない | 基底クラスがSystem.Object |
| BR-06 | ValueType除外 | System.ValueTypeは基底として表示しない | 構造体の基底型 |

### 計算ロジック

特になし

## データベース操作仕様

該当なし（メモリ内処理のみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | シンボル未解決 | カーソル位置にシンボルがない | 何も行わない |
| - | 基底なし | 基底クラス/インターフェースがない | 何も行わない |

### リトライ仕様

特になし

## トランザクション仕様

該当なし（読み取り専用処理）

## パフォーマンス要件

- レスポンス時間: 即座（ユーザー体感で遅延なし）
- 非同期処理でUIスレッドをブロックしない

## セキュリティ考慮事項

特になし（ローカルコード解析のみ）

## 備考

- C#とVBで共通の基盤を使用
- 複数のインターフェースを実装している場合、すべてのインターフェース定義が表示される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: インターフェースを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | IGoToBaseService.cs | `src/Features/Core/Portable/GoToBase/IGoToBaseService.cs` | サービスインターフェース。FindBasesAsyncメソッドを理解する |

**主要処理フロー**:
- **12-13行目**: FindBasesAsync - 位置のシンボルから基底シンボルを検索

#### Step 2: 抽象基底クラスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AbstractGoToBaseService.cs | `src/Features/Core/Portable/GoToBase/AbstractGoToBaseService.cs` | 言語共通の実装。シンボル種別ごとの基底取得を理解する |

**主要処理フロー**:
- **12-27行目**: FindBasesAsync - メイン処理。セマンティックモデル取得とシンボル取得
- **23行目**: FindBaseHelpersを呼び出して基底シンボルを取得
- **26行目**: 各基底シンボルをDefinitionItemに変換

#### Step 3: ヘルパー関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | FindBaseHelpers.cs | `src/Features/Core/Portable/GoToBase/FindBaseHelpers.cs` | 基底シンボル取得の詳細ロジック |

**主要処理フロー**:
- **11-37行目**: FindBasesAsync - シンボル種別に応じた分岐処理
- **14-17行目**: 型シンボルの場合 - 基底型とインターフェースを取得
- **19-22行目**: メソッドシンボルの場合 - オーバーライド元と実装インターフェースを取得
- **24-27行目**: プロパティシンボルの場合
- **29-32行目**: イベントシンボルの場合
- **39-59行目**: AddBasesAsync - 基底型の追加
- **52-53行目**: System.Object、System.ValueType、Object?を除外
- **61-81行目**: AddOverriddenMemberAsync - オーバーライド元メンバーの追加
- **83-106行目**: AddImplementedInterfaceMembersAsync - インターフェース実装の追加

### プログラム呼び出し階層図

```
GoToBaseCommand（エディタコマンド）
    │
    └─ IGoToBaseService.FindBasesAsync()
           │ (AbstractGoToBaseService)
           │
           ├─ document.GetRequiredSemanticModelAsync()
           │      └─ セマンティックモデル取得
           │
           ├─ SymbolFinder.FindSymbolAtPositionAsync()
           │      └─ 位置のシンボル取得
           │
           └─ FindBaseHelpers.FindBasesAsync()
                  │
                  ├─ AddBasesAsync() [型の場合]
                  │      ├─ 基底型を追加
                  │      └─ インターフェースを追加
                  │
                  ├─ AddOverriddenMemberAsync() [メンバーの場合]
                  │      └─ オーバーライド元を追加
                  │
                  └─ AddImplementedInterfaceMembersAsync()
                         └─ インターフェース実装を追加
```

### データフロー図

```
[入力]                      [処理]                           [出力]

Document ─────────┐
                  │
Position ─────────┼──▶ IGoToBaseService ──────────────┐
                  │         │                          │
CancellationToken─┘         ▼                          │
                    セマンティックモデル取得           │
                          │                            │
                          ▼                            │
                    シンボル取得                       │
                          │                            │
                          ▼                            ▼
                    FindBaseHelpers.FindBasesAsync ──▶ ISymbol[]
                          │                            │
                          ▼                            │
                    基底シンボル収集                   │
                          │                            │
                          ▼                            ▼
                    DefinitionItem変換 ──────────────▶ DefinitionItem[]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| IGoToBaseService.cs | `src/Features/Core/Portable/GoToBase/IGoToBaseService.cs` | ソース | サービスインターフェース |
| AbstractGoToBaseService.cs | `src/Features/Core/Portable/GoToBase/AbstractGoToBaseService.cs` | ソース | 抽象基底クラス |
| FindBaseHelpers.cs | `src/Features/Core/Portable/GoToBase/FindBaseHelpers.cs` | ソース | ヘルパー関数 |
| DefinitionItem.cs | `src/Features/Core/Portable/FindUsages/DefinitionItem.cs` | ソース | 定義アイテムモデル |
| SymbolFinder.cs | `src/Workspaces/Core/Portable/FindSymbols/SymbolFinder.cs` | ソース | シンボル検索エンジン |
