# 機能設計書 130-thisの簡略化

## 概要

本ドキュメントは、Roslynプロジェクトにおけるthisの簡略化機能の設計仕様を記載する。不要なthis.（C#）やMe.（VB）修飾子を削除する診断とコード修正を提供する。

### 本機能の処理概要

thisの簡略化機能は、メンバーアクセス式における不要なthis（C#）またはMe（VB）修飾子を検出し、削除するための診断アナライザーとコード修正を提供する。コードスタイル設定に基づいて動作する。

**業務上の目的・背景**：C#やVBでは、インスタンスメンバーへのアクセス時にthis./Me.を明示的に記述する必要がない場合が多い。冗長なthis./Me.はコードの簡潔さを損ない、可読性を低下させる可能性がある。本機能は、コードスタイル設定（QualifyFieldAccess等）に従って不要な修飾子を検出し、自動削除を提供する。

**機能の利用シーン**：
- コードスタイル違反の自動検出
- 一括コードクリーンアップ
- EditorConfig設定に基づく自動修正

**主要な処理内容**：
1. this/Meメンバーアクセス式の検出
2. コードスタイルオプションの確認
3. 簡略化可能かの判定
4. 診断の報告
5. コード修正の適用

**関連システム・外部連携**：EditorConfig、コードスタイル設定。

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | エディタ警告/提案、CodeFix |

## 機能種別

診断アナライザー / コード修正

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| SyntaxNodeAnalysisContext | context | Yes | 構文ノード解析コンテキスト | this/Me式ノード |

### 入力データソース

- ソースコードのthis/Meメンバーアクセス式
- コードスタイルオプション（QualifyFieldAccess等）
- EditorConfig設定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Diagnostic | array | IDE0003診断 |
| CodeFix | action | this/Me削除修正 |

### 出力先

- エラーリスト/警告
- クイックアクション

## 処理フロー

### 処理シーケンス

```
1. this/Me式の検出
   └─ RegisterSyntaxNodeActionでノード登録
2. 親ノードの確認
   └─ TMemberAccessExpressionSyntaxの確認
3. オプション取得
   └─ GetSimplifierOptionsでスタイル設定取得
4. 簡略化判定
   └─ ShouldSimplifyThisMemberAccessExpression
5. 診断報告
   └─ ReportDiagnosticで警告発行
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[this/Me式検出]
    B --> C{親がMemberAccess?}
    C -->|No| D[終了]
    C -->|Yes| E[オプション取得]
    E --> F[ShouldSimplify判定]
    F --> G{簡略化可能?}
    G -->|No| D
    G -->|Yes| H{スキップ条件?}
    H -->|Yes| D
    H -->|No| I[診断報告]
    I --> D
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | フィールドアクセス | QualifyFieldAccess設定に従う | フィールドアクセス時 |
| BR-002 | プロパティアクセス | QualifyPropertyAccess設定に従う | プロパティアクセス時 |
| BR-003 | メソッドアクセス | QualifyMethodAccess設定に従う | メソッドアクセス時 |
| BR-004 | イベントアクセス | QualifyEventAccess設定に従う | イベントアクセス時 |
| BR-005 | 重大度設定 | Notification設定に従う | 全アクセス種別 |

### 計算ロジック

簡略化判定:
- `ShouldSimplifyThisMemberAccessExpression`メソッドで判定
- コードスタイルオプションとセマンティクスを考慮
- 名前衝突がないことを確認

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 診断なし | 簡略化不可 | 診断をスキップ |
| - | 診断なし | オプション無効 | 診断をスキップ |

### リトライ仕様

リトライ処理なし。

## トランザクション仕様

Roslynのイミュータブルモデルにより、変更は新しいドキュメントとして返却。

## パフォーマンス要件

- セマンティックスパン解析として実装
- 対象ノードのみを処理

## セキュリティ考慮事項

- ソースコード変更のみ
- 機密情報の処理なし

## 備考

- 診断ID: IDE0003
- EnforceOnBuild: RemoveQualification設定に従う
- EditorConfig対応

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 診断アナライザーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AbstractSimplifyThisOrMeDiagnosticAnalyzer.cs | `src/Features/Core/Portable/SimplifyThisOrMe/AbstractSimplifyThisOrMeDiagnosticAnalyzer.cs` | 診断アナライザーの実装 |

**主要処理フロー**:
- **14-24行目**: ジェネリック型パラメータと継承
- **25-36行目**: コンストラクタ
  - **26行目**: IDEDiagnosticIds.RemoveThisOrMeQualificationDiagnosticId
  - **28-33行目**: コードスタイルオプション定義
- **39-42行目**: 抽象プロパティ定義
- **44-45行目**: GetAnalyzerCategory - SemanticSpanAnalysis
- **47-48行目**: InitializeWorker - ThisExpression登録

**AnalyzeNode読解ポイント**:
- **50-79行目**: ノード解析処理
  - **56-57行目**: 親がMemberAccessExpressionか確認
  - **59行目**: SimplifierOptions取得
  - **60-65行目**: ShouldSimplifyThisMemberAccessExpression判定
  - **67-78行目**: 診断作成と報告

**読解のコツ**:
- `AbstractBuiltInUnnecessaryCodeStyleDiagnosticAnalyzer`を継承
- `Simplifier`プロパティで言語固有のSimplifierを取得

#### Step 2: コード修正を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AbstractSimplifyThisOrMeCodeFixProvider.cs | `src/Features/Core/Portable/SimplifyThisOrMe/AbstractSimplifyThisOrMeCodeFixProvider.cs` | コード修正の実装 |

**主要処理フロー**:
- **20-23行目**: 抽象メソッド定義（GetTitle, Rewrite）
- **25-28行目**: FixableDiagnosticIds
- **30-34行目**: RegisterCodeFixesAsync
- **36-48行目**: FixAllAsync
  - **40行目**: 構文ルート取得
  - **43-44行目**: 対象ノード収集
  - **46-47行目**: Rewrite実行

### プログラム呼び出し階層図

```
AbstractSimplifyThisOrMeDiagnosticAnalyzer
    │
    ├─ InitializeWorker
    │      └─ RegisterSyntaxNodeAction(AnalyzeNode, ThisExpression)
    │
    └─ AnalyzeNode
           ├─ 親ノード確認（MemberAccessExpression）
           ├─ GetSimplifierOptions
           ├─ ShouldSimplifyThisMemberAccessExpression
           └─ ReportDiagnostic

AbstractSimplifyThisOrMeCodeFixProvider
    │
    ├─ RegisterCodeFixesAsync
    │      └─ RegisterCodeFix
    │
    └─ FixAllAsync
           ├─ GetRequiredSyntaxRootAsync
           ├─ AdditionalLocations[0].FindNode
           └─ Rewrite
```

### データフロー図

```
[入力]                    [処理]                         [出力]

this/Me式 ────────────▶ AnalyzeNode ─────────────▶ Diagnostic
    │                         │
    │                         ├─ 親ノード確認
    │                         ├─ オプション取得
    │                         └─ 簡略化判定
    │                         │
    └─────────────────────────┘
                              ▼
                         FixAllAsync
                              │
                              ├─ 対象ノード収集
                              └─ Rewrite
                              │
                              ▼
                         Document (修正済み)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AbstractSimplifyThisOrMeDiagnosticAnalyzer.cs | `src/Features/Core/Portable/SimplifyThisOrMe/AbstractSimplifyThisOrMeDiagnosticAnalyzer.cs` | ソース | 診断アナライザー |
| AbstractSimplifyThisOrMeCodeFixProvider.cs | `src/Features/Core/Portable/SimplifyThisOrMe/AbstractSimplifyThisOrMeCodeFixProvider.cs` | ソース | コード修正 |
| CSharpSimplifyThisOrMeDiagnosticAnalyzer.cs | `src/Analyzers/CSharp/Analyzers/SimplifyThisOrMe/` | ソース | C#診断 |
| CSharpSimplifyThisOrMeCodeFixProvider.cs | `src/Analyzers/CSharp/CodeFixes/SimplifyThisOrMe/` | ソース | C#修正 |
| VisualBasicSimplifyThisOrMeDiagnosticAnalyzer.cs | `src/Analyzers/VisualBasic/Analyzers/SimplifyThisOrMe/` | ソース | VB診断 |
| VisualBasicSimplifyThisOrMeCodeFixProvider.cs | `src/Analyzers/VisualBasic/CodeFixes/SimplifyThisOrMe/` | ソース | VB修正 |
