# 機能設計書 131-型名の簡略化

## 概要

本ドキュメントは、Roslynの「型名の簡略化（SimplifyTypeNames）」機能の設計を記述する。この機能は、完全修飾型名や冗長な型名表現を簡略化し、コードの可読性を向上させる。

### 本機能の処理概要

この機能は、C#およびVisual Basicコード内の完全修飾型名や冗長なメンバーアクセス表現を検出し、簡略化された形式に変換するリファクタリング機能である。

**業務上の目的・背景**：
開発者がコードを記述する際、IDEの自動補完や他ソースからのコピー&ペーストにより、完全修飾型名（例：`System.Collections.Generic.List<T>`）が使用されることがある。これらは技術的には正しいが、適切なusing文が存在する場合は冗長であり、コードの可読性を低下させる。本機能により、コードの簡潔さと保守性が向上する。

**機能の利用シーン**：
- エディタ上で完全修飾型名にカーソルを置いた際の自動診断
- コード保存時やビルド時のアナライザー実行
- コードクリーンアップ操作の一部として
- 「Quick Actions」メニューからの手動適用

**主要な処理内容**：
1. 構文木の走査による簡略化候補の検出（型名、メンバーアクセス）
2. セマンティック解析による簡略化可能性の判定
3. ユーザー設定（`PreferIntrinsicPredefinedTypeKeywordInDeclaration`等）の参照
4. 診断メッセージの生成とIDE上での表示
5. コード修正の適用（Simplifier annotation追加後の簡略化処理）

**関連システム・外部連携**：
- Roslyn Simplifier API：実際の簡略化ロジックを提供
- EditorConfig：コードスタイル設定（dotnet_style_qualification等）

**権限による制御**：
特に権限による制御はない。エディタ機能として全ユーザーに提供される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | エディタウィンドウ | 主画面 | 診断結果の表示（波線）とクイックアクション提案 |
| - | エラー一覧 | 結果表示画面 | 診断結果の一覧表示 |

## 機能種別

コード診断・リファクタリング

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| node | SyntaxNode | Yes | 解析対象の構文ノード | IsCandidate()で候補判定 |
| model | SemanticModel | Yes | セマンティックモデル | null不可 |
| options | TSimplifierOptions | Yes | 簡略化オプション | null不可 |

### 入力データソース

- ソースコードドキュメント（SyntaxTree）
- セマンティックモデル（SemanticModel）
- EditorConfig設定ファイル

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Diagnostic | Diagnostic | 簡略化可能な箇所の診断情報 |
| issueSpan | TextSpan | 問題箇所のテキスト範囲 |
| diagnosticId | string | 診断ID（IDE0001, IDE0002, IDE0049） |

### 出力先

- IDE診断結果（エディタ波線、エラー一覧）
- 修正適用時は編集後のドキュメント

## 処理フロー

### 処理シーケンス

```
1. AnalyzeCompilation開始
   └─ コンパイル開始時にアナライザーを登録
2. AnalyzeCodeBlock実行
   └─ コードブロック単位で候補ノードを検出
3. TrySimplify判定
   └─ 各候補に対して簡略化可能性を判定
4. CreateDiagnostic生成
   └─ 診断メッセージを作成
5. CodeFix適用（ユーザー操作時）
   └─ SimplificationAnnotationを追加し簡略化実行
```

### フローチャート

```mermaid
flowchart TD
    A[構文ノード取得] --> B{IsCandidate?}
    B -->|No| Z[スキップ]
    B -->|Yes| C{CanSimplifyTypeNameExpression?}
    C -->|No| Z
    C -->|Yes| D[issueSpan・diagnosticId取得]
    D --> E{Hidden領域と重複?}
    E -->|Yes| Z
    E -->|No| F[Diagnostic生成]
    F --> G[診断結果報告]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-131-01 | 組み込み型優先 | int/stringなどのC#キーワードを優先 | PreferIntrinsicPredefinedTypeKeywordInDeclaration設定時 |
| BR-131-02 | メンバーアクセス簡略化 | this.や不要な修飾を削除 | usingディレクティブで解決可能な場合 |
| BR-131-03 | Hidden領域除外 | #region等の非表示領域は処理対象外 | OverlapsHiddenPosition判定 |

### 計算ロジック

簡略化判定は`Simplifier.CanSimplifyTypeNameExpression`メソッドにより、以下を考慮：
- usingディレクティブの存在
- 名前空間の曖昧性
- エイリアスの存在
- ジェネリック型の制約

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし（メモリ上のコード解析のみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 解析失敗 | SemanticModelが取得できない場合 | 診断をスキップ |
| - | キャンセル | ユーザー操作によるキャンセル | CancellationTokenで処理中断 |

### リトライ仕様

リトライは行わない。次回のドキュメント変更時に再解析される。

## トランザクション仕様

トランザクション管理なし。コード修正はSyntaxEditor経由で原子的に適用される。

## パフォーマンス要件

- SemanticSpanAnalysisとして実装（部分的な解析に対応）
- コードブロック単位の並列解析に対応
- IntervalTreeによる重複解析の回避

## セキュリティ考慮事項

- コード内容のログ出力は#if LOGコンパイル時のみ
- ユーザーコードの外部送信なし

## 備考

- 診断ID: IDE0001（SimplifyNames）, IDE0002（SimplifyMemberAccess）, IDE0049（PreferBuiltInOrFrameworkType）
- EnforceOnBuild設定により、ビルド時にも診断可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、診断結果とオプションのデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SimplifierOptions | `src/Workspaces/Core/Portable/Simplification/SimplifierOptions.cs` | PreferPredefinedTypeKeywordInDeclaration等の設定項目 |
| 1-2 | DiagnosticDescriptor | `src/Analyzers/Core/Analyzers/SimplifyTypeNames/SimplifyTypeNamesDiagnosticAnalyzerBase.cs` | 20-48行目：3種類の診断記述子定義 |

**読解のコツ**: `s_descriptorSimplifyNames`、`s_descriptorSimplifyMemberAccess`、`s_descriptorPreferBuiltinOrFrameworkType`の3つの診断記述子が定義されている。

#### Step 2: エントリーポイントを理解する

診断アナライザーのエントリーポイントを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SimplifyTypeNamesDiagnosticAnalyzerBase.cs | `src/Analyzers/Core/Analyzers/SimplifyTypeNames/SimplifyTypeNamesDiagnosticAnalyzerBase.cs` | InitializeWorker、AnalyzeCompilationの登録フロー |

**主要処理フロー**:
1. **76-79行目**: InitializeWorkerでRegisterCompilationStartAction
2. **81-86行目**: AnalyzeCompilationでCodeBlock/SemanticModel解析を登録
3. **100-119行目**: TrySimplifyで簡略化可能性を判定

#### Step 3: コード修正プロバイダーを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AbstractSimplifyTypeNamesCodeFixProvider.cs | `src/Features/Core/Portable/SimplifyTypeNames/AbstractSimplifyTypeNamesCodeFixProvider.cs` | コード修正の実装 |

**主要処理フロー**:
- **70-89行目**: RegisterCodeFixesAsyncでクイックアクション登録
- **91-112行目**: FixAllAsyncで一括修正実装
- **114-125行目**: CanSimplifyTypeNameExpressionで修正可能性判定

### プログラム呼び出し階層図

```
SimplifyTypeNamesDiagnosticAnalyzerBase
    │
    ├─ AnalyzerImpl.AnalyzeCodeBlock
    │      └─ TrySimplify
    │             └─ CanSimplifyTypeNameExpression（言語固有実装）
    │
    └─ AnalyzerImpl.AnalyzeSemanticModel
           └─ AnalyzeSemanticModel（言語固有実装）

AbstractSimplifyTypeNamesCodeFixProvider
    │
    ├─ RegisterCodeFixesAsync
    │      └─ GetNodeToSimplify
    │
    └─ FixAllAsync
           └─ AddSimplificationAnnotationTo
```

### データフロー図

```
[入力]                    [処理]                         [出力]

SyntaxNode ───▶ IsCandidate ───▶ CanSimplify ───▶ Diagnostic
                     │                │
                     │                │
              SemanticModel     SimplifierOptions
                     │                │
                     └────────────────┘
                            ▼
                   CreateDiagnostic ───▶ IDE診断表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SimplifyTypeNamesDiagnosticAnalyzerBase.cs | `src/Analyzers/Core/Analyzers/SimplifyTypeNames/` | ソース | 診断アナライザー基底クラス |
| AbstractSimplifyTypeNamesCodeFixProvider.cs | `src/Features/Core/Portable/SimplifyTypeNames/` | ソース | コード修正プロバイダー基底クラス |
| SimplifyTypeNamesCodeFixProvider.cs | `src/Features/CSharp/Portable/SimplifyTypeNames/` | ソース | C#用コード修正プロバイダー |
| IDEDiagnosticIds.cs | `src/Analyzers/Core/Analyzers/` | ソース | 診断ID定義（IDE0001等） |
| EnforceOnBuildValues.cs | `src/Analyzers/Core/Analyzers/` | ソース | ビルド時強制設定 |
