# 機能設計書 136-パラメータ初期化

## 概要

本ドキュメントは、Roslynの「パラメータ初期化（InitializeParameter）」機能の設計を記述する。この機能は、コンストラクタのパラメータからフィールドまたはプロパティを生成し、初期化コードを自動生成するリファクタリング機能である。

### 本機能の処理概要

この機能は、コンストラクタのパラメータに対して、対応するフィールドまたはプロパティを作成し、パラメータからの代入文を自動生成する。また、nullチェックの追加も提供する。

**業務上の目的・背景**：
コンストラクタでパラメータを受け取り、フィールドやプロパティに代入するのは一般的なパターンである。しかし、これを手動で行うと、フィールド/プロパティの宣言、命名規則に従った名前付け、代入文の記述といった定型作業が発生する。本機能により、これらの作業を自動化し、開発効率を向上させる。

**機能の利用シーン**：
- 新規コンストラクタ作成時
- 依存性注入（DI）パターンの実装時
- 既存コンストラクタへのパラメータ追加時
- Primary Constructor（C# 12）からのメンバー生成時

**主要な処理内容**：
1. コンストラクタパラメータの検出
2. 既存フィールド/プロパティとのマッチング
3. 新規フィールド/プロパティの生成（命名規則に従う）
4. 代入文の生成
5. nullチェックの追加（オプション）

**関連システム・外部連携**：
- NamingRules：命名規則に従った名前生成
- CodeGenerationService：メンバー生成

**権限による制御**：
特に権限による制御はない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | エディタウィンドウ | 主画面 | Quick Actionsメニューからの実行 |

## 機能種別

コードリファクタリング・コード生成

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| document | Document | Yes | 対象ドキュメント | null不可 |
| parameterSyntax | TParameterSyntax | Yes | 対象パラメータ構文 | null不可 |
| parameter | IParameterSymbol | Yes | パラメータシンボル | Name != "" |

### 入力データソース

- ソースコードドキュメント
- NamingRules（命名規則）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| field | IFieldSymbol | 生成されるフィールド |
| property | IPropertySymbol | 生成されるプロパティ |
| assignmentStatement | SyntaxNode | 代入文 |

### 出力先

- 編集後のドキュメント

## 処理フロー

### 処理シーケンス

```
1. ComputeRefactoringsAsync呼び出し
   └─ TryGetRelevantNodeでパラメータ取得
2. メソッドシンボル確認
   └─ コンストラクタかどうか確認
3. 既存メンバー検索
   └─ TryFindMatchingUninitializedFieldOrPropertySymbolAsync
4. アクション生成
   └─ 既存メンバーあり：Initialize field/property
   └─ 既存メンバーなし：Create and assign field/property
5. 実行（ユーザー選択時）
   └─ AddMissingFieldOrPropertyAsync + AddAssignmentAsync
```

### フローチャート

```mermaid
flowchart TD
    A[パラメータ取得] --> B{コンストラクタ?}
    B -->|No| Z[終了]
    B -->|Yes| C{既存代入あり?}
    C -->|Yes| Z
    C -->|No| D[既存メンバー検索]
    D --> E{マッチするメンバーあり?}
    E -->|Yes| F[Initialize existing member]
    E -->|No| G[Create and assign new member]
    F --> H[CodeAction登録]
    G --> H
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-136-01 | コンストラクタ限定 | MethodKind.Constructorのみ対象 | method.MethodKind == MethodKind.Constructor |
| BR-136-02 | 既存代入スキップ | 既にパラメータを代入している場合はスキップ | TryFindFieldOrPropertyAssignmentStatementで検出 |
| BR-136-03 | 命名規則適用 | 新規フィールド/プロパティは命名規則に従う | NamingRulesを参照 |
| BR-136-04 | 隣接パラメータ参照 | 隣接パラメータがフィールド/プロパティに対応している場合はそれに合わせる | TryFindSiblingFieldOrProperty |
| BR-136-05 | ThrowNotImplemented対応 | `=> throw new NotImplementedException()`のプロパティにも初期化可能 | IsThrowNotImplementedProperty判定 |

### 計算ロジック

フィールド/プロパティ名生成:
- IdentifierNameParts.CreateIdentifierNamePartsでパラメータ名を分解
- NamingRuleに基づいて新しい名前を生成
- 既存メンバーとの重複を回避

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ArgumentNullException型なし | コンパイルにArgumentNullExceptionがない | リファクタリング不可 |
| - | パラメータシンボル取得失敗 | GetDeclaredSymbolがnull | 処理をスキップ |

### リトライ仕様

リトライは行わない。

## トランザクション仕様

SyntaxEditorによる原子的な変更適用。

## パフォーマンス要件

- CodeRefactoringProviderとして実装
- 非同期処理（async/await）

## セキュリティ考慮事項

特になし。

## 備考

- Primary Constructor（C# 12）用の専用プロバイダーも存在
- nullチェック追加機能は別プロバイダー（AddParameterCheckCodeRefactoringProvider）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 基底クラスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AbstractInitializeParameterCodeRefactoringProvider.cs | `src/Features/Core/Portable/InitializeParameter/` | リファクタリングプロバイダー基底クラス |

**主要処理フロー**:
1. **55-138行目**: ComputeRefactoringsAsyncでリファクタリング判定
2. **67-68行目**: コンストラクタ以外は除外（MethodKind.Constructor）
3. **80-87行目**: MethodKind.Constructorかつ抽象/extern/partialでないことを確認
4. **91-93行目**: ArgumentNullException型の存在確認
5. **96-102行目**: 単一パラメータに対するリファクタリング

#### Step 2: メンバー生成実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AbstractInitializeMemberFromParameterCodeRefactoringProviderMemberCreation.cs | `src/Features/Core/Portable/InitializeParameter/` | フィールド/プロパティ生成ロジック |

**主要処理フロー**:
- **57-100行目**: GetRefactoringsForSingleParameterAsync - 単一パラメータのリファクタリング
- **102-152行目**: HandleNoExistingFieldOrPropertyAsync - 新規メンバー生成
- **273-307行目**: CreateField - フィールド生成
- **309-354行目**: CreateProperty - プロパティ生成
- **614-686行目**: TryFindMatchingUninitializedFieldOrPropertySymbolAsync - 既存メンバー検索

#### Step 3: サービス実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | IInitializeParameterService.cs | `src/Workspaces/.../InitializeParameter/` | サービスインターフェース |
| 3-2 | InitializeParameterHelpersCore.cs | `src/Workspaces/.../InitializeParameter/` | ヘルパーメソッド |

### プログラム呼び出し階層図

```
AbstractInitializeParameterCodeRefactoringProvider
    │
    ├─ ComputeRefactoringsAsync
    │      ├─ TryGetRelevantNodeAsync
    │      ├─ GetDeclaredSymbol
    │      └─ GetRefactoringsForSingleParameterAsync（派生クラス）
    │
    └─ AbstractInitializeMemberFromParameterCodeRefactoringProvider
           ├─ GetRefactoringsForSingleParameterAsync
           │      ├─ TryFindFieldOrPropertyAssignmentStatement
           │      ├─ TryFindMatchingUninitializedFieldOrPropertySymbolAsync
           │      └─ HandleNoExistingFieldOrPropertyAsync
           │
           └─ AddSingleSymbolInitializationAsync
                  ├─ AddMissingFieldOrPropertyAsync
                  └─ IInitializeParameterService.AddAssignmentAsync
```

### データフロー図

```
[入力]                    [処理]                         [出力]

IParameterSymbol ───▶ IdentifierNameParts ───▶ 命名規則適用
        │                    │
        │                    ├─ CreateField
NamingRules                  └─ CreateProperty
        │
        ▼
ICodeGenerationService ───▶ AddField/AddProperty ───▶ 更新済みDocument
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AbstractInitializeParameterCodeRefactoringProvider.cs | `src/Features/Core/Portable/InitializeParameter/` | ソース | 基底クラス |
| AbstractInitializeMemberFromParameterCodeRefactoringProviderMemberCreation.cs | `src/Features/Core/Portable/InitializeParameter/` | ソース | メンバー生成ロジック |
| AbstractAddParameterCheckCodeRefactoringProvider.cs | `src/Features/Core/Portable/InitializeParameter/` | ソース | nullチェック追加 |
| IInitializeParameterService.cs | `src/Workspaces/.../InitializeParameter/` | ソース | サービスインターフェース |
| InitializeParameterHelpersCore.cs | `src/Workspaces/.../InitializeParameter/` | ソース | ヘルパーメソッド |
| CSharpInitializeMemberFromParameterCodeRefactoringProvider.cs | `src/Features/CSharp/Portable/InitializeParameter/` | ソース | C#用プロバイダー |
