# 機能設計書 137-メンバー選択

## 概要

本ドキュメントは、Roslynの「メンバー選択（PickMembers）」機能の設計を記述する。この機能は、コード生成時にユーザーが対象メンバーを選択するためのUIダイアログサービスを提供する。

### 本機能の処理概要

この機能は、「コンストラクタの生成」「Equalsオーバーライドの生成」「GetHashCodeオーバーライドの生成」などのコード生成機能において、対象となるフィールド/プロパティを選択するためのダイアログを提供する。ユーザーは対象メンバーの選択、順序の変更、追加オプションの設定が可能である。

**業務上の目的・背景**：
コード生成機能では、クラスの全メンバーではなく特定のメンバーのみを対象としたい場合がある。例えば、コンストラクタでは一部のフィールドのみを初期化したい、Equalsでは特定のプロパティのみを比較したいなどのケースがある。本機能により、ユーザーは生成対象を柔軟に選択できる。

**機能の利用シーン**：
- 「Generate constructor」リファクタリング実行時
- 「Generate Equals and GetHashCode」リファクタリング実行時
- その他のメンバー選択が必要なコード生成時

**主要な処理内容**：
1. 選択可能なメンバー一覧の表示
2. メンバーの選択/選択解除
3. メンバーの順序変更（上下移動）
4. 追加オプションの表示と選択
5. 選択結果の返却

**関連システム・外部連携**：
- Visual Studio UI：WPFダイアログ
- IGlyphService：シンボルアイコン表示

**権限による制御**：
特に権限による制御はない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | Pick members ダイアログ | モーダルダイアログ | メンバー選択操作 |

## 機能種別

UIサービス

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| title | string | Yes | ダイアログタイトル | null不可 |
| members | ImmutableArray<ISymbol> | Yes | 選択可能なメンバー一覧 | 空でない |
| options | ImmutableArray<PickMembersOption> | No | 追加オプション | default許容 |
| selectAll | bool | No | 初期選択状態 | デフォルトtrue |

### 入力データソース

- 呼び出し元のコード生成機能

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| IsCanceled | bool | キャンセルされたか |
| Members | ImmutableArray<ISymbol> | 選択されたメンバー |
| Options | ImmutableArray<PickMembersOption> | オプションの結果 |
| SelectedAll | bool | 全選択されたか |

### 出力先

- 呼び出し元へのPickMembersResult返却

## 処理フロー

### 処理シーケンス

```
1. IPickMembersService.PickMembers呼び出し
   └─ ダイアログを開く
2. ユーザー操作
   └─ メンバー選択/順序変更/オプション設定
3. OK/Cancelボタン押下
   └─ PickMembersResult返却
```

### フローチャート

```mermaid
flowchart TD
    A[PickMembers呼び出し] --> B[ダイアログ表示]
    B --> C{ユーザー操作}
    C -->|メンバー選択| D[IsChecked更新]
    C -->|順序変更| E[Move Up/Down]
    C -->|オプション変更| F[Option.Value更新]
    C -->|OK| G[PickMembersResult生成]
    C -->|Cancel| H[Canceled Result返却]
    D --> C
    E --> C
    F --> C
    G --> I[結果返却]
    H --> I
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-137-01 | 初期選択状態 | selectAll引数に基づいて初期選択 | selectAll == true で全選択、false で全解除 |
| BR-137-02 | 順序保持 | 選択結果は表示順序を保持 | 常に適用 |
| BR-137-03 | フィルタリング | 検索テキストでメンバーをフィルタ可能 | 検索ボックス入力時 |

### 計算ロジック

SelectedAll状態:
- SelectAllで全メンバーをIsChecked = true
- DeselectAllで全メンバーをIsChecked = false

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | キャンセル | ユーザーがCancelボタン押下 | PickMembersResult.Canceled返却 |

### リトライ仕様

リトライは行わない。

## トランザクション仕様

トランザクション管理なし。UIダイアログ操作のみ。

## パフォーマンス要件

- UIスレッドでの同期的なダイアログ表示
- 大量メンバー時のスクロール対応

## セキュリティ考慮事項

特になし。

## 備考

- Visual Studio以外の環境ではモック実装が使用される
- WPFベースのモーダルダイアログ

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: サービスインターフェースを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | IPickMembersService.cs | `src/Features/Core/Portable/PickMembers/` | サービスインターフェース定義 |
| 1-2 | PickMembersResult.cs | `src/Features/Core/Portable/PickMembers/` | 結果クラス定義 |

**読解のコツ**:
- `IPickMembersService.PickMembers`が唯一のAPIエントリーポイント
- `PickMembersOption`はチェックボックスオプションを表現
- `PickMembersResult`はキャンセル状態と選択結果を保持

#### Step 2: ViewModelを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | PickMembersDialogViewModel.cs | `src/VisualStudio/Core/Def/PickMembers/` | ダイアログのViewModel |

**主要処理フロー**:
1. **30-48行目**: コンストラクタでメンバーとオプションを初期化
2. **50-57行目**: Filterメソッドで検索フィルタリング
3. **59-71行目**: SelectAll/DeselectAllメソッド
4. **121-148行目**: CanMoveUp/CanMoveDownプロパティ
5. **150-164行目**: MoveUp/MoveDownメソッド
6. **175-200行目**: OptionViewModel内部クラス

#### Step 3: ダイアログ実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | PickMembersDialog.xaml | `src/VisualStudio/Core/Def/PickMembers/` | XAMLレイアウト |
| 3-2 | PickMembersDialog.xaml.cs | `src/VisualStudio/Core/Def/PickMembers/` | コードビハインド |

### プログラム呼び出し階層図

```
IPickMembersService
    │
    └─ VisualStudioPickMembersService（Visual Studio実装）
           │
           └─ PickMembersDialog
                  └─ PickMembersDialogViewModel
                         ├─ MemberContainers（メンバー一覧）
                         ├─ Options（オプション一覧）
                         ├─ Filter（検索フィルタ）
                         ├─ SelectAll/DeselectAll
                         └─ MoveUp/MoveDown
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ImmutableArray<ISymbol> ───▶ PickMembersDialogViewModel ───▶ PickMembersResult
        │                           │
        │                           ├─ MemberSymbolViewModel変換
PickMembersOption                   ├─ OptionViewModel変換
        │                           └─ ユーザー操作の反映
        │
        ▼
IGlyphService ───▶ シンボルアイコン取得
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| IPickMembersService.cs | `src/Features/Core/Portable/PickMembers/` | ソース | サービスインターフェース |
| PickMembersResult.cs | `src/Features/Core/Portable/PickMembers/` | ソース | 結果クラス |
| PickMembersDialogViewModel.cs | `src/VisualStudio/Core/Def/PickMembers/` | ソース | ViewModel |
| MemberSymbolViewModel.cs | `src/VisualStudio/Core/Def/PickMembers/` | ソース | メンバー用ViewModel |
| PickMembersDialog.xaml | `src/VisualStudio/Core/Def/PickMembers/` | XAML | ダイアログUI |
| PickMembersDialog.xaml.cs | `src/VisualStudio/Core/Def/PickMembers/` | ソース | コードビハインド |
| VisualStudioPickMembersService.cs | `src/VisualStudio/Core/Def/PickMembers/` | ソース | VS用サービス実装 |
