# 機能設計書 138-ソリューションクローラー

## 概要

本ドキュメントは、Roslynの「ソリューションクローラー（SolutionCrawler）」機能の設計を記述する。この機能は、ソリューション内のドキュメント変更を監視し、バックグラウンドで増分解析を実行するインフラストラクチャである。

### 本機能の処理概要

ソリューションクローラーは、ワークスペース内のドキュメント変更イベントを監視し、変更があったドキュメントに対して登録済みのインクリメンタルアナライザーを実行する。これにより、診断、コード解析、インデックス更新などのバックグラウンド処理が効率的に行われる。

**業務上の目的・背景**：
IDEでは、ユーザーがコードを編集するたびに、様々な解析処理（診断、コード補完のためのインデックス更新、シンボル検索のための更新など）が必要となる。これらをすべて同期的に実行するとエディタの応答性が低下する。ソリューションクローラーにより、これらの処理をバックグラウンドで非同期に実行し、ユーザー体験を損なわずに解析を行う。

**機能の利用シーン**：
- ドキュメント編集時のバックグラウンド診断
- ファイル追加/削除/名前変更時のインデックス更新
- プロジェクト変更時の再解析
- ソリューション読み込み時の初期解析

**主要な処理内容**：
1. ワークスペースイベントの監視（ドキュメント変更、追加、削除等）
2. 変更キューの管理と優先度付け
3. インクリメンタルアナライザーの呼び出し
4. 解析結果のキャッシュと更新
5. 進捗報告

**関連システム・外部連携**：
- IWorkspaceService：ワークスペースサービス統合
- IAsynchronousOperationListener：非同期操作追跡

**権限による制御**：
特に権限による制御はない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | バックグラウンド処理 | ユーザー操作なし（自動実行） |

## 機能種別

バックグラウンドインフラストラクチャ

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| solution | Solution | Yes | 解析対象ソリューション | null不可 |
| workspaceKind | string | Yes | ワークスペース種別 | null不可 |

### 入力データソース

- Workspaceからのイベント通知
- ILegacySolutionEventsListener

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| - | - | インクリメンタルアナライザーへの解析要求 |

### 出力先

- 登録済みインクリメンタルアナライザー

## 処理フロー

### 処理シーケンス

```
1. Register呼び出し
   └─ WorkCoordinator作成
2. ワークスペースイベント受信
   └─ 変更ドキュメントをキューに追加
3. WorkCoordinatorが処理
   └─ キューから取り出し
4. インクリメンタルアナライザー呼び出し
   └─ ドキュメント解析実行
5. 結果報告
   └─ 進捗とステータス更新
```

### フローチャート

```mermaid
flowchart TD
    A[ワークスペースイベント] --> B{イベント種別}
    B -->|DocumentChanged| C[ドキュメント変更キュー追加]
    B -->|DocumentAdded| D[ドキュメント追加キュー追加]
    B -->|DocumentRemoved| E[ドキュメント削除処理]
    B -->|ProjectChanged| F[プロジェクト変更キュー追加]
    C --> G[WorkCoordinator処理]
    D --> G
    F --> G
    G --> H[IncrementalAnalyzer呼び出し]
    H --> I[結果キャッシュ更新]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-138-01 | 有効化設定 | EnableSolutionCrawlerオプションで制御 | dotnet_enable_solution_crawler設定 |
| BR-138-02 | ワークスペース種別 | ワークスペース種別ごとに独立した登録 | workspaceKind別の管理 |
| BR-138-03 | アナライザープロバイダー選択 | メタデータに基づいてプロバイダーを選択 | WorkspaceKinds属性 |
| BR-138-04 | デフォルトプロバイダー | ワークスペース指定がない場合はデフォルト使用 | WorkspaceKinds == [] |

### 計算ロジック

アナライザープロバイダー選択:
- 特定のワークスペース種別に一致するプロバイダーを優先
- 一致しない場合はデフォルト（WorkspaceKinds空）を使用

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | アナライザー例外 | インクリメンタルアナライザーが例外をスロー | ログ記録して続行 |
| - | キャンセル | シャットダウン時 | CancellationTokenで中断 |

### リトライ仕様

失敗したドキュメントは次回変更時に再解析される。

## トランザクション仕様

トランザクション管理なし。

## パフォーマンス要件

- バックグラウンドスレッドでの非同期実行
- 優先度に基づくキュー管理
- 進捗報告によるUI更新

## セキュリティ考慮事項

特になし。

## 備考

- UnitTesting用の専用実装（UnitTestingSolutionCrawlerRegistrationService）も存在
- 診断アナライザー、IntelliSenseインデックス、Find All Referencesなど多くの機能が依存

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: オプションとサービス登録を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SolutionCrawlerService.cs | `src/Features/Core/Portable/SolutionCrawler/` | EnableSolutionCrawlerオプション定義 |

**読解のコツ**: `EnableSolutionCrawler`オプションがソリューションクローラーの有効/無効を制御する。

#### Step 2: ユニットテスト用実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | UnitTestingSolutionCrawlerRegistrationService.cs | `src/Features/Core/Portable/ExternalAccess/UnitTesting/SolutionCrawler/` | サービス登録実装 |

**主要処理フロー**:
1. **43-51行目**: コンストラクタでアナライザープロバイダーを収集
2. **56-81行目**: Registerメソッドでワークスペースを登録
3. **94-126行目**: AddAnalyzerProviderでプロバイダー追加
4. **128-152行目**: Reanalyzeで再解析を要求
5. **154-171行目**: GetAnalyzerProvidersでプロバイダー取得
6. **173-209行目**: TryGetProviderでワークスペース種別に合うプロバイダー選択
7. **260-279行目**: UnitTestingRegistration内部クラス

#### Step 3: WorkCoordinatorを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | UnitTestingWorkCoordinator.cs | `src/Features/Core/Portable/ExternalAccess/UnitTesting/SolutionCrawler/` | ワークコーディネーター |

### プログラム呼び出し階層図

```
IUnitTestingSolutionCrawlerRegistrationService
    │
    └─ UnitTestingSolutionCrawlerRegistrationService
           │
           ├─ Register
           │      └─ UnitTestingWorkCoordinator作成
           │
           ├─ AddAnalyzerProvider
           │      └─ coordinator.AddAnalyzer
           │
           └─ Reanalyze
                  └─ coordinator.Reanalyze

UnitTestingWorkCoordinator
    │
    ├─ AddAnalyzer
    │
    ├─ Reanalyze
    │
    └─ IUnitTestingIncrementalAnalyzerへの解析要求
```

### データフロー図

```
[入力]                    [処理]                         [出力]

Solution変更イベント ───▶ UnitTestingWorkCoordinator ───▶ 解析要求キュー
        │                        │
        │                        ├─ プロバイダー選択
ILegacySolutionEvents           ├─ アナライザー呼び出し
        │                        └─ 進捗報告
        │
        ▼
IUnitTestingIncrementalAnalyzer ───▶ 解析結果
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SolutionCrawlerService.cs | `src/Features/Core/Portable/SolutionCrawler/` | ソース | オプション定義 |
| UnitTestingSolutionCrawlerRegistrationService.cs | `src/Features/Core/Portable/ExternalAccess/UnitTesting/SolutionCrawler/` | ソース | サービス登録 |
| UnitTestingWorkCoordinator.cs | `src/Features/Core/Portable/ExternalAccess/UnitTesting/SolutionCrawler/` | ソース | ワークコーディネーター |
| IUnitTestingIncrementalAnalyzerProvider.cs | `src/Features/Core/Portable/ExternalAccess/UnitTesting/SolutionCrawler/` | ソース | アナライザープロバイダーIF |
| IUnitTestingIncrementalAnalyzer.cs | `src/Features/Core/Portable/ExternalAccess/UnitTesting/SolutionCrawler/` | ソース | インクリメンタルアナライザーIF |
