# 機能設計書 139-ソリューションエクスプローラー

## 概要

本ドキュメントは、Roslynの「ソリューションエクスプローラー（SolutionExplorer）」機能の設計を記述する。この機能は、Visual Studioのソリューションエクスプローラーにおけるシンボルツリー表示とアナライザー管理機能を提供する。

### 本機能の処理概要

この機能は、ソリューションエクスプローラー内でのシンボル（クラス、メソッド、プロパティ等）のツリー表示と、アナライザー参照の管理（追加、削除、診断重大度設定等）を提供する。

**業務上の目的・背景**：
Visual Studioのソリューションエクスプローラーは、プロジェクト構造をナビゲートする主要なUIである。Roslynはここにコードシンボルのツリー表示を追加し、開発者がコード構造を視覚的に把握できるようにする。また、アナライザー参照の管理機能により、コード品質ツールの設定が容易になる。

**機能の利用シーン**：
- ソリューションエクスプローラーでのファイル展開時のシンボル表示
- アナライザーフォルダでのアナライザー管理
- 診断の重大度設定
- RuleSetファイルの操作

**主要な処理内容**：
1. ドキュメントのシンボルツリー構築
2. シンボル情報の表示名生成
3. アナライザー参照の追加/削除
4. 診断重大度の設定（EditorConfig/RuleSet経由）
5. ヘルプリンクの表示

**関連システム・外部連携**：
- Visual Studio Shell：ソリューションエクスプローラー統合
- EnvDTE：プロジェクトシステム操作
- EditorConfig：診断設定

**権限による制御**：
特に権限による制御はない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | ソリューションエクスプローラー | メイン画面 | シンボルツリー表示、コンテキストメニュー |

## 機能種別

UI統合・シンボル表示

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| documentId | DocumentId | Yes | ドキュメント識別子 | null不可 |
| declarationNode | SyntaxNode | Yes | 宣言構文ノード | null不可 |
| includeNamespaces | bool | No | 名前空間を含めるか | デフォルトfalse |

### 入力データソース

- SyntaxTree
- Visual Studioプロジェクトシステム

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| items | ImmutableArray<SymbolTreeItemData> | シンボルツリーアイテム一覧 |

### 出力先

- ソリューションエクスプローラーツリービュー

## 処理フロー

### 処理シーケンス

```
1. GetItems呼び出し
   └─ ノード種別判定
2. ノード種別に応じた処理
   └─ CompilationUnit/Namespace/Type/Member別処理
3. 子要素の再帰処理
   └─ GetMembersで子メンバー取得
4. 表示名生成
   └─ StringBuilderで名前構築
5. SymbolTreeItemData生成
   └─ 結果配列に追加
```

### フローチャート

```mermaid
flowchart TD
    A[GetItems呼び出し] --> B{ノード種別}
    B -->|CompilationUnit| C[AddTopLevelMembers]
    B -->|Namespace| D[AddNamespaceDeclarationMembers]
    B -->|Type| E[AddTypeDeclarationMembers]
    B -->|Enum| F[AddEnumDeclarationMembers]
    B -->|Member| G[AddMemberDeclaration]
    C --> H[SymbolTreeItemData生成]
    D --> H
    E --> H
    F --> H
    G --> H
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-139-01 | 名前空間表示 | includeNamespaces=trueで名前空間を表示 | returnNamespaces引数 |
| BR-139-02 | 型のネスト | ネストされた型は親型の下に表示 | TryAddTypeがtrueを返す場合 |
| BR-139-03 | シグネチャ表示 | メソッドはパラメータリストを含む | AppendCommaSeparatedList使用 |

### 計算ロジック

表示名生成:
- StringBuilderで名前を構築
- ジェネリックパラメータ、メソッドパラメータを追加
- 言語固有のフォーマットを適用

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | キャンセル | CancellationTokenでキャンセル | 空の結果を返却 |

### リトライ仕様

リトライは行わない。

## トランザクション仕様

トランザクション管理なし。

## パフォーマンス要件

- UIスレッドのブロックを避ける
- ArrayBuilderで効率的なリスト構築
- PooledStringBuilderで文字列生成を最適化

## セキュリティ考慮事項

特になし。

## 備考

- C#とVisual Basic両方に対応
- AnalyzersCommandHandlerでアナライザー管理機能を提供

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: サービスインターフェースを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ISolutionExplorerSymbolTreeItemProvider.cs | `src/Features/Core/Portable/SolutionExplorer/` | サービスインターフェース定義 |

**読解のコツ**: `GetItems`メソッドが唯一のAPI。言語サービスとして実装される。

#### Step 2: 基底クラスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AbstractSolutionExplorerSymbolTreeItemProvider | 同ファイル内 | 基底クラス実装 |

**主要処理フロー**:
1. **34-63行目**: AppendCommaSeparatedListヘルパーメソッド
2. **65-67行目**: GetMembers抽象メソッド（言語固有）
3. **78-110行目**: GetItemsメソッド - ノード種別によるディスパッチ
4. **112-127行目**: AddNamespaceDeclarationMembers
5. **129-140行目**: AddTypeDeclarationMembers
6. **161-193行目**: AddTopLevelMembers

#### Step 3: アナライザー管理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AnalyzersCommandHandler.cs | `src/VisualStudio/Core/Impl/SolutionExplorer/` | コマンドハンドラ |

**主要処理フロー**:
- **99-139行目**: InitializeAsyncでコマンド登録
- **346-349行目**: AddAnalyzerHandler
- **356-362行目**: RemoveAnalyzerHandler
- **393-418行目**: SetSeverityHandler
- **509-521行目**: OpenDiagnosticHelpLinkHandler

### プログラム呼び出し階層図

```
ISolutionExplorerSymbolTreeItemProvider
    │
    └─ AbstractSolutionExplorerSymbolTreeItemProvider
           │
           ├─ GetItems
           │      ├─ AddTopLevelMembers
           │      ├─ AddNamespaceDeclarationMembers
           │      ├─ AddTypeDeclarationMembers
           │      ├─ AddEnumDeclarationMembers
           │      └─ AddMemberDeclaration
           │
           └─ AppendCommaSeparatedList（表示名生成）

AnalyzersCommandHandler
    │
    ├─ AnalyzerFolderContextMenuController
    │      └─ AddAnalyzerHandler
    │
    ├─ AnalyzerContextMenuController
    │      └─ RemoveAnalyzerHandler
    │
    └─ DiagnosticContextMenuController
           ├─ SetSeverityHandler
           └─ OpenDiagnosticHelpLinkHandler
```

### データフロー図

```
[入力]                    [処理]                         [出力]

SyntaxNode ───▶ GetItems ───▶ ImmutableArray<SymbolTreeItemData>
    │              │
    │              ├─ ノード種別判定
DocumentId        ├─ 子要素列挙
    │              └─ 表示名生成
    │
    ▼
ソリューションエクスプローラー表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ISolutionExplorerSymbolTreeItemProvider.cs | `src/Features/Core/Portable/SolutionExplorer/` | ソース | サービスIF・基底クラス |
| SymbolTreeItemData.cs | `src/Features/Core/Portable/SolutionExplorer/` | ソース | データクラス |
| CSharpSolutionExplorerSymbolTreeItemProvider.cs | `src/Features/CSharp/Portable/SolutionExplorer/` | ソース | C#実装 |
| AnalyzersCommandHandler.cs | `src/VisualStudio/Core/Impl/SolutionExplorer/` | ソース | アナライザーコマンド |
| AnalyzerItemsTracker.cs | `src/VisualStudio/Core/Impl/SolutionExplorer/` | ソース | アナライザーアイテム追跡 |
| DiagnosticItem.cs | `src/VisualStudio/Core/Impl/SolutionExplorer/` | ソース | 診断アイテム |
