# 機能設計書 14-参照の検索

## 概要

本ドキュメントは、Roslynの「参照の検索」（Find References / Find Usages）機能の設計について記述する。シンボルのすべての使用箇所をソリューション全体から検索するIDE機能である。

### 本機能の処理概要

参照の検索機能は、選択したシンボル（変数、メソッド、クラス等）がソリューション内のどこで使用されているかをすべて検索し、結果を一覧表示する機能である。

**業務上の目的・背景**：大規模なコードベースにおいて、特定のシンボルがどこで使われているかを把握することは、リファクタリングや影響範囲の分析に不可欠である。この機能により、開発者はシンボルの使用状況を網羅的に把握できる。

**機能の利用シーン**：
- メソッドのリファクタリング前に呼び出し箇所を確認したいとき
- クラスの使用箇所を把握したいとき
- 変数やフィールドの参照箇所を確認したいとき
- インターフェース実装の検索
- 削除予定のコードの影響範囲を確認したいとき

**主要な処理内容**：
1. カーソル位置のシンボル特定
2. ソリューション全体でのシンボル参照検索
3. 継承階層のカスケード検索（オプション）
4. 結果のストリーミング表示
5. 分類済みスパンの生成（シンタックスハイライト用）

**関連システム・外部連携**：
- セマンティック解析エンジン（SymbolFinder）
- Find Usagesウィンドウ
- LSP（Language Server Protocol）
- OOP（Out-of-Process）リモート実行

**権限による制御**：特になし。すべての開発者が利用可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | Find Usagesウィンドウ | 主画面 | 参照結果の一覧表示 |
| - | エディタ | 関連画面 | 結果からのナビゲーション |

## 機能種別

検索 / シンボル解析

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| document | Document | Yes | 対象ドキュメント | null不可 |
| position | int | Yes | カーソル位置 | 0以上 |
| context | IFindUsagesContext | Yes | 結果出力コンテキスト | null不可 |
| options | FindReferencesSearchOptions | No | 検索オプション | - |
| cancellationToken | CancellationToken | Yes | キャンセルトークン | - |

### 入力データソース

- エディタからのカーソル位置情報
- ソリューション全体のドキュメント

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| definitions | DefinitionItem[] | 定義アイテムのリスト |
| references | SourceReferenceItem[] | 参照アイテムのリスト |

### 出力先

- Find Usagesウィンドウ（ストリーミング表示）

## 処理フロー

### 処理シーケンス

```
1. シンボル取得
   └─ カーソル位置のシンボルをセマンティック解析で取得
2. 検索オプション設定
   └─ カスケード検索、実装検索などのオプション設定
3. 参照検索実行
   └─ SymbolFinder.FindReferencesInCurrentProcessAsync
4. ストリーミング出力
   └─ 結果をIFindUsagesContextに順次出力
5. 分類スパン生成
   └─ シンタックスハイライト用のスパン生成
```

### フローチャート

```mermaid
flowchart TD
    A[Find References実行] --> B[カーソル位置のシンボル取得]
    B --> C{シンボル発見?}
    C -->|No| Z[終了]
    C -->|Yes| D[検索オプション設定]
    D --> E[SymbolFinder.FindReferencesAsync]
    E --> F[結果をストリーミング出力]
    F --> G[分類スパン生成]
    G --> H[Find Usagesウィンドウに表示]
    H --> Z
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | カスケード検索 | オーバーライド/実装メンバーも含めて検索 | Cascade=true |
| BR-02 | 実装検索 | インターフェースの実装を検索 | IncludeImplementation=true |
| BR-03 | 参照のみ表示 | DisplayIfNoReferences=falseの定義は除外 | アクセサ等の暗黙定義 |
| BR-04 | 書き込み参照 | 書き込み参照と読み取り参照を区別 | HighlightSpanKind |
| BR-05 | リンクドファイル | 共有プロジェクトのファイルは1つにまとめる | 複数プロジェクトで共有 |

### 計算ロジック

特になし

## データベース操作仕様

該当なし（メモリ内処理のみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | シンボル未解決 | カーソル位置にシンボルがない | 空結果を表示 |
| - | キャンセル | 検索中にキャンセル要求 | 検索を中断 |

### リトライ仕様

特になし

## トランザクション仕様

該当なし（読み取り専用処理）

## パフォーマンス要件

- ストリーミング表示で結果を順次表示
- OOP実行でメインUIスレッドをブロックしない
- 大規模ソリューションでも応答性を維持

## セキュリティ考慮事項

特になし（ローカルコード解析のみ）

## 備考

- C#とVBで共通の基盤を使用
- 結果はグループ化されて表示（定義ごと）

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: インターフェースを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | IFindUsagesService.cs | `src/Features/Core/Portable/FindUsages/IFindUsagesService.cs` | サービスインターフェース。FindReferencesAsync/FindImplementationsAsyncを理解する |

#### Step 2: 抽象基底クラスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AbstractFindUsagesService.cs | `src/Features/Core/Portable/FindUsages/AbstractFindUsagesService.cs` | 言語共通の実装。シンボル取得とコンテキスト出力を理解する |
| 2-2 | AbstractFindUsagesService_FindReferences.cs | `src/Features/Core/Portable/FindUsages/AbstractFindUsagesService_FindReferences.cs` | 参照検索の詳細実装 |
| 2-3 | AbstractFindUsagesService_FindImplementations.cs | `src/Features/Core/Portable/FindUsages/AbstractFindUsagesService_FindImplementations.cs` | 実装検索の詳細実装 |

#### Step 3: データモデルを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | DefinitionItem.cs | `src/Features/Core/Portable/FindUsages/DefinitionItem.cs` | 定義アイテムモデル。Tags、DisplayParts、SourceSpansを理解する |

### プログラム呼び出し階層図

```
FindReferencesCommand（エディタコマンド）
    │
    └─ IFindUsagesService.FindReferencesAsync()
           │ (AbstractFindUsagesService)
           │
           ├─ FindSymbolAtPositionAsync()
           │      └─ 位置のシンボル取得
           │
           ├─ FindReferencesSearchOptions.GetFeatureOptionsForStartingSymbol()
           │      └─ 検索オプション取得
           │
           └─ SymbolFinder.FindReferencesInCurrentProcessAsync()
                  │
                  └─ FindReferencesProgressAdapter（結果ストリーミング）
                         │
                         ├─ context.OnDefinitionFoundAsync()
                         │      └─ 定義を出力
                         │
                         └─ context.OnReferenceFoundAsync()
                                └─ 参照を出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| IFindUsagesService.cs | `src/Features/Core/Portable/FindUsages/IFindUsagesService.cs` | ソース | サービスインターフェース |
| AbstractFindUsagesService.cs | `src/Features/Core/Portable/FindUsages/AbstractFindUsagesService.cs` | ソース | 抽象基底クラス |
| AbstractFindUsagesService_FindReferences.cs | `src/Features/Core/Portable/FindUsages/AbstractFindUsagesService_FindReferences.cs` | ソース | 参照検索実装 |
| AbstractFindUsagesService_FindImplementations.cs | `src/Features/Core/Portable/FindUsages/AbstractFindUsagesService_FindImplementations.cs` | ソース | 実装検索実装 |
| DefinitionItem.cs | `src/Features/Core/Portable/FindUsages/DefinitionItem.cs` | ソース | 定義アイテムモデル |
| IFindUsagesContext.cs | `src/Features/Core/Portable/FindUsages/IFindUsagesContext.cs` | ソース | 結果出力コンテキスト |
| SourceReferenceItem.cs | `src/Features/Core/Portable/FindUsages/SourceReferenceItem.cs` | ソース | 参照アイテムモデル |
