# 機能設計書 140-プロジェクト管理

## 概要

本ドキュメントは、Roslynの「プロジェクト管理（ProjectManagement）」機能の設計を記述する。この機能は、プロジェクト内のフォルダ構造と名前空間情報を取得するサービスを提供する。

### 本機能の処理概要

この機能は、指定されたプロジェクト内のすべてのフォルダ一覧と、プロジェクトのデフォルト名前空間を取得するサービスを提供する。これらの情報は、新規ファイル作成時の配置先選択やコード生成時の名前空間決定に使用される。

**業務上の目的・背景**：
新規ファイル作成ダイアログや「Move to Namespace」リファクタリングなどでは、プロジェクト内のフォルダ構造や名前空間情報が必要となる。本機能により、これらの情報を統一的なAPIで取得できる。

**機能の利用シーン**：
- 新規ファイル作成時のフォルダ選択
- 「Move to Namespace」リファクタリング
- 「Extract Type to File」リファクタリング
- 名前空間に基づくコード生成

**主要な処理内容**：
1. プロジェクト内のフォルダ一覧取得
2. プロジェクトのデフォルト名前空間取得
3. フォルダパスから名前空間への変換（RootNamespace + フォルダパス）

**関連システム・外部連携**：
- Visual Studioプロジェクトシステム
- MSBuildプロパティ（RootNamespace）

**権限による制御**：
特に権限による制御はない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | 新規アイテム追加ダイアログ | 呼び出し元 | フォルダ選択 |

## 機能種別

ワークスペースサービス

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| projectId | ProjectId | Yes | プロジェクト識別子 | null不可 |
| workspace | Workspace | Yes | ワークスペース | null不可 |

### 入力データソース

- Workspaceのプロジェクト情報
- MSBuildプロジェクトプロパティ

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| folders | IList<string> | フォルダパス一覧 |
| defaultNamespace | string | デフォルト名前空間（なければ空文字列） |

### 出力先

- 呼び出し元への返却

## 処理フロー

### 処理シーケンス

```
1. GetFolders/GetDefaultNamespace呼び出し
   └─ 引数検証
2. プロジェクト情報取得
   └─ Workspace.CurrentSolutionから取得
3. 情報抽出
   └─ ドキュメントのフォルダ情報を収集
4. 結果返却
   └─ 一覧またはデフォルト名前空間を返却
```

### フローチャート

```mermaid
flowchart TD
    A[サービス呼び出し] --> B{メソッド種別}
    B -->|GetFolders| C[プロジェクト取得]
    B -->|GetDefaultNamespace| D[プロジェクト取得]
    C --> E[ドキュメントからフォルダ収集]
    D --> F[DefaultNamespaceプロパティ取得]
    E --> G[フォルダ一覧返却]
    F --> H{DefaultNamespaceあり?}
    H -->|Yes| I[DefaultNamespace返却]
    H -->|No| J[空文字列返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-140-01 | フォルダ重複排除 | 同じフォルダパスは1つのみ返却 | GetFolders |
| BR-140-02 | デフォルト名前空間不在時 | DefaultNamespaceがない場合は空文字列 | GetDefaultNamespace |

### 計算ロジック

名前空間計算（呼び出し元での利用）:
```
名前空間 = DefaultNamespace + "." + フォルダパス.Replace("/", ".")
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | プロジェクト未発見 | 指定されたProjectIdが存在しない | 空のリスト/空文字列を返却 |

### リトライ仕様

リトライは行わない。

## トランザクション仕様

トランザクション管理なし。

## パフォーマンス要件

- 読み取り専用操作のみ
- ワークスペースからの情報取得は軽量

## セキュリティ考慮事項

特になし。

## 備考

- Visual Studio以外の環境ではモック実装が使用される可能性あり
- DefaultNamespaceはMSBuildのRootNamespaceプロパティに対応

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: サービスインターフェースを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | IProjectManagementService.cs | `src/Features/Core/Portable/ProjectManagement/` | サービスインターフェース定義 |

**読解のコツ**:
- `GetFolders`：プロジェクト内のフォルダ一覧を取得
- `GetDefaultNamespace`：プロジェクトのデフォルト名前空間を取得

**主要構造**:
1. **13-14行目**: インターフェース定義（IWorkspaceServiceを実装）
2. **16行目**: GetFoldersメソッド - フォルダ一覧取得
3. **19行目**: GetDefaultNamespaceメソッド - デフォルト名前空間取得

#### Step 2: 利用箇所を理解する

このサービスは以下の機能で利用される：
- Move to Namespaceリファクタリング
- Extract Type to Fileリファクタリング
- 新規ファイル生成ダイアログ

### プログラム呼び出し階層図

```
IProjectManagementService
    │
    ├─ GetFolders(ProjectId, Workspace)
    │      └─ フォルダパス一覧を返却
    │
    └─ GetDefaultNamespace(Project, Workspace)
           └─ デフォルト名前空間または空文字列を返却

呼び出し元の例:
    │
    ├─ MoveToNamespaceCodeAction
    ├─ ExtractTypeToFileCodeAction
    └─ NewFileDialog
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ProjectId ───▶ GetFolders ───▶ IList<string>
    │              │
    │              └─ ドキュメント.Folders収集
    │
Workspace ───▶ GetDefaultNamespace ───▶ string
                   │
                   └─ Project.DefaultNamespace取得
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| IProjectManagementService.cs | `src/Features/Core/Portable/ProjectManagement/` | ソース | サービスインターフェース |
| VisualStudioProjectManagementService.cs | `src/VisualStudio/Core/Def/ProjectManagement/` | ソース | VS用実装（推定） |

### 補足情報

このインターフェースは比較的シンプルな設計であり、主に以下の情報を提供する：

1. **フォルダ一覧**: プロジェクト内のすべてのフォルダパスを一覧として返す。これは新規ファイル作成時のフォルダ選択UIで使用される。

2. **デフォルト名前空間**: プロジェクトのルート名前空間（RootNamespace MSBuildプロパティ）を返す。新規ファイル作成時のデフォルト名前空間計算に使用される。

Visual Studio固有の実装では、DTEプロジェクトシステムから情報を取得する可能性がある。
