# 機能設計書 141-埋め込み言語サポート

## 概要

本ドキュメントでは、Roslynの埋め込み言語サポート（EmbeddedLanguages）機能について設計を記載する。この機能は、C#やVBの文字列リテラル内に記述された正規表現、JSON、日付時刻フォーマットなどの埋め込み言語に対して、構文ハイライト、コード補完、診断などのIDE機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：
.NETアプリケーション開発において、正規表現パターン、JSONデータ、日付時刻フォーマット文字列などは頻繁に文字列リテラルとして記述される。しかし従来のIDEでは、これらは単なる文字列として扱われ、構文エラーの検出や補完支援が得られなかった。本機能により、開発者は埋め込み言語に対してもIDEの強力な支援を受けられ、バグの早期発見と生産性向上を実現できる。

**機能の利用シーン**：
- 正規表現パターンを`Regex`クラスのコンストラクタに渡す際のパターン記述
- `[StringSyntax("Regex")]`属性が付与されたパラメータへの引数指定
- JSON文字列の構文チェック
- `DateTime.ToString()`などのフォーマット文字列指定
- `// lang=regex`などのコメントによる明示的な言語指定

**主要な処理内容**：
1. 文字列リテラルトークンの検出と埋め込み言語の識別
2. `[StringSyntax]`属性またはコメントによる言語識別子の解析
3. 対象言語（Regex、JSON、DateTime）固有のパーサーによる構文解析
4. 構文ハイライト（分類）、コード補完、括弧マッチング、ドキュメントハイライトの提供

**関連システム・外部連携**：
- .NET BCLの`System.Diagnostics.CodeAnalysis.StringSyntaxAttribute`との連携
- Visual StudioエディタおよびLSPサーバーとの統合

**権限による制御**：
特定の権限による制御は行わない。すべてのユーザーが利用可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | コードエディタ | 主画面 | 埋め込み言語の構文ハイライト表示 |
| - | IntelliSenseメニュー | 結果表示画面 | コード補完候補の表示 |

## 機能種別

IDE機能 / コード分析 / コード補完

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| token | SyntaxToken | Yes | 対象の文字列リテラルトークン | 文字列リテラルまたは補間文字列テキストトークン |
| semanticModel | SemanticModel | Yes | セマンティック情報 | null不可 |
| languageIdentifiers | ImmutableArray<string> | Yes | 対象言語識別子リスト | 空でないこと |

### 入力データソース

- ソースコード内の文字列リテラルトークン
- `[StringSyntax]`属性のメタデータ
- `// lang=xxx`形式のコメント

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| identifier | string | 検出された言語識別子（regex, json, DateTime等） |
| options | IEnumerable<string> | コメントで指定されたオプション |
| classifications | ImmutableArray<ClassifiedSpan> | 構文ハイライト情報 |
| completionItems | ImmutableArray<CompletionItem> | コード補完候補 |

### 出力先

- エディタUI（構文ハイライト、補完メニュー）
- 診断メッセージ（エラー・警告）

## 処理フロー

### 処理シーケンス

```
1. トークン検出
   └─ 文字列リテラルまたは補間文字列テキストトークンを検出
2. 言語識別
   └─ コメント（lang=xxx）または[StringSyntax]属性から言語を判定
3. 対象言語プロバイダー取得
   └─ IEmbeddedLanguagesProviderから対応するIEmbeddedLanguageを取得
4. 言語固有処理
   └─ パース、分類、補完、診断などの処理を実行
5. 結果返却
   └─ 各IDE機能へ結果を提供
```

### フローチャート

```mermaid
flowchart TD
    A[文字列トークン検出] --> B{StringSyntax属性あり?}
    B -->|Yes| C[属性から言語識別子取得]
    B -->|No| D{lang=コメントあり?}
    D -->|Yes| E[コメントから言語識別子取得]
    D -->|No| F[処理終了]
    C --> G{対応言語プロバイダーあり?}
    E --> G
    G -->|Yes| H[言語固有パーサー実行]
    G -->|No| F
    H --> I[分類・補完・診断情報生成]
    I --> J[結果返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-141-01 | 言語識別優先順位 | コメント指定がStringSyntax属性より優先される | コメントと属性が両方存在する場合 |
| BR-141-02 | サポート言語 | Regex、JSON、DateTimeの3言語をサポート | 文字列リテラル解析時 |
| BR-141-03 | ローカル変数追跡 | ローカル変数に代入された文字列がStringSyntax属性付きAPIに渡される場合も検出 | 変数宣言から使用箇所まで追跡 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作は行わない。

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ERR-141-01 | 構文エラー | 埋め込み言語の構文が不正 | 診断メッセージとして表示 |
| ERR-141-02 | 無効な識別子 | 未サポートの言語識別子 | 処理をスキップ |

### リトライ仕様

リトライは行わない。

## トランザクション仕様

トランザクション管理は不要（読み取り専用処理）。

## パフォーマンス要件

- タイピング中のリアルタイム処理のため、各処理は100ms以内に完了すること
- 大規模な文字列リテラルでもパフォーマンス劣化を最小限に抑えること

## セキュリティ考慮事項

- ユーザーコードの文字列リテラルのみを解析対象とする
- 外部システムへのアクセスは行わない

## 備考

- 本機能は.NET 7以降で導入された`StringSyntaxAttribute`を活用している
- カスタム埋め込み言語の追加はMEFエクスポートにより拡張可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

埋め込み言語機能の基盤となるインターフェースとデータ構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | IEmbeddedLanguagesProvider.cs | `src/Features/Core/Portable/EmbeddedLanguages/IEmbeddedLanguagesProvider.cs` | 埋め込み言語プロバイダーのインターフェース定義（13-18行目） |
| 1-2 | IEmbeddedLanguage.cs | `src/Features/Core/Portable/EmbeddedLanguages/IEmbeddedLanguage.cs` | 個別言語サービスのインターフェース（12-23行目） |
| 1-3 | EmbeddedLanguageInfo.cs | `src/Features/Core/Portable/EmbeddedLanguages/EmbeddedLanguageInfo.cs` | 言語情報を保持する構造体（13-51行目） |

**読解のコツ**: `IEmbeddedLanguagesProvider`は`ILanguageService`を継承しており、言語サービスとしてMEFエクスポートされる。各`IEmbeddedLanguage`は特定の埋め込み言語（Regex、JSON等）の機能を提供する。

#### Step 2: エントリーポイントを理解する

言語検出とプロバイダー選択のロジックを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | EmbeddedLanguageDetector.cs | `src/Features/Core/Portable/EmbeddedLanguages/EmbeddedLanguageDetector.cs` | 埋め込み言語の検出ロジック（31-43行目でメイン判定） |
| 2-2 | AbstractEmbeddedLanguagesProvider.cs | `src/Features/Core/Portable/EmbeddedLanguages/AbstractEmbeddedLanguagesProvider.cs` | C#/VB用プロバイダーの抽象基底クラス（15-34行目） |

**主要処理フロー**:
1. **31-43行目**: `IsEmbeddedLanguageToken`メソッドで文字列トークンが埋め込み言語かどうか判定
2. **58-78行目**: `IsEmbeddedLanguageTokenWorker`で実際の検出処理を実行
3. **80-114行目**: `HasLanguageComment`でコメントベースの言語指定を検出
4. **276-329行目**: `IsEmbeddedLanguageStringLiteralToken`でStringSyntax属性を検出

#### Step 3: 正規表現サポートを理解する

最も使用頻度の高いRegex埋め込み言語の実装を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | RegexEmbeddedLanguage.cs | `src/Features/Core/Portable/EmbeddedLanguages/RegularExpressions/LanguageServices/RegexEmbeddedLanguage.cs` | Regex用埋め込み言語実装（14-47行目） |
| 3-2 | RegexLanguageDetector.cs | `src/Features/Core/Portable/EmbeddedLanguages/RegularExpressions/LanguageServices/RegexLanguageDetector.cs` | Regex検出ロジック |
| 3-3 | RegexParser.cs | `src/Features/Core/Portable/EmbeddedLanguages/RegularExpressions/RegexParser.cs` | 正規表現パーサー |

**主要処理フロー**:
- **22-31行目**: `RegexEmbeddedLanguage`コンストラクタで`RegexEmbeddedCompletionProvider`を初期化
- **33-43行目**: `TryGetTreeAndTokenAtPosition`でRegex構文木を取得

#### Step 4: JSON/DateTime サポートを理解する

他の埋め込み言語の実装パターンを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | JsonEmbeddedLanguage.cs | `src/Features/Core/Portable/EmbeddedLanguages/Json/LanguageServices/JsonEmbeddedLanguage.cs` | JSON用埋め込み言語（10-14行目、補完なし） |
| 4-2 | DateAndTimeEmbeddedLanguage.cs | `src/Features/Core/Portable/EmbeddedLanguages/DateAndTime/LanguageServices/DateAndTimeEmbeddedLanguage.cs` | DateTime用埋め込み言語 |

### プログラム呼び出し階層図

```
IEmbeddedLanguagesProvider (インターフェース)
    │
    └─ AbstractEmbeddedLanguagesProvider (抽象基底)
           │
           ├─ EmbeddedLanguageInfo (言語情報)
           │
           └─ Languages (IEmbeddedLanguage配列)
                  │
                  ├─ RegexEmbeddedLanguage
                  │      ├─ RegexLanguageDetector
                  │      ├─ RegexParser
                  │      └─ RegexEmbeddedCompletionProvider
                  │
                  ├─ JsonEmbeddedLanguage
                  │      ├─ JsonLanguageDetector
                  │      └─ JsonParser
                  │
                  └─ DateAndTimeEmbeddedLanguage
                         ├─ DateAndTimeLanguageDetector
                         └─ DateAndTimeEmbeddedCompletionProvider

EmbeddedLanguageDetector (言語検出)
    │
    ├─ HasLanguageComment() → コメントから検出
    ├─ IsEmbeddedLanguageStringLiteralToken_Direct() → StringSyntax属性から検出
    └─ IsLocalConsumedByApiWithStringSyntaxAttribute() → ローカル変数追跡
```

### データフロー図

```
[入力]                           [処理]                              [出力]

文字列トークン ───────▶ EmbeddedLanguageDetector ───────▶ 言語識別子/オプション
                              │
                              ▼
                        IEmbeddedLanguage
                              │
        ┌─────────────────────┼─────────────────────┐
        ▼                     ▼                     ▼
    RegexParser          JsonParser         DateTimeParser
        │                     │                     │
        ▼                     ▼                     ▼
    RegexTree              JsonTree           DateTimeTree
        │                     │                     │
        └─────────────────────┼─────────────────────┘
                              │
                              ▼
                    分類/補完/診断情報
                              │
                              ▼
                         エディタUI
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| IEmbeddedLanguagesProvider.cs | `src/Features/Core/Portable/EmbeddedLanguages/` | インターフェース | プロバイダーの契約定義 |
| IEmbeddedLanguage.cs | `src/Features/Core/Portable/EmbeddedLanguages/` | インターフェース | 個別言語サービスの契約 |
| AbstractEmbeddedLanguagesProvider.cs | `src/Features/Core/Portable/EmbeddedLanguages/` | ソース | プロバイダー基底クラス |
| EmbeddedLanguageDetector.cs | `src/Features/Core/Portable/EmbeddedLanguages/` | ソース | 言語検出ロジック |
| EmbeddedLanguageInfo.cs | `src/Features/Core/Portable/EmbeddedLanguages/` | ソース | 言語情報構造体 |
| EmbeddedLanguageCommentDetector.cs | `src/Features/Core/Portable/EmbeddedLanguages/` | ソース | コメント解析 |
| RegexEmbeddedLanguage.cs | `src/Features/Core/Portable/EmbeddedLanguages/RegularExpressions/LanguageServices/` | ソース | Regex言語実装 |
| RegexParser.cs | `src/Features/Core/Portable/EmbeddedLanguages/RegularExpressions/` | ソース | 正規表現パーサー |
| RegexClassifier.cs | `src/Features/Core/Portable/EmbeddedLanguages/RegularExpressions/LanguageServices/` | ソース | Regex構文ハイライト |
| JsonEmbeddedLanguage.cs | `src/Features/Core/Portable/EmbeddedLanguages/Json/LanguageServices/` | ソース | JSON言語実装 |
| JsonParser.cs | `src/Features/Core/Portable/EmbeddedLanguages/Json/` | ソース | JSONパーサー |
| DateAndTimeEmbeddedLanguage.cs | `src/Features/Core/Portable/EmbeddedLanguages/DateAndTime/LanguageServices/` | ソース | DateTime言語実装 |
| IEmbeddedLanguageClassifier.cs | `src/Features/Core/Portable/EmbeddedLanguages/Classification/` | インターフェース | 分類サービス契約 |
