# 機能設計書 142-インテントサポート

## 概要

本ドキュメントでは、Roslynのインテントサポート（Intents）機能について設計を記載する。この機能は、ユーザーの意図（Intent）に基づいてコード生成・編集を行うためのフレームワークを提供し、AIアシスタントやスマートエディタ機能との統合を可能にする。

### 本機能の処理概要

**業務上の目的・背景**：
現代のIDE開発では、ユーザーの意図を理解して自動的にコードを生成・編集する機能の需要が高まっている。GitHub CopilotなどのAIアシスタントや、Visual Studioのスマート編集機能がこれに該当する。本機能は、ユーザーの意図（例：「コンストラクタを生成したい」「パラメータを追加したい」）を受け取り、それに対応するコード変更を計算するための統一的なフレームワークを提供する。

**機能の利用シーン**：
- AI支援コード生成でユーザーが「コンストラクタを生成」と指示した場合
- エディタ上でパラメータ追加の意図を示すジェスチャーを行った場合
- 名前変更（Rename）操作を意図として処理する場合
- パラメータ削除操作を意図ベースで実行する場合

**主要な処理内容**：
1. インテント識別子（GenerateConstructor、AddConstructorParameter等）の受信
2. 対応するIIntentProviderの検索と選択
3. 前後のドキュメント状態を比較した編集計算
4. IntentProcessorResultとして変更ドキュメントセットを返却

**関連システム・外部連携**：
- GitHub Copilot連携（AIからのインテント受信）
- Visual Studio/VS Codeエディタとの統合
- Language Server Protocol (LSP)経由でのリクエスト処理

**権限による制御**：
特定の権限による制御は行わない。インテントプロバイダーの登録はMEFにより制御される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | コードエディタ | 主画面 | インテントに基づくコード編集の適用先 |
| - | AIアシスタントUI | 参照画面 | インテント発行元 |

## 機能種別

コード生成 / リファクタリング基盤 / AI連携

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| priorDocument | Document | Yes | 編集前のドキュメント | null不可 |
| priorSelection | TextSpan | Yes | 編集前の選択範囲 | 有効なスパン |
| currentDocument | Document | Yes | 編集後のドキュメント | null不可 |
| intentDataProvider | IntentDataProvider | Yes | インテントに付随するデータ | シリアライズされたJSON |

### 入力データソース

- AIアシスタントからのインテントリクエスト
- エディタからのユーザーアクション
- LSP経由のリクエスト

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Solution | Solution | 変更後のソリューション |
| ChangedDocuments | ImmutableArray<DocumentId> | 変更されたドキュメントのID配列 |
| Title | string | インテント結果のタイトル |
| ActionName | string | サブアクションのメタデータ識別子 |

### 出力先

- エディタへの変更適用
- ユーザーへの変更プレビュー表示

## 処理フロー

### 処理シーケンス

```
1. インテント受信
   └─ インテント識別子とデータをIntentDataProviderから受信
2. プロバイダー検索
   └─ IntentProviderAttributeに基づいて対応するIIntentProviderを取得
3. インテント処理
   └─ ComputeIntentAsyncで前後のドキュメント状態から変更を計算
4. 結果生成
   └─ IntentProcessorResultとして変更情報を構築
5. 結果返却
   └─ 呼び出し元にImmutableArray<IntentProcessorResult>を返却
```

### フローチャート

```mermaid
flowchart TD
    A[インテントリクエスト受信] --> B{インテント識別子の確認}
    B -->|有効| C[対応するIIntentProvider取得]
    B -->|無効| D[空の結果を返却]
    C --> E{プロバイダー存在?}
    E -->|Yes| F[ComputeIntentAsync実行]
    E -->|No| D
    F --> G[前後ドキュメント比較]
    G --> H[変更セット計算]
    H --> I[IntentProcessorResult生成]
    I --> J[結果配列返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-142-01 | 既知インテント | GenerateConstructor、AddConstructorParameter、Rename、DeleteParameterをサポート | WellKnownIntentsに定義 |
| BR-142-02 | プロバイダー選択 | IntentProviderAttributeのIntentNameプロパティでマッチング | インテント処理時 |
| BR-142-03 | データデシリアライズ | IntentDataProviderがJSONをジェネリック型Tにデシリアライズ | インテントデータ処理時 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作は行わない。

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ERR-142-01 | デシリアライズエラー | インテントデータのJSON解析失敗 | nullを返却してエラーログ記録 |
| ERR-142-02 | プロバイダー未登録 | 対応するプロバイダーが見つからない | 空の結果を返却 |

### リトライ仕様

リトライは行わない。

## トランザクション仕様

トランザクション管理は不要（ソリューション操作はイミュータブル）。

## パフォーマンス要件

- インテント処理は500ms以内に完了すること
- 複数ドキュメントの変更も効率的に処理すること

## セキュリティ考慮事項

- 外部からのインテントデータは信頼できるソースからのみ受け付ける
- デシリアライズ時のセキュリティ対策（型制限等）

## 備考

- 本機能はCopilot連携やスマートエディタ機能の基盤として使用される
- 新しいインテントはIIntentProvider実装とIntentProviderAttribute付与で追加可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

インテント機能の基本的なデータ構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | WellKnownIntents.cs | `src/Features/Core/Portable/Intents/WellKnownIntents.cs` | サポートされるインテント識別子の定義（10-16行目） |
| 1-2 | IntentResult.cs | `src/Features/Core/Portable/Intents/IntentResult.cs` | インテント処理結果の構造体（13-35行目） |
| 1-3 | IntentDataProvider.cs | `src/Features/Core/Portable/Intents/IntentDataProvider.cs` | インテントデータのデシリアライズ（12-42行目） |

**読解のコツ**: `WellKnownIntents`は定数文字列として定義されており、プロバイダー属性のマッチングに使用される。`IntentProcessorResult`はreadonlystructで、イミュータブルな結果を表現する。

#### Step 2: インターフェースを理解する

プロバイダーの契約を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | IIntentProvider.cs | `src/Features/Core/Portable/Intents/IIntentProvider.cs` | プロバイダーインターフェース（12-20行目） |
| 2-2 | IntentProviderAttribute.cs | `src/Features/Core/Portable/Intents/IntentProviderAttribute.cs` | プロバイダー登録用属性 |
| 2-3 | IIntentProviderMetadata.cs | `src/Features/Core/Portable/Intents/IIntentProviderMetadata.cs` | メタデータインターフェース |

**主要処理フロー**:
1. **14-19行目**: `ComputeIntentAsync`メソッドが中心的なAPI。前後のドキュメントと選択範囲を受け取り、変更セットを計算

#### Step 3: データプロバイダーを理解する

インテントに付随するデータの処理方法を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | IntentDataProvider.cs | `src/Features/Core/Portable/Intents/IntentDataProvider.cs` | JSONデシリアライズの実装（27-41行目） |

**主要処理フロー**:
- **15-23行目**: `JsonSerializerOptions`の設定（CamelCase、Enum文字列変換）
- **27-41行目**: `GetIntentData<T>`メソッドでジェネリック型へのデシリアライズ
- **35-37行目**: エラー時はFatalError.ReportAndCatchでログ記録後nullを返却

### プログラム呼び出し階層図

```
[外部システム（Copilot/エディタ）]
    │
    ▼
IntentDataProvider (インテントデータ受信)
    │
    ├─ _serializedIntentData (JSON文字列)
    │
    └─ GetIntentData<T>() → デシリアライズ
           │
           ▼
    IIntentProvider (インテント処理)
           │
           ├─ priorDocument (編集前ドキュメント)
           ├─ priorSelection (編集前選択範囲)
           ├─ currentDocument (編集後ドキュメント)
           │
           └─ ComputeIntentAsync()
                  │
                  ▼
           IntentProcessorResult
                  │
                  ├─ Solution (変更後ソリューション)
                  ├─ ChangedDocuments (変更ドキュメントID)
                  ├─ Title (結果タイトル)
                  └─ ActionName (アクション識別子)
```

### データフロー図

```
[入力]                           [処理]                              [出力]

インテント識別子 ───────▶ IntentProviderAttribute ───────▶ IIntentProvider選択
       +                     でマッチング
インテントデータ(JSON)
       │
       ▼
IntentDataProvider ───────▶ GetIntentData<T>() ───────▶ 型付きデータ
       │
       ▼
前後ドキュメント ───────▶ ComputeIntentAsync() ───────▶ IntentProcessorResult[]
                              │
                              ▼
                         Solution変更
                              │
                              ▼
                         エディタ適用
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| IIntentProvider.cs | `src/Features/Core/Portable/Intents/` | インターフェース | プロバイダーの契約定義 |
| IntentProviderAttribute.cs | `src/Features/Core/Portable/Intents/` | ソース | プロバイダー登録用属性 |
| IIntentProviderMetadata.cs | `src/Features/Core/Portable/Intents/` | インターフェース | メタデータインターフェース |
| IntentDataProvider.cs | `src/Features/Core/Portable/Intents/` | ソース | インテントデータのデシリアライズ |
| IntentResult.cs | `src/Features/Core/Portable/Intents/` | ソース | 処理結果構造体 |
| WellKnownIntents.cs | `src/Features/Core/Portable/Intents/` | ソース | 既知インテント識別子定義 |
