# 機能設計書 143-セマンティック検索機能

## 概要

本ドキュメントでは、Roslynのセマンティック検索（SemanticSearch）機能について設計を記載する。この機能は、Roslynのセマンティック解析能力を活用して、コードベース全体からシンボルやパターンを検索するための高度な検索機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：
大規模なコードベースにおいて、単純なテキスト検索では不十分な場面が多い。例えば、「特定のインターフェースを実装しているすべてのクラス」や「特定の属性が付与されているメソッド」といった意味的な検索が必要となる。本機能は、C#やVBのセマンティック情報を活用して、このような高度な検索クエリを実行可能にする。

**機能の利用シーン**：
- コードベース全体から特定パターンのシンボルを検索
- リファクタリング前の影響範囲調査
- コード品質監査での特定パターン検出
- Copilot連携によるAI支援コード検索

**主要な処理内容**：
1. 検索クエリ（トップレベルC#コード）のコンパイル
2. ソリューション全体に対するクエリ実行
3. 検索結果（DefinitionItem）のストリーミング返却
4. OOP（Out-of-Process）サービスとしてのリモート実行

**関連システム・外部連携**：
- Visual Studio/VS Codeエディタとの統合
- RemoteHostClientを通じたOOPサービス連携
- Copilot連携（SemanticSearchCopilotContext）

**権限による制御**：
特定の権限による制御は行わない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | 検索結果ウィンドウ | 結果表示画面 | 検索結果の表示とナビゲーション |
| - | コードエディタ | 参照画面 | 検索結果からのナビゲーション先 |

## 機能種別

検索機能 / セマンティック解析 / リモートサービス

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| query | string | Yes | 検索クエリ（C#トップレベルコード） | 空でないこと |
| targetLanguage | string | No | 対象言語（C#/VB、null=全言語） | 有効な言語名 |
| referenceAssembliesDir | string | Yes | 参照アセンブリディレクトリ | 有効なパス |
| options | QueryExecutionOptions | Yes | 実行オプション | null不可 |

### 入力データソース

- ユーザー入力の検索クエリ
- ソリューション内のすべてのドキュメント
- 参照アセンブリ（SemanticSearchRefs）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| QueryId | CompiledQueryId | コンパイル済みクエリのID |
| CompilationErrors | ImmutableArray<QueryCompilationError> | コンパイルエラー配列 |
| ErrorMessage | string | 実行エラーメッセージ |
| ExecutionTime | TimeSpan | 実行時間 |
| DefinitionItems | DefinitionItem[] | 検索結果（ストリーミング） |

### 出力先

- 検索結果ウィンドウへのストリーミング表示
- コード分類情報の提供

## 処理フロー

### 処理シーケンス

```
1. クエリコンパイル
   └─ CompileQueryでクエリをコンパイルし、CompiledQueryIdを取得
2. クエリ実行
   └─ ExecuteQueryAsyncでソリューションに対してクエリを実行
3. 結果通知
   └─ ISemanticSearchResultsObserver経由で結果をストリーミング
4. クエリ破棄
   └─ 実行後またはキャンセル時にDiscardQueryでリソース解放
```

### フローチャート

```mermaid
flowchart TD
    A[検索クエリ入力] --> B[CompileQuery]
    B --> C{コンパイル成功?}
    C -->|Yes| D[ExecuteQueryAsync]
    C -->|No| E[CompilationErrors返却]
    D --> F[OnDefinitionFoundコールバック]
    F --> G{結果あり?}
    G -->|Yes| H[結果をUIに表示]
    G -->|No| I[検索完了]
    H --> G
    I --> J[DiscardQuery]
    E --> J
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-143-01 | クエリ形式 | トップレベルC#コードとして記述 | クエリ入力時 |
| BR-143-02 | リモート実行 | OOPサービスで実行しメモリ効率を確保 | クエリ実行時 |
| BR-143-03 | リソース解放 | 実行しない場合はDiscardQueryで明示的に解放 | クエリコンパイル後 |

### 計算ロジック

特になし

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作は行わない。

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ERR-143-01 | コンパイルエラー | クエリの構文/セマンティックエラー | CompilationErrorsで詳細を返却 |
| ERR-143-02 | 実行エラー | クエリ実行時の例外 | ErrorMessageで詳細を返却 |
| ERR-143-03 | ユーザーコード例外 | クエリ内のユーザーコードが例外発生 | OnUserCodeExceptionで通知 |

### リトライ仕様

リトライは行わない。

## トランザクション仕様

トランザクション管理は不要（読み取り専用処理）。

## パフォーマンス要件

- クエリコンパイルは1秒以内に完了すること
- 大規模ソリューションでもメモリ使用量を抑制（OOP実行）
- 結果はストリーミングで即時表示すること

## セキュリティ考慮事項

- ユーザー入力クエリの実行は隔離されたプロセスで行う
- 参照アセンブリは信頼されたディレクトリからのみロード

## 備考

- SemanticSearchWorkspaceは専用のワークスペース種別（WorkspaceKind.SemanticSearch）を持つ
- Copilot連携でAI生成クエリの実行も可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

セマンティック検索の結果とクエリ構造を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ExecuteQueryResult.cs | `src/Features/Core/Portable/SemanticSearch/ExecuteQueryResult.cs` | 実行結果とコンパイル結果の構造体（23-50行目） |
| 1-2 | QueryExecutionOptions.cs | `src/Features/Core/Portable/SemanticSearch/QueryExecutionOptions.cs` | クエリ実行オプション |

**読解のコツ**: `ExecuteQueryResult`と`CompileQueryResult`はDataContract属性付きのrecord structで、シリアライズ可能。`CompiledQueryId`はコンパイル済みクエリを識別するラッパー型。

#### Step 2: サービスインターフェースを理解する

クエリサービスの契約を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ISemanticSearchQueryService.cs | `src/Features/Core/Portable/SemanticSearch/ISemanticSearchQueryService.cs` | ローカルクエリサービスインターフェース（12-48行目） |
| 2-2 | IRemoteSemanticSearchService.cs | `src/Features/Core/Portable/SemanticSearch/IRemoteSemanticSearchService.cs` | リモート（OOP）サービスインターフェース（20-37行目） |

**主要処理フロー**:
1. **20-26行目**: `CompileQuery`でクエリをコンパイル
2. **35-41行目**: `ExecuteQueryAsync`でソリューションに対してクエリ実行
3. **47行目**: `DiscardQuery`でコンパイル済みクエリを破棄

#### Step 3: ワークスペースを理解する

セマンティック検索専用ワークスペースの実装を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SemanticSearchWorkspace.cs | `src/Features/Core/Portable/SemanticSearch/SemanticSearchWorkspace.cs` | 専用ワークスペース実装（14-53行目） |
| 3-2 | ISemanticSearchSolutionService.cs | `src/Features/Core/Portable/SemanticSearch/ISemanticSearchSolutionService.cs` | ソリューションサービス |

**主要処理フロー**:
- **21行目**: `ReferenceAssembliesDirectory`で参照アセンブリの場所を定義
- **29-47行目**: `UpdateQueryDocumentAsync`でクエリドキュメントを更新

#### Step 4: リモートプロキシを理解する

OOPサービスとの連携を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | IRemoteSemanticSearchService.cs | `src/Features/Core/Portable/SemanticSearch/IRemoteSemanticSearchService.cs` | RemoteSemanticSearchServiceProxyの実装（39-204行目） |

**主要処理フロー**:
- **164-177行目**: `CompileQueryAsync`でリモートコンパイル
- **189-203行目**: `ExecuteQueryAsync`でリモート実行とコールバック

### プログラム呼び出し階層図

```
[ユーザー/Copilot]
    │
    ▼
ISemanticSearchQueryService (ローカルインターフェース)
    │
    ├─ CompileQuery() → CompileQueryResult
    │      └─ CompiledQueryId
    │
    ├─ ExecuteQueryAsync() → ExecuteQueryResult
    │      │
    │      └─ ISemanticSearchResultsObserver
    │             ├─ OnDefinitionFoundAsync()
    │             ├─ OnUserCodeExceptionAsync()
    │             ├─ AddItemsAsync()
    │             └─ ItemsCompletedAsync()
    │
    └─ DiscardQuery()

RemoteSemanticSearchServiceProxy
    │
    └─ IRemoteSemanticSearchService (リモートインターフェース)
           │
           ├─ CompileQueryAsync()
           ├─ ExecuteQueryAsync()
           └─ DiscardQueryAsync()
                  │
                  ▼
           ServerCallback
                  ├─ OnDefinitionFoundAsync()
                  ├─ OnUserCodeExceptionAsync()
                  └─ OnDocumentUpdatedAsync()
```

### データフロー図

```
[入力]                           [処理]                              [出力]

検索クエリ(C#) ───────▶ CompileQuery ───────▶ CompiledQueryId
                              │                    +CompilationErrors
                              ▼
                    SemanticSearchWorkspace
                              │
ソリューション ───────▶ ExecuteQueryAsync ───────▶ DefinitionItem[]
       +                      │                    (ストリーミング)
参照アセンブリ                │
                              ▼
                    ISemanticSearchResultsObserver
                              │
                              ▼
                         検索結果UI
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ISemanticSearchQueryService.cs | `src/Features/Core/Portable/SemanticSearch/` | インターフェース | ローカルクエリサービス契約 |
| IRemoteSemanticSearchService.cs | `src/Features/Core/Portable/SemanticSearch/` | インターフェース | リモートサービス契約 |
| ExecuteQueryResult.cs | `src/Features/Core/Portable/SemanticSearch/` | ソース | 実行結果構造体 |
| QueryExecutionOptions.cs | `src/Features/Core/Portable/SemanticSearch/` | ソース | 実行オプション |
| SemanticSearchWorkspace.cs | `src/Features/Core/Portable/SemanticSearch/` | ソース | 専用ワークスペース |
| ISemanticSearchSolutionService.cs | `src/Features/Core/Portable/SemanticSearch/` | インターフェース | ソリューションサービス |
| ISemanticSearchResultsObserver.cs | `src/Features/Core/Portable/SemanticSearch/` | インターフェース | 結果オブザーバー |
| SemanticSearchCopilotContext.cs | `src/Features/Core/Portable/SemanticSearch/` | ソース | Copilot連携コンテキスト |
| SearchExceptionDefinitionItem.cs | `src/Features/Core/Portable/SemanticSearch/` | ソース | 例外結果アイテム |
| SearchCompilationFailureDefinitionItem.cs | `src/Features/Core/Portable/SemanticSearch/` | ソース | コンパイル失敗結果アイテム |
| SemanticSearchDefinitionItemFactory.cs | `src/Features/Core/Portable/SemanticSearch/` | ソース | 結果アイテムファクトリ |
| SemanticSearchDocumentSupportsFeatureService.cs | `src/Features/Core/Portable/SemanticSearch/` | ソース | 機能サポートサービス |
