# 機能設計書 15-ドキュメントハイライト

## 概要

本ドキュメントは、Roslynの「ドキュメントハイライト」（Document Highlighting）機能の設計について記述する。現在のドキュメント内でシンボルの定義と参照をハイライト表示するIDE機能である。

### 本機能の処理概要

ドキュメントハイライト機能は、カーソル位置のシンボルに関連するすべての定義と参照を、現在のドキュメント（および関連ドキュメント）内でハイライト表示する機能である。

**業務上の目的・背景**：コードを読む際に、特定の変数やメソッドがドキュメント内でどこで使われているかを視覚的に把握できることで、コードの理解が容易になる。特に、変数の読み取り/書き込みを区別して表示することで、データフローの理解が促進される。

**機能の利用シーン**：
- 変数がどこで使われているか確認したいとき
- メソッド呼び出し箇所をすべて確認したいとき
- 読み取りと書き込みを区別して確認したいとき
- 正規表現やSQL等の埋め込み言語内でのハイライト

**主要な処理内容**：
1. カーソル位置のシンボル特定
2. ドキュメント内の参照検索
3. 定義/参照/書き込み参照の分類
4. ハイライトスパンの生成
5. 埋め込み言語のハイライト対応

**関連システム・外部連携**：
- セマンティック解析エンジン（SymbolFinder）
- 埋め込み言語ハイライターサービス
- LSP（Language Server Protocol）
- OOP（Out-of-Process）リモート実行

**権限による制御**：特になし。すべての開発者が利用可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | エディタ | 主画面 | シンボルのハイライト表示 |

## 機能種別

リアルタイムコード解析 / UI情報提供

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| document | Document | Yes | 対象ドキュメント | null不可 |
| position | int | Yes | カーソル位置 | 0以上 |
| documentsToSearch | IImmutableSet\<Document\> | Yes | 検索対象ドキュメント | null不可 |
| options | HighlightingOptions | Yes | ハイライトオプション | - |
| cancellationToken | CancellationToken | Yes | キャンセルトークン | - |

### 入力データソース

- エディタからのカーソル位置情報
- ドキュメントのセマンティックモデル

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| highlights | ImmutableArray\<DocumentHighlights\> | ドキュメントごとのハイライトスパン |

### DocumentHighlights

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Document | Document | 対象ドキュメント |
| HighlightSpans | ImmutableArray\<HighlightSpan\> | ハイライトスパンのリスト |

### HighlightSpan

| 項目名 | 型 | 説明 |
|--------|-----|------|
| TextSpan | TextSpan | テキストスパン |
| Kind | HighlightSpanKind | スパン種別（None/Definition/Reference/WrittenReference） |

### 出力先

- エディタ（ハイライト表示）

## 処理フロー

### 処理シーケンス

```
1. 埋め込み言語チェック
   └─ 正規表現やSQL等の埋め込み言語かチェック
2. シンボル取得
   └─ カーソル位置のシンボルをセマンティック解析で取得
3. 参照検索
   └─ SymbolFinder.FindReferencesInDocumentsInCurrentProcessAsync
4. スパン生成
   └─ 定義/参照/書き込み参照を分類してスパン生成
5. 結果返却
   └─ DocumentHighlightsを返却
```

### フローチャート

```mermaid
flowchart TD
    A[ハイライト要求] --> B[埋め込み言語チェック]
    B --> C{埋め込み言語?}
    C -->|Yes| D[埋め込み言語ハイライト]
    C -->|No| E[シンボル取得]
    D --> Z[終了]
    E --> F{シンボル発見?}
    F -->|No| Z
    F -->|Yes| G[ShouldConsiderSymbol]
    G -->|No| Z
    G -->|Yes| H[参照検索]
    H --> I[スパン生成]
    I --> J[結果返却]
    J --> Z
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 定義ハイライト | 定義はDefinitionとしてハイライト | 定義位置 |
| BR-02 | 参照ハイライト | 読み取り参照はReferenceとしてハイライト | 読み取り参照 |
| BR-03 | 書き込みハイライト | 書き込み参照はWrittenReferenceとしてハイライト | 書き込み参照 |
| BR-04 | 匿名関数除外 | 匿名関数メソッドはハイライト対象外 | MethodKind.AnonymousFunction |
| BR-05 | アクセサ除外 | プロパティ/イベントアクセサはハイライト対象外 | PropertyGet/Set等 |
| BR-06 | エイリアスフィルタ | エイリアスシンボルは元のシンボルのみフィルタ | IAliasSymbol |
| BR-07 | 位置交差チェック | ハイライトが位置と交差しない場合は結果なし | ユーザー位置との交差 |

### 計算ロジック

特になし

## データベース操作仕様

該当なし（メモリ内処理のみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | シンボル未解決 | カーソル位置にシンボルがない | 空結果を返却 |
| - | シンボル除外 | ShouldConsiderSymbol=false | 空結果を返却 |

### リトライ仕様

特になし

## トランザクション仕様

該当なし（読み取り専用処理）

## パフォーマンス要件

- レスポンス時間: リアルタイム（カーソル移動に追従）
- Nullability解析は無効化してパフォーマンス向上

## セキュリティ考慮事項

特になし（ローカルコード解析のみ）

## 備考

- C#とVBで共通の基盤を使用
- 埋め込み言語（正規表現、SQL等）のハイライトもサポート

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: インターフェースとデータ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | IDocumentHighlightsService.cs | `src/Features/Core/Portable/DocumentHighlighting/IDocumentHighlightsService.cs` | HighlightSpanKind列挙型、HighlightSpan構造体、DocumentHighlights構造体、IDocumentHighlightsServiceインターフェースを理解する |

**主要処理フロー**:
- **14-20行目**: HighlightSpanKind - None/Definition/Reference/WrittenReference
- **22-36行目**: HighlightSpan - TextSpanとKindを保持
- **38-42行目**: DocumentHighlights - ドキュメントとスパンリストを保持
- **48-52行目**: IDocumentHighlightsService.GetDocumentHighlightsAsync

#### Step 2: 抽象基底クラスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AbstractDocumentHighlightsService.cs | `src/Features/Core/Portable/DocumentHighlighting/AbstractDocumentHighlightsService.cs` | 実装クラス。OOP呼び出し、埋め込み言語対応、シンボル検索を理解する |

**主要処理フロー**:
- **36-61行目**: GetDocumentHighlightsAsync - メイン処理。OOP実行を試み、失敗時はローカル実行
- **63-92行目**: GetDocumentHighlightsInCurrentProcessAsync - ローカル実行。埋め込み言語チェック後、シンボル検索
- **94-109行目**: TryGetEmbeddedLanguageHighlights - 埋め込み言語ハイライト
- **111-135行目**: GetTagsForReferencedSymbolAsync - シンボルの参照検索
- **137-159行目**: ShouldConsiderSymbol - ハイライト対象判定（匿名関数、アクセサを除外）
- **161-198行目**: FilterAndCreateSpansAsync - 結果フィルタリングとスパン生成
- **206-278行目**: CreateSpansAsync - スパン生成の詳細実装
- **280-292行目**: ShouldIncludeDefinition - 定義を含めるか判定（名前空間、スクリプトクラスを除外）

### プログラム呼び出し階層図

```
IDocumentHighlightsService.GetDocumentHighlightsAsync()
    │ (AbstractDocumentHighlightsService)
    │
    ├─ RemoteHostClient.TryInvokeAsync() [OOP]
    │      └─ IRemoteDocumentHighlightsService.GetDocumentHighlightsAsync()
    │
    └─ GetDocumentHighlightsInCurrentProcessAsync() [ローカル]
           │
           ├─ TryGetEmbeddedLanguageHighlights()
           │      └─ 埋め込み言語ハイライター
           │
           ├─ SymbolFinder.FindSymbolAtPositionAsync()
           │      └─ シンボル取得
           │
           └─ GetTagsForReferencedSymbolAsync()
                  │
                  ├─ ShouldConsiderSymbol()
                  │      └─ 匿名関数、アクセサを除外
                  │
                  └─ SymbolFinder.FindReferencesInDocumentsInCurrentProcessAsync()
                         └─ FilterAndCreateSpansAsync()
                                └─ CreateSpansAsync()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| IDocumentHighlightsService.cs | `src/Features/Core/Portable/DocumentHighlighting/IDocumentHighlightsService.cs` | ソース | インターフェースとデータ構造 |
| AbstractDocumentHighlightsService.cs | `src/Features/Core/Portable/DocumentHighlighting/AbstractDocumentHighlightsService.cs` | ソース | 抽象基底クラス |
| HighlightingOptions.cs | `src/Features/Core/Portable/DocumentHighlighting/HighlightingOptions.cs` | ソース | オプション設定 |
| IEmbeddedLanguageDocumentHighlighter.cs | `src/Features/Core/Portable/EmbeddedLanguages/DocumentHighlighting/IEmbeddedLanguageDocumentHighlighter.cs` | ソース | 埋め込み言語ハイライター |
