# 機能設計書 16-ナビゲーション

## 概要

本ドキュメントは、Roslynの「ナビゲーション」（Navigation）機能の設計について記述する。シンボルの定義場所やその型の定義場所へナビゲートするための基盤サービスである。

### 本機能の処理概要

ナビゲーション機能は、シンボルまたはシンボルの型の定義場所を取得し、リッチな表示情報とともにナビゲーション可能なアイテムを提供する基盤サービスである。Go To DefinitionやGo To Type Definitionなどの機能で使用される。

**業務上の目的・背景**：コードナビゲーションは開発者の生産性に直結する基本機能である。この機能は、シンボル解析とナビゲーション先の取得を抽象化し、様々なナビゲーション機能で再利用可能な基盤を提供する。

**機能の利用シーン**：
- Go To Definition（定義へ移動）
- Go To Type Definition（型定義へ移動）
- Ctrl+クリックナビゲーション
- シンボルプロバイダからのナビゲーション

**主要な処理内容**：
1. カーソル位置のシンボル特定
2. Frozen Partial Semanticsによる高速解析の試行
3. シンボルのソース定義検索
4. 優先シンボルの選択
5. NavigableItemの生成

**関連システム・外部連携**：
- セマンティック解析エンジン（SymbolFinder）
- Go To Definitionサービス
- 定義ロケーションサービス

**権限による制御**：特になし。すべての開発者が利用可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | エディタ | 主画面 | ナビゲーション実行 |

## 機能種別

ナビゲーション基盤 / シンボル解析

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| document | Document | Yes | 対象ドキュメント | null不可 |
| position | int | Yes | カーソル位置 | 0以上 |
| forSymbolType | bool | No | 型定義を取得するか | デフォルトfalse |
| cancellationToken | CancellationToken | Yes | キャンセルトークン | - |

### 入力データソース

- エディタからのカーソル位置情報
- ドキュメントのセマンティックモデル

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| items | ImmutableArray\<INavigableItem\> | ナビゲーション可能アイテムのリスト |

### INavigableItem

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Glyph | Glyph | アイコン種別 |
| DisplayTaggedParts | ImmutableArray\<TaggedText\> | 表示パーツ |
| DisplayFileLocation | bool | ファイル位置を表示するか |
| IsImplicitlyDeclared | bool | 暗黙宣言か |
| Document | NavigableDocument | ドキュメント情報 |
| SourceSpan | TextSpan | ソーススパン |
| IsStale | bool | 古い情報か |
| ChildItems | ImmutableArray\<INavigableItem\> | 子アイテム |

### 出力先

- エディタ（ナビゲーション）
- ナビゲーションUI

## 処理フロー

### 処理シーケンス

```
1. Frozen Partial Semantics試行
   └─ 高速解析のためFrozen Partial Semanticsで試行
2. 通常解析
   └─ Frozen解析が失敗した場合、通常解析を実行
3. シンボル取得
   └─ IGoToDefinitionSymbolService経由でシンボル取得
4. ソース定義検索
   └─ SymbolFinder.FindSourceDefinitionAsync
5. 優先シンボル選択
   └─ TryGetPreferredSymbolAsync
6. 型シンボル取得（オプション）
   └─ forSymbolType=trueの場合、シンボルの型を取得
7. NavigableItem生成
   └─ NavigableItemFactory.GetItemsFromPreferredSourceLocations
```

### フローチャート

```mermaid
flowchart TD
    A[ナビゲーション要求] --> B[Frozen Partial Semantics試行]
    B --> C{成功?}
    C -->|No| D[通常解析]
    C -->|Yes| E[シンボル取得]
    D --> E
    E --> F{シンボル発見?}
    F -->|No| Z[終了（空結果）]
    F -->|Yes| G[ソース定義検索]
    G --> H[優先シンボル選択]
    H --> I{forSymbolType?}
    I -->|Yes| J[型シンボル取得]
    I -->|No| K[NavigableItem生成]
    J --> L{型シンボル発見?}
    L -->|No| Z
    L -->|Yes| K
    K --> M[結果返却]
    M --> Z
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | Frozen優先 | Frozen Partial Semanticsを優先して高速化 | 常時 |
| BR-02 | ソース定義優先 | メタデータシンボルでもソース定義を優先検索 | 常時 |
| BR-03 | 優先シンボル | TryGetPreferredSymbolAsyncで適切なシンボルを選択 | 常時 |
| BR-04 | エラー型除外 | IErrorTypeSymbolは結果から除外 | シンボル判定 |
| BR-05 | 型取得 | forSymbolType=trueの場合はGetSymbolType()で型を取得 | Go To Type Definition |

### 計算ロジック

特になし

## データベース操作仕様

該当なし（メモリ内処理のみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | シンボル未解決 | カーソル位置にシンボルがない | 空結果を返却 |
| - | エラー型 | シンボルがエラー型 | 空結果を返却 |

### リトライ仕様

- Frozen Partial Semanticsが失敗した場合、通常解析でリトライ

## トランザクション仕様

該当なし（読み取り専用処理）

## パフォーマンス要件

- Frozen Partial Semanticsで高速化
- 非同期処理でUIスレッドをブロックしない

## セキュリティ考慮事項

特になし（ローカルコード解析のみ）

## 備考

- C#とVBで共通の基盤を使用

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: インターフェースを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | INavigableItemsService.cs | `src/Features/Core/Portable/Navigation/INavigableItemsService.cs` | サービスインターフェース。GetNavigableItemsAsyncメソッドを理解する |
| 1-2 | INavigableItem.cs | `src/Features/Core/Portable/Navigation/INavigableItem.cs` | ナビゲーション可能アイテムのインターフェース。各プロパティの役割を理解する |

**主要処理フロー**:
- **22-23行目**: GetNavigableItemsAsync(document, position) - シンボルの定義取得
- **27-28行目**: GetNavigableItemsAsync(document, position, forSymbolType) - 型定義取得オプション付き

#### Step 2: 抽象基底クラスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AbstractNavigableItemsService.cs | `src/Features/Core/Portable/Navigation/AbstractNavigableItemsService.cs` | 実装クラス。Frozen Partial Semantics、シンボル取得、型取得を理解する |

**主要処理フロー**:
- **17-21行目**: GetNavigableItemsAsync - forSymbolType=falseでのオーバーロード
- **23-75行目**: GetNavigableItemsAsync - メイン実装
- **31-33行目**: Frozen Partial Semanticsでの試行 → 失敗時は通常解析
- **43-48行目**: GetSymbolAsync - ローカル関数でシンボル取得
- **51-52行目**: SymbolFinder.FindSourceDefinitionAsync、TryGetPreferredSymbolAsync
- **54-55行目**: エラー型チェック
- **57-71行目**: forSymbolType=trueの場合の型シンボル取得

### プログラム呼び出し階層図

```
INavigableItemsService.GetNavigableItemsAsync()
    │ (AbstractNavigableItemsService)
    │
    ├─ document.WithFrozenPartialSemantics() [高速化試行]
    │
    └─ GetSymbolAsync()
           │
           ├─ document.GetRequiredNullableDisabledSemanticModelAsync()
           │
           ├─ IGoToDefinitionSymbolService.GetSymbolProjectAndBoundSpanAsync()
           │
           ├─ SymbolFinder.FindSourceDefinitionAsync()
           │
           └─ GoToDefinitionFeatureHelpers.TryGetPreferredSymbolAsync()
                  │
                  └─ [forSymbolType=true]
                         │
                         ├─ symbol.GetSymbolType()
                         │
                         └─ 再度ソース定義検索
                                │
                                └─ NavigableItemFactory.GetItemsFromPreferredSourceLocations()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| INavigableItemsService.cs | `src/Features/Core/Portable/Navigation/INavigableItemsService.cs` | ソース | サービスインターフェース |
| AbstractNavigableItemsService.cs | `src/Features/Core/Portable/Navigation/AbstractNavigableItemsService.cs` | ソース | 抽象基底クラス |
| INavigableItem.cs | `src/Features/Core/Portable/Navigation/INavigableItem.cs` | ソース | ナビゲーションアイテムインターフェース |
| NavigableItemFactory.cs | `src/Features/Core/Portable/Navigation/NavigableItemFactory.cs` | ソース | アイテムファクトリ |
| IDefinitionLocationService.cs | `src/Features/Core/Portable/Navigation/IDefinitionLocationService.cs` | ソース | 定義ロケーションサービス |
