# 機能設計書 17-NavigateTo

## 概要

本ドキュメントは、Roslynの「NavigateTo」（Go To All / Ctrl+T）機能の設計について記述する。キーワード検索によりソリューション全体からシンボルを検索し、ナビゲートするIDE機能である。

### 本機能の処理概要

NavigateTo機能は、開発者が入力した検索パターンに一致するシンボル（クラス、メソッド、プロパティ等）をソリューション全体から検索し、結果一覧から選択してナビゲートできる機能である。Ctrl+T（Go To All）で呼び出される。

**業務上の目的・背景**：大規模なコードベースにおいて、目的のシンボルに素早くアクセスできることは開発効率に直結する。この機能により、ファイル構造を知らなくても、シンボル名の一部を入力するだけで目的のコードに到達できる。

**機能の利用シーン**：
- クラス名やメソッド名でコードを検索したいとき
- CamelCaseマッチングでシンボルを検索したいとき
- ファイル構造を知らないコードベースでナビゲートしたいとき
- 部分一致検索でシンボルを探したいとき

**主要な処理内容**：
1. 検索パターンの解析（Exact/Prefix/CamelCase/Fuzzy等）
2. ソリューション全体またはプロジェクト/ドキュメントスコープでの検索
3. キャッシュされたインデックスからの高速検索
4. 生成ドキュメントの検索（オプション）
5. 結果のストリーミング表示
6. パターンマッチングによるランキング

**関連システム・外部連携**：
- 宣言インデックスキャッシュ
- パターンマッチングエンジン
- LSP（Language Server Protocol）
- OOP（Out-of-Process）リモート実行

**権限による制御**：特になし。すべての開発者が利用可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | Go To All ダイアログ | 主画面 | 検索と結果表示 |
| - | エディタ | 結果画面 | 選択結果へのナビゲーション |

## 機能種別

検索 / シンボルインデックス

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| searchPattern | string | Yes | 検索パターン | 2文字以上 |
| kinds | IImmutableSet\<string\> | Yes | 検索対象種別フィルタ | - |
| searchScope | NavigateToSearchScope | Yes | 検索スコープ | Solution/Project/Document |
| cancellationToken | CancellationToken | Yes | キャンセルトークン | - |

### 検索対象種別（NavigateToItemKind）

- Class
- Constant
- Delegate
- Enum
- EnumItem
- Event
- Field
- Interface
- Method
- Module
- Property
- Structure

### 入力データソース

- ユーザー入力の検索パターン
- ソリューションの宣言インデックス

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| results | INavigateToSearchResult[] | 検索結果のリスト |

### INavigateToSearchResult

| 項目名 | 型 | 説明 |
|--------|-----|------|
| AdditionalInformation | string | 追加情報（名前空間等） |
| Kind | string | シンボル種別 |
| MatchKind | NavigateToMatchKind | マッチ種別 |
| IsCaseSensitive | bool | 大文字小文字区別 |
| Name | string | シンボル名 |
| NameMatchSpans | ImmutableArray\<TextSpan\> | マッチしたスパン |
| SecondarySort | string | セカンダリソートキー |
| Summary | string? | サマリー |
| NavigableItem | INavigableItem | ナビゲーションアイテム |
| Matches | ImmutableArray\<PatternMatch\> | パターンマッチ |

### 出力先

- Go To All ダイアログ（ストリーミング表示）

## 処理フロー

### 処理シーケンス

```
1. スコープ判定
   └─ Document/Project/Solutionの検索スコープを判定
2. ロード状態確認
   └─ ソリューションが完全にロードされているか確認
3. プロジェクト優先順位付け
   └─ アクティブドキュメント、可視ドキュメントのプロジェクトを優先
4. 検索実行
   └─ INavigateToSearchService経由で検索
5. 重複除去
   └─ 同一結果の重複を除去
6. 結果通知
   └─ コールバックで結果をストリーミング通知
7. 進捗報告
   └─ プロジェクトごとに進捗を報告
```

### フローチャート

```mermaid
flowchart TD
    A[NavigateTo実行] --> B[検索スコープ判定]
    B --> C{スコープ?}
    C -->|Document| D[ドキュメント検索]
    C -->|Project| E[プロジェクト検索]
    C -->|Solution| F[ソリューション検索]
    D --> G[結果通知]
    E --> G
    F --> H[ロード状態確認]
    H --> I{完全ロード?}
    I -->|Yes| J[全プロジェクト検索]
    I -->|No| K[キャッシュ検索]
    J --> G
    K --> G
    G --> L[重複除去]
    L --> M[ダイアログ表示]
    M --> Z[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | マッチ種別 | Exact > CamelCaseExact > Prefix > CamelCasePrefix > Substring > Fuzzy の優先順 | 結果ランキング |
| BR-02 | 大文字小文字 | 大文字小文字区別マッチが優先 | 結果ランキング |
| BR-03 | アクティブ優先 | アクティブドキュメントのプロジェクトを最優先 | プロジェクト検索順序 |
| BR-04 | 可視優先 | 可視ドキュメントのプロジェクトを次に優先 | プロジェクト検索順序 |
| BR-05 | キャッシュ優先 | 未ロード時はキャッシュから結果を返す | ソリューション未ロード時 |
| BR-06 | 生成ドキュメント | 生成ドキュメントは完全ロード後のみ検索 | source generator対応 |
| BR-07 | 依存関係順 | 生成ドキュメント検索はトポロジカル順序 | 依存関係考慮 |

### 計算ロジック

- マッチスコア: PatternMatchKindとIsCaseSensitiveの組み合わせでランキング

## データベース操作仕様

該当なし（メモリ内インデックス使用）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 結果なし | 一致するシンボルがない | 空結果を表示 |
| - | キャンセル | 検索中にキャンセル | 検索を中断 |

### リトライ仕様

特になし

## トランザクション仕様

該当なし（読み取り専用処理）

## パフォーマンス要件

- ストリーミング表示で結果を順次表示
- キャッシュ使用で高速検索
- OOP実行でメインUIスレッドをブロックしない

## セキュリティ考慮事項

特になし（ローカルコード解析のみ）

## 備考

- C#とVBで共通の基盤を使用
- CamelCaseマッチングで効率的な検索が可能

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: インターフェースとデータ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | INavigateToSearchService.cs | `src/Features/Core/Portable/NavigateTo/INavigateToSearchService.cs` | サービスインターフェース。SearchDocumentAsync、SearchProjectsAsyncを理解する |
| 1-2 | INavigateToSearchResult.cs | `src/Features/Core/Portable/NavigateTo/INavigateToSearchResult.cs` | 検索結果インターフェース。各プロパティの役割を理解する |

**主要処理フロー**:
- **15-16行目**: KindsProvided - 検索可能な種別
- **17行目**: CanFilter - フィルタリング可能か
- **18-23行目**: SearchDocumentAsync - ドキュメント検索
- **30-44行目**: SearchProjectsAsync - プロジェクト検索

#### Step 2: サーチャー実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | NavigateToSearcher.cs | `src/Features/Core/Portable/NavigateTo/NavigateToSearcher.cs` | 検索オーケストレーション。スコープ処理、優先順位付け、OOP連携を理解する |

**主要処理フロー**:
- **25-40行目**: NavigateToDocumentSupport、NavigateToSearchScope列挙型
- **41-113行目**: NavigateToSearcher - 検索オーケストレータークラス
- **132-182行目**: SearchAsync - メイン検索処理
- **184-197行目**: SearchCurrentDocumentAsync - ドキュメント検索
- **220-227行目**: SearchAllProjectsAsync - ソリューション検索
- **284-320行目**: GetOrderedProjectsToProcess - プロジェクト優先順位付け
- **413-429行目**: SearchFullyLoadedProjectsAsync - 完全ロード時の検索
- **431-461行目**: SearchCachedDocumentsAsync - キャッシュ検索
- **463-517行目**: SearchGeneratedDocumentsAsync - 生成ドキュメント検索

#### Step 3: 抽象基底クラスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AbstractNavigateToSearchService.cs | `src/Features/Core/Portable/NavigateTo/AbstractNavigateToSearchService.cs` | 言語共通実装。AllKinds、結果生成を理解する |

**主要処理フロー**:
- **18-31行目**: AllKinds - すべての検索種別
- **36-53行目**: GetOnItemsFoundCallback - 結果通知コールバック

### プログラム呼び出し階層図

```
NavigateToSearcher.SearchAsync()
    │
    ├─ SearchCurrentDocumentAsync() [Document scope]
    │      └─ INavigateToSearchService.SearchDocumentAsync()
    │
    ├─ SearchCurrentProjectAsync() [Project scope]
    │      └─ SearchSpecificProjectsAsync()
    │
    └─ SearchAllProjectsAsync() [Solution scope]
           │
           ├─ IsFullyLoadedAsync()
           │      └─ ロード状態確認
           │
           ├─ GetOrderedProjectsToProcess()
           │      └─ プロジェクト優先順位付け
           │
           ├─ SearchFullyLoadedProjectsAsync() [完全ロード時]
           │      └─ INavigateToSearchService.SearchProjectsAsync()
           │
           ├─ SearchCachedDocumentsAsync() [未ロード時]
           │      └─ IAdvancedNavigateToSearchService.SearchCachedDocumentsAsync()
           │
           └─ SearchGeneratedDocumentsAsync()
                  └─ IAdvancedNavigateToSearchService.SearchGeneratedDocumentsAsync()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| INavigateToSearchService.cs | `src/Features/Core/Portable/NavigateTo/INavigateToSearchService.cs` | ソース | サービスインターフェース |
| INavigateToSearchResult.cs | `src/Features/Core/Portable/NavigateTo/INavigateToSearchResult.cs` | ソース | 結果インターフェース |
| NavigateToSearcher.cs | `src/Features/Core/Portable/NavigateTo/NavigateToSearcher.cs` | ソース | 検索オーケストレーター |
| AbstractNavigateToSearchService.cs | `src/Features/Core/Portable/NavigateTo/AbstractNavigateToSearchService.cs` | ソース | 抽象基底クラス |
| NavigateToItemKind.cs | `src/Features/Core/Portable/NavigateTo/NavigateToItemKind.cs` | ソース | 種別定義 |
| NavigateToMatchKind.cs | `src/Features/Core/Portable/NavigateTo/NavigateToMatchKind.cs` | ソース | マッチ種別定義 |
| INavigateToSearchCallback.cs | `src/Features/Core/Portable/NavigateTo/INavigateToSearchCallback.cs` | ソース | 結果コールバック |
| RoslynNavigateToItem.cs | `src/Features/Core/Portable/NavigateTo/RoslynNavigateToItem.cs` | ソース | 検索アイテム |
