# 機能設計書 18-ナビゲーションバー

## 概要

本ドキュメントは、Roslynの「ナビゲーションバー」（Navigation Bar）機能の設計について記述する。エディタ上部に表示されるドロップダウンで、現在のファイル内の型とメンバーをナビゲートするIDE機能である。

### 本機能の処理概要

ナビゲーションバー機能は、エディタ上部に2つのドロップダウン（型リスト、メンバーリスト）を表示し、現在のファイル内の構造を視覚化してクイックナビゲーションを可能にする機能である。

**業務上の目的・背景**：長いソースファイルにおいて、ファイル内の構造を把握しながら効率的にナビゲートできることは開発効率に直結する。この機能により、スクロールせずにファイル内の任意の型やメンバーに即座にジャンプできる。

**機能の利用シーン**：
- ファイル内の型一覧を確認したいとき
- 特定のメソッドやプロパティにジャンプしたいとき
- 現在のカーソル位置がどの型/メンバーにあるか確認したいとき
- partial型の他のファイルへ移動したいとき

**主要な処理内容**：
1. ドキュメント内の型の収集
2. 各型のメンバー収集
3. カーソル位置に基づく現在の選択の決定
4. 階層構造の構築（入れ子型対応）
5. 他ファイルの partial 型情報の取得

**関連システム・外部連携**：
- セマンティック解析エンジン
- OOP（Out-of-Process）リモート実行
- Visual Studioナビゲーションバーコントロール

**権限による制御**：特になし。すべての開発者が利用可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | ナビゲーションバー | 主画面 | 型・メンバードロップダウン表示 |
| - | エディタ | 関連画面 | 選択アイテムへのナビゲーション |

## 機能種別

UI情報提供 / ナビゲーション

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| document | Document | Yes | 対象ドキュメント | null不可 |
| supportsCodeGeneration | bool | Yes | コード生成をサポートするか | - |
| frozenPartialSemantics | bool | Yes | Frozen Partial Semanticsを使用するか | - |
| cancellationToken | CancellationToken | Yes | キャンセルトークン | - |

### 入力データソース

- ドキュメントの構文木
- セマンティックモデル

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| items | ImmutableArray\<RoslynNavigationBarItem\> | ナビゲーションバーアイテム |

### RoslynNavigationBarItem

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Kind | RoslynNavigationBarItemKind | アイテム種別 |
| Text | string | 表示テキスト |
| Glyph | Glyph | アイコン |
| Bolded | bool | 太字表示 |
| Grayed | bool | グレー表示 |
| Indent | int | インデントレベル |
| ChildItems | ImmutableArray\<RoslynNavigationBarItem\> | 子アイテム（メンバー） |

### 出力先

- ナビゲーションバードロップダウン

## 処理フロー

### 処理シーケンス

```
1. OOP試行
   └─ リモートサービスでの処理を試行
2. ローカル処理
   └─ OOP失敗時はローカルで処理
3. 型収集
   └─ ドキュメント内の型を収集
4. メンバー収集
   └─ 各型のメンバーを収集
5. 階層構築
   └─ 入れ子型を考慮した階層構造を構築
6. シリアライズ
   └─ OOP間転送のためシリアライズ
7. 結果返却
   └─ アイテムリストを返却
```

### フローチャート

```mermaid
flowchart TD
    A[ナビゲーションバー更新要求] --> B[OOP試行]
    B --> C{OOP成功?}
    C -->|Yes| D[リモート結果取得]
    C -->|No| E[ローカル処理]
    D --> F[デシリアライズ]
    E --> G[型収集]
    G --> H[メンバー収集]
    H --> I[階層構築]
    F --> J[結果返却]
    I --> J
    J --> K[ナビゲーションバー更新]
    K --> Z[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 型優先 | 型は名前順にソート | 型リスト |
| BR-02 | メンバー順序 | メンバーはソース位置順 | メンバーリスト |
| BR-03 | 太字表示 | 現在のカーソル位置のアイテムを太字 | 選択状態 |
| BR-04 | グレー表示 | 他ファイルのpartial型メンバーをグレー | 別ファイル定義 |
| BR-05 | インデント | 入れ子型はインデント表示 | 入れ子型 |
| BR-06 | コード生成 | supportsCodeGeneration=trueでイベントハンドラ生成項目を表示 | VB/WinForms |

### 計算ロジック

- 現在選択の決定: カーソル位置と各アイテムのスパンの交差判定

## データベース操作仕様

該当なし（メモリ内処理のみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | OOP失敗 | リモートサービス接続失敗 | ローカル処理にフォールバック |
| - | 構文エラー | ドキュメントに構文エラー | 部分的な結果を返却 |

### リトライ仕様

- OOP失敗時はローカル処理にフォールバック

## トランザクション仕様

該当なし（読み取り専用処理）

## パフォーマンス要件

- リアルタイム更新（編集に追従）
- OOP実行でメインUIスレッドをブロックしない
- Frozen Partial Semanticsで高速化

## セキュリティ考慮事項

特になし（ローカルコード解析のみ）

## 備考

- C#とVBで共通の基盤を使用
- VBではイベントハンドラ生成機能が追加で提供される

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: インターフェースとデータ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | INavigationBarItemService.cs | `src/Features/Core/Portable/NavigationBar/INavigationBarItemService.cs` | サービスインターフェース。GetItemsAsyncを理解する |
| 1-2 | RoslynNavigationBarItem.cs | `src/Features/Core/Portable/NavigationBar/NavigationBarItems/RoslynNavigationBarItem.cs` | アイテム基底クラス。Kind、Text、Glyph、ChildItemsを理解する |

**主要処理フロー**:
- **14行目**: GetItemsAsync - ドキュメントからナビゲーションバーアイテムを取得

#### Step 2: 抽象基底クラスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AbstractNavigationBarItemService.cs | `src/Features/Core/Portable/NavigationBar/AbstractNavigationBarItemService.cs` | 実装クラス。OOP呼び出し、ローカル処理を理解する |

**主要処理フロー**:
- **19行目**: GetItemsInCurrentProcessAsync - ローカル実装（言語固有）
- **21-41行目**: GetItemsAsync - OOP試行とフォールバック
- **23-37行目**: RemoteHostClient経由でのOOP実行
- **43-88行目**: GetSymbolLocation - シンボルの位置取得
- **90-94行目**: ISymbolDeclarationService使用の位置取得

#### Step 3: アイテムデータ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | RoslynNavigationBarItem.cs | `src/Features/Core/Portable/NavigationBar/NavigationBarItems/RoslynNavigationBarItem.cs` | 基底クラス。各プロパティの意味を理解する |

**主要処理フロー**:
- **14-41行目**: コンストラクタとプロパティ
- **16行目**: Kind - アイテム種別
- **18-22行目**: Text、Glyph、Bolded、Grayed、Indent
- **23行目**: ChildItems - 子アイテム（メンバー）
- **43行目**: Dehydrate - シリアライズ用
- **48-58行目**: Equals - 等価比較

### プログラム呼び出し階層図

```
INavigationBarItemService.GetItemsAsync()
    │ (AbstractNavigationBarItemService)
    │
    ├─ RemoteHostClient.TryInvokeAsync() [OOP]
    │      │
    │      └─ IRemoteNavigationBarItemService.GetItemsAsync()
    │             │
    │             └─ SerializableNavigationBarItem.Rehydrate()
    │
    └─ GetItemsInCurrentProcessAsync() [ローカル]
           │ (言語固有実装)
           │
           ├─ 型の収集
           │
           ├─ メンバーの収集
           │
           └─ GetSymbolLocation()
                  │
                  ├─ symbol.DeclaringSyntaxReferences
                  │
                  └─ symbol.Locations
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| INavigationBarItemService.cs | `src/Features/Core/Portable/NavigationBar/INavigationBarItemService.cs` | ソース | サービスインターフェース |
| AbstractNavigationBarItemService.cs | `src/Features/Core/Portable/NavigationBar/AbstractNavigationBarItemService.cs` | ソース | 抽象基底クラス |
| RoslynNavigationBarItem.cs | `src/Features/Core/Portable/NavigationBar/NavigationBarItems/RoslynNavigationBarItem.cs` | ソース | アイテム基底クラス |
| RoslynNavigationBarItemKind.cs | `src/Features/Core/Portable/NavigationBar/RoslynNavigationBarItemKind.cs` | ソース | 種別列挙型 |
| SerializableNavigationBarItem.cs | `src/Features/Core/Portable/NavigationBar/SerializableNavigationBarItem.cs` | ソース | シリアライズ用クラス |
| SymbolItemLocation.cs | `src/Features/Core/Portable/NavigationBar/NavigationBarItems/SymbolItemLocation.cs` | ソース | 位置情報 |
