# 機能設計書 3-コンパイラ共通基盤

## 概要

本ドキュメントは、Roslynプラットフォームにおけるコンパイラ共通基盤の機能設計について記述する。コンパイラ共通基盤は、C#コンパイラ (csc) とVisual Basicコンパイラ (vbc) の両方で共通して使用される基盤機能を提供する。

### 本機能の処理概要

**業務上の目的・背景**：コンパイラ共通基盤は、C#とVisual Basicの両コンパイラで重複するコードを排除し、一貫した動作と保守性を確保するために設計されている。コマンドライン解析、診断メッセージ処理、コード生成 (Emit)、メタデータ参照解決など、言語に依存しない共通処理を集約することで、両コンパイラの品質向上とバグ修正の効率化を実現している。

**機能の利用シーン**：
- C#/VBコンパイラからの共通処理呼び出し
- ビルドパスとワーキングディレクトリの管理
- 参照アセンブリの解決
- 診断メッセージのフォーマットと出力
- コード生成とPEファイル出力
- アナライザーの読み込みと実行

**主要な処理内容**：
1. BuildPaths構造体によるパス管理
2. CommonCompilerクラスによる共通コンパイル処理
3. Compilationクラスによるコンパイル状態の管理
4. 参照解決とメタデータ読み込み
5. 診断情報の収集と出力
6. IL生成とPEファイルのEmit
7. デバッグシンボル (PDB) の生成

**関連システム・外部連携**：
- C#コンパイラ (csc)
- Visual Basicコンパイラ (vbc)
- アナライザードライバー
- ソースジェネレーター

**権限による制御**：特に権限による実行制御は存在しない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | なし | - | ライブラリ機能のため画面は存在しない |

## 機能種別

共通基盤 / フレームワーク

## 入力仕様

### 入力パラメータ (CommonCompiler)

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| parser | CommandLineParser | Yes | コマンドライン解析器 | null不可 |
| responseFile | string | No | レスポンスファイルパス | ファイル存在確認 |
| args | string[] | Yes | コマンドライン引数 | - |
| buildPaths | BuildPaths | Yes | ビルドパス情報 | 各パス存在確認 |
| additionalReferenceDirectories | string | No | 追加参照ディレクトリ | パス形式チェック |
| assemblyLoader | IAnalyzerAssemblyLoader | Yes | アナライザーローダー | null不可 |
| driverCache | GeneratorDriverCache | No | ジェネレータードライバーキャッシュ | - |
| fileSystem | ICommonCompilerFileSystem | No | ファイルシステム抽象化 | - |

### BuildPaths構造体

| フィールド名 | 型 | 説明 |
|-------------|-----|------|
| ClientDirectory | string | コンパイラバイナリとレスポンスファイルのパス |
| WorkingDirectory | string | コンパイル実行時の作業ディレクトリ |
| SdkDirectory | string? | mscorlib等を含むSDKディレクトリ |
| TempDirectory | string? | 一時ファイル用ディレクトリ |

### 入力データソース

- ソースファイル (.cs/.vb)
- レスポンスファイル (.rsp)
- 参照アセンブリ (.dll)
- アナライザーアセンブリ (.dll)

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Compilation | Compilation | コンパイル結果オブジェクト |
| EmitResult | EmitResult | Emit処理結果 |
| Diagnostics | ImmutableArray<Diagnostic> | 診断メッセージ配列 |
| 終了コード | int | 0=成功、1=失敗 |

### 出力先

- ファイルシステム (アセンブリ、PDB)
- 標準出力・標準エラー出力 (診断メッセージ)

## 処理フロー

### 処理シーケンス

```
1. 初期化処理
   └─ CommonCompilerコンストラクタ
      └─ レスポンスファイルの読み込みと引数マージ
      └─ CommandLineParser.Parseによる引数解析
      └─ EmbeddedSourcePathsの設定

2. RunCore処理
   ├─ 早期終了チェック (/version, /help, /langversion)
   ├─ ErrorLoggerの設定
   ├─ AnalyzerConfigの解決
   ├─ CreateCompilation (言語固有実装を呼び出し)
   ├─ ResolveAnalyzersFromArguments
   ├─ CompilationWithAnalyzers生成
   └─ EmitWithAnalyzers

3. Emit処理
   ├─ メタデータの生成
   ├─ ILコードの生成
   ├─ PEファイルの出力
   └─ PDBファイルの生成

4. 診断メッセージ処理
   ├─ 診断の収集と重複排除
   ├─ 重要度フィルタリング
   └─ コンソール/ファイル出力
```

### フローチャート

```mermaid
flowchart TD
    A[CommonCompiler.RunCore開始] --> B{早期終了オプション?}
    B -->|/version| C[PrintVersion]
    B -->|/help| D[PrintHelp]
    B -->|/langversion| E[PrintLangVersions]
    B -->|なし| F[ErrorLogger設定]
    C --> Z[終了]
    D --> Z
    E --> Z
    F --> G[AnalyzerConfig解決]
    G --> H[CreateCompilation呼び出し]
    H --> I{Compilation成功?}
    I -->|No| J[エラー出力]
    I -->|Yes| K[ResolveAnalyzers]
    J --> Z
    K --> L[CompilationWithAnalyzers生成]
    L --> M[EmitWithAnalyzers]
    M --> N{Emit成功?}
    N -->|Yes| O[終了コード0]
    N -->|No| P[エラー出力、終了コード1]
    O --> Z
    P --> Z
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | レスポンスファイル処理 | @ファイル名形式で指定されたレスポンスファイルを読み込み引数として展開 | 引数に@プレフィックスがある場合 |
| BR-02 | 診断重複排除 | 同一の診断メッセージは一度のみ出力 | 常時 |
| BR-03 | 終了コード規約 | 成功=0、失敗=1 | 常時 |
| BR-04 | フォールバックエンコーディング | エンコーディングが不明な場合のフォールバック処理 | エンコーディング検出失敗時 |
| BR-05 | 埋め込みソースパス管理 | 埋め込みソースファイルの二重読み込み防止 | /embed指定時 |

### 計算ロジック

特になし (基盤処理のため)

## データベース操作仕様

データベース操作は存在しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| Failed (1) | 終了コード | コンパイル失敗 | 診断メッセージ確認 |
| ArgumentException | 引数エラー | 不正な引数指定 | 引数確認 |
| FileNotFoundException | ファイルエラー | ファイル未検出 | パス確認 |
| BadImageFormatException | アセンブリエラー | 不正なアセンブリ形式 | アセンブリ確認 |

### リトライ仕様

リトライ処理は存在しない。

## トランザクション仕様

トランザクション処理は存在しない。

## パフォーマンス要件

- Compilationオブジェクトの不変性によるキャッシュ効率化
- 差分コンパイルのサポート
- 遅延評価によるオンデマンドデータ生成

## セキュリティ考慮事項

- EmbeddedSourcePathsによるソースファイルアクセス制御
- アナライザーの分離読み込み

## 備考

- CommonCompilerはabstractクラスであり、C#/VB固有の処理は派生クラスで実装
- Compilationオブジェクトは不変であり、変更時は新しいインスタンスを生成

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

共通基盤で使用されるコアデータ構造から理解を開始する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | CommonCompiler.cs | `src/Compilers/Core/Portable/CommandLine/CommonCompiler.cs` | 28-60行目: BuildPaths構造体の定義 |
| 1-2 | Compilation.cs | `src/Compilers/Core/Portable/Compilation/Compilation.cs` | 42-96行目: Compilationクラスの基本構造 |
| 1-3 | CompilationOptions.cs | `src/Compilers/Core/Portable/Compilation/CompilationOptions.cs` | コンパイルオプションの共通定義 |

**読解のコツ**: BuildPathsは4つのディレクトリパスを管理する readonly struct。ClientDirectory (コンパイラバイナリ)、WorkingDirectory (作業ディレクトリ)、SdkDirectory (SDK)、TempDirectory (一時ファイル) の役割を理解する。

#### Step 2: CommonCompilerを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CommonCompiler.cs | `src/Compilers/Core/Portable/CommandLine/CommonCompiler.cs` | 65-141行目: クラス定義と初期化処理 |

**主要処理フロー**:
1. **67-68行目**: Failed=1, Succeeded=0の終了コード定義
2. **76-80行目**: 主要プロパティ (MessageProvider, Arguments, AssemblyLoader等)
3. **95-100行目**: CreateCompilation抽象メソッド定義
4. **125-141行目**: コンストラクタでのレスポンスファイル処理と引数解析

#### Step 3: Compilationクラスを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Compilation.cs | `src/Compilers/Core/Portable/Compilation/Compilation.cs` | コンパイル状態を管理する不変オブジェクト |

**主要処理フロー**:
- **34-41行目**: Compilationクラスの概要コメント（不変、オンデマンド、キャッシュ、差分）
- **57行目**: IsCaseSensitive抽象プロパティ（言語による違い）
- **77-96行目**: コンストラクタでの初期化
- **127行目**: CreateAnalyzerDriver抽象メソッド
- **132行目**: Language抽象プロパティ ("C#" or "Visual Basic")

#### Step 4: Emit処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | EmitResult.cs | `src/Compilers/Core/Portable/Compilation/EmitResult.cs` | Emit処理結果の定義 |
| 4-2 | CommonCompiler.cs (Emit部分) | 後半部分 | Emit処理の共通実装 |

### プログラム呼び出し階層図

```
[言語固有コンパイラ]
    │
    ├─ CSharpCompiler / VisualBasicCompiler
    │      │
    │      └─ CommonCompiler (継承)
    │             │
    │             ├─ RunCore
    │             │      │
    │             │      ├─ CreateCompilation (abstract → 言語固有実装)
    │             │      │
    │             │      ├─ ResolveAnalyzersFromArguments
    │             │      │
    │             │      └─ Emit
    │             │             │
    │             │             └─ Compilation.Emit
    │             │
    │             └─ ReportDiagnostics
    │
    └─ Compilation
           │
           ├─ CSharpCompilation / VisualBasicCompilation
           │
           ├─ Emit
           │      │
           │      └─ EmitResult
           │
           └─ GetDiagnostics
```

### データフロー図

```
[入力]                         [処理]                           [出力]

コマンドライン引数       ──▶  CommandLineParser.Parse    ──▶  CommandLineArguments
        │                                                           │
        ▼                                                           ▼
BuildPaths              ──▶  CommonCompiler初期化       ──▶  CommonCompilerインスタンス
        │                                                           │
        ▼                                                           ▼
ソースファイル          ──▶  CreateCompilation (abstract) ──▶  Compilation
        │                                                           │
        ▼                                                           ▼
参照アセンブリ          ──▶  ResolveMetadataReferences   ──▶  MetadataReference[]
        │                                                           │
        ▼                                                           ▼
アナライザー            ──▶  ResolveAnalyzers            ──▶  DiagnosticAnalyzer[]
        │                                                           │
        ▼                                                           ▼
                             CompilationWithAnalyzers
                                    │
                                    ▼
                             Emit
                                    │
                    ┌───────────────┴───────────────┐
                    ▼                               ▼
            EmitResult                        出力ファイル (PE, PDB)
                    │
                    ▼
            診断メッセージ出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CommonCompiler.cs | `src/Compilers/Core/Portable/CommandLine/CommonCompiler.cs` | ソース | 共通コンパイラ基盤クラス |
| Compilation.cs | `src/Compilers/Core/Portable/Compilation/Compilation.cs` | ソース | コンパイル状態管理 |
| CompilationOptions.cs | `src/Compilers/Core/Portable/Compilation/CompilationOptions.cs` | ソース | コンパイルオプション基底クラス |
| CommandLineParser.cs | `src/Compilers/Core/Portable/CommandLine/CommandLineParser.cs` | ソース | コマンドライン解析基底クラス |
| CommandLineArguments.cs | `src/Compilers/Core/Portable/CommandLine/CommandLineArguments.cs` | ソース | 解析済み引数データ構造 |
| EmitResult.cs | `src/Compilers/Core/Portable/Compilation/EmitResult.cs` | ソース | Emit結果データ構造 |
| ParseOptions.cs | `src/Compilers/Core/Portable/Compilation/ParseOptions.cs` | ソース | パースオプション基底クラス |
| SemanticModel.cs | `src/Compilers/Core/Portable/Compilation/SemanticModel.cs` | ソース | 意味解析モデル基底クラス |
