# 機能設計書 4-MSBuildタスク

## 概要

本ドキュメントは、RoslynプラットフォームにおけるMSBuildタスクの機能設計について記述する。MSBuildタスクは、MSBuildビルドシステムからRoslynコンパイラを呼び出すためのタスク実装を提供する。

### 本機能の処理概要

**業務上の目的・背景**：MSBuildタスクは、.NETプロジェクトのビルドプロセスにおいて、MSBuildビルドエンジンからRoslynコンパイラ (csc/vbc) を呼び出すための標準インターフェースを提供する。従来のコンパイラツール実行に加えて、コンパイラサーバー経由での高速コンパイル、アナライザーの統合、ソースジェネレーターの実行をサポートする。これにより、Visual StudioやCI/CDパイプラインでの効率的なビルドが可能となる。

**機能の利用シーン**：
- Visual Studioでのプロジェクトビルド
- dotnet buildコマンドの実行
- MSBuildコマンドラインツールの実行
- CI/CDパイプラインでの自動ビルド
- カスタムビルドターゲットからのコンパイラ呼び出し

**主要な処理内容**：
1. MSBuildプロパティからコンパイラオプションへの変換
2. コンパイラサーバー接続とリクエスト送信
3. フォールバック時のコマンドラインツール実行
4. アナライザーとソースジェネレーターの実行
5. ビルド診断メッセージのMSBuild形式への変換
6. 出力ファイル (アセンブリ、PDB) の管理

**関連システム・外部連携**：
- MSBuildビルドエンジン
- Roslynコンパイラサーバー (VBCSCompiler)
- C#コンパイラ (csc)
- Visual Basicコンパイラ (vbc)

**権限による制御**：特に権限による実行制御は存在しない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | なし | - | バックエンドタスクのため画面は存在しない |

## 機能種別

ビルドタスク / 統合

## 入力仕様

### 入力パラメータ (ManagedCompiler共通)

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| Sources | ITaskItem[] | Yes | コンパイル対象ソースファイル | ファイル存在確認 |
| References | ITaskItem[] | No | 参照アセンブリ | ファイル存在確認 |
| OutputAssembly | ITaskItem | Yes | 出力アセンブリパス | パス形式チェック |
| AdditionalLibPaths | string[] | No | 追加ライブラリパス | パス形式チェック |
| Analyzers | ITaskItem[] | No | アナライザーアセンブリ | ファイル存在確認 |
| AnalyzerConfigFiles | ITaskItem[] | No | .editorconfig等のアナライザー設定 | ファイル存在確認 |
| CodeAnalysisRuleSet | string | No | ルールセットファイルパス | ファイル存在確認 |
| DefineConstants | string | No | プリプロセッサシンボル | 識別子形式チェック |
| DebugType | string | No | デバッグ情報種別 | 列挙値チェック |
| Deterministic | bool | No | 決定論的ビルド | - |
| EmitDebugInformation | bool | No | デバッグ情報出力 | - |
| TargetType | string | No | 出力種別 (exe/library等) | 列挙値チェック |
| UseSharedCompilation | bool | No | コンパイラサーバー使用 | - |

### Csc固有パラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|-----|-----|------|
| AllowUnsafeBlocks | bool | No | unsafeコード許可 |
| Nullable | string | No | Nullable参照型設定 |
| LangVersion | string | No | 言語バージョン |
| CheckForOverflowUnderflow | bool | No | オーバーフローチェック |

### Vbc固有パラメータ

| パラメータ名 | 型 | 必須 | 説明 |
|-------------|-----|-----|------|
| OptionStrict | bool | No | 厳格な型チェック |
| OptionExplicit | bool | No | 変数の明示的宣言 |
| OptionInfer | bool | No | 型推論有効化 |
| OptionCompare | string | No | 文字列比較モード |
| Imports | ITaskItem[] | No | グローバルインポート |

### 入力データソース

- MSBuildプロジェクトファイル (.csproj/.vbproj)
- MSBuildプロパティとアイテム
- ソースファイル (.cs/.vb)
- 参照アセンブリ (.dll)

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| OutputAssembly | ITaskItem | 生成されたアセンブリ |
| OutputRefAssembly | ITaskItem | 参照アセンブリ (ref assembly) |
| CommandLineArgs | ITaskItem[] | 使用されたコマンドライン引数 |
| タスク成功/失敗 | bool | Execute()の戻り値 |

### 出力先

- ファイルシステム (OutputPath配下)
- MSBuildログ (診断メッセージ)

## 処理フロー

### 処理シーケンス

```
1. タスク初期化
   └─ ManagedCompiler.Execute 開始

2. コマンドライン構築
   └─ GenerateCommandLineBuilder
      └─ MSBuildプロパティからコンパイラオプションへ変換

3. コンパイル方式決定
   ├─ UseSharedCompilation=true → コンパイラサーバー
   └─ UseSharedCompilation=false → ツール直接実行

4. コンパイル実行
   ├─ サーバー経由
   │   └─ BuildClient.RunServerCompilation
   │       └─ 成功/失敗
   │       └─ フォールバック判定
   └─ ツール実行
       └─ ToolTask.Execute (csc.exe/vbc.exe)

5. 結果処理
   ├─ 診断メッセージをMSBuild形式に変換
   ├─ 出力ファイルの確認
   └─ Execute結果を返却
```

### フローチャート

```mermaid
flowchart TD
    A[Execute開始] --> B[コマンドライン構築]
    B --> C{UseSharedCompilation?}
    C -->|Yes| D[コンパイラサーバー接続]
    C -->|No| E[ツール直接実行]
    D --> F{接続成功?}
    F -->|Yes| G[サーバーでコンパイル]
    F -->|No| H[フォールバック判定]
    H --> I{フォールバック許可?}
    I -->|Yes| E
    I -->|No| J[エラー終了]
    E --> K[csc.exe/vbc.exe実行]
    G --> L[コンパイル結果受信]
    K --> M[結果解析]
    L --> M
    M --> N{成功?}
    N -->|Yes| O[true返却]
    N -->|No| P[エラーログ出力]
    P --> Q[false返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | サーバー優先 | UseSharedCompilation=true時はコンパイラサーバーを優先使用 | 既定動作 |
| BR-02 | フォールバック | サーバー接続失敗時はツール実行にフォールバック | サーバー障害時 |
| BR-03 | 診断変換 | コンパイラ診断をMSBuild警告/エラーに変換 | 常時 |
| BR-04 | 標準エラーはエラー扱い | LogStandardErrorAsError=true | 常時 |
| BR-05 | 決定論的ビルド | Deterministic=true時は出力が再現可能 | 指定時 |

### CompilationKind列挙

| 値 | 説明 |
|---|------|
| Tool | コマンドラインツールによる通常実行 |
| ToolFallback | サーバー失敗後のフォールバック実行 |
| Server | コンパイラサーバーでの実行 |
| FatalError | 致命的エラーで実行不可 |

## データベース操作仕様

データベース操作は存在しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| MSB3073 | タスク失敗 | コンパイルエラー | ソースコード修正 |
| CS/BCxxxx | コンパイルエラー | 言語固有エラー | コード修正 |
| サーバー接続失敗 | 通信エラー | サーバー未起動/タイムアウト | フォールバック実行 |

### リトライ仕様

コンパイラサーバー接続失敗時は、ツール実行にフォールバック (1回のみ)。

## トランザクション仕様

トランザクション処理は存在しない。

## パフォーマンス要件

- コンパイラサーバーによるJIT済みコンパイラの再利用
- インクリメンタルビルドのサポート
- 並列コンパイル対応

## セキュリティ考慮事項

- コンパイラサーバーとの通信は名前付きパイプ経由
- アナライザーアセンブリの読み込み時検証

## 備考

- ManagedCompilerはCsc/Vbcの共通基底クラス
- ManagedToolTaskはToolTaskの派生クラス
- Visual Studioではホストオブジェクト (ICscHostObject/IVbcHostObject) 経由で追加機能を提供

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: クラス階層を理解する

MSBuildタスクのクラス継承構造から理解を開始する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ManagedToolTask.cs | `src/Compilers/Core/MSBuildTask/ManagedToolTask.cs` | ToolTaskを継承した基盤クラス |
| 1-2 | ManagedCompiler.cs | `src/Compilers/Core/MSBuildTask/ManagedCompiler.cs` | C#/VB共通のコンパイラタスク |

**読解のコツ**: MSBuildタスクの継承階層は `ToolTask → ManagedToolTask → ManagedCompiler → Csc/Vbc`。各階層で追加されるプロパティと処理を理解する。

#### Step 2: ManagedCompilerを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ManagedCompiler.cs | `src/Compilers/Core/MSBuildTask/ManagedCompiler.cs` | 共通プロパティとコンパイル実行 |

**主要処理フロー**:
1. **27行目**: ManagedToolTaskを継承したManagedCompilerクラス定義
2. **29-52行目**: CompilationKind列挙型の定義 (Tool, ToolFallback, Server, FatalError)
3. **56行目**: Language抽象プロパティ (C#/VB識別)
4. **58-64行目**: コンストラクタでLogStandardErrorAsError=trueを設定
5. **66-200行目以降**: 共通プロパティ (Sources, References, Analyzers等) の定義

#### Step 3: 言語固有タスクを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Csc.cs | `src/Compilers/Core/MSBuildTask/Csc.cs` | C#コンパイラMSBuildタスク |
| 3-2 | Vbc.cs | `src/Compilers/Core/MSBuildTask/Vbc.cs` | VBコンパイラMSBuildタスク |

**Csc.cs主要処理**:
- **35-39行目**: AllowUnsafeBlocksプロパティ
- **156-166行目**: Nullableプロパティ
- **Language**: RequestLanguage.CSharpCompile

**Vbc.cs主要処理**:
- **42行目**: RequestLanguage.VisualBasicCompile
- **127-143行目**: OptionStrict, OptionExplicit, OptionInferプロパティ
- **86-90行目**: Importsプロパティ

#### Step 4: ユーティリティを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | CommandLineBuilderExtension.cs | `src/Compilers/Core/MSBuildTask/CommandLineBuilderExtension.cs` | コマンドライン構築ヘルパー |
| 4-2 | Utilities.cs | `src/Compilers/Core/MSBuildTask/Utilities.cs` | 汎用ユーティリティ |

### プログラム呼び出し階層図

```
MSBuild Engine
    │
    ├─ <Csc> または <Vbc> タスク呼び出し
    │      │
    │      └─ ManagedCompiler.Execute
    │             │
    │             ├─ GenerateCommandLineBuilder
    │             │      │
    │             │      └─ AddSwitch, AddFileArguments, ...
    │             │
    │             ├─ UseSharedCompilation判定
    │             │      │
    │             │      ├─ [サーバー経由]
    │             │      │    └─ BuildClient.RunServerCompilation
    │             │      │           │
    │             │      │           └─ VBCSCompiler.exe
    │             │      │
    │             │      └─ [ツール実行]
    │             │           └─ ToolTask.ExecuteTool
    │             │                  │
    │             │                  └─ csc.exe / vbc.exe
    │             │
    │             └─ 結果処理
    │                    │
    │                    ├─ LogEventsFromTextOutput
    │                    │
    │                    └─ タスク成功/失敗判定
    │
    └─ MSBuildログ出力
```

### データフロー図

```
[入力]                          [処理]                          [出力]

MSBuildプロパティ         ──▶  ManagedCompiler            ──▶  MSBuildログ
(Sources, References等)              │
        │                            ▼
        ▼                  GenerateCommandLineBuilder
ITaskItem[]               ──▶  コマンドライン引数変換    ──▶  CommandLineArgs
        │                            │
        ▼                            ▼
                           UseSharedCompilation判定
                                    │
                    ┌───────────────┴───────────────┐
                    ▼                               ▼
            コンパイラサーバー                 csc.exe/vbc.exe
                    │                               │
                    └───────────────┬───────────────┘
                                    ▼
                             コンパイル結果
                                    │
                    ┌───────────────┼───────────────┐
                    ▼               ▼               ▼
            OutputAssembly    OutputRefAssembly   診断メッセージ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ManagedCompiler.cs | `src/Compilers/Core/MSBuildTask/ManagedCompiler.cs` | ソース | 共通コンパイラタスク基底クラス |
| Csc.cs | `src/Compilers/Core/MSBuildTask/Csc.cs` | ソース | C#コンパイラタスク |
| Vbc.cs | `src/Compilers/Core/MSBuildTask/Vbc.cs` | ソース | VBコンパイラタスク |
| ManagedToolTask.cs | `src/Compilers/Core/MSBuildTask/ManagedToolTask.cs` | ソース | ToolTask派生基底クラス |
| CommandLineBuilderExtension.cs | `src/Compilers/Core/MSBuildTask/CommandLineBuilderExtension.cs` | ソース | コマンドライン構築拡張 |
| PropertyDictionary.cs | `src/Compilers/Core/MSBuildTask/PropertyDictionary.cs` | ソース | プロパティ格納辞書 |
| Utilities.cs | `src/Compilers/Core/MSBuildTask/Utilities.cs` | ソース | ユーティリティ関数 |
| ICscHostObject5.cs | `src/Compilers/Core/MSBuildTask/ICscHostObject5.cs` | ソース | C#ホストオブジェクトインターフェース |
| IVbcHostObject6.cs | `src/Compilers/Core/MSBuildTask/IVbcHostObject6.cs` | ソース | VBホストオブジェクトインターフェース |
