# 機能設計書 41-オーバーライド生成

## 概要

本ドキュメントは、Roslyn IDEの「オーバーライド生成（Generate Overrides）」機能の設計を記述したものである。この機能は、基底クラスの仮想メンバーをオーバーライドするコードを自動生成するコードリファクタリング機能である。

### 本機能の処理概要

**業務上の目的・背景**：オブジェクト指向プログラミングにおいて、基底クラスのメソッドやプロパティをオーバーライドする必要がある場面は頻繁に発生する。手動でオーバーライドコードを記述すると、メソッドシグネチャの誤りや基底呼び出しの記述漏れなどが発生しやすい。この機能は、オーバーライド可能なメンバーを一覧から選択し、正確なシグネチャを持つオーバーライドコードを自動生成することで、開発者の生産性向上とコード品質の確保を実現する。

**機能の利用シーン**：開発者がクラスまたは構造体の宣言部にカーソルを置き、コードアクションメニューから「Generate overrides」を選択する場面で利用される。特に、新しい派生クラスを作成した際や、基底クラスに新しい仮想メンバーが追加された際に活用される。

**主要な処理内容**：
1. 現在のカーソル位置がクラスまたは構造体の型宣言ヘッダー上、またはメンバー間の空行にあるかを判定
2. 含まれる型のオーバーライド可能なメンバー（仮想メソッド、仮想プロパティなど）を収集
3. メンバー選択ダイアログ（IPickMembersService）を表示し、オーバーライド対象を選択
4. 選択されたメンバーに対してオーバーライドコードを生成
5. 生成されたコードを適切な位置に挿入

**関連システム・外部連携**：IPickMembersServiceを使用してメンバー選択UIを提供する。また、SyntaxGeneratorを使用してオーバーライドコードを生成する。

**権限による制御**：特になし。ただし、アクセス可能なメンバーのみがオーバーライド対象として表示される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 9 | メンバー選択ダイアログ | 主画面 | オーバーライド対象メンバーの選択UI |
| 13 | メンバー選択コントロール | 補助機能 | メンバー選択の共通UIコンポーネント |

## 機能種別

コード生成 / リファクタリング

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| document | Document | Yes | 対象ドキュメント | null不可 |
| textSpan | TextSpan | Yes | カーソル位置 | 有効な範囲内 |
| containingType | INamedTypeSymbol | Yes | オーバーライドを追加する型 | クラスまたは構造体 |
| viableMembers | ImmutableArray<ISymbol> | Yes | オーバーライド可能なメンバー一覧 | 1つ以上 |

### 入力データソース

- ソースコードのカーソル位置からセマンティックモデルを介して取得
- 型の継承階層から仮想メンバーを収集

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 生成コード | SyntaxNode[] | オーバーライドメソッド/プロパティの構文ノード |
| 更新ドキュメント | Document | オーバーライドが追加されたドキュメント |

### 出力先

ソースコードのクラス/構造体宣言内に挿入

## 処理フロー

### 処理シーケンス

```
1. カーソル位置の検証
   └─ 型宣言ヘッダー上またはメンバー間の空行かを判定
2. 含まれる型の取得
   └─ セマンティックモデルから宣言されたシンボルを取得
3. オーバーライド可能メンバーの収集
   └─ GetOverridableMembersメソッドで継承階層から収集
4. メンバー選択ダイアログ表示
   └─ IPickMembersServiceでUIを提供
5. オーバーライドコード生成
   └─ SyntaxGenerator.OverrideAsyncで各メンバーのコードを生成
6. コード挿入
   └─ CodeGenerator.AddMemberDeclarationsAsyncで挿入
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{カーソル位置が有効?}
    B -->|No| C[終了:リファクタリング不可]
    B -->|Yes| D[含まれる型を取得]
    D --> E{クラスまたは構造体?}
    E -->|No| C
    E -->|Yes| F[オーバーライド可能メンバー収集]
    F --> G{メンバーあり?}
    G -->|No| C
    G -->|Yes| H[メンバー選択ダイアログ表示]
    H --> I{選択あり?}
    I -->|No| C
    I -->|Yes| J[オーバーライドコード生成]
    J --> K[ドキュメントに挿入]
    K --> L[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 対象位置判定 | 型宣言ヘッダー上またはメンバー間の空行でのみ有効 | カーソル位置検証時 |
| BR-02 | 対象型制限 | クラスと構造体のみ対象、インターフェースは除外 | 型検証時 |
| BR-03 | 単一選択時の挿入位置 | 1つのメンバー選択時はカーソル位置に挿入 | コード挿入時 |
| BR-04 | 複数選択時の挿入位置 | 複数メンバー選択時は自動配置 | コード挿入時 |

### 計算ロジック

該当なし

## データベース操作仕様

該当なし（ソースコード操作のみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-01 | 位置エラー | 無効なカーソル位置 | リファクタリングを提供しない |
| E-02 | 型エラー | 対象外の型（インターフェース等） | リファクタリングを提供しない |
| E-03 | メンバー不在 | オーバーライド可能メンバーなし | リファクタリングを提供しない |

### リトライ仕様

なし

## トランザクション仕様

ドキュメント変更は単一のApplyChangesOperationでアトミックに適用される

## パフォーマンス要件

- メンバー収集は非同期で実行
- 複数メンバーのオーバーライド生成はTask.WhenAllで並列実行

## セキュリティ考慮事項

特になし

## 備考

- C#とVisual Basicの両言語をサポート
- 実行順序はAddConstructorParametersFromMembersの後に設定

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

メンバー選択の結果やオプションの管理に使用されるデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | PickMembersResult.cs | `src/Features/Core/Portable/PickMembers/` | メンバー選択結果の構造を理解する |

**読解のコツ**: PickMembersResultはIsCanceledとMembers配列を持ち、ダイアログの結果を表現する。

#### Step 2: エントリーポイントを理解する

リファクタリングプロバイダーが処理の起点となる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | GenerateOverridesCodeRefactoringProvider.cs | `src/Features/Core/Portable/GenerateOverrides/` | ComputeRefactoringsAsyncメソッドが処理の開始点 |

**主要処理フロー**:
1. **31-44行目**: カーソル位置の検証（型ヘッダー上またはメンバー間空行）
2. **46-49行目**: セマンティックモデルから含まれる型を取得
3. **51-53行目**: オーバーライド可能メンバーの収集と空チェック
4. **55-58行目**: GenerateOverridesWithDialogCodeActionの登録

#### Step 3: コードアクション実装を理解する

ダイアログ表示とコード生成の実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | GenerateOverridesWithDialogCodeAction.cs | `src/Features/Core/Portable/GenerateOverrides/` | GetOptionsとComputeOperationsAsyncの実装 |

**主要処理フロー**:
- **38-48行目**: GetOptionsでメンバー選択ダイアログを表示
- **50-87行目**: ComputeOperationsAsyncで選択結果を処理
- **62-64行目**: 単一選択時は現在位置に挿入、複数選択時は自動配置
- **67-70行目**: 各メンバーのオーバーライドを並列生成
- **72-80行目**: CodeGenerator.AddMemberDeclarationsAsyncで挿入

### プログラム呼び出し階層図

```
GenerateOverridesCodeRefactoringProvider.ComputeRefactoringsAsync
    │
    ├─ IRefactoringHelpersService.IsOnTypeHeader / IsBetweenTypeMembers
    │      └─ カーソル位置の検証
    │
    ├─ SemanticModel.GetRequiredDeclaredSymbol
    │      └─ 含まれる型の取得
    │
    ├─ INamedTypeSymbol.GetOverridableMembers
    │      └─ オーバーライド可能メンバーの収集
    │
    └─ GenerateOverridesWithDialogCodeAction
           │
           ├─ GetOptions (IPickMembersService.PickMembers)
           │      └─ メンバー選択UI表示
           │
           ├─ ComputeOperationsAsync
           │      ├─ SyntaxGenerator.OverrideAsync (各メンバー)
           │      │      └─ オーバーライドコード生成
           │      │
           │      └─ CodeGenerator.AddMemberDeclarationsAsync
           │             └─ ドキュメントへの挿入
           │
           └─ ApplyChangesOperation
                  └─ ソリューション更新
```

### データフロー図

```
[入力]               [処理]                    [出力]

カーソル位置 ───▶ 位置検証 ───▶ (検証結果)
      │
      ▼
型シンボル ───▶ メンバー収集 ───▶ オーバーライド可能メンバー一覧
      │
      ▼
選択結果 ◀─── メンバー選択ダイアログ ◀─── メンバー一覧
      │
      ▼
選択メンバー ───▶ オーバーライド生成 ───▶ 生成コード
      │
      ▼
生成コード ───▶ ドキュメント挿入 ───▶ 更新ドキュメント
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| GenerateOverridesCodeRefactoringProvider.cs | `src/Features/Core/Portable/GenerateOverrides/` | ソース | リファクタリングプロバイダー本体 |
| GenerateOverridesWithDialogCodeAction.cs | `src/Features/Core/Portable/GenerateOverrides/` | ソース | ダイアログ連携とコード生成 |
| IPickMembersService.cs | `src/Features/Core/Portable/PickMembers/` | ソース | メンバー選択サービスインターフェース |
| SyntaxGenerator.cs | `src/Workspaces/Core/Portable/Editing/` | ソース | コード生成ユーティリティ |
| CodeGenerator.cs | `src/Workspaces/Core/Portable/CodeGeneration/` | ソース | コード挿入ユーティリティ |
