# 機能設計書 44-コンストラクタパラメータ追加

## 概要

本ドキュメントは、Roslyn IDEの「コンストラクタパラメータ追加（Add Constructor Parameters from Members）」機能の設計を記述したものである。この機能は、選択されたフィールドまたはプロパティに基づいて、既存のコンストラクタにパラメータを追加するコードリファクタリング機能である。

### 本機能の処理概要

**業務上の目的・背景**：クラスに新しいフィールドやプロパティを追加した際、既存のコンストラクタにそれらを初期化するパラメータを追加する必要がある場合が多い。手動でコンストラクタを修正すると、パラメータの追加、フィールドへの代入文の追加を漏れなく行う必要があり、ミスが発生しやすい。この機能は、選択されたメンバーから自動的にコンストラクタパラメータを追加することで、正確で効率的なコード変更を支援する。

**機能の利用シーン**：開発者がクラス内のフィールドまたはプロパティを選択し、コードアクションメニューから「Add parameter to constructor」または「Add optional parameter to constructor」を選択する場面で利用される。

**主要な処理内容**：
1. 選択されたフィールド/プロパティの抽出
2. パラメータ追加可能なコンストラクタ候補の特定
3. 各コンストラクタに対して、必須パラメータまたはオプショナルパラメータとして追加するアクションを生成
4. 選択されたアクションに基づいてコンストラクタを更新
5. フィールド/プロパティへの代入文を追加

**関連システム・外部連携**：GenerateFromMembersHelpersを使用してメンバー情報を取得する。IIntentProviderインターフェースを実装し、インテント機能との連携もサポートする。

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能には専用の関連画面はない |

## 機能種別

コード生成 / リファクタリング

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| document | Document | Yes | 対象ドキュメント | null不可 |
| textSpan | TextSpan | Yes | 選択範囲 | 有効な範囲内 |
| selectedMembers | ImmutableArray<ISymbol> | Yes | 選択されたフィールド/プロパティ | 1つ以上 |

### 入力データソース

- ソースコードの選択範囲から取得
- セマンティックモデルを介してメンバー情報を収集

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 更新されたコンストラクタ | IMethodSymbol | パラメータが追加されたコンストラクタ |
| 代入文 | SyntaxNode[] | フィールド/プロパティへの代入文 |

### 出力先

ソースコードのコンストラクタ宣言に対して更新

## 処理フロー

### 処理シーケンス

```
1. メンバー選択の取得
   └─ GetSelectedMemberInfoAsyncで選択情報を取得
2. State生成
   └─ State.GenerateAsyncでコンストラクタ候補を特定
3. コードアクション生成
   └─ 必須パラメータ/オプショナルパラメータのアクションを生成
4. グループ化
   └─ 複数コンストラクタの場合はサブメニュー形式
5. パラメータ追加
   └─ コンストラクタにパラメータを追加
6. 代入文追加
   └─ フィールド/プロパティへの代入を追加
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{選択メンバーあり?}
    B -->|No| C[終了:リファクタリング不可]
    B -->|Yes| D[State生成]
    D --> E{コンストラクタ候補あり?}
    E -->|No| C
    E -->|Yes| F{複数コンストラクタ?}
    F -->|No| G[単一アクションを登録]
    F -->|Yes| H[サブメニュー形式で登録]
    G --> I[終了]
    H --> I
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 必須パラメータ条件 | 既存パラメータがすべて必須の場合のみ必須パラメータ追加可 | パラメータ追加時 |
| BR-02 | オプショナルパラメータ | hasDefaultValue=trueでオプショナルパラメータを生成 | オプショナル選択時 |
| BR-03 | 部分選択許可 | allowPartialSelection=trueで部分的なメンバー選択を許可 | メンバー取得時 |
| BR-04 | サブメニュー条件 | コンストラクタ候補が2つ以上の場合はサブメニュー形式 | UI登録時 |

### 計算ロジック

該当なし

## データベース操作仕様

該当なし（ソースコード操作のみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-01 | ワークスペースエラー | MiscellaneousFilesワークスペース | リファクタリングを提供しない |
| E-02 | State不在 | コンストラクタ候補なし | リファクタリングを提供しない |

### リトライ仕様

なし

## トランザクション仕様

ドキュメント変更は単一のCodeActionでアトミックに適用される

## パフォーマンス要件

- メンバー取得とState生成は非同期で実行
- インテント機能との連携時はCodeAnalysisProgress.Noneを使用

## セキュリティ考慮事項

特になし

## 備考

- C#とVisual Basicの両言語をサポート
- 実行順序はGenerateConstructorFromMembersの後、GenerateOverridesの前
- IIntentProviderを実装しWellKnownIntents.AddConstructorParameterをサポート

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

State、ConstructorCandidate、AddConstructorParameterResultの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | State.cs | `src/Features/Core/Portable/AddConstructorParametersFromMembers/` | Stateクラスの構造 |
| 1-2 | ConstructorCandidate.cs | `src/Features/Core/Portable/AddConstructorParametersFromMembers/` | コンストラクタ候補の構造 |
| 1-3 | AddConstructorParameterResult.cs | `src/Features/Core/Portable/AddConstructorParametersFromMembers/` | 結果の構造 |

**読解のコツ**: ConstructorCandidateはMissingParametersAndMembersを持ち、追加すべきパラメータとメンバーのペアを管理する。

#### Step 2: エントリーポイントを理解する

リファクタリングプロバイダーが処理の起点となる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AddConstructorParametersFromMembersCodeRefactoringProvider.cs | `src/Features/Core/Portable/AddConstructorParametersFromMembers/` | ComputeRefactoringsAsyncが開始点 |

**主要処理フロー**:
1. **35-46行目**: ComputeRefactoringsAsyncでメンバー取得とアクション登録
2. **49-71行目**: AddConstructorParametersFromMembersAsyncでState生成
3. **74-103行目**: GetGroupedActionsでサブメニュー/単一アクション判定
4. **106-151行目**: CreateCodeActionsで必須/オプショナルアクション生成

#### Step 3: コードアクション実装を理解する

パラメータ追加の実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AddConstructorParametersCodeAction.cs | `src/Features/Core/Portable/AddConstructorParametersFromMembers/` | パラメータ追加の実装 |

**主要処理フロー**:
- コンストラクタにパラメータを追加
- フィールド/プロパティへの代入文を追加

### プログラム呼び出し階層図

```
AddConstructorParametersFromMembersCodeRefactoringProvider.ComputeRefactoringsAsync
    │
    ├─ AddConstructorParametersFromMembersAsync
    │      │
    │      ├─ GetSelectedMemberInfoAsync
    │      │      └─ 選択メンバーの取得
    │      │
    │      └─ State.GenerateAsync
    │             └─ コンストラクタ候補の特定
    │
    └─ GetGroupedActions
           │
           ├─ CreateCodeActions
           │      │
           │      ├─ CanHaveRequiredParameters判定
           │      │      └─ 必須パラメータ追加可否
           │      │
           │      └─ AddConstructorParametersCodeAction (必須/オプショナル)
           │
           └─ CodeAction.Create
                  └─ サブメニューまたは単一アクション
```

### データフロー図

```
[入力]               [処理]                    [出力]

選択範囲 ───▶ メンバー抽出 ───▶ 選択メンバー一覧
      │
      ▼
選択メンバー ───▶ State生成 ───▶ コンストラクタ候補一覧
      │
      ▼
候補一覧 ───▶ アクション生成 ───▶ 必須/オプショナルアクション
      │
      ▼
選択アクション ───▶ コンストラクタ更新 ───▶ 更新ドキュメント
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AddConstructorParametersFromMembersCodeRefactoringProvider.cs | `src/Features/Core/Portable/AddConstructorParametersFromMembers/` | ソース | リファクタリングプロバイダー本体 |
| AddConstructorParametersCodeAction.cs | `src/Features/Core/Portable/AddConstructorParametersFromMembers/` | ソース | コードアクション実装 |
| State.cs | `src/Features/Core/Portable/AddConstructorParametersFromMembers/` | ソース | 状態管理 |
| ConstructorCandidate.cs | `src/Features/Core/Portable/AddConstructorParametersFromMembers/` | ソース | コンストラクタ候補 |
| AddConstructorParameterResult.cs | `src/Features/Core/Portable/AddConstructorParametersFromMembers/` | ソース | 結果構造 |
| GenerateFromMembersHelpers.cs | `src/Features/Core/Portable/GenerateFromMembers/` | ソース | メンバー取得ユーティリティ |
