# 機能設計書 47-自動プロパティをフルプロパティに変換

## 概要

本ドキュメントは、Roslyn IDEの「自動プロパティをフルプロパティに変換（Convert Auto Property to Full Property）」機能の設計を記述したものである。この機能は、自動実装プロパティを明示的なバッキングフィールドを持つフルプロパティに変換するコードリファクタリング機能である。

### 本機能の処理概要

**業務上の目的・背景**：自動実装プロパティは簡潔なコードを書くのに便利だが、getter/setterにカスタムロジック（検証、イベント発火、遅延初期化など）を追加する必要が生じることがある。この機能は、自動プロパティをフルプロパティに変換することで、カスタムロジックの追加を容易にする。

**機能の利用シーン**：開発者が自動プロパティの宣言にカーソルを置き、コードアクションメニューから「Convert to full property」または「Convert to field property」を選択する場面で利用される。

**主要な処理内容**：
1. カーソル位置のプロパティ宣言を取得
2. プロパティが有効な自動プロパティであることを検証
3. バッキングフィールド名を生成
4. フルプロパティ（getter/setter）を生成
5. バッキングフィールドを型に追加
6. 初期化子がある場合はフィールドに移動

**関連システム・外部連携**：ICodeGenerationServiceを使用してフィールドを追加する。C# 13以降では`field`キーワードを使用したフィールドプロパティへの変換もサポート。

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能には専用の関連画面はない |

## 機能種別

コード変換 / リファクタリング

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| document | Document | Yes | 対象ドキュメント | null不可 |
| property | TPropertyDeclarationNode | Yes | プロパティ宣言ノード | 自動プロパティ |
| propertySymbol | IPropertySymbol | Yes | プロパティシンボル | AssociatedSymbolがフィールド |

### 入力データソース

- ソースコードのカーソル位置からプロパティ宣言を取得
- セマンティックモデルからプロパティシンボルを取得

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| バッキングフィールド | IFieldSymbol | 生成されたプライベートフィールド |
| フルプロパティ | SyntaxNode | getter/setterを持つプロパティ |

### 出力先

- バッキングフィールド：型宣言内のフィールド領域
- フルプロパティ：元のプロパティ位置を置換

## 処理フロー

### 処理シーケンス

```
1. プロパティ取得
   └─ TryGetRelevantNodeAsyncでプロパティ宣言を取得
2. 自動プロパティ検証
   └─ IsValidAutoPropertyで有効性を確認
3. フィールド名生成
   └─ GetFieldNameAsyncでユニークなフィールド名を生成
4. アクセサ生成
   └─ GetNewAccessorsでgetter/setterを生成
5. フルプロパティ作成
   └─ CreateFinalPropertyでプロパティを構築
6. フィールド追加
   └─ ICodeGenerationService.AddFieldでフィールドを追加
7. ドキュメント更新
   └─ SyntaxEditorで変更を適用
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{プロパティ宣言あり?}
    B -->|No| C[終了:リファクタリング不可]
    B -->|Yes| D{自動プロパティ?}
    D -->|No| C
    D -->|Yes| E[アクション登録]
    E --> F{Full Property選択?}
    F -->|Yes| G[バッキングフィールド名生成]
    F -->|No| H{field式サポート?}
    H -->|Yes| I[field propertyに変換]
    H -->|No| C
    G --> J[getter/setter生成]
    J --> K[フィールド追加]
    K --> L[終了]
    I --> L
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 自動プロパティ判定 | AssociatedSymbolがフィールドである場合に有効 | プロパティ検証時 |
| BR-02 | フィールド名規則 | プロパティ名からユニークなフィールド名を生成 | フィールド名生成時 |
| BR-03 | 初期化子移動 | プロパティの初期化子はフィールドに移動 | 変換時 |
| BR-04 | 修飾子継承 | static等の修飾子はフィールドに継承 | フィールド生成時 |
| BR-05 | field式条件 | SupportsFieldExpressionがtrueかつ既存のfield式がない場合 | field property選択時 |

### 計算ロジック

該当なし

## データベース操作仕様

該当なし（ソースコード操作のみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-01 | プロパティ不在 | プロパティ宣言が見つからない | リファクタリングを提供しない |
| E-02 | 非自動プロパティ | 既にフルプロパティ | リファクタリングを提供しない |
| E-03 | 親型不在 | 型宣言の外のプロパティ | リファクタリングを提供しない |

### リトライ仕様

なし

## トランザクション仕様

ドキュメント変更は単一のCodeActionでアトミックに適用される

## パフォーマンス要件

- フィールド名生成は非同期で実行
- 複数の型宣言がある場合は各型に対してフィールドを追加

## セキュリティ考慮事項

特になし

## 備考

- 言語固有の実装は各言語のプロバイダーで行う
- C# 13以降ではfield式を使用したfield propertyへの変換もサポート

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

リファクタリングプロバイダーが処理の起点となる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AbstractConvertAutoPropertyToFullPropertyCodeRefactoringProvider.cs | `src/Features/Core/Portable/ConvertAutoPropertyToFullProperty/` | ComputeRefactoringsAsyncが開始点 |

**主要処理フロー**:
1. **34-41行目**: ComputeRefactoringsAsyncでプロパティ取得と検証
2. **43-46行目**: セマンティックモデルからプロパティシンボル取得
3. **48行目**: IsValidAutoPropertyで自動プロパティ検証
4. **50-66行目**: 2つのアクション登録（full property / field property）

#### Step 2: 自動プロパティ検証を理解する

自動プロパティかどうかの判定ロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AbstractConvertAutoPropertyToFullPropertyCodeRefactoringProvider.cs | `src/Features/Core/Portable/ConvertAutoPropertyToFullProperty/` | IsValidAutoPropertyメソッド |

**主要処理フロー**:
- **69-73行目**: AssociatedSymbolがフィールドであるメンバーを検索
- フィールドがあれば自動プロパティと判定

#### Step 3: 変換ロジックを理解する

フルプロパティへの変換ロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AbstractConvertAutoPropertyToFullPropertyCodeRefactoringProvider.cs | `src/Features/Core/Portable/ConvertAutoPropertyToFullProperty/` | ExpandToFullPropertyAsyncメソッド |

**主要処理フロー**:
- **85-127行目**: ExpandToFullPropertyAsyncでフルプロパティ変換
- **99-100行目**: GetFieldNameAsyncとGetNewAccessorsの呼び出し
- **107-111行目**: CodeGenerationSymbolFactory.CreateFieldSymbolでフィールド生成
- **113-122行目**: 各型宣言にフィールドを追加

### プログラム呼び出し階層図

```
AbstractConvertAutoPropertyToFullPropertyCodeRefactoringProvider.ComputeRefactoringsAsync
    │
    ├─ GetPropertyAsync
    │      └─ TryGetRelevantNodeAsync<TPropertyDeclarationNode>
    │
    ├─ IsValidAutoProperty
    │      └─ AssociatedSymbolがフィールドか確認
    │
    └─ CodeAction.Create
           │
           ├─ ExpandToFullPropertyAsync（フルプロパティ）
           │      │
           │      ├─ GetFieldNameAsync
           │      │      └─ ユニークなフィールド名生成
           │      │
           │      ├─ GetNewAccessors
           │      │      └─ getter/setter生成
           │      │
           │      ├─ CreateFinalProperty
           │      │      └─ フルプロパティ構築
           │      │
           │      └─ ICodeGenerationService.AddField
           │             └─ バッキングフィールド追加
           │
           └─ ExpandToFieldPropertyAsync（field property）
                  └─ field式を使用したプロパティ生成
```

### データフロー図

```
[入力]               [処理]                    [出力]

カーソル位置 ───▶ プロパティ取得 ───▶ プロパティノード
      │
      ▼
プロパティ ───▶ シンボル取得 ───▶ IPropertySymbol
      │
      ▼
シンボル ───▶ 検証 ───▶ 自動プロパティ確認
      │
      ▼
プロパティ名 ───▶ フィールド名生成 ───▶ バッキングフィールド名
      │
      ▼
プロパティ ───▶ アクセサ生成 ───▶ getter/setter
      │
      ▼
変換結果 ───▶ ドキュメント更新 ───▶ 更新ドキュメント
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AbstractConvertAutoPropertyToFullPropertyCodeRefactoringProvider.cs | `src/Features/Core/Portable/ConvertAutoPropertyToFullProperty/` | ソース | リファクタリングプロバイダー本体 |
| CodeGenerationSymbolFactory.cs | `src/Workspaces/Core/Portable/CodeGeneration/` | ソース | シンボル生成ユーティリティ |
| ICodeGenerationService.cs | `src/Workspaces/Core/Portable/CodeGeneration/` | ソース | コード生成サービス |
