# 機能設計書 48-foreachをforに変換

## 概要

本ドキュメントは、Roslyn IDEの「foreachをforに変換（Convert ForEach to For）」機能の設計を記述したものである。この機能は、foreach文をインデックスベースのfor文に変換するコードリファクタリング機能である。

### 本機能の処理概要

**業務上の目的・背景**：foreach文は読みやすく多くの場面で推奨されるが、インデックスへのアクセスが必要な場合や、パフォーマンスが重視される場面ではfor文が適している場合がある。この機能は、foreach文をfor文に変換することで、インデックスベースの操作への切り替えを容易にする。

**機能の利用シーン**：開発者がforeach文にカーソルを置き、コードアクションメニューから「Convert to for」を選択する場面で利用される。特に、ループ内でインデックスが必要になった場合や、配列・リストへの直接アクセスが必要な場合に活用される。

**主要な処理内容**：
1. カーソル位置のforeach文を取得
2. コレクションの型とインデックス可能性を検証
3. Length/Countプロパティの存在を確認
4. インデックス変数と要素変数を生成
5. for文に変換（コレクション変数の導入が必要な場合あり）
6. 変換による意味の変化について警告を追加（必要な場合）

**関連システム・外部連携**：ISemanticFactsServiceを使用してユニークな変数名を生成する。IOperationを使用してforeach文の構造を解析する。

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能には専用の関連画面はない |

## 機能種別

コード変換 / リファクタリング

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| document | Document | Yes | 対象ドキュメント | null不可 |
| foreachStatement | TForEachStatement | Yes | foreach文ノード | 有効なforeach |
| foreachInfo | ForEachInfo | Yes | foreach解析情報 | null不可 |

### 入力データソース

- ソースコードのカーソル位置からforeach文を取得
- セマンティックモデルとIForEachLoopOperationから詳細情報を取得

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| for文 | SyntaxNode | 変換されたfor文 |
| コレクション変数宣言 | SyntaxNode | 必要な場合のみ |
| 要素変数宣言 | SyntaxNode | foreach変数に相当 |

### 出力先

foreach文を置換、必要に応じてコレクション変数を前に挿入

## 処理フロー

### 処理シーケンス

```
1. foreach文取得
   └─ TryGetRelevantNodeAsyncでforeach文を取得
2. 解析情報取得
   └─ GetForeachInfoでコレクション型等の情報を取得
3. 変換可否判定
   └─ ValidLocationで位置の妥当性を確認
4. コレクション変数判定
   └─ CheckRequireCollectionStatementで一時変数の必要性判定
5. for文生成
   └─ ConvertToForStatementでfor文を構築
6. 警告追加
   └─ 意味が変わる可能性がある場合に警告アノテーション
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B{foreach文あり?}
    B -->|No| C[終了:リファクタリング不可]
    B -->|Yes| D[解析情報取得]
    D --> E{有効なforeach?}
    E -->|No| C
    E -->|Yes| F{配列/リスト?}
    F -->|No| G{IList等を実装?}
    G -->|No| C
    G -->|Yes| H[for文に変換]
    F -->|Yes| H
    H --> I{コレクション変数必要?}
    I -->|Yes| J[コレクション変数宣言追加]
    I -->|No| K[直接コレクション参照]
    J --> L[終了]
    K --> L
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-01 | 対象コレクション | 配列、文字列、IList<T>、IReadOnlyList<T>、IList、ImmutableArray<T> | コレクション検証時 |
| BR-02 | 1次元配列のみ | 多次元配列は対象外 | 配列検証時 |
| BR-03 | コレクション変数導入 | リテラル等の場合は一時変数を導入 | コレクション処理時 |
| BR-04 | foreach変数書き込み警告 | ループ内でforeach変数に書き込みがある場合は警告 | 変換時 |
| BR-05 | 明示的実装対応 | 明示的インターフェース実装の場合はキャストを追加 | コレクション処理時 |

### 計算ロジック

**プロパティ名の決定**：
- 配列、文字列、ImmutableArray：`Length`
- IList、IList<T>、IReadOnlyList<T>：`Count`

## データベース操作仕様

該当なし（ソースコード操作のみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| E-01 | foreach不在 | foreach文が見つからない | リファクタリングを提供しない |
| E-02 | 非対応コレクション | インデックスアクセス不可能 | リファクタリングを提供しない |
| E-03 | 多次元配列 | Rank != 1 | リファクタリングを提供しない |

### リトライ仕様

なし

## トランザクション仕様

ドキュメント変更は単一のCodeActionでアトミックに適用される

## パフォーマンス要件

- データフロー解析で変数の書き込みを検出
- 警告生成は最小限に抑制

## セキュリティ考慮事項

特になし

## 備考

- 意味の変化（foreach変数への書き込み等）がある場合は警告を付与
- VBでは特殊なNext文のパターンは非対応

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ForEachInfo構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AbstractConvertForEachToForCodeRefactoringProvider.cs | `src/Features/Core/Portable/ConvertForEachToFor/` | ForEachInfoクラス |

**読解のコツ**: ForEachInfoは428-441行目に定義され、コレクション名提案、Count名、明示的キャスト型、要素型、コレクション変数必要性を保持する。

#### Step 2: エントリーポイントを理解する

リファクタリングプロバイダーが処理の起点となる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | AbstractConvertForEachToForCodeRefactoringProvider.cs | `src/Features/Core/Portable/ConvertForEachToFor/` | ComputeRefactoringsAsyncが開始点 |

**主要処理フロー**:
1. **59-66行目**: ComputeRefactoringsAsyncでforeach文取得と検証
2. **71-75行目**: GetForeachInfoで解析情報取得
3. **77-83行目**: コードアクション登録

#### Step 3: コレクション解析を理解する

コレクション型の解析とインデックスアクセス可否の判定を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AbstractConvertForEachToForCodeRefactoringProvider.cs | `src/Features/Core/Portable/ConvertForEachToFor/` | GetInterfaceInfoメソッド |

**主要処理フロー**:
- **192-337行目**: GetInterfaceInfoでコレクション型を解析
- **216-235行目**: 配列の処理
- **239-251行目**: 文字列の処理
- **254-269行目**: ImmutableArrayの処理
- **272-337行目**: IList等のインターフェース処理

### プログラム呼び出し階層図

```
AbstractConvertForEachToForCodeRefactoringProvider.ComputeRefactoringsAsync
    │
    ├─ TryGetRelevantNodeAsync<TForEachStatement>
    │      └─ foreach文取得
    │
    ├─ GetForeachInfo
    │      │
    │      ├─ IForEachLoopOperation取得
    │      │
    │      ├─ IsSupported（言語固有チェック）
    │      │
    │      ├─ CheckIfForEachVariableIsWrittenInside
    │      │      └─ データフロー解析
    │      │
    │      ├─ GetInterfaceInfo
    │      │      └─ コレクション型解析
    │      │
    │      └─ CheckRequireCollectionStatement
    │             └─ 一時変数必要性判定
    │
    └─ CodeAction.Create
           │
           └─ ConvertForeachToForAsync
                  │
                  └─ ConvertToForStatement（言語固有実装）
                         │
                         ├─ CreateUniqueName（インデックス変数名）
                         │
                         ├─ GetCollectionVariableName
                         │
                         ├─ IntroduceCollectionStatement
                         │
                         └─ AddItemVariableDeclaration
```

### データフロー図

```
[入力]               [処理]                    [出力]

カーソル位置 ───▶ foreach取得 ───▶ foreach文ノード
      │
      ▼
foreach ───▶ Operation取得 ───▶ IForEachLoopOperation
      │
      ▼
コレクション ───▶ 型解析 ───▶ ForEachInfo
      │
      ▼
ForEachInfo ───▶ for文生成 ───▶ for文ノード
      │
      ▼
変換結果 ───▶ ドキュメント更新 ───▶ 更新ドキュメント
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AbstractConvertForEachToForCodeRefactoringProvider.cs | `src/Features/Core/Portable/ConvertForEachToFor/` | ソース | リファクタリングプロバイダー本体 |
| ISemanticFactsService.cs | `src/Workspaces/Core/Portable/LanguageService/` | ソース | ユニーク名生成サービス |
